/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.kv;

import com.couchbase.client.core.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.core.io.netty.kv.MemcacheProtocol;
import com.couchbase.client.core.kv.CoreRangeScanItem;
import com.couchbase.client.core.kv.LastCoreRangeScanItem;
import com.couchbase.client.core.msg.BaseResponse;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.util.UnsignedLEB128;
import com.couchbase.client.core.util.Validators;
import java.time.Instant;
import java.util.List;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Sinks;

public class RangeScanContinueResponse
extends BaseResponse {
    private final Sinks.Many<CoreRangeScanItem> items;
    private final boolean keysOnly;

    public RangeScanContinueResponse(ResponseStatus status, Sinks.Many<CoreRangeScanItem> items, boolean keysOnly) {
        super(status);
        this.items = Validators.notNull(items, "CoreRangeScanItems Sink");
        this.keysOnly = keysOnly;
    }

    public Flux<CoreRangeScanItem> items() {
        return this.items.asFlux();
    }

    public void feedItems(List<CoreRangeScanItem> items, boolean signalLastItem, boolean completeFeed) {
        for (CoreRangeScanItem item : items) {
            this.items.tryEmitNext(item);
        }
        if (signalLastItem) {
            this.items.tryEmitNext(LastCoreRangeScanItem.INSTANCE);
        }
        if (completeFeed) {
            this.items.tryEmitComplete();
        }
    }

    public void feedItems(ByteBuf itemsBuf, boolean signalLastItem, boolean completeFeed) {
        try {
            if (this.keysOnly) {
                this.feedKeysOnly(itemsBuf);
            } else {
                this.feedKeysAndBody(itemsBuf);
            }
            if (signalLastItem) {
                this.items.tryEmitNext(LastCoreRangeScanItem.INSTANCE);
            }
            if (completeFeed) {
                this.items.tryEmitComplete();
            }
        }
        catch (Throwable cause) {
            this.items.tryEmitError(cause);
        }
    }

    public void failFeed(Throwable cause) {
        this.items.tryEmitError(cause);
    }

    private void feedKeysOnly(ByteBuf itemsBuf) {
        while (itemsBuf.isReadable()) {
            int keyLength = (int)UnsignedLEB128.read(itemsBuf);
            byte[] key = new byte[keyLength];
            itemsBuf.readBytes(key, 0, keyLength);
            this.items.tryEmitNext(CoreRangeScanItem.keyOnly(key));
        }
    }

    private void feedKeysAndBody(ByteBuf itemsBuf) {
        while (itemsBuf.isReadable()) {
            int flags = itemsBuf.readInt();
            long expiry = itemsBuf.readUnsignedInt();
            Instant expiryInstant = expiry == 0L ? null : Instant.ofEpochSecond(expiry);
            long seqno = itemsBuf.readLong();
            long cas = itemsBuf.readLong();
            byte dataType = itemsBuf.readByte();
            byte[] key = RangeScanContinueResponse.readLengthPrefixedBytes(itemsBuf);
            byte[] rawValue = RangeScanContinueResponse.readLengthPrefixedBytes(itemsBuf);
            byte[] value = MemcacheProtocol.tryDecompression(rawValue, dataType);
            this.items.tryEmitNext(CoreRangeScanItem.keyAndBody(flags, expiryInstant, seqno, cas, key, value));
        }
    }

    private static byte[] readLengthPrefixedBytes(ByteBuf buf) {
        int len = Math.toIntExact(UnsignedLEB128.read(buf));
        byte[] result = new byte[len];
        buf.readBytes(result);
        return result;
    }
}

