/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.msg.query;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.msg.query.PreparedStatement;
import com.couchbase.client.core.msg.query.PreparedStatementStrategy;
import com.couchbase.client.core.msg.query.QueryRequest;
import com.couchbase.client.core.msg.query.QueryResponse;
import reactor.core.publisher.Mono;

@Stability.Internal
public class EnhancedPreparedStatementStrategy
extends PreparedStatementStrategy {
    public EnhancedPreparedStatementStrategy(Core core, int cacheSize) {
        super(core, cacheSize);
    }

    @Override
    public Mono<QueryResponse> execute(QueryRequest request) {
        return Mono.fromCallable(() -> (PreparedStatement)this.cache.get(request.statement())).flatMap(preparedStatement -> this.executeAlreadyPrepared(request, (PreparedStatement)preparedStatement)).switchIfEmpty(this.prepareAndExecute(request));
    }

    private Mono<QueryResponse> prepareAndExecute(QueryRequest request) {
        return this.executeAdhoc(request.toPrepareRequest(true, this.requestTracer())).flatMap(queryResponse -> {
            String preparedName = queryResponse.header().prepared().orElse(null);
            if (preparedName == null) {
                return Mono.error(new CouchbaseException("Failed to locate prepared statement name in query response; this is a query bug!"));
            }
            this.cache.put(request.statement(), PreparedStatement.enhanced(preparedName));
            return Mono.just(queryResponse);
        });
    }
}

