/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.node;

import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.cnc.events.node.NodeLocatorBugIdentifiedEvent;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.ClusterConfig;
import com.couchbase.client.core.config.NodeInfo;
import com.couchbase.client.core.config.PortInfo;
import com.couchbase.client.core.error.FeatureNotAvailableException;
import com.couchbase.client.core.error.ServiceNotAvailableException;
import com.couchbase.client.core.error.context.GenericRequestErrorContext;
import com.couchbase.client.core.msg.CancellationReason;
import com.couchbase.client.core.msg.Request;
import com.couchbase.client.core.msg.Response;
import com.couchbase.client.core.node.Locator;
import com.couchbase.client.core.node.Node;
import com.couchbase.client.core.node.NodeIdentifier;
import com.couchbase.client.core.retry.RetryOrchestrator;
import com.couchbase.client.core.retry.RetryReason;
import com.couchbase.client.core.service.ServiceType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.atomic.AtomicLong;

public class RoundRobinLocator
implements Locator {
    private final AtomicLong counter;
    private final ServiceType serviceType;

    public RoundRobinLocator(ServiceType serviceType) {
        this(serviceType, new Random().nextInt(1024));
    }

    RoundRobinLocator(ServiceType serviceType, long initialValue) {
        this.counter = new AtomicLong(initialValue);
        this.serviceType = serviceType;
    }

    @Override
    public void dispatch(Request<? extends Response> request, List<Node> nodes, ClusterConfig config, CoreContext ctx) {
        boolean isTargeted;
        if (!this.checkServiceNotAvailable(request, config)) {
            return;
        }
        boolean bl = isTargeted = request.target() != null;
        if (!isTargeted && !config.hasClusterOrBucketConfig()) {
            boolean loadInProgress;
            boolean globalLoadInProgress = ctx.core().configurationProvider().globalConfigLoadInProgress();
            boolean bucketLoadInProgress = ctx.core().configurationProvider().bucketConfigLoadInProgress();
            boolean bl2 = loadInProgress = globalLoadInProgress || bucketLoadInProgress;
            if (loadInProgress) {
                RetryOrchestrator.maybeRetry(ctx, request, bucketLoadInProgress ? RetryReason.BUCKET_OPEN_IN_PROGRESS : RetryReason.GLOBAL_CONFIG_LOAD_IN_PROGRESS);
            } else {
                request.fail(FeatureNotAvailableException.clusterLevelQuery(this.serviceType));
            }
            return;
        }
        List<Node> filteredNodes = this.filterNodes(nodes, request, config);
        if (filteredNodes.isEmpty()) {
            if (this.serviceShowsUpInConfig(config) || !config.hasClusterOrBucketConfig()) {
                RetryOrchestrator.maybeRetry(ctx, request, RetryReason.NODE_NOT_AVAILABLE);
            } else {
                request.fail(new ServiceNotAvailableException("The " + request.serviceType().ident() + " service is not available in the cluster.", new GenericRequestErrorContext(request)));
            }
            return;
        }
        if (isTargeted) {
            this.dispatchTargeted(request, filteredNodes, ctx);
        } else {
            this.dispatchUntargeted(request, filteredNodes, ctx);
        }
    }

    private boolean serviceShowsUpInConfig(ClusterConfig clusterConfig) {
        if (clusterConfig.globalConfig() != null) {
            for (PortInfo portInfo : clusterConfig.globalConfig().portInfos()) {
                if (!portInfo.ports().containsKey((Object)this.serviceType)) continue;
                return true;
            }
        }
        for (BucketConfig bucketConfig : clusterConfig.bucketConfigs().values()) {
            for (NodeInfo nodeInfo : bucketConfig.nodes()) {
                if (!nodeInfo.services().containsKey((Object)this.serviceType)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean checkServiceNotAvailable(Request<? extends Response> request, ClusterConfig config) {
        return true;
    }

    private void dispatchTargeted(Request<? extends Response> request, List<Node> nodes, CoreContext ctx) {
        for (Node n : nodes) {
            if (!n.identifier().equals(request.target())) continue;
            n.send(request);
            return;
        }
        RoundRobinLocator.handleTargetNotAvailable(request, nodes, ctx);
    }

    private static void handleTargetNotAvailable(Request<?> request, List<Node> nodes, CoreContext ctx) {
        NodeIdentifier target = Objects.requireNonNull(request.target());
        for (Node node : nodes) {
            if (!target.equals(node.identifier())) continue;
            RetryOrchestrator.maybeRetry(ctx, request, RetryReason.NODE_NOT_AVAILABLE);
            return;
        }
        request.cancel(CancellationReason.TARGET_NODE_REMOVED);
    }

    private void dispatchUntargeted(Request<? extends Response> request, List<Node> nodes, CoreContext ctx) {
        int nodeSize = nodes.size();
        int offset = (int)Math.floorMod(this.counter.getAndIncrement(), (long)nodeSize);
        Node node = nodes.get(offset);
        if (node != null) {
            node.send(request);
        } else {
            RetryOrchestrator.maybeRetry(ctx, request, RetryReason.NODE_NOT_AVAILABLE);
            ctx.environment().eventBus().publish(new NodeLocatorBugIdentifiedEvent(ctx));
        }
    }

    private List<Node> filterNodes(List<Node> allNodes, Request<? extends Response> request, ClusterConfig config) {
        ArrayList<Node> result = new ArrayList<Node>(allNodes.size());
        for (Node n : allNodes) {
            if (!n.serviceEnabled(this.serviceType) || !this.nodeCanBeUsed(n, request, config)) continue;
            result.add(n);
        }
        return result;
    }

    protected boolean nodeCanBeUsed(Node node, Request<? extends Response> request, ClusterConfig config) {
        return true;
    }
}

