/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.CoreContext;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.cnc.CbTracing;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.env.TimeoutConfig;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.error.context.ReducedKeyValueErrorContext;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.kv.CoreRangeScanItem;
import com.couchbase.client.core.kv.RangeScanOrchestrator;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.msg.kv.GetAndLockRequest;
import com.couchbase.client.core.msg.kv.GetAndTouchRequest;
import com.couchbase.client.core.msg.kv.GetMetaRequest;
import com.couchbase.client.core.msg.kv.GetRequest;
import com.couchbase.client.core.msg.kv.InsertRequest;
import com.couchbase.client.core.msg.kv.MutationToken;
import com.couchbase.client.core.msg.kv.RemoveRequest;
import com.couchbase.client.core.msg.kv.ReplaceRequest;
import com.couchbase.client.core.msg.kv.SubdocCommandType;
import com.couchbase.client.core.msg.kv.SubdocGetRequest;
import com.couchbase.client.core.msg.kv.SubdocMutateRequest;
import com.couchbase.client.core.msg.kv.TouchRequest;
import com.couchbase.client.core.msg.kv.UnlockRequest;
import com.couchbase.client.core.msg.kv.UpsertRequest;
import com.couchbase.client.core.retry.RetryStrategy;
import com.couchbase.client.core.service.kv.ReplicaHelper;
import com.couchbase.client.core.util.BucketConfigUtil;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.AsyncBinaryCollection;
import com.couchbase.client.java.ReactiveCollection;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.codec.Transcoder;
import com.couchbase.client.java.env.ClusterEnvironment;
import com.couchbase.client.java.kv.CommonDurabilityOptions;
import com.couchbase.client.java.kv.ExistsAccessor;
import com.couchbase.client.java.kv.ExistsOptions;
import com.couchbase.client.java.kv.ExistsResult;
import com.couchbase.client.java.kv.Expiry;
import com.couchbase.client.java.kv.GetAccessor;
import com.couchbase.client.java.kv.GetAllReplicasOptions;
import com.couchbase.client.java.kv.GetAndLockOptions;
import com.couchbase.client.java.kv.GetAndTouchOptions;
import com.couchbase.client.java.kv.GetAnyReplicaOptions;
import com.couchbase.client.java.kv.GetOptions;
import com.couchbase.client.java.kv.GetReplicaResult;
import com.couchbase.client.java.kv.GetResult;
import com.couchbase.client.java.kv.InsertAccessor;
import com.couchbase.client.java.kv.InsertOptions;
import com.couchbase.client.java.kv.LookupInAccessor;
import com.couchbase.client.java.kv.LookupInOptions;
import com.couchbase.client.java.kv.LookupInResult;
import com.couchbase.client.java.kv.LookupInSpec;
import com.couchbase.client.java.kv.MutateInAccessor;
import com.couchbase.client.java.kv.MutateInOptions;
import com.couchbase.client.java.kv.MutateInResult;
import com.couchbase.client.java.kv.MutateInSpec;
import com.couchbase.client.java.kv.MutationResult;
import com.couchbase.client.java.kv.PersistTo;
import com.couchbase.client.java.kv.RangeScan;
import com.couchbase.client.java.kv.RemoveAccessor;
import com.couchbase.client.java.kv.RemoveOptions;
import com.couchbase.client.java.kv.ReplaceAccessor;
import com.couchbase.client.java.kv.ReplaceOptions;
import com.couchbase.client.java.kv.SamplingScan;
import com.couchbase.client.java.kv.ScanOptions;
import com.couchbase.client.java.kv.ScanResult;
import com.couchbase.client.java.kv.ScanType;
import com.couchbase.client.java.kv.StoreSemantics;
import com.couchbase.client.java.kv.TouchAccessor;
import com.couchbase.client.java.kv.TouchOptions;
import com.couchbase.client.java.kv.UnlockAccessor;
import com.couchbase.client.java.kv.UnlockOptions;
import com.couchbase.client.java.kv.UpsertAccessor;
import com.couchbase.client.java.kv.UpsertOptions;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import reactor.core.publisher.Flux;

public class AsyncCollection {
    private final Core core;
    private final CoreContext coreContext;
    private final ClusterEnvironment environment;
    private final String name;
    private final String bucket;
    private final String scopeName;
    private final AsyncBinaryCollection asyncBinaryCollection;
    private final CollectionIdentifier collectionIdentifier;
    private final RangeScanOrchestrator rangeScanOrchestrator;

    AsyncCollection(String name, String scopeName, String bucket, Core core, ClusterEnvironment environment) {
        this.name = name;
        this.scopeName = scopeName;
        this.core = core;
        this.coreContext = core.context();
        this.environment = environment;
        this.bucket = bucket;
        this.collectionIdentifier = new CollectionIdentifier(bucket, Optional.of(scopeName), Optional.of(name));
        this.asyncBinaryCollection = new AsyncBinaryCollection(core, environment, this.collectionIdentifier);
        this.rangeScanOrchestrator = new RangeScanOrchestrator(core, this.collectionIdentifier);
    }

    @Stability.Volatile
    public Core core() {
        return this.core;
    }

    @Stability.Internal
    RangeScanOrchestrator rangeScanOrchestrator() {
        return this.rangeScanOrchestrator;
    }

    public ClusterEnvironment environment() {
        return this.environment;
    }

    public String name() {
        return this.name;
    }

    public String bucketName() {
        return this.bucket;
    }

    public String scopeName() {
        return this.scopeName;
    }

    public AsyncBinaryCollection binary() {
        return this.asyncBinaryCollection;
    }

    public CompletableFuture<GetResult> get(String id) {
        return this.get(id, ReactiveCollection.DEFAULT_GET_OPTIONS);
    }

    public CompletableFuture<GetResult> get(String id, GetOptions options) {
        Transcoder transcoder;
        Validators.notNull(options, "GetOptions", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier));
        GetOptions.Built opts = options.build();
        Transcoder transcoder2 = transcoder = opts.transcoder() == null ? this.environment.transcoder() : opts.transcoder();
        if (opts.projections().isEmpty() && !opts.withExpiry()) {
            return GetAccessor.get(this.core, this.fullGetRequest(id, opts), transcoder);
        }
        return GetAccessor.subdocGet(this.core, this.subdocGetRequest(id, opts), transcoder);
    }

    @Stability.Internal
    GetRequest fullGetRequest(String id, GetOptions.Built opts) {
        Validators.notNullOrEmpty(id, "Id", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier));
        Duration timeout = opts.timeout().orElse(this.environment.timeoutConfig().kvTimeout());
        RetryStrategy retryStrategy = opts.retryStrategy().orElse(this.environment.retryStrategy());
        RequestSpan span = this.environment.requestTracer().requestSpan("get", opts.parentSpan().orElse(null));
        GetRequest request = new GetRequest(id, timeout, this.coreContext, this.collectionIdentifier, retryStrategy, span);
        request.context().clientContext(opts.clientContext());
        return request;
    }

    @Stability.Internal
    SubdocGetRequest subdocGetRequest(String id, GetOptions.Built opts) {
        try {
            Validators.notNullOrEmpty(id, "Id");
            if (opts.withExpiry()) {
                if (opts.projections().size() > 15) {
                    throw InvalidArgumentException.fromMessage("Only a maximum of 16 fields can be projected per request due to a server limitation (includes the expiration macro as one field).");
                }
            } else if (opts.projections().size() > 16) {
                throw InvalidArgumentException.fromMessage("Only a maximum of 16 fields can be projected per request due to a server limitation.");
            }
        }
        catch (Exception cause) {
            throw new InvalidArgumentException("Argument validation failed", cause, ReducedKeyValueErrorContext.create(id, this.collectionIdentifier));
        }
        Duration timeout = opts.timeout().orElse(this.environment.timeoutConfig().kvTimeout());
        RetryStrategy retryStrategy = opts.retryStrategy().orElse(this.environment.retryStrategy());
        ArrayList<SubdocGetRequest.Command> commands = new ArrayList<SubdocGetRequest.Command>(16);
        if (!opts.projections().isEmpty()) {
            if (opts.projections().size() > 16) {
                throw new UnsupportedOperationException("Only a maximum of 16 fields can be projected per request.");
            }
            List<String> projections = opts.projections();
            for (int i = 0; i < projections.size(); ++i) {
                commands.add(new SubdocGetRequest.Command(SubdocCommandType.GET, projections.get(i), false, commands.size()));
            }
        } else {
            commands.add(new SubdocGetRequest.Command(SubdocCommandType.GET_DOC, "", false, commands.size()));
        }
        if (opts.withExpiry()) {
            commands.add(0, new SubdocGetRequest.Command(SubdocCommandType.GET, "$document.exptime", true, commands.size()));
            if (opts.projections().isEmpty()) {
                commands.add(1, new SubdocGetRequest.Command(SubdocCommandType.GET, "$document.flags", true, commands.size()));
            }
        }
        RequestSpan span = this.environment.requestTracer().requestSpan("lookup_in", opts.parentSpan().orElse(null));
        SubdocGetRequest request = new SubdocGetRequest(timeout, this.coreContext, this.collectionIdentifier, retryStrategy, id, 0, commands, span);
        request.context().clientContext(opts.clientContext());
        return request;
    }

    public CompletableFuture<GetResult> getAndLock(String id, Duration lockTime) {
        return this.getAndLock(id, lockTime, ReactiveCollection.DEFAULT_GET_AND_LOCK_OPTIONS);
    }

    public CompletableFuture<GetResult> getAndLock(String id, Duration lockTime, GetAndLockOptions options) {
        Validators.notNull(options, "GetAndLockOptions", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier));
        GetAndLockOptions.Built opts = options.build();
        Transcoder transcoder = opts.transcoder() == null ? this.environment.transcoder() : opts.transcoder();
        return GetAccessor.getAndLock(this.core, this.getAndLockRequest(id, lockTime, opts), transcoder);
    }

    @Stability.Internal
    GetAndLockRequest getAndLockRequest(String id, Duration lockTime, GetAndLockOptions.Built opts) {
        Validators.notNullOrEmpty(id, "Id", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier));
        Validators.notNull(lockTime, "LockTime", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier));
        Duration timeout = opts.timeout().orElse(this.environment.timeoutConfig().kvTimeout());
        RetryStrategy retryStrategy = opts.retryStrategy().orElse(this.environment.retryStrategy());
        RequestSpan span = this.environment.requestTracer().requestSpan("get_and_lock", opts.parentSpan().orElse(null));
        GetAndLockRequest request = new GetAndLockRequest(id, timeout, this.coreContext, this.collectionIdentifier, retryStrategy, lockTime, span);
        request.context().clientContext(opts.clientContext());
        return request;
    }

    public CompletableFuture<GetResult> getAndTouch(String id, Duration expiry) {
        return this.getAndTouch(id, expiry, ReactiveCollection.DEFAULT_GET_AND_TOUCH_OPTIONS);
    }

    public CompletableFuture<GetResult> getAndTouch(String id, Duration expiry, GetAndTouchOptions options) {
        Validators.notNull(expiry, "Expiry", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier));
        Validators.notNull(options, "GetAndTouchOptions", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier));
        GetAndTouchOptions.Built opts = options.build();
        Transcoder transcoder = opts.transcoder() == null ? this.environment.transcoder() : opts.transcoder();
        return GetAccessor.getAndTouch(this.core, this.getAndTouchRequest(id, Expiry.relative(expiry), opts), transcoder);
    }

    @Stability.Internal
    GetAndTouchRequest getAndTouchRequest(String id, Expiry expiry, GetAndTouchOptions.Built opts) {
        Validators.notNullOrEmpty(id, "Id", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier));
        Validators.notNull(expiry, "Expiry", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier));
        Duration timeout = opts.timeout().orElse(this.environment.timeoutConfig().kvTimeout());
        RetryStrategy retryStrategy = opts.retryStrategy().orElse(this.environment.retryStrategy());
        RequestSpan span = this.environment.requestTracer().requestSpan("get_and_touch", opts.parentSpan().orElse(null));
        long encodedExpiry = expiry.encode();
        GetAndTouchRequest request = new GetAndTouchRequest(id, timeout, this.coreContext, this.collectionIdentifier, retryStrategy, encodedExpiry, span);
        request.context().clientContext(opts.clientContext());
        return request;
    }

    public CompletableFuture<List<CompletableFuture<GetReplicaResult>>> getAllReplicas(String id) {
        return this.getAllReplicas(id, ReactiveCollection.DEFAULT_GET_ALL_REPLICAS_OPTIONS);
    }

    public CompletableFuture<List<CompletableFuture<GetReplicaResult>>> getAllReplicas(String id, GetAllReplicasOptions options) {
        Validators.notNull(options, "GetAllReplicasOptions");
        GetAllReplicasOptions.Built opts = options.build();
        Transcoder transcoder = opts.transcoder() == null ? this.environment.transcoder() : opts.transcoder();
        return ReplicaHelper.getAllReplicasAsync(this.core, this.collectionIdentifier, id, opts.timeout().orElse(this.environment.timeoutConfig().kvTimeout()), opts.retryStrategy().orElse(this.environment().retryStrategy()), opts.clientContext(), opts.parentSpan().orElse(null), response -> GetReplicaResult.from(response, transcoder));
    }

    public CompletableFuture<GetReplicaResult> getAnyReplica(String id) {
        return this.getAnyReplica(id, ReactiveCollection.DEFAULT_GET_ANY_REPLICA_OPTIONS);
    }

    public CompletableFuture<GetReplicaResult> getAnyReplica(String id, GetAnyReplicaOptions options) {
        Validators.notNullOrEmpty(id, "Id", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier));
        Validators.notNull(options, "GetAnyReplicaOptions", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier));
        GetAnyReplicaOptions.Built opts = options.build();
        Transcoder transcoder = opts.transcoder() == null ? this.environment.transcoder() : opts.transcoder();
        return ReplicaHelper.getAnyReplicaAsync(this.core, this.collectionIdentifier, id, opts.timeout().orElse(this.environment.timeoutConfig().kvTimeout()), opts.retryStrategy().orElse(this.environment().retryStrategy()), opts.clientContext(), opts.parentSpan().orElse(null), response -> GetReplicaResult.from(response, transcoder));
    }

    public CompletableFuture<ExistsResult> exists(String id) {
        return this.exists(id, ReactiveCollection.DEFAULT_EXISTS_OPTIONS);
    }

    public CompletableFuture<ExistsResult> exists(String id, ExistsOptions options) {
        return ExistsAccessor.exists(id, this.core, this.existsRequest(id, options));
    }

    GetMetaRequest existsRequest(String id, ExistsOptions options) {
        Validators.notNullOrEmpty(id, "Id", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier));
        Validators.notNull(options, "ExistsOptions", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier));
        ExistsOptions.Built opts = options.build();
        Duration timeout = opts.timeout().orElse(this.environment.timeoutConfig().kvTimeout());
        RetryStrategy retryStrategy = opts.retryStrategy().orElse(this.environment.retryStrategy());
        RequestSpan span = this.environment.requestTracer().requestSpan("exists", opts.parentSpan().orElse(null));
        GetMetaRequest request = new GetMetaRequest(id, timeout, this.coreContext, this.collectionIdentifier, retryStrategy, span);
        request.context().clientContext(opts.clientContext());
        return request;
    }

    public CompletableFuture<MutationResult> remove(String id) {
        return this.remove(id, ReactiveCollection.DEFAULT_REMOVE_OPTIONS);
    }

    public CompletableFuture<MutationResult> remove(String id, RemoveOptions options) {
        Validators.notNull(options, "RemoveOptions", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier));
        RemoveOptions.Built opts = options.build();
        return RemoveAccessor.remove(this.core, this.removeRequest(id, opts), id, opts.persistTo(), opts.replicateTo());
    }

    RemoveRequest removeRequest(String id, RemoveOptions.Built opts) {
        Validators.notNullOrEmpty(id, "Id", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier));
        Duration timeout = AsyncCollection.decideKvTimeout(opts, this.environment.timeoutConfig());
        RetryStrategy retryStrategy = opts.retryStrategy().orElse(this.environment.retryStrategy());
        RequestSpan span = this.environment.requestTracer().requestSpan("remove", opts.parentSpan().orElse(null));
        RemoveRequest request = new RemoveRequest(id, opts.cas(), timeout, this.coreContext, this.collectionIdentifier, retryStrategy, opts.durabilityLevel(), span);
        request.context().clientContext(opts.clientContext());
        return request;
    }

    public CompletableFuture<MutationResult> insert(String id, Object content) {
        return this.insert(id, content, ReactiveCollection.DEFAULT_INSERT_OPTIONS);
    }

    public CompletableFuture<MutationResult> insert(String id, Object content, InsertOptions options) {
        Validators.notNull(options, "InsertOptions", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier));
        InsertOptions.Built opts = options.build();
        return InsertAccessor.insert(this.core, this.insertRequest(id, content, opts), id, opts.persistTo(), opts.replicateTo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InsertRequest insertRequest(String id, Object content, InsertOptions.Built opts) {
        Transcoder.EncodedValue encoded;
        Validators.notNullOrEmpty(id, "Id", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier));
        Validators.notNull(content, "Content", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier));
        Duration timeout = AsyncCollection.decideKvTimeout(opts, this.environment.timeoutConfig());
        RetryStrategy retryStrategy = opts.retryStrategy().orElse(this.environment.retryStrategy());
        Transcoder transcoder = opts.transcoder() == null ? this.environment.transcoder() : opts.transcoder();
        RequestSpan span = this.environment.requestTracer().requestSpan("insert", opts.parentSpan().orElse(null));
        RequestSpan encodeSpan = CbTracing.newSpan(this.coreContext, "request_encoding", span);
        long start = System.nanoTime();
        try {
            encoded = transcoder.encode(content);
        }
        finally {
            encodeSpan.end();
        }
        long end = System.nanoTime();
        long expiry = opts.expiry().encode();
        InsertRequest request = new InsertRequest(id, encoded.encoded(), expiry, encoded.flags(), timeout, this.coreContext, this.collectionIdentifier, retryStrategy, opts.durabilityLevel(), span);
        request.context().clientContext(opts.clientContext()).encodeLatency(end - start);
        return request;
    }

    public CompletableFuture<MutationResult> upsert(String id, Object content) {
        return this.upsert(id, content, ReactiveCollection.DEFAULT_UPSERT_OPTIONS);
    }

    public CompletableFuture<MutationResult> upsert(String id, Object content, UpsertOptions options) {
        Validators.notNull(options, "UpsertOptions", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier));
        UpsertOptions.Built opts = options.build();
        return UpsertAccessor.upsert(this.core, this.upsertRequest(id, content, opts), id, opts.persistTo(), opts.replicateTo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UpsertRequest upsertRequest(String id, Object content, UpsertOptions.Built opts) {
        Transcoder.EncodedValue encoded;
        Validators.notNullOrEmpty(id, "Id", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier));
        Validators.notNull(content, "Content", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier));
        Duration timeout = AsyncCollection.decideKvTimeout(opts, this.environment.timeoutConfig());
        RetryStrategy retryStrategy = opts.retryStrategy().orElse(this.environment.retryStrategy());
        Transcoder transcoder = opts.transcoder() == null ? this.environment.transcoder() : opts.transcoder();
        RequestSpan span = this.environment.requestTracer().requestSpan("upsert", opts.parentSpan().orElse(null));
        RequestSpan encodeSpan = CbTracing.newSpan(this.coreContext, "request_encoding", span);
        long start = System.nanoTime();
        try {
            encoded = transcoder.encode(content);
        }
        finally {
            encodeSpan.end();
        }
        long end = System.nanoTime();
        long expiry = opts.expiry().encode();
        UpsertRequest request = new UpsertRequest(id, encoded.encoded(), expiry, opts.preserveExpiry(), encoded.flags(), timeout, this.coreContext, this.collectionIdentifier, retryStrategy, opts.durabilityLevel(), span);
        request.context().clientContext(opts.clientContext()).encodeLatency(end - start);
        return request;
    }

    public CompletableFuture<MutationResult> replace(String id, Object content) {
        return this.replace(id, content, ReactiveCollection.DEFAULT_REPLACE_OPTIONS);
    }

    public CompletableFuture<MutationResult> replace(String id, Object content, ReplaceOptions options) {
        Validators.notNull(options, "ReplaceOptions", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier));
        ReplaceOptions.Built opts = options.build();
        return ReplaceAccessor.replace(this.core, this.replaceRequest(id, content, opts), id, opts.persistTo(), opts.replicateTo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReplaceRequest replaceRequest(String id, Object content, ReplaceOptions.Built opts) {
        Transcoder.EncodedValue encoded;
        Validators.notNullOrEmpty(id, "Id", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier));
        Validators.notNull(content, "Content", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier));
        Duration timeout = AsyncCollection.decideKvTimeout(opts, this.environment.timeoutConfig());
        RetryStrategy retryStrategy = opts.retryStrategy().orElse(this.environment.retryStrategy());
        Transcoder transcoder = opts.transcoder() == null ? this.environment.transcoder() : opts.transcoder();
        RequestSpan span = this.environment.requestTracer().requestSpan("replace", opts.parentSpan().orElse(null));
        RequestSpan encodeSpan = CbTracing.newSpan(this.coreContext, "request_encoding", span);
        long start = System.nanoTime();
        try {
            encoded = transcoder.encode(content);
        }
        finally {
            encodeSpan.end();
        }
        long end = System.nanoTime();
        long expiry = opts.expiry().encode();
        ReplaceRequest request = new ReplaceRequest(id, encoded.encoded(), expiry, opts.preserveExpiry(), encoded.flags(), timeout, opts.cas(), this.coreContext, this.collectionIdentifier, retryStrategy, opts.durabilityLevel(), span);
        request.context().clientContext(opts.clientContext()).encodeLatency(end - start);
        return request;
    }

    public CompletableFuture<MutationResult> touch(String id, Duration expiry) {
        return this.touch(id, expiry, ReactiveCollection.DEFAULT_TOUCH_OPTIONS);
    }

    public CompletableFuture<MutationResult> touch(String id, Duration expiry, TouchOptions options) {
        Validators.notNull(expiry, "Expiry", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier));
        return TouchAccessor.touch(this.core, this.touchRequest(id, Expiry.relative(expiry), options), id);
    }

    TouchRequest touchRequest(String id, Expiry expiry, TouchOptions options) {
        Validators.notNullOrEmpty(id, "Id", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier));
        Validators.notNull(expiry, "Expiry", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier));
        Validators.notNull(options, "TouchOptions", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier));
        TouchOptions.Built opts = options.build();
        Duration timeout = opts.timeout().orElse(this.environment.timeoutConfig().kvTimeout());
        RetryStrategy retryStrategy = opts.retryStrategy().orElse(this.environment.retryStrategy());
        RequestSpan span = this.environment.requestTracer().requestSpan("touch", opts.parentSpan().orElse(null));
        long encodedExpiry = expiry.encode();
        TouchRequest request = new TouchRequest(timeout, this.coreContext, this.collectionIdentifier, retryStrategy, id, encodedExpiry, span);
        request.context().clientContext(opts.clientContext());
        return request;
    }

    public CompletableFuture<Void> unlock(String id, long cas) {
        return this.unlock(id, cas, ReactiveCollection.DEFAULT_UNLOCK_OPTIONS);
    }

    public CompletableFuture<Void> unlock(String id, long cas, UnlockOptions options) {
        return UnlockAccessor.unlock(id, this.core, this.unlockRequest(id, cas, options));
    }

    UnlockRequest unlockRequest(String id, long cas, UnlockOptions options) {
        Validators.notNullOrEmpty(id, "Id", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier));
        Validators.notNull(options, "UnlockOptions", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier));
        if (cas == 0L) {
            throw new InvalidArgumentException("CAS cannot be 0", null, ReducedKeyValueErrorContext.create(id, this.collectionIdentifier));
        }
        UnlockOptions.Built opts = options.build();
        Duration timeout = opts.timeout().orElse(this.environment.timeoutConfig().kvTimeout());
        RetryStrategy retryStrategy = opts.retryStrategy().orElse(this.environment.retryStrategy());
        RequestSpan span = this.environment.requestTracer().requestSpan("unlock", opts.parentSpan().orElse(null));
        UnlockRequest request = new UnlockRequest(timeout, this.coreContext, this.collectionIdentifier, retryStrategy, id, cas, span);
        request.context().clientContext(opts.clientContext());
        return request;
    }

    public CompletableFuture<LookupInResult> lookupIn(String id, List<LookupInSpec> specs) {
        return this.lookupIn(id, specs, ReactiveCollection.DEFAULT_LOOKUP_IN_OPTIONS);
    }

    public CompletableFuture<LookupInResult> lookupIn(String id, List<LookupInSpec> specs, LookupInOptions options) {
        Validators.notNull(options, "LookupInOptions", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier));
        LookupInOptions.Built opts = options.build();
        JsonSerializer serializer = opts.serializer() == null ? this.environment.jsonSerializer() : opts.serializer();
        return LookupInAccessor.lookupInAccessor(this.core, this.lookupInRequest(id, specs, opts), serializer);
    }

    SubdocGetRequest lookupInRequest(String id, List<LookupInSpec> specs, LookupInOptions.Built opts) {
        Validators.notNullOrEmpty(id, "Id", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier));
        Validators.notNullOrEmpty(specs, "LookupInSpecs", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier));
        ArrayList<SubdocGetRequest.Command> commands = new ArrayList<SubdocGetRequest.Command>(specs.size());
        for (int i = 0; i < specs.size(); ++i) {
            LookupInSpec spec = specs.get(i);
            commands.add(spec.export(i));
        }
        commands.sort(Comparator.comparing(v -> !v.xattr()));
        Duration timeout = opts.timeout().orElse(this.environment.timeoutConfig().kvTimeout());
        RetryStrategy retryStrategy = opts.retryStrategy().orElse(this.environment.retryStrategy());
        byte flags = 0;
        if (opts.accessDeleted()) {
            flags = (byte)(flags | 4);
        }
        RequestSpan span = this.environment.requestTracer().requestSpan("lookup_in", opts.parentSpan().orElse(null));
        SubdocGetRequest request = new SubdocGetRequest(timeout, this.coreContext, this.collectionIdentifier, retryStrategy, id, flags, commands, span);
        request.context().clientContext(opts.clientContext());
        return request;
    }

    public CompletableFuture<MutateInResult> mutateIn(String id, List<MutateInSpec> specs) {
        return this.mutateIn(id, specs, ReactiveCollection.DEFAULT_MUTATE_IN_OPTIONS);
    }

    public CompletableFuture<MutateInResult> mutateIn(String id, List<MutateInSpec> specs, MutateInOptions options) {
        Validators.notNull(options, "MutateInOptions", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier));
        MutateInOptions.Built opts = options.build();
        Duration timeout = AsyncCollection.decideKvTimeout(opts, this.environment.timeoutConfig());
        return this.mutateInRequest(id, specs, opts, timeout).thenCompose(request -> MutateInAccessor.mutateIn(this.core, request, id, opts.persistTo(), opts.replicateTo(), opts.storeSemantics() == StoreSemantics.INSERT, this.environment.jsonSerializer()));
    }

    @Stability.Volatile
    public CompletableFuture<List<ScanResult>> scan(ScanType scanType) {
        return this.scan(scanType, ScanOptions.scanOptions());
    }

    @Stability.Volatile
    public CompletableFuture<List<ScanResult>> scan(ScanType scanType, ScanOptions options) {
        return this.scanRequest(scanType, options).collectList().toFuture();
    }

    Flux<ScanResult> scanRequest(ScanType scanType, ScanOptions options) {
        Flux<CoreRangeScanItem> coreScanStream;
        Validators.notNull(scanType, "ScanType");
        Validators.notNull(options, "Options");
        ScanOptions.Built opts = options.build();
        Duration timeout = opts.timeout().orElse(this.environment().timeoutConfig().kvScanTimeout());
        Map<Short, MutationToken> consistencyTokens = opts.consistentWith().map(ms -> {
            HashMap<Short, MutationToken> tokens = new HashMap<Short, MutationToken>();
            for (MutationToken mt : ms) {
                tokens.put(mt.partitionID(), mt);
            }
            return tokens;
        }).orElse(Collections.emptyMap());
        if (scanType instanceof RangeScan) {
            RangeScan rs = (RangeScan)scanType;
            coreScanStream = this.rangeScanOrchestrator.rangeScan(rs.from().id(), rs.from().exclusive(), rs.to().id(), rs.to().exclusive(), timeout, opts.batchItemLimit(), opts.batchByteLimit(), opts.idsOnly(), opts.sort().intoCore(), opts.parentSpan(), consistencyTokens);
        } else if (scanType instanceof SamplingScan) {
            SamplingScan ss = (SamplingScan)scanType;
            coreScanStream = this.rangeScanOrchestrator.samplingScan(ss.limit(), ss.seed(), timeout, opts.batchItemLimit(), opts.batchByteLimit(), opts.idsOnly(), opts.sort().intoCore(), opts.parentSpan(), consistencyTokens);
        } else {
            return Flux.error(InvalidArgumentException.fromMessage("Unsupported ScanType: " + scanType));
        }
        Transcoder transcoder = opts.transcoder() == null ? this.environment().transcoder() : opts.transcoder();
        return coreScanStream.map(item -> new ScanResult(opts.idsOnly(), item.key(), item.value(), item.flags(), item.cas(), Optional.ofNullable(item.expiry()), transcoder));
    }

    CompletableFuture<SubdocMutateRequest> mutateInRequest(String id, List<MutateInSpec> specs, MutateInOptions.Built opts, Duration timeout) {
        Validators.notNullOrEmpty(id, "Id", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier));
        Validators.notNullOrEmpty(specs, "MutateInSpecs", () -> ReducedKeyValueErrorContext.create(id, this.collectionIdentifier));
        if (specs.isEmpty()) {
            throw SubdocMutateRequest.errIfNoCommands(ReducedKeyValueErrorContext.create(id, this.collectionIdentifier));
        }
        if (specs.size() > 16) {
            throw SubdocMutateRequest.errIfTooManyCommands(ReducedKeyValueErrorContext.create(id, this.collectionIdentifier));
        }
        boolean requiresBucketConfig = opts.createAsDeleted() || opts.storeSemantics() == StoreSemantics.REVIVE;
        CompletableFuture<Object> bucketConfigFuture = requiresBucketConfig ? BucketConfigUtil.waitForBucketConfig(this.core, this.bucketName(), timeout).toFuture() : CompletableFuture.completedFuture(null);
        return bucketConfigFuture.thenCompose(bucketConfig -> {
            RetryStrategy retryStrategy = opts.retryStrategy().orElse(this.environment.retryStrategy());
            JsonSerializer serializer = opts.serializer() == null ? this.environment.jsonSerializer() : opts.serializer();
            RequestSpan span = this.environment.requestTracer().requestSpan("mutate_in", opts.parentSpan().orElse(null));
            ArrayList<SubdocMutateRequest.Command> commands = new ArrayList<SubdocMutateRequest.Command>(specs.size());
            RequestSpan encodeSpan = CbTracing.newSpan(this.coreContext, "request_encoding", span);
            long start = System.nanoTime();
            try {
                for (int i = 0; i < specs.size(); ++i) {
                    MutateInSpec spec = (MutateInSpec)specs.get(i);
                    commands.add(spec.encode(serializer, i));
                }
            }
            finally {
                encodeSpan.end();
            }
            long end = System.nanoTime();
            commands.sort(Comparator.comparing(v -> !v.xattr()));
            long expiry = opts.expiry().encode();
            SubdocMutateRequest request = new SubdocMutateRequest(timeout, this.coreContext, this.collectionIdentifier, (BucketConfig)bucketConfig, retryStrategy, id, opts.storeSemantics() == StoreSemantics.INSERT, opts.storeSemantics() == StoreSemantics.UPSERT, opts.storeSemantics() == StoreSemantics.REVIVE, opts.accessDeleted(), opts.createAsDeleted(), (List<SubdocMutateRequest.Command>)commands, expiry, opts.preserveExpiry(), opts.cas(), opts.durabilityLevel(), span);
            request.context().clientContext(opts.clientContext()).encodeLatency(end - start);
            CompletableFuture<SubdocMutateRequest> future = new CompletableFuture<SubdocMutateRequest>();
            future.complete(request);
            return future;
        });
    }

    static Duration decideKvTimeout(CommonDurabilityOptions.BuiltCommonDurabilityOptions opts, TimeoutConfig config) {
        boolean pollDurability;
        Optional<Duration> userTimeout = opts.timeout();
        if (userTimeout.isPresent()) {
            return userTimeout.get();
        }
        boolean syncDurability = opts.durabilityLevel().isPresent() && (opts.durabilityLevel().get() == DurabilityLevel.MAJORITY_AND_PERSIST_TO_ACTIVE || opts.durabilityLevel().get() == DurabilityLevel.PERSIST_TO_MAJORITY);
        boolean bl = pollDurability = opts.persistTo() != PersistTo.NONE;
        if (syncDurability || pollDurability) {
            return config.kvDurableTimeout();
        }
        return config.kvTimeout();
    }

    CollectionIdentifier collectionIdentifier() {
        return this.collectionIdentifier;
    }
}

