/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.Reactor;
import com.couchbase.client.core.error.context.ReducedKeyValueErrorContext;
import com.couchbase.client.core.msg.kv.AppendRequest;
import com.couchbase.client.core.msg.kv.DecrementRequest;
import com.couchbase.client.core.msg.kv.IncrementRequest;
import com.couchbase.client.core.msg.kv.PrependRequest;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.AsyncBinaryCollection;
import com.couchbase.client.java.kv.AppendAccessor;
import com.couchbase.client.java.kv.AppendOptions;
import com.couchbase.client.java.kv.CounterAccessor;
import com.couchbase.client.java.kv.CounterResult;
import com.couchbase.client.java.kv.DecrementOptions;
import com.couchbase.client.java.kv.IncrementOptions;
import com.couchbase.client.java.kv.MutationResult;
import com.couchbase.client.java.kv.PrependAccessor;
import com.couchbase.client.java.kv.PrependOptions;
import reactor.core.publisher.Mono;

public class ReactiveBinaryCollection {
    private final AsyncBinaryCollection async;
    private final Core core;

    ReactiveBinaryCollection(Core core, AsyncBinaryCollection async) {
        this.core = core;
        this.async = async;
    }

    public Mono<MutationResult> append(String id, byte[] content) {
        return this.append(id, content, AsyncBinaryCollection.DEFAULT_APPEND_OPTIONS);
    }

    public Mono<MutationResult> append(String id, byte[] content, AppendOptions options) {
        return Mono.defer(() -> {
            Validators.notNull(options, "AppendOptions", () -> ReducedKeyValueErrorContext.create(id, this.async.collectionIdentifier()));
            AppendOptions.Built opts = options.build();
            AppendRequest request = this.async.appendRequest(id, content, opts);
            return Reactor.wrap(request, AppendAccessor.append(this.core, request, id, opts.persistTo(), opts.replicateTo()), true);
        });
    }

    public Mono<MutationResult> prepend(String id, byte[] content) {
        return this.prepend(id, content, AsyncBinaryCollection.DEFAULT_PREPEND_OPTIONS);
    }

    public Mono<MutationResult> prepend(String id, byte[] content, PrependOptions options) {
        return Mono.defer(() -> {
            Validators.notNull(options, "PrependOptions", () -> ReducedKeyValueErrorContext.create(id, this.async.collectionIdentifier()));
            PrependOptions.Built opts = options.build();
            PrependRequest request = this.async.prependRequest(id, content, opts);
            return Reactor.wrap(request, PrependAccessor.prepend(this.core, request, id, opts.persistTo(), opts.replicateTo()), true);
        });
    }

    public Mono<CounterResult> increment(String id) {
        return this.increment(id, AsyncBinaryCollection.DEFAULT_INCREMENT_OPTIONS);
    }

    public Mono<CounterResult> increment(String id, IncrementOptions options) {
        return Mono.defer(() -> {
            Validators.notNull(options, "IncrementOptions", () -> ReducedKeyValueErrorContext.create(id, this.async.collectionIdentifier()));
            IncrementOptions.Built opts = options.build();
            IncrementRequest request = this.async.incrementRequest(id, opts);
            return Reactor.wrap(request, CounterAccessor.increment(this.core, request, id, opts.persistTo(), opts.replicateTo()), true);
        });
    }

    public Mono<CounterResult> decrement(String id) {
        return this.decrement(id, AsyncBinaryCollection.DEFAULT_DECREMENT_OPTIONS);
    }

    public Mono<CounterResult> decrement(String id, DecrementOptions options) {
        return Mono.defer(() -> {
            Validators.notNull(options, "DecrementOptions", () -> ReducedKeyValueErrorContext.create(id, this.async.collectionIdentifier()));
            DecrementOptions.Built opts = options.build();
            DecrementRequest request = this.async.decrementRequest(id, opts);
            return Reactor.wrap(request, CounterAccessor.decrement(this.core, request, id, opts.persistTo(), opts.replicateTo()), true);
        });
    }
}

