/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.codec;

import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.msg.kv.CodecFlags;
import com.couchbase.client.java.CommonOptions;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.codec.Transcoder;
import com.couchbase.client.java.codec.TypeRef;
import java.util.Objects;

public class JsonTranscoder
implements Transcoder {
    private final JsonSerializer serializer;

    public static JsonTranscoder create(JsonSerializer serializer) {
        return new JsonTranscoder(serializer);
    }

    private JsonTranscoder(JsonSerializer serializer) {
        this.serializer = Objects.requireNonNull(serializer);
    }

    @Override
    public Transcoder.EncodedValue encode(Object input) {
        if (input instanceof CommonOptions.BuiltCommonOptions || input instanceof CommonOptions) {
            throw InvalidArgumentException.fromMessage("No content provided, cannot encode " + input.getClass().getSimpleName() + " as content!");
        }
        if (input instanceof byte[]) {
            throw InvalidArgumentException.fromMessage("byte[] input is not supported for the JsonTranscoder!. If you want to store already encoded JSON, use the RawJsonTranscoder, otherwise store it with the RawBinaryTranscoder!");
        }
        return new Transcoder.EncodedValue(this.serializer.serialize(input), CodecFlags.JSON_COMPAT_FLAGS);
    }

    @Override
    public <T> T decode(Class<T> target, byte[] input, int flags) {
        if (target.equals(byte[].class)) {
            throw InvalidArgumentException.fromMessage("byte[] input is not supported for the JsonTranscoder!. If you want to read already encoded JSON, use the RawJsonTranscoder, otherwise read it with the RawBinaryTranscoder!");
        }
        return this.serializer.deserialize(target, input);
    }

    @Override
    public <T> T decode(TypeRef<T> target, byte[] input, int flags) {
        return this.serializer.deserialize(target, input);
    }
}

