/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.codec;

import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.java.codec.Transcoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Sdk2CompatibleLegacyTranscoder
implements Transcoder {
    public static final Sdk2CompatibleLegacyTranscoder INSTANCE = new Sdk2CompatibleLegacyTranscoder();
    public static final int DEFAULT_COMPRESSION_THRESHOLD = 16384;
    private static final Pattern DECIMAL_PATTERN = Pattern.compile("^-?\\d+$");
    static final int SERIALIZED = 1;
    static final int COMPRESSED = 2;
    private static final int SPECIAL_MASK = 65280;
    static final int SPECIAL_BOOLEAN = 256;
    static final int SPECIAL_INT = 512;
    static final int SPECIAL_LONG = 768;
    static final int SPECIAL_DATE = 1024;
    static final int SPECIAL_BYTE = 1280;
    static final int SPECIAL_FLOAT = 1536;
    static final int SPECIAL_DOUBLE = 1792;
    static final int SPECIAL_BYTEARRAY = 2048;
    private final int compressionThreshold;

    public Sdk2CompatibleLegacyTranscoder() {
        this(16384);
    }

    public Sdk2CompatibleLegacyTranscoder(int compressionThreshold) {
        this.compressionThreshold = compressionThreshold;
    }

    @Override
    public Transcoder.EncodedValue encode(Object input) {
        byte[] compressed;
        byte[] encoded;
        int flags = 0;
        boolean isJson = false;
        if (input instanceof String) {
            String c = (String)input;
            isJson = Sdk2CompatibleLegacyTranscoder.isJsonObject(c);
            encoded = c.getBytes(StandardCharsets.UTF_8);
        } else if (input instanceof Long) {
            flags |= 0x300;
            encoded = Sdk2CompatibleLegacyTranscoder.encodeNum((Long)input, 8);
        } else if (input instanceof Integer) {
            flags |= 0x200;
            encoded = Sdk2CompatibleLegacyTranscoder.encodeNum(((Integer)input).intValue(), 4);
        } else if (input instanceof Boolean) {
            flags |= 0x100;
            boolean b = (Boolean)input;
            encoded = new byte[]{(byte)(b ? 49 : 48)};
        } else if (input instanceof Date) {
            flags |= 0x400;
            encoded = Sdk2CompatibleLegacyTranscoder.encodeNum(((Date)input).getTime(), 8);
        } else if (input instanceof Byte) {
            flags |= 0x500;
            encoded = new byte[]{(Byte)input};
        } else if (input instanceof Float) {
            flags |= 0x600;
            encoded = Sdk2CompatibleLegacyTranscoder.encodeNum(Float.floatToRawIntBits(((Float)input).floatValue()), 4);
        } else if (input instanceof Double) {
            flags |= 0x700;
            encoded = Sdk2CompatibleLegacyTranscoder.encodeNum(Double.doubleToRawLongBits((Double)input), 8);
        } else if (input instanceof byte[]) {
            flags |= 0x800;
            encoded = (byte[])input;
        } else {
            flags |= 1;
            encoded = Sdk2CompatibleLegacyTranscoder.serialize(input);
        }
        if (!isJson && encoded.length >= this.compressionThreshold && (compressed = this.compress(encoded)).length < encoded.length) {
            encoded = compressed;
            flags |= 2;
        }
        return new Transcoder.EncodedValue(encoded, flags);
    }

    @Override
    public <T> T decode(Class<T> target, byte[] input, int flags) {
        Object decoded;
        block12: {
            block13: {
                int maskedFlags;
                block11: {
                    if ((flags & 2) != 0) {
                        input = this.decompress(input);
                    }
                    maskedFlags = flags & 0xFF00;
                    if ((flags & 1) == 0 || input == null) break block11;
                    decoded = this.deserialize(input);
                    break block12;
                }
                if (maskedFlags == 0 || input == null) break block13;
                switch (maskedFlags) {
                    case 256: {
                        decoded = input[0] == 49;
                        break block12;
                    }
                    case 512: {
                        decoded = (int)Sdk2CompatibleLegacyTranscoder.decodeLong(input);
                        break block12;
                    }
                    case 768: {
                        decoded = Sdk2CompatibleLegacyTranscoder.decodeLong(input);
                        break block12;
                    }
                    case 1024: {
                        decoded = new Date(Sdk2CompatibleLegacyTranscoder.decodeLong(input));
                        break block12;
                    }
                    case 1280: {
                        decoded = input[0];
                        break block12;
                    }
                    case 1536: {
                        decoded = Float.valueOf(Float.intBitsToFloat((int)Sdk2CompatibleLegacyTranscoder.decodeLong(input)));
                        break block12;
                    }
                    case 1792: {
                        decoded = Double.longBitsToDouble(Sdk2CompatibleLegacyTranscoder.decodeLong(input));
                        break block12;
                    }
                    case 2048: {
                        decoded = input;
                        break block12;
                    }
                    default: {
                        throw new CouchbaseException("Undecodeable with flags " + flags);
                    }
                }
            }
            decoded = new String(input, StandardCharsets.UTF_8);
        }
        return (T)decoded;
    }

    private static boolean isJsonObject(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        return s.startsWith("{") || s.startsWith("[") || "true".equals(s) || "false".equals(s) || "null".equals(s) || DECIMAL_PATTERN.matcher(s).matches();
    }

    protected byte[] compress(byte[] in) {
        if (in == null) {
            throw new NullPointerException("Can't compress null");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        GZIPOutputStream gz = null;
        try {
            gz = new GZIPOutputStream(bos);
            gz.write(in);
        }
        catch (IOException e) {
            throw new RuntimeException("IO exception compressing data", e);
        }
        finally {
            try {
                if (gz != null) {
                    gz.close();
                }
            }
            catch (Exception exception) {}
            try {
                bos.close();
            }
            catch (Exception exception) {}
        }
        return bos.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] decompress(byte[] in) {
        ByteArrayOutputStream bos = null;
        if (in != null) {
            ByteArrayInputStream bis = new ByteArrayInputStream(in);
            bos = new ByteArrayOutputStream();
            GZIPInputStream gis = null;
            try {
                int r;
                gis = new GZIPInputStream(bis);
                byte[] buf = new byte[8192];
                while ((r = gis.read(buf)) > 0) {
                    bos.write(buf, 0, r);
                }
            }
            catch (IOException e) {
                bos = null;
            }
            finally {
                try {
                    if (bos != null) {
                        bos.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    if (gis != null) {
                        gis.close();
                    }
                }
                catch (Exception exception) {}
                try {
                    bis.close();
                }
                catch (Exception exception) {}
            }
        }
        return bos == null ? null : bos.toByteArray();
    }

    public static byte[] encodeNum(long l, int maxBytes) {
        int firstNon0;
        byte[] rv = new byte[maxBytes];
        for (int i = 0; i < rv.length; ++i) {
            int pos = rv.length - i - 1;
            rv[pos] = (byte)(l >> 8 * i & 0xFFL);
        }
        for (firstNon0 = 0; firstNon0 < rv.length && rv[firstNon0] == 0; ++firstNon0) {
        }
        if (firstNon0 > 0) {
            byte[] tmp = new byte[rv.length - firstNon0];
            System.arraycopy(rv, firstNon0, tmp, 0, rv.length - firstNon0);
            rv = tmp;
        }
        return rv;
    }

    private static byte[] serialize(Object content) {
        byte[] rv;
        if (content == null) {
            throw new NullPointerException("Can't serialize null");
        }
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             ObjectOutputStream os = new ObjectOutputStream(bos);){
            os.writeObject(content);
            os.close();
            bos.close();
            rv = bos.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Non-serializable object", e);
        }
        return rv;
    }

    protected Object deserialize(byte[] in) {
        Object rv = null;
        ByteArrayInputStream bis = null;
        ObjectInputStream is = null;
        try {
            if (in != null) {
                bis = new ByteArrayInputStream(in);
                is = new ObjectInputStream(bis);
                rv = is.readObject();
                is.close();
                bis.close();
            }
        }
        catch (IOException e) {
            throw new CouchbaseException("Caught IOException decoding bytes of data", e);
        }
        catch (ClassNotFoundException e) {
            throw new CouchbaseException("Caught ClassNotFoundException decoding bytes of data", e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Exception exception) {}
        }
        return rv;
    }

    static long decodeLong(byte[] b) {
        long rv = 0L;
        for (int n : b) {
            rv = rv << 8 | (long)(n < 0 ? 256 + n : n);
        }
        return rv;
    }
}

