/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.datastructures;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.CasMismatchException;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.DocumentExistsException;
import com.couchbase.client.core.error.DocumentNotFoundException;
import com.couchbase.client.core.error.context.ReducedKeyValueErrorContext;
import com.couchbase.client.core.error.subdoc.PathNotFoundException;
import com.couchbase.client.core.retry.reactor.RetryExhaustedException;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.Collection;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.kv.ArrayListOptions;
import com.couchbase.client.java.kv.GetOptions;
import com.couchbase.client.java.kv.GetResult;
import com.couchbase.client.java.kv.InsertOptions;
import com.couchbase.client.java.kv.LookupInOptions;
import com.couchbase.client.java.kv.LookupInResult;
import com.couchbase.client.java.kv.LookupInSpec;
import com.couchbase.client.java.kv.MutateInResult;
import com.couchbase.client.java.kv.MutateInSpec;
import com.couchbase.client.java.kv.MutationResult;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.ListIterator;

@Stability.Volatile
public class CouchbaseArrayList<E>
extends AbstractList<E> {
    private final String id;
    private final Collection collection;
    private final ArrayListOptions.Built arrayListOptions;
    private final GetOptions getOptions;
    private final LookupInOptions lookupInOptions;
    private final InsertOptions insertOptions;
    private final Class<E> entityTypeClass;

    public CouchbaseArrayList(String id, Collection collection, Class<E> entityType, ArrayListOptions options) {
        Validators.notNull(collection, "Collection", () -> ReducedKeyValueErrorContext.create(id, null, null, null));
        Validators.notNullOrEmpty(id, "Id", () -> ReducedKeyValueErrorContext.create(id, collection.bucketName(), collection.scopeName(), collection.name()));
        Validators.notNull(entityType, "EntityType", () -> ReducedKeyValueErrorContext.create(id, collection.bucketName(), collection.scopeName(), collection.name()));
        Validators.notNull(options, "ArrayListOptions", () -> ReducedKeyValueErrorContext.create(id, collection.bucketName(), collection.scopeName(), collection.name()));
        this.collection = collection;
        this.id = id;
        this.entityTypeClass = entityType;
        ArrayListOptions.Built optionsIn = options.build();
        ArrayListOptions opts = ArrayListOptions.arrayListOptions();
        optionsIn.copyInto(opts);
        this.arrayListOptions = opts.build();
        this.getOptions = optionsIn.getOptions();
        this.lookupInOptions = optionsIn.lookupInOptions();
        this.insertOptions = optionsIn.insertOptions();
    }

    @Override
    public E get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        String idx = "[" + index + "]";
        try {
            LookupInResult result = this.collection.lookupIn(this.id, Collections.singletonList(LookupInSpec.get(idx)), this.lookupInOptions);
            if (!result.exists(0)) {
                throw new IndexOutOfBoundsException("Index: " + index);
            }
            return result.contentAs(0, this.entityTypeClass);
        }
        catch (DocumentNotFoundException e) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
    }

    @Override
    public int size() {
        try {
            LookupInResult result = this.collection.lookupIn(this.id, Collections.singletonList(LookupInSpec.count("")), this.lookupInOptions);
            return result.contentAs(0, Integer.class);
        }
        catch (DocumentNotFoundException e) {
            return 0;
        }
    }

    @Override
    public boolean isEmpty() {
        try {
            LookupInResult current = this.collection.lookupIn(this.id, Collections.singletonList(LookupInSpec.exists("[0]")), this.lookupInOptions);
            return !current.exists(0);
        }
        catch (DocumentNotFoundException e) {
            return true;
        }
    }

    @Override
    public E set(int index, E element) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        String idx = "[" + index + "]";
        for (int i = 0; i < this.arrayListOptions.casMismatchRetries(); ++i) {
            try {
                LookupInResult current = this.collection.lookupIn(this.id, Collections.singletonList(LookupInSpec.get(idx)), this.lookupInOptions);
                long returnCas = current.cas();
                E result = current.contentAs(0, this.entityTypeClass);
                this.collection.mutateIn(this.id, Collections.singletonList(MutateInSpec.replace(idx, element)), this.arrayListOptions.mutateInOptions().cas(returnCas));
                return result;
            }
            catch (DocumentNotFoundException e) {
                this.createEmptyList();
                continue;
            }
            catch (CasMismatchException e) {
                continue;
            }
            catch (PathNotFoundException ex) {
                throw new IndexOutOfBoundsException("Index: " + index);
            }
        }
        throw new CouchbaseException("CouchbaseArrayList set failed", new RetryExhaustedException("Couldn't perform set in less than " + this.arrayListOptions.casMismatchRetries() + " iterations. It is likely concurrent modifications of this document are the reason"));
    }

    @Override
    public void add(int index, E element) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        try {
            for (int retry = 0; retry < 2; ++retry) {
                try {
                    this.collection.mutateIn(this.id, Collections.singletonList(MutateInSpec.arrayInsert("[" + index + "]", Collections.singletonList(element))), this.arrayListOptions.mutateInOptions());
                    return;
                }
                catch (DocumentNotFoundException e) {
                    this.createEmptyList();
                    continue;
                }
            }
        }
        catch (PathNotFoundException e) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
    }

    @Override
    public E remove(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        String idx = "[" + index + "]";
        for (int i = 0; i < this.arrayListOptions.casMismatchRetries(); ++i) {
            try {
                LookupInResult current = this.collection.lookupIn(this.id, Collections.singletonList(LookupInSpec.get(idx)), this.lookupInOptions);
                long returnCas = current.cas();
                E result = current.contentAs(0, this.entityTypeClass);
                this.collection.mutateIn(this.id, Collections.singletonList(MutateInSpec.remove(idx)), this.arrayListOptions.mutateInOptions().cas(returnCas));
                return result;
            }
            catch (DocumentNotFoundException e) {
                throw new IndexOutOfBoundsException("Index:" + index);
            }
            catch (CasMismatchException e) {
                continue;
            }
            catch (PathNotFoundException e) {
                throw new IndexOutOfBoundsException("Index: " + index);
            }
        }
        throw new CouchbaseException("CouchbaseArrayList remove failed", new RetryExhaustedException("Couldn't perform remove in less than " + this.arrayListOptions.casMismatchRetries() + " iterations. It is likely concurrent modifications of this document are the reason"));
    }

    @Override
    public boolean contains(Object o) {
        return super.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return new CouchbaseListIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new CouchbaseListIterator(index);
    }

    @Override
    public void clear() {
        try {
            this.collection.remove(this.id);
        }
        catch (DocumentNotFoundException documentNotFoundException) {
            // empty catch block
        }
    }

    private long createEmptyList() {
        try {
            MutationResult resp = this.collection.insert(this.id, JsonArray.create(), this.insertOptions);
            return resp.cas();
        }
        catch (DocumentExistsException ex) {
            return 0L;
        }
    }

    private class CouchbaseListIterator
    implements ListIterator<E> {
        private long cas;
        private final ListIterator<E> delegate;
        private int cursor;
        private int lastVisited;

        CouchbaseListIterator(int index) {
            JsonArray current;
            try {
                GetResult result = CouchbaseArrayList.this.collection.get(CouchbaseArrayList.this.id, CouchbaseArrayList.this.getOptions);
                current = result.contentAs(JsonArray.class);
                this.cas = result.cas();
            }
            catch (DocumentNotFoundException e) {
                current = JsonArray.create();
                this.cas = 0L;
            }
            ArrayList list = new ArrayList(current.size());
            for (Object value : current) {
                list.add(value);
            }
            this.delegate = list.listIterator(index);
            this.lastVisited = -1;
            this.cursor = index;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public E next() {
            Object next = this.delegate.next();
            this.lastVisited = this.cursor++;
            return next;
        }

        @Override
        public boolean hasPrevious() {
            return this.delegate.hasPrevious();
        }

        @Override
        public E previous() {
            Object previous = this.delegate.previous();
            --this.cursor;
            this.lastVisited = this.cursor;
            return previous;
        }

        @Override
        public int nextIndex() {
            return this.delegate.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.delegate.previousIndex();
        }

        @Override
        public void remove() {
            if (this.lastVisited < 0) {
                throw new IllegalStateException();
            }
            int index = this.lastVisited;
            String idx = "[" + index + "]";
            try {
                MutateInResult updated = CouchbaseArrayList.this.collection.mutateIn(CouchbaseArrayList.this.id, Collections.singletonList(MutateInSpec.remove(idx)), CouchbaseArrayList.this.arrayListOptions.mutateInOptions().cas(this.cas));
                this.cas = updated.cas();
                this.delegate.remove();
                this.cursor = this.lastVisited;
                this.lastVisited = -1;
            }
            catch (CasMismatchException | DocumentNotFoundException ex) {
                throw new ConcurrentModificationException("List was modified since iterator creation: " + ex);
            }
            catch (PathNotFoundException ex) {
                throw new ConcurrentModificationException("Element doesn't exist anymore at index: " + index);
            }
        }

        @Override
        public void set(E e) {
            if (this.lastVisited < 0) {
                throw new IllegalStateException();
            }
            int index = this.lastVisited;
            String idx = "[" + index + "]";
            try {
                MutateInResult updated = CouchbaseArrayList.this.collection.mutateIn(CouchbaseArrayList.this.id, Collections.singletonList(MutateInSpec.replace(idx, e)), CouchbaseArrayList.this.arrayListOptions.mutateInOptions().cas(this.cas));
                this.cas = updated.cas();
                this.delegate.set(e);
            }
            catch (CasMismatchException | DocumentNotFoundException ex) {
                throw new ConcurrentModificationException("List was modified since iterator creation: " + ex);
            }
            catch (PathNotFoundException ex) {
                throw new ConcurrentModificationException("Element doesn't exist anymore at index: " + index);
            }
        }

        @Override
        public void add(E e) {
            int index = this.cursor++;
            String idx = "[" + index + "]";
            try {
                MutateInResult updated = CouchbaseArrayList.this.collection.mutateIn(CouchbaseArrayList.this.id, Collections.singletonList(MutateInSpec.arrayInsert(idx, Collections.singletonList(e))), CouchbaseArrayList.this.arrayListOptions.mutateInOptions().cas(this.cas));
                this.cas = updated.cas();
                this.delegate.add(e);
                this.lastVisited = -1;
            }
            catch (DocumentNotFoundException ex) {
                if (this.delegate.nextIndex() == 0 && !this.delegate.hasNext()) {
                    this.cas = CouchbaseArrayList.this.createEmptyList();
                    this.add(e);
                }
                throw new ConcurrentModificationException("List was modified since iterator creation", ex);
            }
            catch (CasMismatchException ex) {
                throw new ConcurrentModificationException("List was modified since iterator creation", ex);
            }
            catch (PathNotFoundException ex) {
                throw new ConcurrentModificationException("Element doesn't exist anymore at index: " + index);
            }
        }
    }
}

