/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.datastructures;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.CasMismatchException;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.DocumentExistsException;
import com.couchbase.client.core.error.DocumentNotFoundException;
import com.couchbase.client.core.error.context.ReducedKeyValueErrorContext;
import com.couchbase.client.core.error.subdoc.PathNotFoundException;
import com.couchbase.client.core.retry.reactor.RetryExhaustedException;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.Collection;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.kv.GetOptions;
import com.couchbase.client.java.kv.InsertOptions;
import com.couchbase.client.java.kv.LookupInOptions;
import com.couchbase.client.java.kv.LookupInResult;
import com.couchbase.client.java.kv.LookupInSpec;
import com.couchbase.client.java.kv.MapOptions;
import com.couchbase.client.java.kv.MutateInSpec;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@Stability.Committed
public class CouchbaseMap<E>
extends AbstractMap<String, E> {
    private final String id;
    private final Collection collection;
    private final Class<E> entityTypeClass;
    private final MapOptions.Built mapOptions;
    private final GetOptions getOptions;
    private final LookupInOptions lookupInOptions;
    private final InsertOptions insertOptions;

    public CouchbaseMap(String id, Collection collection, Class<E> entityType, MapOptions options) {
        Validators.notNull(collection, "Collection", () -> ReducedKeyValueErrorContext.create(id, null, null, null));
        Validators.notNullOrEmpty(id, "Id", () -> ReducedKeyValueErrorContext.create(id, collection.bucketName(), collection.scopeName(), collection.name()));
        Validators.notNull(entityType, "EntityType", () -> ReducedKeyValueErrorContext.create(id, collection.bucketName(), collection.scopeName(), collection.name()));
        Validators.notNull(options, "MapOptions", () -> ReducedKeyValueErrorContext.create(id, collection.bucketName(), collection.scopeName(), collection.name()));
        this.id = id;
        this.collection = collection;
        this.entityTypeClass = entityType;
        MapOptions.Built optionsIn = options.build();
        MapOptions mapOpts = MapOptions.mapOptions();
        optionsIn.copyInto(mapOpts);
        this.mapOptions = mapOpts.build();
        this.getOptions = optionsIn.getOptions();
        this.lookupInOptions = optionsIn.lookupInOptions();
        this.insertOptions = optionsIn.insertOptions();
    }

    @Override
    public E put(String key, E value) {
        this.checkKey(key);
        for (int i = 0; i < this.mapOptions.casMismatchRetries(); ++i) {
            try {
                long returnCas = 0L;
                E result = null;
                try {
                    LookupInResult current = this.collection.lookupIn(this.id, Collections.singletonList(LookupInSpec.get(key)), this.lookupInOptions);
                    returnCas = current.cas();
                    if (current.exists(0)) {
                        result = current.contentAs(0, this.entityTypeClass);
                    }
                }
                catch (PathNotFoundException current) {
                }
                catch (DocumentNotFoundException e) {
                    returnCas = this.createEmpty();
                }
                this.collection.mutateIn(this.id, Collections.singletonList(MutateInSpec.upsert(key, value)), this.mapOptions.mutateInOptions().cas(returnCas));
                return result;
            }
            catch (CasMismatchException casMismatchException) {
                continue;
            }
        }
        throw new CouchbaseException("CouchbaseMap put failed", new RetryExhaustedException("Couldn't perform put in less than " + this.mapOptions.casMismatchRetries() + " iterations. It is likely concurrent modifications of this document are the reason"));
    }

    @Override
    public E get(Object key) {
        String idx = this.checkKey(key);
        try {
            return this.collection.lookupIn(this.id, Collections.singletonList(LookupInSpec.get(idx)), this.lookupInOptions).contentAs(0, this.entityTypeClass);
        }
        catch (DocumentNotFoundException | PathNotFoundException e) {
            return null;
        }
    }

    @Override
    public E remove(Object key) {
        String idx = this.checkKey(key);
        for (int i = 0; i < this.mapOptions.casMismatchRetries(); ++i) {
            try {
                LookupInResult current = this.collection.lookupIn(this.id, Collections.singletonList(LookupInSpec.get(idx)), this.lookupInOptions);
                long returnCas = current.cas();
                E result = current.contentAs(0, this.entityTypeClass);
                this.collection.mutateIn(this.id, Collections.singletonList(MutateInSpec.remove(idx)), this.mapOptions.mutateInOptions().cas(returnCas));
                return result;
            }
            catch (DocumentNotFoundException | PathNotFoundException e) {
                return null;
            }
            catch (CasMismatchException casMismatchException) {
                continue;
            }
        }
        throw new CouchbaseException("CouchbaseMap remove failed", new RetryExhaustedException("Couldn't perform remove in less than " + this.mapOptions.casMismatchRetries() + " iterations. It is likely concurrent modifications of this document are the reason"));
    }

    @Override
    public void clear() {
        this.collection.remove(this.id);
    }

    @Override
    public Set<Map.Entry<String, E>> entrySet() {
        JsonObject obj;
        try {
            obj = this.collection.get(this.id, this.getOptions).contentAsObject();
        }
        catch (DocumentNotFoundException e) {
            obj = JsonObject.create();
        }
        return new CouchbaseEntrySet(obj.toMap());
    }

    @Override
    public boolean containsKey(Object key) {
        String idx = this.checkKey(key);
        try {
            return this.collection.lookupIn(this.id, Collections.singletonList(LookupInSpec.exists(idx)), this.lookupInOptions).exists(0);
        }
        catch (DocumentNotFoundException e) {
            return false;
        }
    }

    @Override
    public boolean containsValue(Object value) {
        return super.containsValue(value);
    }

    @Override
    public int size() {
        try {
            LookupInResult current = this.collection.lookupIn(this.id, Collections.singletonList(LookupInSpec.count("")), this.lookupInOptions);
            return current.contentAs(0, Integer.class);
        }
        catch (DocumentNotFoundException e) {
            return 0;
        }
    }

    private String checkKey(Object key) {
        if (key == null) {
            throw new NullPointerException("Unsupported null key");
        }
        return String.valueOf(key);
    }

    private long createEmpty() {
        try {
            return this.collection.insert(this.id, JsonObject.create(), this.insertOptions).cas();
        }
        catch (DocumentExistsException ex) {
            return this.collection.get(this.id, this.getOptions).cas();
        }
    }

    private class CouchbaseEntrySetIterator
    implements Iterator<Map.Entry<String, E>> {
        private final Iterator<Map.Entry<String, E>> delegateItr;
        private Map.Entry<String, E> lastNext = null;

        CouchbaseEntrySetIterator(Iterator<Map.Entry<String, E>> iterator) {
            this.delegateItr = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.delegateItr.hasNext();
        }

        @Override
        public Map.Entry<String, E> next() {
            this.lastNext = this.delegateItr.next();
            return this.lastNext;
        }

        @Override
        public void remove() {
            if (this.lastNext == null) {
                throw new IllegalStateException("next() hasn't been called before remove()");
            }
            this.delegateItr.remove();
            CouchbaseMap.this.remove(this.lastNext.getKey());
        }
    }

    private class CouchbaseEntrySet
    implements Set<Map.Entry<String, E>> {
        private final Set<Map.Entry<String, E>> delegate;

        private CouchbaseEntrySet(Map<String, E> data) {
            this.delegate = data.entrySet();
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.delegate.contains(o);
        }

        @Override
        public Iterator<Map.Entry<String, E>> iterator() {
            return new CouchbaseEntrySetIterator(this.delegate.iterator());
        }

        @Override
        public Object[] toArray() {
            return this.delegate.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.delegate.toArray(a);
        }

        @Override
        public boolean add(Map.Entry<String, E> stringVEntry) {
            return this.delegate.add(stringVEntry);
        }

        @Override
        public boolean remove(Object o) {
            if (this.delegate.remove(o)) {
                if (!(o instanceof Map.Entry)) {
                    throw new IllegalStateException("Expected entrySet remove() to remove an entry");
                }
                Map.Entry entry = (Map.Entry)o;
                CouchbaseMap.this.remove(entry.getKey());
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAll(java.util.Collection<?> c) {
            return this.delegate.containsAll(c);
        }

        @Override
        public boolean addAll(java.util.Collection<? extends Map.Entry<String, E>> c) {
            return this.delegate.addAll(c);
        }

        @Override
        public boolean retainAll(java.util.Collection<?> c) {
            return this.delegate.retainAll(c);
        }

        @Override
        public boolean removeAll(java.util.Collection<?> c) {
            return this.delegate.removeAll(c);
        }

        @Override
        public void clear() {
            this.delegate.clear();
            CouchbaseMap.this.clear();
        }

        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public int hashCode() {
            return this.delegate.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }
    }
}

