/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.datastructures;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.CasMismatchException;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.DocumentNotFoundException;
import com.couchbase.client.core.error.context.ReducedKeyValueErrorContext;
import com.couchbase.client.core.error.subdoc.PathNotFoundException;
import com.couchbase.client.core.retry.reactor.RetryExhaustedException;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.Collection;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.kv.GetResult;
import com.couchbase.client.java.kv.LookupInOptions;
import com.couchbase.client.java.kv.LookupInResult;
import com.couchbase.client.java.kv.LookupInSpec;
import com.couchbase.client.java.kv.MutateInResult;
import com.couchbase.client.java.kv.MutateInSpec;
import com.couchbase.client.java.kv.QueueOptions;
import com.couchbase.client.java.kv.StoreSemantics;
import java.util.AbstractQueue;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;

@Stability.Committed
public class CouchbaseQueue<E>
extends AbstractQueue<E> {
    private final String id;
    private final Collection collection;
    private final Class<E> entityTypeClass;
    private final QueueOptions.Built queueOptions;
    private final LookupInOptions lookupInOptions;

    public CouchbaseQueue(String id, Collection collection, Class<E> entityType, QueueOptions options) {
        Validators.notNull(collection, "Collection", () -> ReducedKeyValueErrorContext.create(id, null, null, null));
        Validators.notNullOrEmpty(id, "Id", () -> ReducedKeyValueErrorContext.create(id, collection.bucketName(), collection.scopeName(), collection.name()));
        Validators.notNull(entityType, "EntityType", () -> ReducedKeyValueErrorContext.create(id, collection.bucketName(), collection.scopeName(), collection.name()));
        Validators.notNull(options, "QueueOptions", () -> ReducedKeyValueErrorContext.create(id, collection.bucketName(), collection.scopeName(), collection.name()));
        this.collection = collection;
        this.id = id;
        this.entityTypeClass = entityType;
        QueueOptions.Built optionsIn = options.build();
        QueueOptions opts = QueueOptions.queueOptions();
        optionsIn.copyInto(opts);
        this.queueOptions = opts.build();
        this.lookupInOptions = optionsIn.lookupInOptions();
    }

    @Override
    public Iterator<E> iterator() {
        return new CouchbaseQueueIterator();
    }

    @Override
    public int size() {
        try {
            LookupInResult result = this.collection.lookupIn(this.id, Collections.singletonList(LookupInSpec.count("")), this.lookupInOptions);
            return result.contentAs(0, Integer.class);
        }
        catch (DocumentNotFoundException e) {
            return 0;
        }
    }

    @Override
    public void clear() {
        this.collection.remove(this.id);
    }

    @Override
    public boolean offer(E e) {
        if (e == null) {
            throw new NullPointerException("Unsupported null value");
        }
        this.collection.mutateIn(this.id, Collections.singletonList(MutateInSpec.arrayPrepend("", Collections.singletonList(e))), this.queueOptions.mutateInOptions().storeSemantics(StoreSemantics.UPSERT));
        return true;
    }

    @Override
    public E poll() {
        String idx = "[-1]";
        for (int i = 0; i < this.queueOptions.casMismatchRetries(); ++i) {
            try {
                LookupInResult result = this.collection.lookupIn(this.id, Collections.singletonList(LookupInSpec.get(idx)), this.lookupInOptions);
                E current = result.contentAs(0, this.entityTypeClass);
                long returnCas = result.cas();
                this.collection.mutateIn(this.id, Collections.singletonList(MutateInSpec.remove(idx)), this.queueOptions.mutateInOptions().cas(returnCas));
                return current;
            }
            catch (DocumentNotFoundException | PathNotFoundException ex) {
                return null;
            }
            catch (CasMismatchException casMismatchException) {
                continue;
            }
        }
        throw new CouchbaseException("CouchbaseQueue poll failed", new RetryExhaustedException("Couldn't perform poll in less than " + this.queueOptions.casMismatchRetries() + " iterations. It is likely concurrent modifications of this document are the reason"));
    }

    @Override
    public E peek() {
        try {
            LookupInResult result = this.collection.lookupIn(this.id, Collections.singletonList(LookupInSpec.get("[-1]")), this.lookupInOptions);
            return result.contentAs(0, this.entityTypeClass);
        }
        catch (DocumentNotFoundException | PathNotFoundException e) {
            return null;
        }
    }

    public class CouchbaseQueueIterator<E>
    implements Iterator<E> {
        private long cas;
        private final Iterator<E> delegate;
        private int lastVisited = -1;
        private boolean doneRemove = false;

        CouchbaseQueueIterator() {
            JsonArray content;
            try {
                GetResult result = CouchbaseQueue.this.collection.get(CouchbaseQueue.this.id);
                this.cas = result.cas();
                content = result.contentAsArray();
            }
            catch (DocumentNotFoundException e) {
                this.cas = 0L;
                content = JsonArray.create();
            }
            this.delegate = content.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public E next() {
            if (this.hasNext()) {
                ++this.lastVisited;
                this.doneRemove = false;
            }
            return this.delegate.next();
        }

        @Override
        public void remove() {
            if (this.lastVisited < 0) {
                throw new IllegalStateException("Cannot remove before having started iterating");
            }
            if (this.doneRemove) {
                throw new IllegalStateException("Cannot remove twice in a row while iterating");
            }
            String path = "[" + this.lastVisited + "]";
            try {
                MutateInResult result = CouchbaseQueue.this.collection.mutateIn(CouchbaseQueue.this.id, Collections.singletonList(MutateInSpec.remove(path)), CouchbaseQueue.this.queueOptions.mutateInOptions().cas(this.cas));
                this.cas = result.cas();
                this.delegate.remove();
                this.doneRemove = true;
                --this.lastVisited;
            }
            catch (CasMismatchException | DocumentNotFoundException e) {
                throw new ConcurrentModificationException("Couldn't remove while iterating: " + e);
            }
            catch (PathNotFoundException ex) {
                return;
            }
        }
    }
}

