/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.kv;

import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.CommonOptions;
import com.couchbase.client.java.kv.PersistTo;
import com.couchbase.client.java.kv.ReplicateTo;
import java.util.Optional;

public abstract class CommonDurabilityOptions<SELF extends CommonDurabilityOptions<SELF>>
extends CommonOptions<SELF> {
    private PersistTo persistTo = PersistTo.NONE;
    private ReplicateTo replicateTo = ReplicateTo.NONE;
    private Optional<DurabilityLevel> durabilityLevel = Optional.empty();

    public SELF durability(PersistTo persistTo, ReplicateTo replicateTo) {
        Validators.notNull(persistTo, "PersistTo");
        Validators.notNull(replicateTo, "ReplicateTo");
        if (this.durabilityLevel.isPresent()) {
            this.durabilityLevel = Optional.empty();
        }
        this.persistTo = persistTo;
        this.replicateTo = replicateTo;
        return (SELF)((CommonDurabilityOptions)this.self());
    }

    public SELF durability(DurabilityLevel durabilityLevel) {
        Validators.notNull(durabilityLevel, "DurabilityLevel");
        this.persistTo = PersistTo.NONE;
        this.replicateTo = ReplicateTo.NONE;
        this.durabilityLevel = durabilityLevel != DurabilityLevel.NONE ? Optional.of(durabilityLevel) : Optional.empty();
        return (SELF)((CommonDurabilityOptions)this.self());
    }

    public abstract class BuiltCommonDurabilityOptions
    extends CommonOptions.BuiltCommonOptions {
        public BuiltCommonDurabilityOptions() {
            super(CommonDurabilityOptions.this);
        }

        public PersistTo persistTo() {
            return CommonDurabilityOptions.this.persistTo;
        }

        public ReplicateTo replicateTo() {
            return CommonDurabilityOptions.this.replicateTo;
        }

        public Optional<DurabilityLevel> durabilityLevel() {
            return CommonDurabilityOptions.this.durabilityLevel;
        }
    }
}

