/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.kv;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.DocumentExistsException;
import com.couchbase.client.core.error.context.KeyValueErrorContext;
import com.couchbase.client.core.msg.ResponseStatus;
import com.couchbase.client.core.msg.kv.InsertRequest;
import com.couchbase.client.java.kv.DurabilityUtils;
import com.couchbase.client.java.kv.MutationResult;
import com.couchbase.client.java.kv.PersistTo;
import com.couchbase.client.java.kv.ReplicateTo;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

@Stability.Internal
public enum InsertAccessor {


    public static CompletableFuture<MutationResult> insert(Core core, InsertRequest request, String key, PersistTo persistTo, ReplicateTo replicateTo) {
        core.send(request);
        CompletionStage mutationResult = request.response().thenApply(response -> {
            if (response.status().success()) {
                return new MutationResult(response.cas(), response.mutationToken());
            }
            if (response.status() == ResponseStatus.EXISTS || response.status() == ResponseStatus.NOT_STORED) {
                throw new DocumentExistsException(KeyValueErrorContext.completedRequest(request, response));
            }
            throw response.errorIfNeeded(request);
        });
        return DurabilityUtils.wrapWithDurability(mutationResult, key, persistTo, replicateTo, core, request, false);
    }
}

