/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.kv;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.context.KeyValueErrorContext;
import com.couchbase.client.core.error.context.SubDocumentErrorContext;
import com.couchbase.client.core.error.subdoc.PathInvalidException;
import com.couchbase.client.core.msg.kv.SubDocumentField;
import com.couchbase.client.core.msg.kv.SubDocumentOpResponseStatus;
import com.couchbase.client.core.msg.kv.SubdocCommandType;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.codec.TypeRef;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Objects;

public class LookupInResult {
    private final SubDocumentField[] encoded;
    private final long cas;
    private final JsonSerializer serializer;
    private final KeyValueErrorContext ctx;
    private final boolean isDeleted;

    LookupInResult(SubDocumentField[] encoded, long cas, JsonSerializer serializer, KeyValueErrorContext ctx, boolean isDeleted) {
        this.cas = cas;
        this.encoded = encoded;
        this.serializer = serializer;
        this.ctx = ctx;
        this.isDeleted = isDeleted;
    }

    public long cas() {
        return this.cas;
    }

    public <T> T contentAs(int index, Class<T> target) {
        SubDocumentField field = this.getFieldAtIndex(index);
        if (field.type() == SubdocCommandType.EXISTS) {
            if (target.isAssignableFrom(Boolean.class)) {
                return target.cast(field.status() == SubDocumentOpResponseStatus.SUCCESS);
            }
            throw new IllegalArgumentException("A Boolean is the only supported target class for an exists Sub-Document spec");
        }
        return this.serializer.deserialize(target, field.value());
    }

    public <T> T contentAs(int index, TypeRef<T> target) {
        SubDocumentField field = this.getFieldAtIndex(index);
        if (field.type() == SubdocCommandType.EXISTS) {
            String existsAsString = field.status() == SubDocumentOpResponseStatus.SUCCESS ? "true" : "false";
            Type type = target.type();
            if (((Class)type).isAssignableFrom(Boolean.class)) {
                Class rawType = type instanceof Class ? (Class)type : (Class)((ParameterizedType)type).getRawType();
                try {
                    return rawType.getConstructor(String.class).newInstance(existsAsString);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new RuntimeException("Unable to convert result in target", e);
                }
            }
            throw new IllegalArgumentException("A Boolean is the only supported target class for an exists Sub-Document spec");
        }
        return this.serializer.deserialize(target, field.value());
    }

    @Stability.Uncommitted
    public byte[] contentAsBytes(int index) {
        return this.getFieldAtIndex(index).value();
    }

    private SubDocumentField getFieldAtIndex(int index) {
        if (index >= 0 && index < this.encoded.length) {
            SubDocumentField value = this.encoded[index];
            if (value == null) {
                throw new PathInvalidException("No result exists at index", new SubDocumentErrorContext(this.ctx, index, null, null));
            }
            if (value.error().isPresent()) {
                throw value.error().get();
            }
            return value;
        }
        throw new PathInvalidException("Index is out of bounds", new SubDocumentErrorContext(this.ctx, index, null, null));
    }

    public JsonObject contentAsObject(int index) {
        return this.contentAs(index, JsonObject.class);
    }

    public JsonArray contentAsArray(int index) {
        return this.contentAs(index, JsonArray.class);
    }

    public boolean exists(int index) {
        if (index >= 0 && index < this.encoded.length) {
            SubDocumentField value = this.encoded[index];
            return value != null && value.status().success();
        }
        return false;
    }

    @Stability.Internal
    public boolean isDeleted() {
        return this.isDeleted;
    }

    public String toString() {
        return "LookupInResult{encoded=" + Arrays.asList(this.encoded) + ", cas=0x" + Long.toHexString(this.cas) + ", isDeleted=" + this.isDeleted + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LookupInResult that = (LookupInResult)o;
        return this.cas == that.cas && Arrays.equals(this.encoded, that.encoded) && Objects.equals(this.serializer, that.serializer) && this.isDeleted == that.isDeleted;
    }

    public int hashCode() {
        int result = Objects.hash(this.cas, this.serializer, this.isDeleted);
        result = 31 * result + Arrays.hashCode(this.encoded);
        return result;
    }
}

