/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.kv;

import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.kv.MutationToken;
import com.couchbase.client.core.msg.kv.SubDocumentField;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.codec.TypeRef;
import com.couchbase.client.java.kv.MutationResult;
import java.util.NoSuchElementException;
import java.util.Optional;

public class MutateInResult
extends MutationResult {
    private final SubDocumentField[] encoded;
    private final JsonSerializer serializer;

    MutateInResult(SubDocumentField[] encoded, long cas, Optional<MutationToken> mutationToken, JsonSerializer serializer) {
        super(cas, mutationToken);
        this.encoded = encoded;
        this.serializer = serializer;
    }

    public <T> T contentAs(int index, Class<T> target) {
        return this.contentAs(index, target, this.serializer);
    }

    public <T> T contentAs(int index, TypeRef<T> target) {
        return this.contentAs(index, target, this.serializer);
    }

    public <T> T contentAs(int index, Class<T> target, JsonSerializer serializer) {
        return serializer.deserialize(target, this.getFieldAtIndex(index).value());
    }

    public <T> T contentAs(int index, TypeRef<T> target, JsonSerializer serializer) {
        return serializer.deserialize(target, this.getFieldAtIndex(index).value());
    }

    private SubDocumentField getFieldAtIndex(int index) {
        if (index >= 0 && index < this.encoded.length) {
            SubDocumentField value = this.encoded[index];
            if (value == null) {
                throw new NoSuchElementException("No result exists at index " + index);
            }
            value.error().map(err -> {
                throw err;
            });
            return value;
        }
        throw InvalidArgumentException.fromMessage("Index " + index + " is invalid");
    }

    @Override
    public String toString() {
        return "MutateInResult{encoded=" + RedactableArgument.redactUser(this.encoded) + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MutateInResult that = (MutateInResult)o;
        return this.encoded != null ? this.encoded.equals(that.encoded) : that.encoded == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.encoded != null ? this.encoded.hashCode() : 0);
        return result;
    }
}

