/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.kv;

import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.msg.kv.MutationToken;
import com.couchbase.client.core.msg.kv.MutationTokenAggregator;
import com.couchbase.client.java.json.JsonObject;
import java.util.Iterator;
import java.util.Objects;

public class MutationState
implements Iterable<MutationToken> {
    private final MutationTokenAggregator tokens;

    private MutationState() {
        this.tokens = new MutationTokenAggregator();
    }

    private MutationState(MutationTokenAggregator tokens) {
        this.tokens = Objects.requireNonNull(tokens);
    }

    public static MutationState from(MutationToken ... mutationTokens) {
        return new MutationState().add(mutationTokens);
    }

    public MutationState add(MutationToken ... mutationTokens) {
        if (mutationTokens == null || mutationTokens.length == 0) {
            throw InvalidArgumentException.fromMessage("At least one MutationToken must be provided.");
        }
        for (MutationToken t : mutationTokens) {
            this.tokens.add(t);
        }
        return this;
    }

    public MutationState add(MutationState mutationState) {
        for (MutationToken token : mutationState) {
            this.tokens.add(token);
        }
        return this;
    }

    @Override
    public Iterator<MutationToken> iterator() {
        return this.tokens.iterator();
    }

    public JsonObject export() {
        return JsonObject.from(this.tokens.export());
    }

    public JsonObject exportForSearch() {
        return JsonObject.from(this.tokens.exportForSearch());
    }

    public static MutationState from(String source) {
        return MutationState.from(JsonObject.fromJson(source));
    }

    public static MutationState from(JsonObject source) {
        return new MutationState(MutationTokenAggregator.from(source.toMap()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MutationState state = (MutationState)o;
        return this.tokens.equals(state.tokens);
    }

    public int hashCode() {
        return this.tokens.hashCode();
    }

    public String toString() {
        return "MutationState{tokens=" + this.tokens + '}';
    }
}

