/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.kv;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.DefaultErrorUtil;
import com.couchbase.client.core.msg.kv.RemoveRequest;
import com.couchbase.client.java.kv.DurabilityUtils;
import com.couchbase.client.java.kv.MutationResult;
import com.couchbase.client.java.kv.PersistTo;
import com.couchbase.client.java.kv.ReplicateTo;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

@Stability.Internal
public enum RemoveAccessor {


    public static CompletableFuture<MutationResult> remove(Core core, RemoveRequest request, String key, PersistTo persistTo, ReplicateTo replicateTo) {
        core.send(request);
        CompletionStage mutationResult = request.response().thenApply(response -> {
            if (response.status().success()) {
                return new MutationResult(response.cas(), response.mutationToken());
            }
            throw DefaultErrorUtil.keyValueStatusToException(request, response);
        });
        return DurabilityUtils.wrapWithDurability(mutationResult, key, persistTo, replicateTo, core, request, true);
    }
}

