/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.analytics;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.java.CommonOptions;
import com.couchbase.client.java.manager.analytics.link.AnalyticsLinkType;
import java.util.Optional;

public class GetLinksAnalyticsOptions
extends CommonOptions<GetLinksAnalyticsOptions> {
    private Optional<String> dataverseName = Optional.empty();
    private Optional<AnalyticsLinkType> linkType = Optional.empty();
    private Optional<String> name = Optional.empty();

    private GetLinksAnalyticsOptions() {
    }

    public static GetLinksAnalyticsOptions getLinksAnalyticsOptions() {
        return new GetLinksAnalyticsOptions();
    }

    public GetLinksAnalyticsOptions dataverseName(String dataverseName) {
        this.dataverseName = Optional.ofNullable(dataverseName);
        return this;
    }

    public GetLinksAnalyticsOptions name(String linkName) {
        this.name = Optional.ofNullable(linkName);
        return this;
    }

    public GetLinksAnalyticsOptions linkType(AnalyticsLinkType linkType) {
        this.linkType = Optional.ofNullable(linkType);
        return this;
    }

    @Stability.Internal
    public Built build() {
        if (this.name.isPresent() && !this.dataverseName.isPresent()) {
            throw InvalidArgumentException.fromMessage("If a linkName is provided, a dataverseName must also be provided");
        }
        return new Built();
    }

    public class Built
    extends CommonOptions.BuiltCommonOptions {
        Built() {
            super(GetLinksAnalyticsOptions.this);
        }

        public Optional<String> dataverseName() {
            return GetLinksAnalyticsOptions.this.dataverseName;
        }

        public Optional<String> name() {
            return GetLinksAnalyticsOptions.this.name;
        }

        public Optional<AnalyticsLinkType> linkType() {
            return GetLinksAnalyticsOptions.this.linkType;
        }
    }
}

