/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.analytics.link;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonValue;
import com.couchbase.client.core.util.CbObjects;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class AnalyticsLinkType {
    private static final ConcurrentMap<String, AnalyticsLinkType> values = new ConcurrentHashMap<String, AnalyticsLinkType>();
    public static final AnalyticsLinkType S3_EXTERNAL = AnalyticsLinkType.of("s3");
    public static final AnalyticsLinkType COUCHBASE_REMOTE = AnalyticsLinkType.of("couchbase");
    private final String wireName;

    private AnalyticsLinkType(String wireName) {
        this.wireName = Objects.requireNonNull(wireName);
    }

    @Stability.Internal
    public static AnalyticsLinkType of(String wireName) {
        return values.computeIfAbsent(CbObjects.defaultIfNull(wireName, "unknown"), AnalyticsLinkType::new);
    }

    @JsonValue
    public String wireName() {
        return this.wireName;
    }

    public String toString() {
        return this.wireName;
    }
}

