/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.bucket;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.manager.CoreBucketManager;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.java.manager.bucket.BucketSettings;
import com.couchbase.client.java.manager.bucket.BucketType;
import com.couchbase.client.java.manager.bucket.CreateBucketOptions;
import com.couchbase.client.java.manager.bucket.DropBucketOptions;
import com.couchbase.client.java.manager.bucket.FlushBucketOptions;
import com.couchbase.client.java.manager.bucket.GetAllBucketOptions;
import com.couchbase.client.java.manager.bucket.GetBucketOptions;
import com.couchbase.client.java.manager.bucket.UpdateBucketOptions;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class AsyncBucketManager {
    private final CoreBucketManager coreBucketManager;

    @Stability.Internal
    public AsyncBucketManager(Core core) {
        this.coreBucketManager = new CoreBucketManager(core);
    }

    public CompletableFuture<Void> createBucket(BucketSettings settings) {
        return this.createBucket(settings, CreateBucketOptions.createBucketOptions());
    }

    public CompletableFuture<Void> createBucket(BucketSettings settings, CreateBucketOptions options) {
        return this.coreBucketManager.createBucket(AsyncBucketManager.toMap(settings), options.build());
    }

    public CompletableFuture<Void> updateBucket(BucketSettings settings) {
        return this.updateBucket(settings, UpdateBucketOptions.updateBucketOptions());
    }

    public CompletableFuture<Void> updateBucket(BucketSettings settings, UpdateBucketOptions options) {
        return this.coreBucketManager.updateBucket(AsyncBucketManager.toMap(settings), options.build());
    }

    public CompletableFuture<Void> dropBucket(String bucketName) {
        return this.dropBucket(bucketName, DropBucketOptions.dropBucketOptions());
    }

    public CompletableFuture<Void> dropBucket(String bucketName, DropBucketOptions options) {
        return this.coreBucketManager.dropBucket(bucketName, options.build());
    }

    public CompletableFuture<BucketSettings> getBucket(String bucketName) {
        return this.getBucket(bucketName, GetBucketOptions.getBucketOptions());
    }

    public CompletableFuture<BucketSettings> getBucket(String bucketName, GetBucketOptions options) {
        return this.coreBucketManager.getBucket(bucketName, options.build()).thenApply(AsyncBucketManager.parseBucketSettings());
    }

    public CompletableFuture<Map<String, BucketSettings>> getAllBuckets() {
        return this.getAllBuckets(GetAllBucketOptions.getAllBucketOptions());
    }

    public CompletableFuture<Map<String, BucketSettings>> getAllBuckets(GetAllBucketOptions options) {
        return this.coreBucketManager.getAllBuckets(options.build()).thenApply(bucketNameToBytes -> CbCollections.transformValues(bucketNameToBytes, AsyncBucketManager.parseBucketSettings()));
    }

    public CompletableFuture<Void> flushBucket(String bucketName) {
        return this.flushBucket(bucketName, FlushBucketOptions.flushBucketOptions());
    }

    public CompletableFuture<Void> flushBucket(String bucketName, FlushBucketOptions options) {
        return this.coreBucketManager.flushBucket(bucketName, options.build());
    }

    private static Function<byte[], BucketSettings> parseBucketSettings() {
        return bucketBytes -> BucketSettings.create(Mapper.decodeIntoTree(bucketBytes));
    }

    private static Map<String, String> toMap(BucketSettings settings) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("ramQuotaMB", String.valueOf(settings.ramQuotaMB()));
        if (settings.bucketType() != BucketType.MEMCACHED) {
            params.put("replicaNumber", String.valueOf(settings.numReplicas()));
        }
        params.put("flushEnabled", String.valueOf(settings.flushEnabled() ? 1 : 0));
        long maxTTL = settings.maxExpiry().getSeconds();
        if (maxTTL != 0L) {
            params.put("maxTTL", String.valueOf(maxTTL));
        }
        if (settings.evictionPolicy() != null) {
            params.put("evictionPolicy", settings.evictionPolicy().alias());
        }
        if (settings.compressionMode != null) {
            params.put("compressionMode", settings.compressionMode().alias());
        }
        if (settings.minimumDurabilityLevel() != DurabilityLevel.NONE) {
            params.put("durabilityMinLevel", settings.minimumDurabilityLevel().encodeForManagementApi());
        }
        if (settings.storageBackend() != null) {
            params.put("storageBackend", settings.storageBackend().alias());
        }
        params.put("name", settings.name());
        params.put("bucketType", settings.bucketType().alias());
        params.put("conflictResolutionType", settings.conflictResolutionType().alias());
        if (settings.bucketType() != BucketType.EPHEMERAL) {
            params.put("replicaIndex", String.valueOf(settings.replicaIndexes() ? 1 : 0));
        }
        return params;
    }
}

