/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.bucket;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonCreator;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.couchbase.client.core.deps.com.fasterxml.jackson.annotation.JsonProperty;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.manager.bucket.BucketType;
import com.couchbase.client.java.manager.bucket.CompressionMode;
import com.couchbase.client.java.manager.bucket.ConflictResolutionType;
import com.couchbase.client.java.manager.bucket.EjectionPolicy;
import com.couchbase.client.java.manager.bucket.EvictionPolicyType;
import com.couchbase.client.java.manager.bucket.StorageBackend;
import java.time.Duration;
import java.util.Map;
import reactor.util.annotation.Nullable;

@JsonIgnoreProperties(ignoreUnknown=true)
public class BucketSettings {
    private final String name;
    private boolean flushEnabled = false;
    private long ramQuotaMB = 100L;
    private int numReplicas = 1;
    private boolean replicaIndexes = false;
    private Duration maxExpiry = Duration.ZERO;
    @Nullable
    CompressionMode compressionMode = null;
    private BucketType bucketType = BucketType.COUCHBASE;
    private ConflictResolutionType conflictResolutionType = ConflictResolutionType.SEQUENCE_NUMBER;
    private EvictionPolicyType evictionPolicy = null;
    private DurabilityLevel minimumDurabilityLevel = DurabilityLevel.NONE;
    private StorageBackend storageBackend = null;
    private boolean healthy = true;

    @Stability.Internal
    @JsonCreator
    public BucketSettings(@JsonProperty(value="name") String name, @JsonProperty(value="controllers") Map<String, String> controllers, @JsonProperty(value="quota") Map<String, Long> quota, @JsonProperty(value="replicaNumber") int numReplicas, @JsonProperty(value="replicaIndex") boolean replicaIndex, @JsonProperty(value="maxTTL") int maxTTL, @JsonProperty(value="compressionMode") CompressionMode compressionMode, @JsonProperty(value="bucketType") BucketType bucketType, @JsonProperty(value="conflictResolutionType") ConflictResolutionType conflictResolutionType, @JsonProperty(value="evictionPolicy") EvictionPolicyType evictionPolicy, @JsonProperty(value="durabilityMinLevel") String durabilityMinLevel, @JsonProperty(value="storageBackend") StorageBackend storageBackend) {
        this.name = name;
        this.flushEnabled = controllers.containsKey("flush");
        this.ramQuotaMB = BucketSettings.ramQuotaToMB(quota.get("rawRAM"));
        this.numReplicas = numReplicas;
        this.replicaIndexes = replicaIndex;
        this.maxExpiry = Duration.ofSeconds(maxTTL);
        this.compressionMode = compressionMode;
        this.bucketType = bucketType;
        this.conflictResolutionType = conflictResolutionType;
        this.evictionPolicy = evictionPolicy;
        this.minimumDurabilityLevel = DurabilityLevel.decodeFromManagementApi(durabilityMinLevel);
        this.storageBackend = storageBackend;
    }

    private BucketSettings(String name) {
        this.name = name;
    }

    public static BucketSettings create(String name) {
        return new BucketSettings(name);
    }

    static BucketSettings create(JsonNode tree) {
        BucketSettings settings = Mapper.convertValue((Object)tree, BucketSettings.class);
        JsonNode nodes = tree.get("nodes");
        if (nodes.isArray() && !nodes.isEmpty()) {
            for (JsonNode node : nodes) {
                String status = node.get("status").asText();
                if (status.equals("healthy")) continue;
                settings.healthy = false;
            }
        } else {
            settings.healthy = false;
        }
        return settings;
    }

    private static long ramQuotaToMB(long ramQuotaBytes) {
        long BYTES_PER_MEGABYTE = 0x100000L;
        return ramQuotaBytes == 0L ? 0L : ramQuotaBytes / 0x100000L;
    }

    public String name() {
        return this.name;
    }

    public boolean flushEnabled() {
        return this.flushEnabled;
    }

    public long ramQuotaMB() {
        return this.ramQuotaMB;
    }

    public int numReplicas() {
        return this.numReplicas;
    }

    public boolean replicaIndexes() {
        return this.replicaIndexes;
    }

    public DurabilityLevel minimumDurabilityLevel() {
        return this.minimumDurabilityLevel;
    }

    public Duration maxExpiry() {
        return this.maxExpiry;
    }

    public CompressionMode compressionMode() {
        if (this.compressionMode == null) {
            return CompressionMode.OFF;
        }
        return this.compressionMode;
    }

    public BucketType bucketType() {
        return this.bucketType;
    }

    public ConflictResolutionType conflictResolutionType() {
        return this.conflictResolutionType;
    }

    public StorageBackend storageBackend() {
        return this.storageBackend;
    }

    public EvictionPolicyType evictionPolicy() {
        return this.evictionPolicy;
    }

    @Stability.Internal
    public boolean healthy() {
        return this.healthy;
    }

    public BucketSettings flushEnabled(boolean flushEnabled) {
        this.flushEnabled = flushEnabled;
        return this;
    }

    public BucketSettings ramQuotaMB(long ramQuotaMB) {
        this.ramQuotaMB = ramQuotaMB;
        return this;
    }

    public BucketSettings numReplicas(int numReplicas) {
        this.numReplicas = numReplicas;
        return this;
    }

    public BucketSettings replicaIndexes(boolean replicaIndexes) {
        this.replicaIndexes = replicaIndexes;
        return this;
    }

    public BucketSettings maxExpiry(Duration maxExpiry) {
        this.maxExpiry = Validators.notNull(maxExpiry, "MaxExpiry");
        return this;
    }

    public BucketSettings compressionMode(CompressionMode compressionMode) {
        this.compressionMode = Validators.notNull(compressionMode, "CompressionMode");
        return this;
    }

    public BucketSettings bucketType(BucketType bucketType) {
        this.bucketType = Validators.notNull(bucketType, "BucketType");
        return this;
    }

    public BucketSettings conflictResolutionType(ConflictResolutionType conflictResolutionType) {
        this.conflictResolutionType = Validators.notNull(conflictResolutionType, "ConflictResolutionType");
        return this;
    }

    public BucketSettings evictionPolicy(EvictionPolicyType evictionPolicy) {
        this.evictionPolicy = evictionPolicy;
        return this;
    }

    public BucketSettings minimumDurabilityLevel(DurabilityLevel durabilityLevel) {
        this.minimumDurabilityLevel = Validators.notNull(durabilityLevel, "DurabilityLevel");
        return this;
    }

    public BucketSettings storageBackend(StorageBackend storageBackend) {
        this.storageBackend = Validators.notNull(storageBackend, "storageBackend");
        return this;
    }

    @Deprecated
    public int maxTTL() {
        return (int)this.maxExpiry().getSeconds();
    }

    @Deprecated
    public BucketSettings maxTTL(int maxTTL) {
        return this.maxExpiry(Duration.ofSeconds(maxTTL));
    }

    @Deprecated
    public EjectionPolicy ejectionPolicy() {
        return EjectionPolicy.of(this.evictionPolicy);
    }

    @Deprecated
    public BucketSettings ejectionPolicy(EjectionPolicy ejectionPolicy) {
        this.evictionPolicy = ejectionPolicy == null ? null : ejectionPolicy.toEvictionPolicy();
        return this;
    }

    public String toString() {
        return "BucketSettings{name='" + RedactableArgument.redactMeta(this.name) + '\'' + ", flushEnabled=" + this.flushEnabled + ", ramQuotaMB=" + this.ramQuotaMB + ", numReplicas=" + this.numReplicas + ", replicaIndexes=" + this.replicaIndexes + ", maxExpiry=" + this.maxExpiry.getSeconds() + ", compressionMode=" + (Object)((Object)this.compressionMode) + ", bucketType=" + (Object)((Object)this.bucketType) + ", conflictResolutionType=" + (Object)((Object)this.conflictResolutionType) + ", evictionPolicy=" + (Object)((Object)this.evictionPolicy) + ", minimumDurabilityLevel=" + (Object)((Object)this.minimumDurabilityLevel) + ", storageBackend=" + this.storageBackend + '}';
    }
}

