/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.eventing;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.manager.CoreEventingFunctionManager;
import com.couchbase.client.core.util.CbCollections;
import com.couchbase.client.java.manager.eventing.DeployFunctionOptions;
import com.couchbase.client.java.manager.eventing.DropFunctionOptions;
import com.couchbase.client.java.manager.eventing.EventingFunction;
import com.couchbase.client.java.manager.eventing.EventingFunctionBucketAccess;
import com.couchbase.client.java.manager.eventing.EventingFunctionBucketBinding;
import com.couchbase.client.java.manager.eventing.EventingFunctionConstantBinding;
import com.couchbase.client.java.manager.eventing.EventingFunctionDcpBoundary;
import com.couchbase.client.java.manager.eventing.EventingFunctionDeploymentStatus;
import com.couchbase.client.java.manager.eventing.EventingFunctionKeyspace;
import com.couchbase.client.java.manager.eventing.EventingFunctionLanguageCompatibility;
import com.couchbase.client.java.manager.eventing.EventingFunctionLogLevel;
import com.couchbase.client.java.manager.eventing.EventingFunctionProcessingStatus;
import com.couchbase.client.java.manager.eventing.EventingFunctionSettings;
import com.couchbase.client.java.manager.eventing.EventingFunctionUrlAuthBasic;
import com.couchbase.client.java.manager.eventing.EventingFunctionUrlAuthBearer;
import com.couchbase.client.java.manager.eventing.EventingFunctionUrlAuthDigest;
import com.couchbase.client.java.manager.eventing.EventingFunctionUrlBinding;
import com.couchbase.client.java.manager.eventing.EventingFunctionUrlNoAuth;
import com.couchbase.client.java.manager.eventing.EventingStatus;
import com.couchbase.client.java.manager.eventing.FunctionsStatusOptions;
import com.couchbase.client.java.manager.eventing.GetAllFunctionsOptions;
import com.couchbase.client.java.manager.eventing.GetFunctionOptions;
import com.couchbase.client.java.manager.eventing.PauseFunctionOptions;
import com.couchbase.client.java.manager.eventing.ResumeFunctionOptions;
import com.couchbase.client.java.manager.eventing.UndeployFunctionOptions;
import com.couchbase.client.java.manager.eventing.UpsertFunctionOptions;
import com.couchbase.client.java.query.QueryScanConsistency;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

@Stability.Uncommitted
public class AsyncEventingFunctionManager {
    private final CoreEventingFunctionManager coreManager;

    @Stability.Internal
    public AsyncEventingFunctionManager(Core core) {
        this.coreManager = new CoreEventingFunctionManager(core);
    }

    public CompletableFuture<Void> upsertFunction(EventingFunction function) {
        return this.upsertFunction(function, UpsertFunctionOptions.upsertFunctionOptions());
    }

    public CompletableFuture<Void> upsertFunction(EventingFunction function, UpsertFunctionOptions options) {
        return this.coreManager.upsertFunction(function.name(), AsyncEventingFunctionManager.encodeFunction(function), options.build());
    }

    public CompletableFuture<EventingFunction> getFunction(String name) {
        return this.getFunction(name, GetFunctionOptions.getFunctionOptions());
    }

    public CompletableFuture<EventingFunction> getFunction(String name, GetFunctionOptions options) {
        return this.coreManager.getFunction(name, options.build()).thenApply(AsyncEventingFunctionManager::decodeFunction);
    }

    public CompletableFuture<List<EventingFunction>> getAllFunctions() {
        return this.getAllFunctions(GetAllFunctionsOptions.getAllFunctionsOptions());
    }

    public CompletableFuture<List<EventingFunction>> getAllFunctions(GetAllFunctionsOptions options) {
        return this.coreManager.getAllFunctions(options.build()).thenApply(AsyncEventingFunctionManager::decodeFunctions);
    }

    public CompletableFuture<Void> dropFunction(String name) {
        return this.dropFunction(name, DropFunctionOptions.dropFunctionOptions());
    }

    public CompletableFuture<Void> dropFunction(String name, DropFunctionOptions options) {
        return this.coreManager.dropFunction(name, options.build());
    }

    public CompletableFuture<Void> deployFunction(String name) {
        return this.deployFunction(name, DeployFunctionOptions.deployFunctionOptions());
    }

    public CompletableFuture<Void> deployFunction(String name, DeployFunctionOptions options) {
        return this.coreManager.deployFunction(name, options.build());
    }

    public CompletableFuture<Void> undeployFunction(String name) {
        return this.undeployFunction(name, UndeployFunctionOptions.undeployFunctionOptions());
    }

    public CompletableFuture<Void> undeployFunction(String name, UndeployFunctionOptions options) {
        return this.coreManager.undeployFunction(name, options.build());
    }

    public CompletableFuture<Void> pauseFunction(String name) {
        return this.pauseFunction(name, PauseFunctionOptions.pauseFunctionOptions());
    }

    public CompletableFuture<Void> pauseFunction(String name, PauseFunctionOptions options) {
        return this.coreManager.pauseFunction(name, options.build());
    }

    public CompletableFuture<Void> resumeFunction(String name) {
        return this.resumeFunction(name, ResumeFunctionOptions.resumeFunctionOptions());
    }

    public CompletableFuture<Void> resumeFunction(String name, ResumeFunctionOptions options) {
        return this.coreManager.resumeFunction(name, options.build());
    }

    public CompletableFuture<EventingStatus> functionsStatus() {
        return this.functionsStatus(FunctionsStatusOptions.functionsStatusOptions());
    }

    public CompletableFuture<EventingStatus> functionsStatus(FunctionsStatusOptions options) {
        return this.coreManager.functionsStatus(options.build()).thenApply(bytes -> Mapper.decodeInto(bytes, EventingStatus.class));
    }

    private static byte[] encodeFunction(EventingFunction function) {
        HashMap<String, Object> func = new HashMap<String, Object>();
        func.put("appname", function.name());
        func.put("appcode", function.code());
        if (function.version() != null) {
            func.put("version", function.version());
        }
        if (function.enforceSchema()) {
            func.put("enforce_schema", function.enforceSchema());
        }
        if (function.handlerUuid() != 0L) {
            func.put("handleruuid", function.handlerUuid());
        }
        if (function.functionInstanceId() != null) {
            func.put("function_instance_id", function.functionInstanceId());
        }
        HashMap<String, Object> depcfg = new HashMap<String, Object>();
        depcfg.put("source_bucket", function.sourceKeyspace().bucket());
        depcfg.put("source_scope", function.sourceKeyspace().scope());
        depcfg.put("source_collection", function.sourceKeyspace().collection());
        depcfg.put("metadata_bucket", function.metadataKeyspace().bucket());
        depcfg.put("metadata_scope", function.metadataKeyspace().scope());
        depcfg.put("metadata_collection", function.metadataKeyspace().collection());
        if (function.constantBindings() != null && !function.constantBindings().isEmpty()) {
            List constants = function.constantBindings().stream().map(c -> CbCollections.mapOf("value", c.alias(), "literal", c.literal())).collect(Collectors.toList());
            depcfg.put("constants", constants);
        }
        if (function.urlBindings() != null && !function.urlBindings().isEmpty()) {
            List urls = function.urlBindings().stream().map(c -> {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("value", c.alias());
                map.put("hostname", c.hostname());
                map.put("allow_cookies", c.allowCookies());
                map.put("validate_ssl_certificate", c.validateSslCertificate());
                if (c.auth() instanceof EventingFunctionUrlNoAuth) {
                    map.put("auth_type", "no-auth");
                } else if (c.auth() instanceof EventingFunctionUrlAuthBasic) {
                    map.put("auth_type", "basic");
                    map.put("username", ((EventingFunctionUrlAuthBasic)c.auth()).username());
                    map.put("password", ((EventingFunctionUrlAuthBasic)c.auth()).password());
                } else if (c.auth() instanceof EventingFunctionUrlAuthDigest) {
                    map.put("auth_type", "digest");
                    map.put("username", ((EventingFunctionUrlAuthDigest)c.auth()).username());
                    map.put("password", ((EventingFunctionUrlAuthDigest)c.auth()).password());
                } else if (c.auth() instanceof EventingFunctionUrlAuthBearer) {
                    map.put("auth_type", "bearer");
                    map.put("bearer_key", ((EventingFunctionUrlAuthBearer)c.auth()).key());
                }
                return map;
            }).collect(Collectors.toList());
            depcfg.put("curl", urls);
        }
        if (function.bucketBindings() != null && !function.bucketBindings().isEmpty()) {
            List buckets = function.bucketBindings().stream().map(c -> {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("alias", c.alias());
                map.put("bucket_name", c.keyspace().bucket());
                map.put("scope_name", c.keyspace().scope());
                map.put("collection_name", c.keyspace().collection());
                if (c.access() != null) {
                    map.put("access", c.access() == EventingFunctionBucketAccess.READ_ONLY ? "r" : "rw");
                }
                return map;
            }).collect(Collectors.toList());
            depcfg.put("buckets", buckets);
        }
        HashMap<String, Object> settings = new HashMap<String, Object>();
        EventingFunctionSettings efs = function.settings();
        if (efs.processingStatus() != null) {
            settings.put("processing_status", efs.processingStatus().isRunning());
        } else {
            settings.put("processing_status", false);
        }
        if (efs.deploymentStatus() != null) {
            settings.put("deployment_status", efs.deploymentStatus().isDeployed());
        } else {
            settings.put("deployment_status", false);
        }
        if (efs.cppWorkerThreadCount() > 0L) {
            settings.put("cpp_worker_thread_count", efs.cppWorkerThreadCount());
        }
        if (efs.dcpStreamBoundary() != null) {
            settings.put("dcp_stream_boundary", efs.dcpStreamBoundary().toString());
        }
        if (efs.description() != null) {
            settings.put("description", efs.description());
        }
        if (efs.logLevel() != null) {
            settings.put("log_level", efs.logLevel().toString());
        }
        if (efs.languageCompatibility() != null) {
            settings.put("language_compatibility", efs.languageCompatibility().toString());
        }
        if (efs.executionTimeout() != null) {
            settings.put("execution_timeout", efs.executionTimeout().getSeconds());
        }
        if (efs.lcbTimeout() != null) {
            settings.put("lcb_timeout", efs.lcbTimeout().getSeconds());
        }
        if (efs.lcbInstCapacity() > 0L) {
            settings.put("lcb_inst_capacity", efs.lcbInstCapacity());
        }
        if (efs.lcbRetryCount() > 0L) {
            settings.put("lcb_retry_count", efs.lcbRetryCount());
        }
        if (efs.numTimerPartitions() > 0L) {
            settings.put("num_timer_partitions", efs.numTimerPartitions());
        }
        if (efs.sockBatchSize() > 0L) {
            settings.put("sock_batch_size", efs.sockBatchSize());
        }
        if (efs.tickDuration() != null) {
            settings.put("tick_duration", efs.tickDuration().toMillis());
        }
        if (efs.timerContextSize() > 0L) {
            settings.put("timer_context_size", efs.timerContextSize());
        }
        if (efs.bucketCacheSize() > 0L) {
            settings.put("bucket_cache_size", efs.bucketCacheSize());
        }
        if (efs.bucketCacheAge() > 0L) {
            settings.put("bucket_cache_age", efs.bucketCacheAge());
        }
        if (efs.curlMaxAllowedRespSize() > 0L) {
            settings.put("curl_max_allowed_resp_size", efs.curlMaxAllowedRespSize());
        }
        if (efs.workerCount() > 0L) {
            settings.put("worker_count", efs.workerCount());
        }
        if (efs.appLogMaxSize() > 0L) {
            settings.put("app_log_max_size", efs.appLogMaxSize());
        }
        if (efs.appLogMaxFiles() > 0L) {
            settings.put("app_log_max_files", efs.appLogMaxFiles());
        }
        if (efs.checkpointInterval() != null) {
            settings.put("checkpoint_interval", efs.checkpointInterval().getSeconds());
        }
        if (efs.handlerHeaders() != null && !efs.handlerHeaders().isEmpty()) {
            settings.put("handler_headers", efs.handlerHeaders());
        }
        if (efs.handlerFooters() != null && !efs.handlerFooters().isEmpty()) {
            settings.put("handler_footers", efs.handlerFooters());
        }
        if (efs.queryPrepareAll()) {
            settings.put("n1ql_prepare_all", efs.queryPrepareAll());
        }
        if (efs.enableAppLogRotation()) {
            settings.put("enable_applog_rotation", efs.enableAppLogRotation());
        }
        if (efs.userPrefix() != null) {
            settings.put("user_prefix", efs.userPrefix());
        }
        if (efs.appLogDir() != null) {
            settings.put("app_log_dir", efs.appLogDir());
        }
        if (efs.queryConsistency() != null) {
            String encoded = efs.queryConsistency() == QueryScanConsistency.REQUEST_PLUS ? "request" : "none";
            settings.put("n1ql_consistency", encoded);
        }
        func.put("depcfg", depcfg);
        func.put("settings", settings);
        return Mapper.encodeAsBytes(func);
    }

    static EventingFunction decodeFunction(byte[] encoded) {
        JsonNode func = Mapper.decodeIntoTree(encoded);
        if (func.isArray()) {
            throw new InvalidArgumentException("The provided JSON is an array (potentially of functions), not an individual function.", null, null);
        }
        JsonNode depcfg = func.get("depcfg");
        JsonNode settings = func.get("settings");
        String version = func.has("version") ? func.get("version").asText() : null;
        String functionInstanceId = func.has("function_instance_id") ? func.get("function_instance_id").asText() : null;
        int handlerUuid = func.has("handleruuid") ? func.get("handleruuid").asInt() : 0;
        EventingFunction.Builder toReturn = EventingFunction.builder(func.get("appname").asText(), func.get("appcode").asText(), EventingFunctionKeyspace.create(depcfg.get("source_bucket").asText(), depcfg.get("source_scope").asText(), depcfg.get("source_collection").asText()), EventingFunctionKeyspace.create(depcfg.get("metadata_bucket").asText(), depcfg.get("metadata_scope").asText(), depcfg.get("metadata_collection").asText())).handlerUuid(handlerUuid).functionInstanceId(functionInstanceId).version(version);
        EventingFunctionSettings.Builder settingsBuilder = EventingFunctionSettings.builder();
        if (settings.has("deployment_status")) {
            settingsBuilder.deploymentStatus(settings.get("deployment_status").asBoolean() ? EventingFunctionDeploymentStatus.DEPLOYED : EventingFunctionDeploymentStatus.UNDEPLOYED);
        }
        if (settings.has("processing_status")) {
            settingsBuilder.processingStatus(settings.get("processing_status").asBoolean() ? EventingFunctionProcessingStatus.RUNNING : EventingFunctionProcessingStatus.PAUSED);
        }
        if (func.has("enforce_schema")) {
            toReturn.enforceSchema(func.get("enforce_schema").asBoolean());
        }
        if (settings.has("cpp_worker_thread_count")) {
            settingsBuilder.cppWorkerThreadCount(settings.get("cpp_worker_thread_count").asLong());
        }
        if (settings.has("dcp_stream_boundary")) {
            String boundary = settings.get("dcp_stream_boundary").asText();
            settingsBuilder.dcpStreamBoundary(boundary.equals(EventingFunctionDcpBoundary.EVERYTHING.toString()) ? EventingFunctionDcpBoundary.EVERYTHING : EventingFunctionDcpBoundary.FROM_NOW);
        }
        if (settings.has("description")) {
            settingsBuilder.description(settings.get("description").asText());
        }
        if (settings.has("log_level")) {
            String logLevel = settings.get("log_level").asText();
            if (logLevel.equals(EventingFunctionLogLevel.DEBUG.toString())) {
                settingsBuilder.logLevel(EventingFunctionLogLevel.DEBUG);
            } else if (logLevel.equals(EventingFunctionLogLevel.TRACE.toString())) {
                settingsBuilder.logLevel(EventingFunctionLogLevel.TRACE);
            } else if (logLevel.equals(EventingFunctionLogLevel.INFO.toString())) {
                settingsBuilder.logLevel(EventingFunctionLogLevel.INFO);
            } else if (logLevel.equals(EventingFunctionLogLevel.ERROR.toString())) {
                settingsBuilder.logLevel(EventingFunctionLogLevel.ERROR);
            } else if (logLevel.equals(EventingFunctionLogLevel.WARNING.toString())) {
                settingsBuilder.logLevel(EventingFunctionLogLevel.WARNING);
            }
        }
        if (settings.has("language_compatibility")) {
            String compat = settings.get("language_compatibility").asText();
            if (compat.equals(EventingFunctionLanguageCompatibility.VERSION_6_0_0.toString())) {
                settingsBuilder.languageCompatibility(EventingFunctionLanguageCompatibility.VERSION_6_0_0);
            } else if (compat.equals(EventingFunctionLanguageCompatibility.VERSION_6_5_0.toString())) {
                settingsBuilder.languageCompatibility(EventingFunctionLanguageCompatibility.VERSION_6_5_0);
            } else if (compat.equals(EventingFunctionLanguageCompatibility.VERSION_6_6_2.toString())) {
                settingsBuilder.languageCompatibility(EventingFunctionLanguageCompatibility.VERSION_6_6_2);
            }
        }
        if (settings.has("lcb_inst_capacity")) {
            settingsBuilder.lcbInstCapacity(settings.get("lcb_inst_capacity").asLong());
        }
        if (settings.has("lcb_retry_count")) {
            settingsBuilder.lcbRetryCount(settings.get("lcb_retry_count").asLong());
        }
        if (settings.has("num_timer_partitions")) {
            settingsBuilder.numTimerPartitions(settings.get("num_timer_partitions").asLong());
        }
        if (settings.has("sock_batch_size")) {
            settingsBuilder.sockBatchSize(settings.get("sock_batch_size").asLong());
        }
        if (settings.has("tick_duration")) {
            settingsBuilder.tickDuration(Duration.ofMillis(settings.get("tick_duration").asLong()));
        }
        if (settings.has("timer_context_size")) {
            settingsBuilder.timerContextSize(settings.get("timer_context_size").asLong());
        }
        if (settings.has("bucket_cache_size")) {
            settingsBuilder.bucketCacheSize(settings.get("bucket_cache_size").asLong());
        }
        if (settings.has("bucket_cache_age")) {
            settingsBuilder.bucketCacheAge(settings.get("bucket_cache_age").asLong());
        }
        if (settings.has("curl_max_allowed_resp_size")) {
            settingsBuilder.curlMaxAllowedRespSize(settings.get("curl_max_allowed_resp_size").asLong());
        }
        if (settings.has("worker_count")) {
            settingsBuilder.workerCount(settings.get("worker_count").asLong());
        }
        if (settings.has("app_log_max_size")) {
            settingsBuilder.appLogMaxSize(settings.get("app_log_max_size").asLong());
        }
        if (settings.has("app_log_max_files")) {
            settingsBuilder.appLogMaxFiles(settings.get("app_log_max_files").asLong());
        }
        if (settings.has("checkpoint_interval")) {
            settingsBuilder.checkpointInterval(Duration.ofSeconds(settings.get("checkpoint_interval").asLong()));
        }
        if (settings.has("execution_timeout")) {
            settingsBuilder.executionTimeout(Duration.ofSeconds(settings.get("execution_timeout").asLong()));
        }
        if (settings.has("lcb_timeout")) {
            settingsBuilder.lcbTimeout(Duration.ofSeconds(settings.get("lcb_timeout").asLong()));
        }
        if (settings.has("user_prefix")) {
            settingsBuilder.userPrefix(settings.get("user_prefix").asText());
        }
        if (settings.has("app_log_dir")) {
            settingsBuilder.appLogDir(settings.get("app_log_dir").asText());
        }
        if (settings.has("n1ql_prepare_all")) {
            settingsBuilder.queryPrepareAll(settings.get("n1ql_prepare_all").asBoolean());
        }
        if (settings.has("enable_applog_rotation")) {
            settingsBuilder.enableAppLogRotation(settings.get("enable_applog_rotation").asBoolean());
        }
        if (settings.has("n1ql_consistency")) {
            if ("request".equals(settings.get("n1ql_consistency").asText())) {
                settingsBuilder.queryConsistency(QueryScanConsistency.REQUEST_PLUS);
            } else {
                settingsBuilder.queryConsistency(QueryScanConsistency.NOT_BOUNDED);
            }
        }
        if (settings.has("handler_headers")) {
            ArrayList<String> headers = new ArrayList<String>();
            for (JsonNode entry : settings.get("handler_headers")) {
                headers.add(entry.asText());
            }
            settingsBuilder.handlerHeaders(headers);
        }
        if (settings.has("handler_footers")) {
            ArrayList<String> footers = new ArrayList<String>();
            for (JsonNode entry : settings.get("handler_footers")) {
                footers.add(entry.asText());
            }
            settingsBuilder.handlerFooters(footers);
        }
        if (depcfg.has("buckets")) {
            ArrayList<EventingFunctionBucketBinding> bucketBindings = new ArrayList<EventingFunctionBucketBinding>();
            for (JsonNode buckets : depcfg.get("buckets")) {
                String alias = buckets.get("alias").asText();
                EventingFunctionKeyspace keyspace = EventingFunctionKeyspace.create(buckets.get("bucket_name").asText(), buckets.get("scope_name").asText(), buckets.get("collection_name").asText());
                if ("rw".equals(buckets.get("access").asText())) {
                    bucketBindings.add(EventingFunctionBucketBinding.createReadWrite(alias, keyspace));
                    continue;
                }
                bucketBindings.add(EventingFunctionBucketBinding.createReadOnly(alias, keyspace));
            }
            toReturn.bucketBindings(bucketBindings);
        }
        if (depcfg.has("constants")) {
            ArrayList<EventingFunctionConstantBinding> constantBindings = new ArrayList<EventingFunctionConstantBinding>();
            for (JsonNode constants : depcfg.get("constants")) {
                constantBindings.add(EventingFunctionConstantBinding.create(constants.get("value").asText(), constants.get("literal").asText()));
            }
            toReturn.constantBindings(constantBindings);
        }
        if (depcfg.has("curl")) {
            ArrayList<EventingFunctionUrlBinding> urlBindings = new ArrayList<EventingFunctionUrlBinding>();
            for (JsonNode url : depcfg.get("curl")) {
                EventingFunctionUrlBinding.Builder binding = EventingFunctionUrlBinding.builder(url.get("hostname").asText(), url.get("value").asText());
                if (url.has("allow_cookies")) {
                    binding.allowCookies(url.get("allow_cookies").asBoolean());
                }
                if (url.has("validate_ssl_certificate")) {
                    binding.validateSslCertificate(url.get("validate_ssl_certificate").asBoolean());
                }
                if (url.has("auth_type")) {
                    switch (url.get("auth_type").asText()) {
                        case "no-auth": {
                            binding.auth(new EventingFunctionUrlNoAuth());
                            break;
                        }
                        case "basic": {
                            binding.auth(new EventingFunctionUrlAuthBasic(url.get("username").asText(), null));
                            break;
                        }
                        case "digest": {
                            binding.auth(new EventingFunctionUrlAuthDigest(url.get("username").asText(), null));
                            break;
                        }
                        case "bearer": {
                            binding.auth(new EventingFunctionUrlAuthBearer(url.get("bearer_key").asText()));
                        }
                    }
                }
                urlBindings.add(binding.build());
            }
            toReturn.urlBindings(urlBindings);
        }
        return toReturn.settings(settingsBuilder.build()).build();
    }

    private static List<EventingFunction> decodeFunctions(byte[] encoded) {
        JsonNode encodedFunctions = Mapper.decodeIntoTree(encoded);
        ArrayList<EventingFunction> functions = new ArrayList<EventingFunction>();
        for (JsonNode encodedFunction : encodedFunctions) {
            functions.add(AsyncEventingFunctionManager.decodeFunction(Mapper.encodeAsBytes(encodedFunction)));
        }
        return functions;
    }
}

