/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.query;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.CommonOptions;
import java.util.Optional;

public class DropQueryIndexOptions
extends CommonOptions<DropQueryIndexOptions> {
    private boolean ignoreIfNotExists;
    private String scopeName;
    private String collectionName;

    private DropQueryIndexOptions() {
    }

    public static DropQueryIndexOptions dropQueryIndexOptions() {
        return new DropQueryIndexOptions();
    }

    public DropQueryIndexOptions ignoreIfNotExists(boolean ignore) {
        this.ignoreIfNotExists = ignore;
        return this;
    }

    public DropQueryIndexOptions scopeName(String scopeName) {
        this.scopeName = Validators.notNullOrEmpty(scopeName, "ScopeName");
        return this;
    }

    public DropQueryIndexOptions collectionName(String collectionName) {
        this.collectionName = Validators.notNullOrEmpty(collectionName, "CollectionName");
        return this;
    }

    @Stability.Internal
    public Built build() {
        if (this.collectionName != null && this.scopeName == null) {
            throw InvalidArgumentException.fromMessage("If a collectionName is provided, a scopeName must also be provided");
        }
        if (this.scopeName != null && this.collectionName == null) {
            throw InvalidArgumentException.fromMessage("If a scopeName is provided, a collectionName must also be provided");
        }
        return new Built();
    }

    public class Built
    extends CommonOptions.BuiltCommonOptions {
        Built() {
            super(DropQueryIndexOptions.this);
        }

        public boolean ignoreIfNotExists() {
            return DropQueryIndexOptions.this.ignoreIfNotExists;
        }

        public Optional<String> scopeName() {
            return Optional.ofNullable(DropQueryIndexOptions.this.scopeName);
        }

        public Optional<String> collectionName() {
            return Optional.ofNullable(DropQueryIndexOptions.this.collectionName);
        }
    }
}

