/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.raw;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.codec.TypeRef;
import java.nio.charset.StandardCharsets;

@Stability.Uncommitted
public class RawManagerResponse {
    private final ServiceType serviceType;
    private final JsonSerializer serializer;
    private final int httpStatus;
    private final byte[] payload;

    public RawManagerResponse(ServiceType serviceType, JsonSerializer serializer, int httpStatus, byte[] payload) {
        this.serviceType = serviceType;
        this.serializer = serializer;
        this.httpStatus = httpStatus;
        this.payload = payload;
    }

    public int httpStatus() {
        return this.httpStatus;
    }

    public ServiceType serviceType() {
        return this.serviceType;
    }

    public <T> T contentAs(Class<T> target) {
        return this.serializer.deserialize(target, this.payload);
    }

    public <T> T contentAs(TypeRef<T> target) {
        return this.serializer.deserialize(target, this.payload);
    }

    public String toString() {
        return "RawManagerResponse{serviceType=" + (Object)((Object)this.serviceType) + ", httpStatus=" + this.httpStatus + ", payload=" + RedactableArgument.redactMeta(new String(this.payload, StandardCharsets.UTF_8)) + '}';
    }
}

