/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.search;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.cnc.CbTracing;
import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.type.TypeReference;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.io.netty.handler.codec.http.HttpHeaderNames;
import com.couchbase.client.core.endpoint.http.CoreHttpClient;
import com.couchbase.client.core.endpoint.http.CoreHttpPath;
import com.couchbase.client.core.error.CouchbaseException;
import com.couchbase.client.core.error.FeatureNotAvailableException;
import com.couchbase.client.core.error.IndexNotFoundException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.msg.RequestTarget;
import com.couchbase.client.core.util.UrlQueryStringBuilder;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.manager.search.AllowQueryingSearchIndexOptions;
import com.couchbase.client.java.manager.search.AnalyzeDocumentOptions;
import com.couchbase.client.java.manager.search.DisallowQueryingSearchIndexOptions;
import com.couchbase.client.java.manager.search.DropSearchIndexOptions;
import com.couchbase.client.java.manager.search.FreezePlanSearchIndexOptions;
import com.couchbase.client.java.manager.search.GetAllSearchIndexesOptions;
import com.couchbase.client.java.manager.search.GetIndexedSearchIndexOptions;
import com.couchbase.client.java.manager.search.GetSearchIndexOptions;
import com.couchbase.client.java.manager.search.PauseIngestSearchIndexOptions;
import com.couchbase.client.java.manager.search.ResumeIngestSearchIndexOptions;
import com.couchbase.client.java.manager.search.SearchIndex;
import com.couchbase.client.java.manager.search.UnfreezePlanSearchIndexOptions;
import com.couchbase.client.java.manager.search.UpsertSearchIndexOptions;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class AsyncSearchIndexManager {
    private final Core core;
    private final CoreHttpClient searchHttpClient;

    public AsyncSearchIndexManager(Core core) {
        this.core = core;
        this.searchHttpClient = core.httpClient(RequestTarget.search());
    }

    private static String indexesPath() {
        return "/api/index";
    }

    private static String indexPath(String indexName) {
        return AsyncSearchIndexManager.indexesPath() + "/" + UrlQueryStringBuilder.urlEncode(indexName);
    }

    private static String indexCountPath(String indexName) {
        return AsyncSearchIndexManager.indexPath(indexName) + "/count";
    }

    private static String analyzeDocumentPath(String indexName) {
        return AsyncSearchIndexManager.indexPath(indexName) + "/analyzeDoc";
    }

    private static String pauseIngestPath(String indexName) {
        return AsyncSearchIndexManager.indexPath(indexName) + "/ingestControl/pause";
    }

    private static String resumeIngestPath(String indexName) {
        return AsyncSearchIndexManager.indexPath(indexName) + "/ingestControl/resume";
    }

    private static String allowQueryingPath(String indexName) {
        return AsyncSearchIndexManager.indexPath(indexName) + "/queryControl/allow";
    }

    private static String disallowQueryingPath(String indexName) {
        return AsyncSearchIndexManager.indexPath(indexName) + "/queryControl/disallow";
    }

    private static String freezePlanPath(String indexName) {
        return AsyncSearchIndexManager.indexPath(indexName) + "/planFreezeControl/freeze";
    }

    private static String unfreezePlanPath(String indexName) {
        return AsyncSearchIndexManager.indexPath(indexName) + "/planFreezeControl/unfreeze";
    }

    public CompletableFuture<SearchIndex> getIndex(String name) {
        return this.getIndex(name, GetSearchIndexOptions.getSearchIndexOptions());
    }

    public CompletableFuture<SearchIndex> getIndex(String name, GetSearchIndexOptions options) {
        Validators.notNullOrEmpty(name, "Search Index Name");
        RequestSpan span = CbTracing.newSpan(this.core.context(), "manager_search_get_index", (RequestSpan)options.build().parentSpan().orElse(null));
        return ((CompletableFuture)this.getAllIndexes((GetAllSearchIndexesOptions)GetAllSearchIndexesOptions.getAllSearchIndexesOptions().parentSpan(span)).thenApply(indexes -> indexes.stream().filter(i -> i.name().equals(name)).findFirst().orElseThrow(() -> new IndexNotFoundException(name)))).whenComplete((r, t) -> span.end());
    }

    public CompletableFuture<List<SearchIndex>> getAllIndexes() {
        return this.getAllIndexes(GetAllSearchIndexesOptions.getAllSearchIndexesOptions());
    }

    public CompletableFuture<List<SearchIndex>> getAllIndexes(GetAllSearchIndexesOptions options) {
        return this.searchHttpClient.get(CoreHttpPath.path(AsyncSearchIndexManager.indexesPath()), options.build()).trace("manager_search_get_all_indexes").exec(this.core).thenApply(response -> {
            JsonNode rootNode = Mapper.decodeIntoTree(response.content());
            JsonNode indexDefs = rootNode.get("indexDefs").get("indexDefs");
            Map<String, SearchIndex> indexes = Mapper.convertValue((Object)indexDefs, new TypeReference<Map<String, SearchIndex>>(){});
            return indexes == null ? Collections.emptyList() : new ArrayList<SearchIndex>(indexes.values());
        });
    }

    public CompletableFuture<Long> getIndexedDocumentsCount(String name) {
        return this.getIndexedDocumentsCount(name, GetIndexedSearchIndexOptions.getIndexedSearchIndexOptions());
    }

    public CompletableFuture<Long> getIndexedDocumentsCount(String name, GetIndexedSearchIndexOptions options) {
        Validators.notNullOrEmpty(name, "Search Index Name");
        return this.searchHttpClient.get(CoreHttpPath.path(AsyncSearchIndexManager.indexCountPath(name)), options.build()).trace("manager_search_get_indexed_documents_count").exec(this.core).thenApply(response -> {
            JsonNode rootNode = Mapper.decodeIntoTree(response.content());
            return rootNode.get("count").asLong();
        });
    }

    public CompletableFuture<Void> upsertIndex(SearchIndex index) {
        return this.upsertIndex(index, UpsertSearchIndexOptions.upsertSearchIndexOptions());
    }

    public CompletableFuture<Void> upsertIndex(SearchIndex index, UpsertSearchIndexOptions options) {
        Validators.notNull(index, "Search Index");
        return this.searchHttpClient.put(CoreHttpPath.path(AsyncSearchIndexManager.indexPath(index.name())), options.build()).trace("manager_search_upsert_index").json(index.toJson().getBytes(StandardCharsets.UTF_8)).header(HttpHeaderNames.CACHE_CONTROL, "no-cache").exec(this.core).thenApply(response -> null);
    }

    public CompletableFuture<Void> dropIndex(String name) {
        return this.dropIndex(name, DropSearchIndexOptions.dropSearchIndexOptions());
    }

    public CompletableFuture<Void> dropIndex(String name, DropSearchIndexOptions options) {
        Validators.notNullOrEmpty(name, "Search Index Name");
        return this.searchHttpClient.delete(CoreHttpPath.path(AsyncSearchIndexManager.indexPath(name)), options.build()).trace("manager_search_drop_index").exec(this.core).thenApply(response -> null);
    }

    public CompletableFuture<List<JsonObject>> analyzeDocument(String name, JsonObject document) {
        return this.analyzeDocument(name, document, AnalyzeDocumentOptions.analyzeDocumentOptions());
    }

    public CompletableFuture<List<JsonObject>> analyzeDocument(String name, JsonObject document, AnalyzeDocumentOptions options) {
        Validators.notNullOrEmpty(name, "Search Index Name");
        Validators.notNull(document, "Document");
        return ((CompletableFuture)this.searchHttpClient.post(CoreHttpPath.path(AsyncSearchIndexManager.analyzeDocumentPath(name)), options.build()).trace("manager_search_analyze_document").json(Mapper.encodeAsBytes(document.toMap())).exec(this.core).exceptionally(throwable -> {
            if (throwable.getMessage().contains("Page not found")) {
                throw new FeatureNotAvailableException("Document analysis is not available on this server version!");
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new CouchbaseException("Failed to analyze search document", (Throwable)throwable);
        })).thenApply(response -> {
            JsonNode rootNode = Mapper.decodeIntoTree(response.content());
            List<Map<String, Object>> analyzed = Mapper.convertValue((Object)rootNode.get("analyzed"), new TypeReference<List<Map<String, Object>>>(){});
            return analyzed.stream().filter(Objects::nonNull).map(JsonObject::from).collect(Collectors.toList());
        });
    }

    public CompletableFuture<Void> pauseIngest(String name) {
        return this.pauseIngest(name, PauseIngestSearchIndexOptions.pauseIngestSearchIndexOptions());
    }

    public CompletableFuture<Void> pauseIngest(String name, PauseIngestSearchIndexOptions options) {
        Validators.notNullOrEmpty(name, "Search Index Name");
        return this.searchHttpClient.post(CoreHttpPath.path(AsyncSearchIndexManager.pauseIngestPath(name)), options.build()).trace("manager_search_pause_ingest").exec(this.core).thenApply(response -> null);
    }

    public CompletableFuture<Void> resumeIngest(String name) {
        return this.resumeIngest(name, ResumeIngestSearchIndexOptions.resumeIngestSearchIndexOptions());
    }

    public CompletableFuture<Void> resumeIngest(String name, ResumeIngestSearchIndexOptions options) {
        Validators.notNullOrEmpty(name, "Search Index Name");
        return this.searchHttpClient.post(CoreHttpPath.path(AsyncSearchIndexManager.resumeIngestPath(name)), options.build()).trace("manager_search_resume_ingest").exec(this.core).thenApply(response -> null);
    }

    public CompletableFuture<Void> allowQuerying(String name) {
        return this.allowQuerying(name, AllowQueryingSearchIndexOptions.allowQueryingSearchIndexOptions());
    }

    public CompletableFuture<Void> allowQuerying(String name, AllowQueryingSearchIndexOptions options) {
        Validators.notNullOrEmpty(name, "Search Index Name");
        return this.searchHttpClient.post(CoreHttpPath.path(AsyncSearchIndexManager.allowQueryingPath(name)), options.build()).trace("manager_search_allow_querying").exec(this.core).thenApply(response -> null);
    }

    public CompletableFuture<Void> disallowQuerying(String name) {
        return this.disallowQuerying(name, DisallowQueryingSearchIndexOptions.disallowQueryingSearchIndexOptions());
    }

    public CompletableFuture<Void> disallowQuerying(String name, DisallowQueryingSearchIndexOptions options) {
        Validators.notNullOrEmpty(name, "Search Index Name");
        return this.searchHttpClient.post(CoreHttpPath.path(AsyncSearchIndexManager.disallowQueryingPath(name)), options.build()).trace("manager_search_disallow_querying").exec(this.core).thenApply(response -> null);
    }

    public CompletableFuture<Void> freezePlan(String name) {
        return this.freezePlan(name, FreezePlanSearchIndexOptions.freezePlanSearchIndexOptions());
    }

    public CompletableFuture<Void> freezePlan(String name, FreezePlanSearchIndexOptions options) {
        Validators.notNullOrEmpty(name, "Search Index Name");
        return this.searchHttpClient.post(CoreHttpPath.path(AsyncSearchIndexManager.freezePlanPath(name)), options.build()).trace("manager_search_freeze_plan").exec(this.core).thenApply(response -> null);
    }

    public CompletableFuture<Void> unfreezePlan(String name) {
        return this.unfreezePlan(name, UnfreezePlanSearchIndexOptions.unfreezePlanSearchIndexOptions());
    }

    public CompletableFuture<Void> unfreezePlan(String name, UnfreezePlanSearchIndexOptions options) {
        Validators.notNullOrEmpty(name, "Search Index Name");
        return this.searchHttpClient.post(CoreHttpPath.path(AsyncSearchIndexManager.unfreezePlanPath(name)), options.build()).trace("manager_search_unfreeze_plan").exec(this.core).thenApply(response -> null);
    }
}

