/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.user;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.util.CbStrings;
import com.couchbase.client.java.manager.user.Role;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@Stability.Volatile
public class User {
    private final String username;
    private String displayName = "";
    private Set<String> groups = new HashSet<String>();
    private Set<Role> innateRoles = new HashSet<Role>();
    private Optional<String> password = Optional.empty();

    public User(String username) {
        this.username = Objects.requireNonNull(username);
    }

    public String username() {
        return this.username;
    }

    Optional<String> password() {
        return this.password;
    }

    public User password(String newPassword) {
        this.password = Optional.of(newPassword);
        return this;
    }

    public String displayName() {
        return this.displayName;
    }

    public User displayName(String displayName) {
        this.displayName = CbStrings.nullToEmpty(displayName);
        return this;
    }

    public Set<String> groups() {
        return this.groups;
    }

    public User groups(Collection<String> groups) {
        this.groups = new HashSet<String>(groups);
        return this;
    }

    public User groups(String ... groups) {
        return this.groups(Arrays.asList(groups));
    }

    public Set<Role> roles() {
        return this.innateRoles;
    }

    public User roles(Collection<Role> roles) {
        this.innateRoles = new HashSet<Role>(roles);
        return this;
    }

    public User roles(Role ... roles) {
        return this.roles(Arrays.asList(roles));
    }

    public String toString() {
        return "User{username='" + this.username + '\'' + ", displayName='" + this.displayName + '\'' + ", groups=" + this.groups + ", innateRoles=" + this.innateRoles + '}';
    }
}

