/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.manager.view;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.deps.com.fasterxml.jackson.core.type.TypeReference;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.node.ObjectNode;
import com.couchbase.client.core.error.context.ReducedViewErrorContext;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.manager.CoreViewIndexManager;
import com.couchbase.client.core.util.CbStrings;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.manager.view.DesignDocument;
import com.couchbase.client.java.manager.view.DropDesignDocumentOptions;
import com.couchbase.client.java.manager.view.GetAllDesignDocumentsOptions;
import com.couchbase.client.java.manager.view.GetDesignDocumentOptions;
import com.couchbase.client.java.manager.view.PublishDesignDocumentOptions;
import com.couchbase.client.java.manager.view.UpsertDesignDocumentOptions;
import com.couchbase.client.java.manager.view.View;
import com.couchbase.client.java.view.DesignDocumentNamespace;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class AsyncViewIndexManager {
    private final CoreViewIndexManager coreManager;
    private final String bucket;

    public AsyncViewIndexManager(Core core, String bucket) {
        this.coreManager = new CoreViewIndexManager(core, bucket);
        this.bucket = Objects.requireNonNull(bucket);
    }

    public CompletableFuture<List<DesignDocument>> getAllDesignDocuments(DesignDocumentNamespace namespace) {
        return this.getAllDesignDocuments(namespace, GetAllDesignDocumentsOptions.getAllDesignDocumentsOptions());
    }

    public CompletableFuture<List<DesignDocument>> getAllDesignDocuments(DesignDocumentNamespace namespace, GetAllDesignDocumentsOptions options) {
        Validators.notNull(namespace, "DesignDocumentNamespace", () -> new ReducedViewErrorContext(null, null, this.bucket));
        Validators.notNull(options, "GetAllDesignDocumentsOptions", () -> new ReducedViewErrorContext(null, null, this.bucket));
        return this.coreManager.getAllDesignDocuments(namespace == DesignDocumentNamespace.PRODUCTION, options.build()).thenApply(AsyncViewIndexManager::parseAllDesignDocuments);
    }

    private static List<DesignDocument> parseAllDesignDocuments(Map<String, ObjectNode> ddocNameToJson) {
        ArrayList<DesignDocument> result = new ArrayList<DesignDocument>();
        ddocNameToJson.forEach((k, v) -> result.add(AsyncViewIndexManager.parseDesignDocument(k, v)));
        return result;
    }

    public CompletableFuture<DesignDocument> getDesignDocument(String name, DesignDocumentNamespace namespace) {
        return this.getDesignDocument(name, namespace, GetDesignDocumentOptions.getDesignDocumentOptions());
    }

    public CompletableFuture<DesignDocument> getDesignDocument(String name, DesignDocumentNamespace namespace, GetDesignDocumentOptions options) {
        Validators.notNullOrEmpty(name, "Name", () -> new ReducedViewErrorContext(null, null, this.bucket));
        Validators.notNull(namespace, "DesignDocumentNamespace", () -> new ReducedViewErrorContext(name, null, this.bucket));
        Validators.notNull(options, "GetDesignDocumentOptions", () -> new ReducedViewErrorContext(name, null, this.bucket));
        return this.coreManager.getDesignDocument(name, namespace == DesignDocumentNamespace.PRODUCTION, options.build()).thenApply(responseBytes -> AsyncViewIndexManager.parseDesignDocument(name, Mapper.decodeIntoTree(responseBytes)));
    }

    private static DesignDocument parseDesignDocument(String name, JsonNode node) {
        ObjectNode viewsNode = (ObjectNode)node.path("views");
        Map<String, View> views = Mapper.convertValue((Object)viewsNode, new TypeReference<Map<String, View>>(){});
        return new DesignDocument(CbStrings.removeStart(name, "dev_"), views);
    }

    public CompletableFuture<Void> upsertDesignDocument(DesignDocument doc, DesignDocumentNamespace namespace) {
        return this.upsertDesignDocument(doc, namespace, UpsertDesignDocumentOptions.upsertDesignDocumentOptions());
    }

    public CompletableFuture<Void> upsertDesignDocument(DesignDocument doc, DesignDocumentNamespace namespace, UpsertDesignDocumentOptions options) {
        Validators.notNull(doc, "DesignDocument", () -> new ReducedViewErrorContext(null, null, this.bucket));
        Validators.notNull(namespace, "DesignDocumentNamespace", () -> new ReducedViewErrorContext(doc.name(), null, this.bucket));
        Validators.notNull(options, "UpsertDesignDocumentOptions", () -> new ReducedViewErrorContext(doc.name(), null, this.bucket));
        byte[] docBytes = Mapper.encodeAsBytes(AsyncViewIndexManager.toJson(doc));
        return this.coreManager.upsertDesignDocument(doc.name(), docBytes, namespace == DesignDocumentNamespace.PRODUCTION, options.build());
    }

    public CompletableFuture<Void> publishDesignDocument(String name) {
        return this.publishDesignDocument(name, PublishDesignDocumentOptions.publishDesignDocumentOptions());
    }

    public CompletableFuture<Void> publishDesignDocument(String name, PublishDesignDocumentOptions options) {
        Validators.notNullOrEmpty(name, "Name", () -> new ReducedViewErrorContext(null, null, this.bucket));
        Validators.notNull(options, "PublishDesignDocumentOptions", () -> new ReducedViewErrorContext(name, null, this.bucket));
        return this.coreManager.publishDesignDocument(name, options.build());
    }

    public CompletableFuture<Void> dropDesignDocument(String name, DesignDocumentNamespace namespace) {
        return this.dropDesignDocument(name, namespace, DropDesignDocumentOptions.dropDesignDocumentOptions());
    }

    public CompletableFuture<Void> dropDesignDocument(String name, DesignDocumentNamespace namespace, DropDesignDocumentOptions options) {
        Validators.notNullOrEmpty(name, "Name", () -> new ReducedViewErrorContext(null, null, this.bucket));
        Validators.notNull(namespace, "DesignDocumentNamespace", () -> new ReducedViewErrorContext(name, null, this.bucket));
        Validators.notNull(options, "DropDesignDocumentOptions", () -> new ReducedViewErrorContext(name, null, this.bucket));
        return this.coreManager.dropDesignDocument(name, namespace == DesignDocumentNamespace.PRODUCTION, options.build());
    }

    private static ObjectNode toJson(DesignDocument doc) {
        ObjectNode root = Mapper.createObjectNode();
        ObjectNode views = root.putObject("views");
        doc.views().forEach((k, v) -> {
            ObjectNode viewNode = Mapper.createObjectNode();
            viewNode.put("map", v.map());
            v.reduce().ifPresent(r -> viewNode.put("reduce", (String)r));
            views.set((String)k, viewNode);
        });
        return root;
    }
}

