/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.queries;

import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.search.SearchQuery;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class DocIdQuery
extends SearchQuery {
    private List<String> docIds = new LinkedList<String>();

    public DocIdQuery(String ... docIds) {
        Collections.addAll(this.docIds, docIds);
    }

    public DocIdQuery docIds(String ... docIds) {
        Collections.addAll(this.docIds, docIds);
        return this;
    }

    @Override
    public DocIdQuery boost(double boost) {
        super.boost(boost);
        return this;
    }

    @Override
    protected void injectParams(JsonObject input) {
        if (this.docIds.isEmpty()) {
            throw InvalidArgumentException.fromMessage("DocID query needs at least one document ID");
        }
        JsonArray ids = JsonArray.from(this.docIds);
        input.put("ids", ids);
    }
}

