/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.search.queries;

import com.couchbase.client.core.error.InvalidArgumentException;
import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.couchbase.client.java.search.SearchQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PhraseQuery
extends SearchQuery {
    private final List<String> terms = new ArrayList<String>();
    private String field;

    public PhraseQuery(String ... terms) {
        Collections.addAll(this.terms, terms);
    }

    public PhraseQuery field(String field) {
        this.field = field;
        return this;
    }

    @Override
    public PhraseQuery boost(double boost) {
        super.boost(boost);
        return this;
    }

    @Override
    protected void injectParams(JsonObject input) {
        if (this.terms.isEmpty()) {
            throw InvalidArgumentException.fromMessage("Phrase query must at least have one term");
        }
        JsonArray terms = JsonArray.from(this.terms);
        input.put("terms", terms);
        if (this.field != null) {
            input.put("field", this.field);
        }
    }
}

