/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.transactions.config;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.io.CollectionIdentifier;
import com.couchbase.client.core.msg.kv.DurabilityLevel;
import com.couchbase.client.core.transaction.cleanup.CleanerFactory;
import com.couchbase.client.core.transaction.cleanup.ClientRecordFactory;
import com.couchbase.client.core.transaction.config.CoreTransactionsCleanupConfig;
import com.couchbase.client.core.transaction.config.CoreTransactionsConfig;
import com.couchbase.client.core.transaction.support.TransactionAttemptContextFactory;
import com.couchbase.client.core.util.Validators;
import com.couchbase.client.java.transactions.TransactionKeyspace;
import com.couchbase.client.java.transactions.config.TransactionsCleanupConfig;
import com.couchbase.client.java.transactions.config.TransactionsQueryConfig;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import reactor.util.annotation.Nullable;

public class TransactionsConfig {
    private static final Duration TRANSACTION_TIMEOUT_MSECS_DEFAULT = Duration.of(15L, ChronoUnit.SECONDS);

    public static Builder builder() {
        return new Builder();
    }

    public static Builder cleanupConfig(TransactionsCleanupConfig.Builder config) {
        return TransactionsConfig.builder().cleanupConfig(config);
    }

    public static Builder timeout(Duration timeout) {
        return TransactionsConfig.builder().timeout(timeout);
    }

    public static Builder durabilityLevel(DurabilityLevel level) {
        return TransactionsConfig.builder().durabilityLevel(level);
    }

    public static Builder metadataCollection(TransactionKeyspace collection) {
        return TransactionsConfig.builder().metadataCollection(collection);
    }

    public static Builder queryConfig(TransactionsQueryConfig.Builder queryConfig) {
        return TransactionsConfig.builder().queryConfig(queryConfig);
    }

    public static class Builder {
        private DurabilityLevel level = DurabilityLevel.MAJORITY;
        private Optional<Duration> timeout = Optional.empty();
        private Optional<CoreTransactionsCleanupConfig> cleanupConfig = Optional.empty();
        private Optional<TransactionAttemptContextFactory> attemptContextFactory = Optional.empty();
        private Optional<CleanerFactory> cleanerFactory = Optional.empty();
        private Optional<ClientRecordFactory> clientRecordFactory = Optional.empty();
        private Optional<Integer> numAtrs = Optional.empty();
        private Optional<CollectionIdentifier> metadataCollection = Optional.empty();
        private Optional<TransactionsQueryConfig.Builder> queryConfig = Optional.empty();

        @Stability.Internal
        public CoreTransactionsConfig build() {
            return new CoreTransactionsConfig(this.level, this.timeout.orElse(TRANSACTION_TIMEOUT_MSECS_DEFAULT), this.cleanupConfig.orElse(TransactionsCleanupConfig.builder().build()), this.attemptContextFactory.orElse(new TransactionAttemptContextFactory()), this.cleanerFactory.orElse(new CleanerFactory()), this.clientRecordFactory.orElse(new ClientRecordFactory()), this.numAtrs.orElse(1024), this.metadataCollection, this.queryConfig.flatMap(v -> v.scanConsistency().map(Enum::name)));
        }

        public Builder cleanupConfig(TransactionsCleanupConfig.Builder config) {
            Validators.notNull(config, "cleanupConfig");
            this.cleanupConfig = Optional.of(config.build());
            return this;
        }

        public Builder timeout(Duration timeout) {
            Validators.notNull(timeout, "timeout");
            this.timeout = Optional.of(timeout);
            return this;
        }

        public Builder durabilityLevel(DurabilityLevel level) {
            Validators.notNull(level, "durabilityLevel");
            this.level = level;
            return this;
        }

        @Stability.Internal
        Builder testFactories(@Nullable TransactionAttemptContextFactory attemptContextFactory, @Nullable CleanerFactory cleanerFactory, @Nullable ClientRecordFactory clientRecordFactory) {
            this.attemptContextFactory = Optional.ofNullable(attemptContextFactory);
            this.cleanerFactory = Optional.ofNullable(cleanerFactory);
            this.clientRecordFactory = Optional.ofNullable(clientRecordFactory);
            return this;
        }

        public Builder metadataCollection(TransactionKeyspace collection) {
            Validators.notNull(collection, "metadataCollection");
            CollectionIdentifier coll = new CollectionIdentifier(collection.bucket(), Optional.of(collection.scope()), Optional.of(collection.collection()));
            this.metadataCollection = Optional.ofNullable(coll);
            return this;
        }

        public Builder queryConfig(TransactionsQueryConfig.Builder queryConfig) {
            Validators.notNull(queryConfig, "queryConfig");
            this.queryConfig = Optional.of(queryConfig);
            return this;
        }
    }
}

