/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.transactions.internal;

import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.error.UnambiguousTimeoutException;
import com.couchbase.client.core.error.transaction.internal.CoreTransactionCommitAmbiguousException;
import com.couchbase.client.core.error.transaction.internal.CoreTransactionExpiredException;
import com.couchbase.client.core.error.transaction.internal.CoreTransactionFailedException;
import com.couchbase.client.java.transactions.error.TransactionCommitAmbiguousException;
import com.couchbase.client.java.transactions.error.TransactionExpiredException;
import com.couchbase.client.java.transactions.error.TransactionFailedException;
import reactor.core.publisher.Mono;

@Stability.Internal
public class ErrorUtil {
    private ErrorUtil() {
    }

    public static <T> Mono<T> convertTransactionFailedInternal(Throwable err) {
        Throwable out = err;
        if (err instanceof CoreTransactionCommitAmbiguousException) {
            out = new TransactionCommitAmbiguousException((CoreTransactionCommitAmbiguousException)err);
        } else if (err instanceof CoreTransactionExpiredException) {
            out = new TransactionExpiredException((CoreTransactionExpiredException)err);
        } else if (err instanceof CoreTransactionFailedException) {
            out = new TransactionFailedException((CoreTransactionFailedException)err);
        }
        return Mono.error(out);
    }

    public static Mono<?> convertTransactionFailedSingleQueryMono(Throwable err) {
        return ErrorUtil.convertTransactionFailedInternal(err).onErrorResume(ex -> {
            if (ex instanceof TransactionExpiredException) {
                return Mono.error(new UnambiguousTimeoutException(ex.getMessage(), null));
            }
            return Mono.error(ex);
        });
    }

    public static void convertTransactionFailedSingleQuery(RuntimeException err) {
        ErrorUtil.convertTransactionFailedSingleQueryMono(err).block();
    }
}

