/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.view;

import com.couchbase.client.core.Core;
import com.couchbase.client.core.Reactor;
import com.couchbase.client.core.annotation.Stability;
import com.couchbase.client.core.msg.view.ViewChunkRow;
import com.couchbase.client.core.msg.view.ViewRequest;
import com.couchbase.client.core.msg.view.ViewResponse;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.view.ReactiveViewResult;
import com.couchbase.client.java.view.ViewResult;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import reactor.core.publisher.Mono;

@Stability.Internal
public class ViewAccessor {
    public static CompletableFuture<ViewResult> viewQueryAsync(Core core, ViewRequest request, JsonSerializer serializer) {
        return ViewAccessor.viewQueryInternal(core, request).flatMap(response -> response.rows().collectList().map(rows -> new ViewResult(response.header(), (List<ViewChunkRow>)rows, serializer))).toFuture();
    }

    public static Mono<ReactiveViewResult> viewQueryReactive(Core core, ViewRequest request, JsonSerializer serializer) {
        return ViewAccessor.viewQueryInternal(core, request).map(r -> new ReactiveViewResult((ViewResponse)r, serializer));
    }

    private static Mono<ViewResponse> viewQueryInternal(Core core, ViewRequest request) {
        core.send(request);
        return Reactor.wrap(request, request.response(), true).doOnNext(ignored -> request.context().logicallyComplete()).doOnError(err -> request.context().logicallyComplete((Throwable)err));
    }
}

