/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.java.view;

import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.core.error.ViewServiceException;
import com.couchbase.client.core.json.Mapper;
import com.couchbase.client.core.json.MapperException;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.java.codec.JsonSerializer;
import com.couchbase.client.java.codec.TypeRef;
import java.nio.charset.StandardCharsets;
import java.util.Optional;

public class ViewRow {
    private final byte[] raw;
    private final JsonNode rootNode;
    private final JsonSerializer serializer;

    ViewRow(byte[] raw, JsonSerializer serializer) {
        this.raw = raw;
        this.serializer = serializer;
        try {
            this.rootNode = Mapper.decodeIntoTree(raw);
        }
        catch (MapperException e) {
            throw new ViewServiceException("Could not parse row!");
        }
    }

    public Optional<String> id() {
        return this.decode(String.class, "id");
    }

    public <T> Optional<T> keyAs(Class<T> target) {
        return this.decode(target, "key");
    }

    public <T> Optional<T> keyAs(TypeRef<T> target) {
        return this.decode(target, "key");
    }

    public <T> Optional<T> valueAs(Class<T> target) {
        return this.decode(target, "value");
    }

    public <T> Optional<T> valueAs(TypeRef<T> target) {
        return this.decode(target, "value");
    }

    private <T> Optional<T> decode(Class<T> target, String path) {
        return this.findNonNullNode(path).map(subNode -> {
            byte[] raw = Mapper.encodeAsBytes(subNode);
            return this.serializer.deserialize(target, raw);
        });
    }

    private <T> Optional<T> decode(TypeRef<T> target, String path) {
        return this.findNonNullNode(path).map(subNode -> {
            byte[] raw = Mapper.encodeAsBytes(subNode);
            return this.serializer.deserialize(target, raw);
        });
    }

    private Optional<JsonNode> findNonNullNode(String path) {
        JsonNode subNode = this.rootNode.get(path);
        return subNode == null || subNode.isNull() ? Optional.empty() : Optional.of(subNode);
    }

    public String toString() {
        return "ViewRow{raw=" + RedactableArgument.redactUser(new String(this.raw, StandardCharsets.UTF_8)) + '}';
    }
}

