/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.couchbase;

import com.couchbase.client.core.deps.com.fasterxml.jackson.databind.JsonNode;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Collection;
import com.couchbase.client.java.Scope;
import com.couchbase.client.java.view.ViewOptions;
import com.couchbase.client.java.view.ViewOrdering;
import com.couchbase.client.java.view.ViewResult;
import com.couchbase.client.java.view.ViewRow;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.couchbase.CouchbaseCollectionOperation;
import org.apache.camel.component.couchbase.CouchbaseEndpoint;
import org.apache.camel.resume.ResumeAware;
import org.apache.camel.resume.ResumeStrategy;
import org.apache.camel.support.DefaultScheduledPollConsumer;
import org.apache.camel.support.resume.ResumeStrategyHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CouchbaseConsumer
extends DefaultScheduledPollConsumer
implements ResumeAware<ResumeStrategy> {
    private static final Logger LOG = LoggerFactory.getLogger(CouchbaseConsumer.class);
    private final CouchbaseEndpoint endpoint;
    private final Bucket bucket;
    private final Collection collection;
    private ViewOptions viewOptions;
    private ResumeStrategy resumeStrategy;

    public CouchbaseConsumer(CouchbaseEndpoint endpoint, Bucket client, Processor processor) {
        super(endpoint, processor);
        this.bucket = client;
        this.endpoint = endpoint;
        Scope scope = endpoint.getScope() != null ? client.scope(endpoint.getScope()) : client.defaultScope();
        this.collection = endpoint.getCollection() != null ? scope.collection(endpoint.getCollection()) : client.defaultCollection();
    }

    @Override
    protected void doInit() {
        int skip;
        this.viewOptions = ViewOptions.viewOptions();
        int limit = this.endpoint.getLimit();
        if (limit > 0) {
            this.viewOptions.limit(limit);
        }
        if ((skip = this.endpoint.getSkip()) > 0) {
            this.viewOptions.skip(skip);
        }
        if (this.endpoint.isDescending()) {
            this.viewOptions.order(ViewOrdering.DESCENDING);
        }
        String rangeStartKey = this.endpoint.getRangeStartKey();
        String rangeEndKey = this.endpoint.getRangeEndKey();
        if ("".equals(rangeStartKey) || "".equals(rangeEndKey)) {
            return;
        }
        this.viewOptions.startKey(rangeStartKey).endKey(rangeEndKey);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        ResumeStrategyHelper.resume(this.getEndpoint().getCamelContext(), this, this.resumeStrategy, "CamelCqlResumeQuery");
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this.bucket != null) {
            this.bucket.core().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized int poll() throws Exception {
        ViewResult result = this.bucket.viewQuery(this.endpoint.getDesignDocumentName(), this.endpoint.getViewName(), this.viewOptions);
        if (LOG.isTraceEnabled()) {
            LOG.trace("ViewResponse =  {}", (Object)result);
        }
        String consumerProcessedStrategy = this.endpoint.getConsumerProcessedStrategy();
        for (ViewRow row : result.rows()) {
            String id = row.id().get();
            Object doc = this.endpoint.isFullDocument() ? CouchbaseCollectionOperation.getDocument(this.collection, id, this.endpoint.getQueryTimeout()) : row.valueAs(Object.class);
            String key = row.keyAs(JsonNode.class).get().asText();
            String designDocumentName = this.endpoint.getDesignDocumentName();
            String viewName = this.endpoint.getViewName();
            Exchange exchange = this.createExchange(false);
            try {
                exchange.getIn().setBody(doc);
                exchange.getIn().setHeader("CCB_ID", id);
                exchange.getIn().setHeader("CCB_KEY", key);
                exchange.getIn().setHeader("CCB_DDN", designDocumentName);
                exchange.getIn().setHeader("CCB_VN", viewName);
                if ("delete".equalsIgnoreCase(consumerProcessedStrategy)) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Deleting doc with ID {}", (Object)id);
                    }
                    CouchbaseCollectionOperation.removeDocument(this.collection, id, this.endpoint.getWriteQueryTimeout(), this.endpoint.getProducerRetryPause());
                } else if ("filter".equalsIgnoreCase(consumerProcessedStrategy)) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Filtering out ID {}", (Object)id);
                    }
                } else {
                    LOG.trace("No strategy set for already processed docs, beware of duplicates!");
                }
                this.logDetails(id, doc, key, designDocumentName, viewName, exchange);
                this.getProcessor().process(exchange);
            }
            catch (Exception e) {
                this.getExceptionHandler().handleException("Error processing exchange.", exchange, e);
            }
            finally {
                this.releaseExchange(exchange, false);
            }
        }
        return result.rows().size();
    }

    private void logDetails(String id, Object doc, String key, String designDocumentName, String viewName, Exchange exchange) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Created exchange = {}", (Object)exchange);
            LOG.trace("Added Document in body = {}", doc);
            LOG.trace("Adding to Header");
            LOG.trace("ID = {}", (Object)id);
            LOG.trace("Key = {}", (Object)key);
            LOG.trace("Design Document Name = {}", (Object)designDocumentName);
            LOG.trace("View Name = {}", (Object)viewName);
        }
    }

    @Override
    public ResumeStrategy getResumeStrategy() {
        return this.resumeStrategy;
    }

    @Override
    public void setResumeStrategy(ResumeStrategy resumeStrategy) {
        this.resumeStrategy = resumeStrategy;
    }
}

