/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.converter.crypto;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.converter.crypto.PGPDataFormatUtil;
import org.apache.camel.converter.crypto.PGPPublicKeyAccessor;
import org.apache.camel.util.ObjectHelper;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.bc.BcKeyFingerprintCalculator;

public class DefaultPGPPublicKeyAccessor
implements PGPPublicKeyAccessor {
    private final PGPPublicKeyRingCollection pgpPublicKeyRing;

    public DefaultPGPPublicKeyAccessor(byte[] publicKeyRing) throws IOException, PGPException {
        ObjectHelper.notNull((Object)publicKeyRing, (String)"publicKeyRing");
        this.pgpPublicKeyRing = new PGPPublicKeyRingCollection(PGPUtil.getDecoderStream(new ByteArrayInputStream(publicKeyRing)), (KeyFingerPrintCalculator)new BcKeyFingerprintCalculator());
    }

    @Override
    public List<PGPPublicKey> getEncryptionKeys(Exchange exchange, List<String> useridParts) throws Exception {
        return PGPDataFormatUtil.findPublicKeys(useridParts, true, this.pgpPublicKeyRing);
    }

    @Override
    public PGPPublicKey getPublicKey(Exchange exchange, long keyId, List<String> userIdParts) throws Exception {
        return PGPDataFormatUtil.getPublicKeyWithKeyIdAndUserID(keyId, userIdParts, this.pgpPublicKeyRing);
    }
}

