/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel;

import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointProducerResolver;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.Service;
import org.apache.camel.util.ObjectHelper;

public interface FluentProducerTemplate
extends Service {
    public CamelContext getCamelContext();

    public int getMaximumCacheSize();

    public void setMaximumCacheSize(int var1);

    public int getCurrentCacheSize();

    public Endpoint getDefaultEndpoint();

    public void setDefaultEndpoint(Endpoint var1);

    public void setDefaultEndpointUri(String var1);

    public void setEventNotifierEnabled(boolean var1);

    public boolean isEventNotifierEnabled();

    public void cleanUp();

    @Deprecated
    public FluentProducerTemplate clearAll();

    public FluentProducerTemplate withHeaders(Map<String, Object> var1);

    public FluentProducerTemplate withHeader(String var1, Object var2);

    @Deprecated
    public FluentProducerTemplate clearHeaders();

    public FluentProducerTemplate withBody(Object var1);

    public FluentProducerTemplate withBodyAs(Object var1, Class<?> var2);

    @Deprecated
    public FluentProducerTemplate clearBody();

    public FluentProducerTemplate withTemplateCustomizer(Consumer<ProducerTemplate> var1);

    public FluentProducerTemplate withExchange(Exchange var1);

    public FluentProducerTemplate withExchange(Supplier<Exchange> var1);

    public FluentProducerTemplate withProcessor(Processor var1);

    public FluentProducerTemplate withProcessor(Supplier<Processor> var1);

    public FluentProducerTemplate withDefaultEndpoint(String var1);

    public FluentProducerTemplate withDefaultEndpoint(EndpointProducerResolver var1);

    public FluentProducerTemplate withDefaultEndpoint(Endpoint var1);

    default public FluentProducerTemplate to(String endpointUri) {
        CamelContext context = ObjectHelper.notNull(this.getCamelContext(), "camel context");
        return this.to(context.getEndpoint(endpointUri));
    }

    default public FluentProducerTemplate toF(String uri, Object ... args) {
        return this.to(String.format(uri, args));
    }

    default public FluentProducerTemplate to(EndpointProducerResolver resolver2) {
        CamelContext context = ObjectHelper.notNull(this.getCamelContext(), "camel context");
        Endpoint endpoint = resolver2.resolve(context);
        return this.to(endpoint);
    }

    public FluentProducerTemplate to(Endpoint var1);

    public Object request() throws CamelExecutionException;

    public <T> T request(Class<T> var1) throws CamelExecutionException;

    public Future<Object> asyncRequest();

    public <T> Future<T> asyncRequest(Class<T> var1);

    public Exchange send() throws CamelExecutionException;

    public Future<Exchange> asyncSend();
}

