/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.attachment;

import java.io.File;
import javax.activation.FileDataSource;
import javax.activation.FileTypeMap;

public class CamelFileDataSource
extends FileDataSource {
    private final String fileName;
    private FileTypeMap typeMap;

    public CamelFileDataSource(File file, String fileName) {
        super(file);
        this.fileName = fileName;
    }

    @Override
    public String getContentType() {
        if (this.typeMap == null) {
            return FileTypeMap.getDefaultFileTypeMap().getContentType(this.fileName);
        }
        return this.typeMap.getContentType(this.fileName);
    }

    @Override
    public void setFileTypeMap(FileTypeMap map) {
        this.typeMap = map;
    }

    @Override
    public String getName() {
        if (this.fileName != null) {
            return this.fileName;
        }
        return super.getName();
    }
}

