/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class CxfEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":beanId:address";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    @Override
    public boolean isEnabled(String scheme) {
        return "cxf".equals(scheme);
    }

    @Override
    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "beanId", null, false, copy);
        uri = this.buildPathParameter(syntax, uri, "address", null, false, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    @Override
    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    @Override
    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    @Override
    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(37);
        props.add("bus");
        props.add("cxfBinding");
        props.add("synchronous");
        props.add("mtomEnabled");
        props.add("hostnameVerifier");
        props.add("sslContextParameters");
        props.add("portName");
        props.add("defaultBus");
        props.add("mergeProtocolHeaders");
        props.add("defaultOperationName");
        props.add("password");
        props.add("bridgeErrorHandler");
        props.add("headerFilterStrategy");
        props.add("loggingSizeLimit");
        props.add("wrappedStyle");
        props.add("bindingId");
        props.add("beanId");
        props.add("wrapped");
        props.add("wsdlURL");
        props.add("defaultOperationNamespace");
        props.add("address");
        props.add("skipFaultLogging");
        props.add("serviceClass");
        props.add("dataFormat");
        props.add("continuationTimeout");
        props.add("exchangePattern");
        props.add("allowStreaming");
        props.add("serviceName");
        props.add("loggingFeatureEnabled");
        props.add("lazyStartProducer");
        props.add("publishedEndpointUrl");
        props.add("skipPayloadMessagePartCheck");
        props.add("cookieHandler");
        props.add("cxfConfigurer");
        props.add("exceptionHandler");
        props.add("properties");
        props.add("username");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(2);
        secretProps.add("password");
        secretProps.add("username");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
    }
}

