/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf;

import javax.xml.namespace.QName;
import javax.xml.ws.Provider;
import org.apache.camel.component.cxf.CxfComponent;
import org.apache.camel.component.cxf.CxfEndpoint;
import org.apache.camel.component.cxf.CxfEndpointUtils;
import org.apache.camel.component.cxf.DataFormat;
import org.apache.camel.component.cxf.DefaultPayloadProviderSEI;
import org.apache.camel.component.cxf.DefaultSEI;
import org.apache.camel.component.cxf.WSDLServiceFactoryBean;
import org.apache.camel.util.ObjectHelper;
import org.apache.cxf.bus.spring.BusWiringBeanFactoryPostProcessor;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientFactoryBean;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.jaxws.JaxWsServerFactoryBean;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class CxfSpringEndpoint
extends CxfEndpoint
implements ApplicationContextAware {
    private String beanId;
    private ApplicationContext applicationContext;

    public CxfSpringEndpoint(CxfComponent component, String address) {
        super(address, component);
    }

    public CxfSpringEndpoint() {
    }

    @Override
    Client createClient() throws Exception {
        Class<?> cls = this.getServiceClass();
        if (this.getDataFormat().equals((Object)DataFormat.POJO)) {
            ObjectHelper.notNull(cls, "serviceClass");
        }
        if (this.getWsdlURL() == null && cls == null) {
            this.setServiceClass(DefaultSEI.class.getName());
            this.setDefaultOperationNamespace("http://camel.apache.org/cxf/jaxws/dispatch");
            this.setDefaultOperationName("Invoke");
            if (this.getDataFormat().equals((Object)DataFormat.PAYLOAD)) {
                this.setSkipPayloadMessagePartCheck(true);
            }
            cls = this.getServiceClass();
        }
        ClientFactoryBean factoryBean = cls != null ? this.createClientFactoryBean(cls) : this.createClientFactoryBean();
        this.setupClientFactoryBean(factoryBean, cls);
        QName serviceQName = null;
        try {
            serviceQName = factoryBean.getServiceName();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (serviceQName == null && this.getServiceLocalName() != null) {
            factoryBean.setServiceName(new QName(this.getServiceNamespace(), this.getServiceLocalName()));
        }
        if (factoryBean.getEndpointName() == null && this.getEndpointLocalName() != null) {
            factoryBean.setEndpointName(new QName(this.getEndpointNamespace(), this.getEndpointLocalName()));
        }
        if (cls == null) {
            this.checkName(factoryBean.getEndpointName(), "endpoint/port name");
            this.checkName(factoryBean.getServiceName(), "service name");
        }
        Client client = factoryBean.create();
        this.setupHandlers(factoryBean, client);
        return client;
    }

    @Override
    ServerFactoryBean createServerFactoryBean() throws Exception {
        Class<Object> cls = this.getServiceClass();
        if (this.getWsdlURL() == null && cls == null) {
            if (this.getDataFormat().equals((Object)DataFormat.PAYLOAD)) {
                this.setServiceClass(DefaultPayloadProviderSEI.class.getName());
            }
            cls = this.getServiceClass();
        }
        ServerFactoryBean answer = null;
        if (cls == null) {
            if (!this.getDataFormat().equals((Object)DataFormat.POJO)) {
                answer = new JaxWsServerFactoryBean(new WSDLServiceFactoryBean());
                cls = Provider.class;
            } else {
                ObjectHelper.notNull(cls, "serviceClass");
            }
        } else {
            answer = CxfEndpointUtils.hasWebServiceAnnotation(cls) ? new JaxWsServerFactoryBean() : new ServerFactoryBean();
        }
        this.setupServerFactoryBean(answer, cls);
        if (answer.getServiceName() == null && this.getServiceLocalName() != null) {
            answer.setServiceName(new QName(this.getServiceNamespace(), this.getServiceLocalName()));
        }
        if (answer.getEndpointName() == null && this.getEndpointLocalName() != null) {
            answer.setEndpointName(new QName(this.getEndpointNamespace(), this.getEndpointLocalName()));
        }
        this.checkName(answer.getEndpointName(), "endpoint/port name");
        this.checkName(answer.getServiceName(), "service name");
        return answer;
    }

    @Override
    public String getBeanId() {
        return this.beanId;
    }

    @Override
    public void setBeanId(String id) {
        this.beanId = id;
    }

    public void setServiceNamespace(String serviceNamespace) {
        QName qn = this.getServiceNameAsQName();
        if (qn == null) {
            this.setServiceNameAsQName(new QName(serviceNamespace, "local"));
        } else {
            this.setServiceNameAsQName(new QName(serviceNamespace, qn.getLocalPart()));
        }
    }

    public String getServiceNamespace() {
        QName qn = this.getServiceNameAsQName();
        if (qn == null) {
            return null;
        }
        return qn.getNamespaceURI();
    }

    public void setServiceLocalName(String serviceLocalName) {
        QName qn = this.getServiceNameAsQName();
        if (qn == null) {
            this.setServiceNameAsQName(new QName("", serviceLocalName));
        } else {
            this.setServiceNameAsQName(new QName(qn.getNamespaceURI(), serviceLocalName));
        }
    }

    public String getServiceLocalName() {
        QName qn = this.getServiceNameAsQName();
        if (qn == null) {
            return null;
        }
        return qn.getLocalPart();
    }

    public String getEndpointLocalName() {
        QName qn = this.getPortNameAsQName();
        if (qn == null) {
            return null;
        }
        return qn.getLocalPart();
    }

    public void setEndpointLocalName(String endpointLocalName) {
        QName qn = this.getPortNameAsQName();
        if (qn == null) {
            this.setPortNameAsQName(new QName("", endpointLocalName));
        } else {
            this.setPortNameAsQName(new QName(qn.getNamespaceURI(), endpointLocalName));
        }
    }

    public void setEndpointNamespace(String endpointNamespace) {
        QName qn = this.getPortNameAsQName();
        if (qn == null) {
            this.setPortNameAsQName(new QName(endpointNamespace, "local"));
        } else {
            this.setPortNameAsQName(new QName(endpointNamespace, qn.getLocalPart()));
        }
    }

    public String getEndpointNamespace() {
        QName qn = this.getPortNameAsQName();
        if (qn == null) {
            return null;
        }
        return qn.getNamespaceURI();
    }

    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        this.applicationContext = ctx;
        if (this.bus == null) {
            this.createBus = true;
            this.bus = BusWiringBeanFactoryPostProcessor.addDefaultBus(ctx);
        }
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }
}

