/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.common.header;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.camel.component.cxf.common.header.MessageHeaderFilter;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.cxf.binding.soap.SoapHeader;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.SoapVersionFactory;
import org.apache.cxf.headers.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoapMessageHeaderFilter
implements MessageHeaderFilter {
    private static final Logger LOG = LoggerFactory.getLogger(SoapMessageHeaderFilter.class);
    private static final List<String> ACTIVATION_NS = Arrays.asList("http://schemas.xmlsoap.org/soap/", "http://schemas.xmlsoap.org/wsdl/soap/", "http://schemas.xmlsoap.org/wsdl/soap12/");

    @Override
    public List<String> getActivationNamespaces() {
        return ACTIVATION_NS;
    }

    @Override
    public void filter(HeaderFilterStrategy.Direction direction, List<Header> headers) {
        if (headers == null) {
            return;
        }
        Iterator<Header> iterator = headers.iterator();
        block0: while (iterator.hasNext()) {
            Header header = iterator.next();
            LOG.trace("Processing header: {}", (Object)header);
            if (!(header instanceof SoapHeader)) {
                LOG.trace("Skipped header: {} since it is not a SoapHeader", (Object)header);
                continue;
            }
            SoapHeader soapHeader = (SoapHeader)SoapHeader.class.cast(header);
            Iterator<SoapVersion> itv = SoapVersionFactory.getInstance().getVersions();
            while (itv.hasNext()) {
                SoapVersion version = itv.next();
                if (soapHeader.getActor() == null || !soapHeader.getActor().equals(version.getNextRole())) continue;
                LOG.trace("Filtered header: {}", (Object)header);
                iterator.remove();
                continue block0;
            }
        }
    }
}

