/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.common.message;

import java.security.Principal;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.cxf.common.message.CxfMessageHelper;
import org.apache.camel.component.cxf.common.message.CxfMessageMapper;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.security.SecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCxfMessageMapper
implements CxfMessageMapper {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCxfMessageMapper.class);
    private static final String CXF_HTTP_REQUEST = "HTTP.REQUEST";
    private static final String CXF_HTTP_RESPONSE = "HTTP.RESPONSE";

    @Override
    public org.apache.cxf.message.Message createCxfMessageFromCamelExchange(Exchange camelExchange, HeaderFilterStrategy headerFilterStrategy) {
        org.apache.cxf.message.Message answer = CxfMessageHelper.getCxfInMessage(headerFilterStrategy, camelExchange, false);
        Message camelMessage = camelExchange.getIn();
        String requestContentType = this.getRequestContentType(camelMessage);
        String acceptContentTypes = camelMessage.getHeader("Accept", String.class);
        if (acceptContentTypes == null) {
            acceptContentTypes = "*/*";
        }
        String enc = this.getCharacterEncoding(camelMessage);
        String requestURI = this.getRequestURI(camelMessage);
        String path = this.getPath(camelMessage);
        String basePath = this.getBasePath(camelExchange);
        String verb = this.getVerb(camelMessage);
        String queryString = this.getQueryString(camelMessage);
        answer.put("org.apache.cxf.request.uri", requestURI);
        answer.put(org.apache.cxf.message.Message.BASE_PATH, basePath);
        answer.put("org.apache.cxf.request.method", verb);
        answer.put(org.apache.cxf.message.Message.PATH_INFO, path);
        answer.put("Content-Type", requestContentType);
        answer.put("Accept", acceptContentTypes);
        answer.put(org.apache.cxf.message.Message.ENCODING, enc);
        answer.put(org.apache.cxf.message.Message.QUERY_STRING, queryString);
        HttpServletRequest request = (HttpServletRequest)camelMessage.getHeader("CamelHttpServletRequest");
        answer.put(CXF_HTTP_REQUEST, request);
        if (request != null) {
            this.setSecurityContext(answer, request);
        }
        Object response = camelMessage.getHeader("CamelHttpServletResponse");
        answer.put(CXF_HTTP_RESPONSE, response);
        LOG.trace("Processing {}, requestContentType = {}, acceptContentTypes = {}, encoding = {}, path = {}, basePath = {}, verb = {}", new Object[]{camelExchange, requestContentType, acceptContentTypes, enc, path, basePath, verb});
        return answer;
    }

    protected void setSecurityContext(org.apache.cxf.message.Message cxfMessage, final HttpServletRequest request) {
        cxfMessage.put(SecurityContext.class, new SecurityContext(){

            @Override
            public Principal getUserPrincipal() {
                return request.getUserPrincipal();
            }

            @Override
            public boolean isUserInRole(String role) {
                return request.isUserInRole(role);
            }
        });
    }

    @Override
    public void propagateResponseHeadersToCamel(org.apache.cxf.message.Message cxfMessage, Exchange exchange, HeaderFilterStrategy strategy) {
        String key;
        Object value;
        LOG.trace("Propagating response headers from CXF message {}", (Object)cxfMessage);
        if (strategy == null) {
            return;
        }
        Map<String, Object> camelHeaders = exchange.getOut().getHeaders();
        camelHeaders.putAll(exchange.getIn().getHeaders());
        Map cxfHeaders = CastUtils.cast((Map)cxfMessage.get(org.apache.cxf.message.Message.PROTOCOL_HEADERS));
        if (cxfHeaders != null) {
            for (Map.Entry entry : cxfHeaders.entrySet()) {
                if (strategy.applyFilterToExternalHeaders((String)entry.getKey(), entry.getValue(), exchange)) continue;
                camelHeaders.put((String)entry.getKey(), ((List)entry.getValue()).get(0));
                LOG.trace("Populate header from CXF header={} value={}", entry.getKey(), entry.getValue());
            }
        }
        if ((value = cxfMessage.get(key = org.apache.cxf.message.Message.RESPONSE_CODE)) != null && !strategy.applyFilterToExternalHeaders(key, value, exchange)) {
            camelHeaders.put("CamelHttpResponseCode", value);
            LOG.trace("Populate header from CXF header={} value={} as {}", new Object[]{key, value, "CamelHttpResponseCode"});
        }
        if (cxfMessage.get("Content-Type") != null) {
            camelHeaders.put("Content-Type", cxfMessage.get("Content-Type"));
        }
    }

    protected String getPath(Message camelMessage) {
        String answer = camelMessage.getHeader("CamelHttpPath", String.class);
        return answer;
    }

    protected String getRequestURI(Message camelMessage) {
        String answer = camelMessage.getHeader("CamelHttpUri", String.class);
        return answer;
    }

    protected String getBasePath(Exchange camelExchange) {
        String answer = camelExchange.getIn().getHeader("CamelHttpBaseUri", String.class);
        if (answer == null) {
            answer = camelExchange.getFromEndpoint().getEndpointUri();
            answer = answer.replaceFirst("^\\w+:http", "http");
            answer = answer.replaceFirst("^\\w+:https", "https");
        }
        return answer;
    }

    protected String getVerb(Message camelMessage) {
        String answer = camelMessage.getHeader("CamelHttpMethod", String.class);
        return answer;
    }

    protected String getQueryString(Message camelMessage) {
        String answer = camelMessage.getHeader("CamelHttpQuery", String.class);
        return answer;
    }

    protected String getCharacterEncoding(Message camelMessage) {
        String answer = camelMessage.getHeader("CamelHttpCharacterEncoding", String.class);
        if (answer == null) {
            answer = camelMessage.getHeader("CamelCharsetName", String.class);
        }
        return answer;
    }

    protected String getRequestContentType(Message camelMessage) {
        String answer = camelMessage.getHeader("Content-Type", String.class);
        if (answer != null) {
            return answer;
        }
        return "*/*";
    }
}

