/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.interceptors;

import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Writer;
import java.util.List;
import org.apache.camel.StreamCache;
import org.apache.camel.util.IOHelper;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

public class RawMessageContentRedirectInterceptor
extends AbstractPhaseInterceptor<Message> {
    public RawMessageContentRedirectInterceptor() {
        super("write");
    }

    @Override
    public void handleMessage(Message message) throws Fault {
        Throwable ex = message.getContent(Throwable.class);
        if (ex != null) {
            if (ex instanceof Fault) {
                throw (Fault)ex;
            }
            throw new Fault(ex);
        }
        List params = message.getContent(List.class);
        if (null != params) {
            InputStream is = (InputStream)params.get(0);
            OutputStream os = message.getContent(OutputStream.class);
            Writer writer = message.getContent(Writer.class);
            if (os == null && writer == null) {
                return;
            }
            try {
                if (os == null && writer != null) {
                    IOUtils.copyAndCloseInput(new InputStreamReader(is), writer);
                } else if (is instanceof StreamCache) {
                    ((StreamCache)((Object)is)).writeTo(os);
                } else {
                    IOUtils.copy(is, os);
                }
            }
            catch (Exception e) {
                throw new Fault(e);
            }
            finally {
                IOHelper.close((Closeable)is, "input stream", null);
            }
        }
    }
}

