/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.jaxrs;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.SSLContextParametersAware;
import org.apache.camel.component.cxf.jaxrs.CxfRsEndpoint;
import org.apache.camel.component.cxf.jaxrs.CxfRsEndpointFactoryBean;
import org.apache.camel.component.cxf.jaxrs.DefaultCxfRsEndpointFactoryBean;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.HeaderFilterStrategyComponent;
import org.apache.camel.support.ObjectHelper;
import org.apache.camel.util.CastUtils;
import org.apache.cxf.jaxrs.AbstractJAXRSFactoryBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(value="cxfrs")
public class CxfRsComponent
extends HeaderFilterStrategyComponent
implements SSLContextParametersAware {
    private static final Logger LOG = LoggerFactory.getLogger(CxfRsComponent.class);
    @Metadata(label="security", defaultValue="false")
    private boolean useGlobalSslContextParameters;

    public CxfRsComponent() {
    }

    public CxfRsComponent(CamelContext context) {
        super(context);
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        CxfRsEndpoint answer;
        Object value = parameters.remove("setDefaultBus");
        if (value != null) {
            LOG.warn("The option setDefaultBus is @deprecated, use name defaultBus instead");
            if (!parameters.containsKey("defaultBus")) {
                parameters.put("defaultBus", value);
            }
        }
        if (remaining.startsWith("bean:")) {
            String beanId = remaining.substring("bean:".length());
            if (beanId.startsWith("//")) {
                beanId = beanId.substring(2);
            }
            AbstractJAXRSFactoryBean bean = CamelContextHelper.mandatoryLookup(this.getCamelContext(), beanId, AbstractJAXRSFactoryBean.class);
            CxfRsEndpointFactoryBean factory = null;
            if (bean.getClass().getName().contains("blueprint")) {
                Class<CxfRsEndpointFactoryBean> clazz = this.getCamelContext().getClassResolver().resolveMandatoryClass("org.apache.camel.component.cxf.jaxrs.blueprint.CxfRsBlueprintEndpointFactoryBean", CxfRsEndpointFactoryBean.class);
                factory = this.getCamelContext().getInjector().newInstance(clazz);
            } else {
                factory = new DefaultCxfRsEndpointFactoryBean();
            }
            answer = factory.createEndpoint(this, remaining, bean);
            if (bean.getProperties() != null) {
                HashMap<String, Object> copy = new HashMap<String, Object>();
                copy.putAll(bean.getProperties());
                this.setProperties(answer, copy);
            }
            answer.setBeanId(beanId);
        } else {
            answer = new CxfRsEndpoint(remaining, this);
        }
        String resourceClass = this.getAndRemoveParameter(parameters, "resourceClass", String.class);
        if (resourceClass != null) {
            Class<?> clazz = this.getCamelContext().getClassResolver().resolveMandatoryClass(resourceClass);
            answer.addResourceClass(clazz);
        }
        String resourceClasses = this.getAndRemoveParameter(parameters, "resourceClasses", String.class);
        Iterator<?> it = ObjectHelper.createIterator(resourceClasses);
        while (it.hasNext()) {
            String name = (String)it.next();
            Class<?> clazz = this.getCamelContext().getClassResolver().resolveMandatoryClass(name);
            answer.addResourceClass(clazz);
        }
        this.setProperties(answer, parameters);
        Map<String, String> params = CastUtils.cast(parameters);
        answer.setParameters(params);
        this.setEndpointHeaderFilterStrategy(answer);
        if (answer.getSslContextParameters() == null) {
            answer.setSslContextParameters(this.retrieveGlobalSslContextParameters());
        }
        return answer;
    }

    @Override
    protected void afterConfiguration(String uri, String remaining, Endpoint endpoint, Map<String, Object> parameters) throws Exception {
        CxfRsEndpoint cxfRsEndpoint = (CxfRsEndpoint)endpoint;
        cxfRsEndpoint.updateEndpointUri(uri);
    }

    @Override
    public boolean isUseGlobalSslContextParameters() {
        return this.useGlobalSslContextParameters;
    }

    @Override
    public void setUseGlobalSslContextParameters(boolean useGlobalSslContextParameters) {
        this.useGlobalSslContextParameters = useGlobalSslContextParameters;
    }
}

