/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.spring;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.component.cxf.NullFaultListener;
import org.apache.camel.component.cxf.jaxrs.BeanIdAware;
import org.apache.cxf.bus.spring.BusWiringBeanFactoryPostProcessor;
import org.apache.cxf.feature.LoggingFeature;
import org.apache.cxf.jaxrs.client.JAXRSClientFactoryBean;
import org.apache.cxf.logging.FaultListener;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringJAXRSClientFactoryBean
extends JAXRSClientFactoryBean
implements ApplicationContextAware,
BeanIdAware {
    private String beanId;
    private int loggingSizeLimit;
    private LoggingFeature loggingFeature;

    public boolean isLoggingFeatureEnabled() {
        return this.loggingFeature != null;
    }

    public void setLoggingFeatureEnabled(boolean loggingFeatureEnabled) {
        if (this.loggingFeature != null) {
            this.getFeatures().remove(this.loggingFeature);
            this.loggingFeature = null;
        }
        if (loggingFeatureEnabled) {
            this.loggingFeature = this.getLoggingSizeLimit() > 0 ? new LoggingFeature(this.getLoggingSizeLimit()) : new LoggingFeature();
            this.getFeatures().add(this.loggingFeature);
        }
    }

    public int getLoggingSizeLimit() {
        return this.loggingSizeLimit;
    }

    public void setLoggingSizeLimit(int loggingSizeLimit) {
        this.loggingSizeLimit = loggingSizeLimit;
        if (this.loggingFeature != null) {
            this.getFeatures().remove(this.loggingFeature);
            this.loggingFeature = loggingSizeLimit > 0 ? new LoggingFeature(loggingSizeLimit) : new LoggingFeature();
            this.getFeatures().add(this.loggingFeature);
        }
    }

    public void setApplicationContext(ApplicationContext ctx) throws BeansException {
        if (this.bus == null) {
            this.setBus(BusWiringBeanFactoryPostProcessor.addDefaultBus(ctx));
        }
    }

    @Override
    public String getBeanId() {
        return this.beanId;
    }

    @Override
    public void setBeanId(String id) {
        this.beanId = id;
    }

    List<String> getSchemaLocations() {
        return this.schemaLocations;
    }

    public void setSkipFaultLogging(boolean skipFaultLogging) {
        if (skipFaultLogging) {
            if (this.getProperties() == null) {
                this.setProperties(new HashMap<String, Object>());
            }
            this.getProperties().put(FaultListener.class.getName(), new NullFaultListener());
        }
    }

    @Override
    public void setProperties(Map<String, Object> properties) {
        if (this.getProperties() != null && properties != null) {
            this.getProperties().putAll(properties);
        } else {
            super.setProperties(properties);
        }
    }
}

