/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.CatalogCamelContext;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Endpoint;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.ExchangeConstantProvider;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.FailedToStartComponentException;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.GlobalEndpointConfiguration;
import org.apache.camel.IsSingleton;
import org.apache.camel.LoggingLevel;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.Route;
import org.apache.camel.RouteAware;
import org.apache.camel.RouteConfigurationsBuilder;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.Service;
import org.apache.camel.ServiceStatus;
import org.apache.camel.ShutdownRoute;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.StartupListener;
import org.apache.camel.StartupStep;
import org.apache.camel.StartupSummaryLevel;
import org.apache.camel.Suspendable;
import org.apache.camel.SuspendableService;
import org.apache.camel.TypeConverter;
import org.apache.camel.VetoCamelContextStartException;
import org.apache.camel.catalog.RuntimeCamelCatalog;
import org.apache.camel.health.HealthCheckRegistry;
import org.apache.camel.health.HealthCheckResolver;
import org.apache.camel.impl.engine.BootstrapConfigurerResolver;
import org.apache.camel.impl.engine.CustomizersLifecycleStrategy;
import org.apache.camel.impl.engine.DefaultAutowiredLifecycleStrategy;
import org.apache.camel.impl.engine.DefaultCamelContextNameStrategy;
import org.apache.camel.impl.engine.DefaultConsumerTemplate;
import org.apache.camel.impl.engine.DefaultFluentProducerTemplate;
import org.apache.camel.impl.engine.DefaultGlobalEndpointConfiguration;
import org.apache.camel.impl.engine.DefaultManagementNameStrategy;
import org.apache.camel.impl.engine.DefaultManagementStrategyFactory;
import org.apache.camel.impl.engine.DefaultProducerTemplate;
import org.apache.camel.impl.engine.DefaultRouteError;
import org.apache.camel.impl.engine.DefaultRouteStartupOrder;
import org.apache.camel.impl.engine.DefaultRuntimeEndpointRegistry;
import org.apache.camel.impl.engine.DefaultServiceBootstrapCloseable;
import org.apache.camel.impl.engine.DeferServiceStartupListener;
import org.apache.camel.impl.engine.ExplicitCamelContextNameStrategy;
import org.apache.camel.impl.engine.HashMapHeadersMapFactory;
import org.apache.camel.impl.engine.InternalRouteController;
import org.apache.camel.impl.engine.InternalRouteStartupManager;
import org.apache.camel.impl.engine.OnCamelContextLifecycleStrategy;
import org.apache.camel.impl.engine.ProvisionalEndpointRegistry;
import org.apache.camel.impl.engine.RouteService;
import org.apache.camel.impl.engine.TransformerKey;
import org.apache.camel.impl.engine.ValidatorKey;
import org.apache.camel.spi.AnnotationBasedProcessorFactory;
import org.apache.camel.spi.AnnotationScanTypeConverters;
import org.apache.camel.spi.AsyncProcessorAwaitManager;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.spi.BeanProcessorFactory;
import org.apache.camel.spi.BeanProxyFactory;
import org.apache.camel.spi.BootstrapCloseable;
import org.apache.camel.spi.CamelBeanPostProcessor;
import org.apache.camel.spi.CamelContextNameStrategy;
import org.apache.camel.spi.CamelContextTracker;
import org.apache.camel.spi.CamelLogger;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.ComponentNameResolver;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.spi.ConfigurerResolver;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatResolver;
import org.apache.camel.spi.DataType;
import org.apache.camel.spi.Debugger;
import org.apache.camel.spi.DeferServiceFactory;
import org.apache.camel.spi.EndpointRegistry;
import org.apache.camel.spi.EndpointStrategy;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.ExchangeFactory;
import org.apache.camel.spi.ExchangeFactoryManager;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.spi.FactoryFinder;
import org.apache.camel.spi.FactoryFinderResolver;
import org.apache.camel.spi.HeadersMapFactory;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.Injector;
import org.apache.camel.spi.InterceptEndpointFactory;
import org.apache.camel.spi.InterceptSendToEndpoint;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.InternalProcessorFactory;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.LanguageResolver;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.LogListener;
import org.apache.camel.spi.ManagementMBeanAssembler;
import org.apache.camel.spi.ManagementNameStrategy;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.ManagementStrategyFactory;
import org.apache.camel.spi.MessageHistoryFactory;
import org.apache.camel.spi.ModelJAXBContextFactory;
import org.apache.camel.spi.ModelToXMLDumper;
import org.apache.camel.spi.NodeIdFactory;
import org.apache.camel.spi.NormalizedEndpointUri;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.PackageScanResourceResolver;
import org.apache.camel.spi.ProcessorExchangeFactory;
import org.apache.camel.spi.ProcessorFactory;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.ReactiveExecutor;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.ReifierStrategy;
import org.apache.camel.spi.ResourceLoader;
import org.apache.camel.spi.RestBindingJaxbDataFormatFactory;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.spi.RestRegistry;
import org.apache.camel.spi.RestRegistryFactory;
import org.apache.camel.spi.RouteController;
import org.apache.camel.spi.RouteError;
import org.apache.camel.spi.RouteFactory;
import org.apache.camel.spi.RoutePolicyFactory;
import org.apache.camel.spi.RouteStartupOrder;
import org.apache.camel.spi.RouteTemplateParameterSource;
import org.apache.camel.spi.RoutesLoader;
import org.apache.camel.spi.RuntimeEndpointRegistry;
import org.apache.camel.spi.ShutdownStrategy;
import org.apache.camel.spi.StartupStepRecorder;
import org.apache.camel.spi.StreamCachingStrategy;
import org.apache.camel.spi.Tracer;
import org.apache.camel.spi.Transformer;
import org.apache.camel.spi.TransformerRegistry;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.spi.UnitOfWorkFactory;
import org.apache.camel.spi.UriFactoryResolver;
import org.apache.camel.spi.UuidGenerator;
import org.apache.camel.spi.Validator;
import org.apache.camel.spi.ValidatorRegistry;
import org.apache.camel.spi.XMLRoutesDefinitionLoader;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.EndpointHelper;
import org.apache.camel.support.EventHelper;
import org.apache.camel.support.LRUCacheFactory;
import org.apache.camel.support.NormalizedUri;
import org.apache.camel.support.OrderedComparator;
import org.apache.camel.support.ProcessorEndpoint;
import org.apache.camel.support.ResolverHelper;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.support.service.BaseService;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.startup.DefaultStartupStepRecorder;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.TimeUtils;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public abstract class AbstractCamelContext
extends BaseService
implements ExtendedCamelContext,
CatalogCamelContext,
Suspendable {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractCamelContext.class);
    int defaultRouteStartupOrder = 1000;
    private final AtomicInteger endpointKeyCounter = new AtomicInteger();
    private final List<EndpointStrategy> endpointStrategies = new ArrayList<EndpointStrategy>();
    private final GlobalEndpointConfiguration globalEndpointConfiguration = new DefaultGlobalEndpointConfiguration();
    private final Map<String, Component> components = new ConcurrentHashMap<String, Component>();
    private final Set<Route> routes = new LinkedHashSet<Route>();
    private final List<Service> servicesToStop = new CopyOnWriteArrayList<Service>();
    private final List<BootstrapCloseable> bootstraps = new CopyOnWriteArrayList<BootstrapCloseable>();
    private final List<StartupListener> startupListeners = new CopyOnWriteArrayList<StartupListener>();
    private final DeferServiceStartupListener deferStartupListener = new DeferServiceStartupListener();
    private final Map<String, Language> languages = new ConcurrentHashMap<String, Language>();
    private final Map<String, DataFormat> dataformats = new ConcurrentHashMap<String, DataFormat>();
    private final List<LifecycleStrategy> lifecycleStrategies = new CopyOnWriteArrayList<LifecycleStrategy>();
    private final ThreadLocal<Boolean> isStartingRoutes = new ThreadLocal();
    private final ThreadLocal<Boolean> isSetupRoutes = new ThreadLocal();
    private final Map<String, FactoryFinder> factories = new ConcurrentHashMap<String, FactoryFinder>();
    private final Map<String, FactoryFinder> bootstrapFactories = new ConcurrentHashMap<String, FactoryFinder>();
    private volatile FactoryFinder bootstrapFactoryFinder;
    private volatile ConfigurerResolver bootstrapConfigurerResolver;
    private final Map<String, RouteService> routeServices = new LinkedHashMap<String, RouteService>();
    private final Map<String, RouteService> suspendedRouteServices = new LinkedHashMap<String, RouteService>();
    private final Object lock = new Object();
    private final RouteController internalRouteController = new InternalRouteController(this);
    private final InternalRouteStartupManager internalRouteStartupManager = new InternalRouteStartupManager(this);
    private volatile DeferServiceFactory deferServiceFactory;
    private volatile AnnotationBasedProcessorFactory annotationBasedProcessorFactory;
    private final List<RouteStartupOrder> routeStartupOrder = new ArrayList<RouteStartupOrder>();
    private final StopWatch stopWatch = new StopWatch(false);
    private final Map<Class<?>, Object> extensions = new ConcurrentHashMap();
    private Set<LogListener> logListeners;
    private final ThreadLocal<Set<String>> componentsInCreation = new ThreadLocal<Set<String>>(){

        @Override
        public Set<String> initialValue() {
            return new HashSet<String>();
        }
    };
    private VetoCamelContextStartException vetoed;
    private String managementName;
    private ClassLoader applicationContextClassLoader;
    private boolean autoCreateComponents = true;
    private volatile RestConfiguration restConfiguration;
    private List<InterceptStrategy> interceptStrategies = new ArrayList<InterceptStrategy>();
    private List<RoutePolicyFactory> routePolicyFactories = new ArrayList<RoutePolicyFactory>();
    private volatile boolean firstStartDone;
    private volatile boolean firstStopDone;
    private volatile boolean doNotStartRoutesOnFirstStart;
    private Initialization initialization = Initialization.Default;
    private Boolean autoStartup = Boolean.TRUE;
    private Boolean backlogTrace = Boolean.FALSE;
    private Boolean trace = Boolean.FALSE;
    private Boolean traceStandby = Boolean.FALSE;
    private String tracePattern;
    private Boolean debug = Boolean.FALSE;
    private Boolean messageHistory = Boolean.FALSE;
    private Boolean logMask = Boolean.FALSE;
    private Boolean logExhaustedMessageBody = Boolean.FALSE;
    private Boolean streamCache = Boolean.FALSE;
    private Boolean disableJMX = Boolean.FALSE;
    private Boolean loadTypeConverters = Boolean.FALSE;
    private Boolean loadHealthChecks = Boolean.FALSE;
    private Boolean typeConverterStatisticsEnabled = Boolean.FALSE;
    private Boolean dumpRoutes = Boolean.FALSE;
    private Boolean useMDCLogging = Boolean.FALSE;
    private String mdcLoggingKeysPattern;
    private Boolean useDataType = Boolean.FALSE;
    private Boolean useBreadcrumb = Boolean.FALSE;
    private Boolean allowUseOriginalMessage = Boolean.FALSE;
    private Boolean caseInsensitiveHeaders = Boolean.TRUE;
    private Boolean autowiredEnabled = Boolean.TRUE;
    private boolean lightweight;
    private Long delay;
    private ErrorHandlerFactory errorHandlerFactory;
    private Map<String, String> globalOptions = new HashMap<String, String>();
    private volatile String version;
    private volatile PropertiesComponent propertiesComponent;
    private volatile CamelContextNameStrategy nameStrategy;
    private volatile ExchangeFactoryManager exchangeFactoryManager;
    private volatile ExchangeFactory exchangeFactory;
    private volatile ProcessorExchangeFactory processorExchangeFactory;
    private volatile ReactiveExecutor reactiveExecutor;
    private volatile ManagementNameStrategy managementNameStrategy;
    private volatile Registry registry;
    private volatile TypeConverter typeConverter;
    private volatile TypeConverterRegistry typeConverterRegistry;
    private volatile Injector injector;
    private volatile CamelBeanPostProcessor beanPostProcessor;
    private volatile ComponentResolver componentResolver;
    private volatile ComponentNameResolver componentNameResolver;
    private volatile LanguageResolver languageResolver;
    private volatile ConfigurerResolver configurerResolver;
    private volatile UriFactoryResolver uriFactoryResolver;
    private volatile DataFormatResolver dataFormatResolver;
    private volatile HealthCheckResolver healthCheckResolver;
    private volatile ManagementStrategy managementStrategy;
    private volatile ManagementMBeanAssembler managementMBeanAssembler;
    private volatile RestRegistryFactory restRegistryFactory;
    private volatile RestRegistry restRegistry;
    private volatile HeadersMapFactory headersMapFactory;
    private volatile BeanProxyFactory beanProxyFactory;
    private volatile BeanProcessorFactory beanProcessorFactory;
    private volatile XMLRoutesDefinitionLoader xmlRoutesDefinitionLoader;
    private volatile RoutesLoader routesLoader;
    private volatile ResourceLoader resourceLoader;
    private volatile ModelToXMLDumper modelToXMLDumper;
    private volatile RestBindingJaxbDataFormatFactory restBindingJaxbDataFormatFactory;
    private volatile RuntimeCamelCatalog runtimeCamelCatalog;
    private volatile ClassResolver classResolver;
    private volatile PackageScanClassResolver packageScanClassResolver;
    private volatile PackageScanResourceResolver packageScanResourceResolver;
    private volatile NodeIdFactory nodeIdFactory;
    private volatile ProcessorFactory processorFactory;
    private volatile InternalProcessorFactory internalProcessorFactory;
    private volatile InterceptEndpointFactory interceptEndpointFactory;
    private volatile RouteFactory routeFactory;
    private volatile MessageHistoryFactory messageHistoryFactory;
    private volatile FactoryFinderResolver factoryFinderResolver;
    private volatile StreamCachingStrategy streamCachingStrategy;
    private volatile InflightRepository inflightRepository;
    private volatile AsyncProcessorAwaitManager asyncProcessorAwaitManager;
    private volatile ShutdownStrategy shutdownStrategy;
    private volatile ModelJAXBContextFactory modelJAXBContextFactory;
    private volatile ExecutorServiceManager executorServiceManager;
    private volatile UuidGenerator uuidGenerator;
    private volatile UnitOfWorkFactory unitOfWorkFactory;
    private volatile RouteController routeController;
    private volatile ScheduledExecutorService errorHandlerExecutorService;
    private volatile BeanIntrospection beanIntrospection;
    private volatile Tracer tracer;
    private volatile boolean eventNotificationApplicable;
    private volatile TransformerRegistry<TransformerKey> transformerRegistry;
    private volatile ValidatorRegistry<ValidatorKey> validatorRegistry;
    private volatile StartupStepRecorder startupStepRecorder = new DefaultStartupStepRecorder();
    private EndpointRegistry<NormalizedUri> endpoints;
    private RuntimeEndpointRegistry runtimeEndpointRegistry;
    private ShutdownRoute shutdownRoute = ShutdownRoute.Default;
    private ShutdownRunningTask shutdownRunningTask = ShutdownRunningTask.CompleteCurrentTaskOnly;
    private Debugger debugger;
    private long buildTaken;
    private long initTaken;
    private long startDate;
    private SSLContextParameters sslContextParameters;
    private StartupSummaryLevel startupSummaryLevel = StartupSummaryLevel.Default;

    public AbstractCamelContext() {
        this(true);
    }

    public AbstractCamelContext(Registry registry) {
        this();
        this.setRegistry(registry);
    }

    public AbstractCamelContext(boolean build) {
        this.endpoints = new ProvisionalEndpointRegistry();
        this.startupListeners.add(this.deferStartupListener);
        this.lifecycleStrategies.add(new OnCamelContextLifecycleStrategy());
        this.lifecycleStrategies.add(new CustomizersLifecycleStrategy(this));
        this.lifecycleStrategies.add(new DefaultAutowiredLifecycleStrategy(this));
        this.bootstraps.add(new DefaultServiceBootstrapCloseable(this));
        this.bootstraps.add(new BootstrapCloseable(){

            @Override
            public void close() throws IOException {
                AbstractCamelContext.this.bootstrapFactories.clear();
            }
        });
        if (build) {
            try {
                this.build();
            }
            catch (Exception e) {
                throw new RuntimeException("Error initializing CamelContext", e);
            }
        }
    }

    protected static <T> T lookup(CamelContext context, String ref, Class<T> type) {
        try {
            return context.getRegistry().lookupByNameAndType(ref, type);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setContextCounter(int value) {
        DefaultCamelContextNameStrategy.setCounter(value);
        DefaultManagementNameStrategy.setCounter(value);
    }

    @Override
    public void close() throws IOException {
        try {
            this.stop();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public CamelContext getCamelContextReference() {
        return this;
    }

    protected boolean eagerCreateTypeConverter() {
        return true;
    }

    @Override
    public <T extends CamelContext> T adapt(Class<T> type) {
        return (T)((CamelContext)type.cast(this));
    }

    @Override
    public <T> T getExtension(Class<T> type) {
        if (type.isInstance(this)) {
            return type.cast(this);
        }
        Object extension = this.extensions.get(type);
        if (extension instanceof Supplier) {
            extension = ((Supplier)extension).get();
            this.setExtension(type, extension);
        }
        return (T)extension;
    }

    @Override
    public <T> void setExtension(Class<T> type, T module) {
        if (module != null) {
            try {
                this.extensions.put(type, this.doAddService(module));
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeCamelException(e);
            }
        }
    }

    public <T> void setDefaultExtension(Class<T> type, Supplier<T> module) {
        if (module != null) {
            this.extensions.putIfAbsent(type, module);
        }
    }

    @Override
    public boolean isVetoStarted() {
        return this.vetoed != null;
    }

    @Deprecated
    public Initialization getInitialization() {
        return this.initialization;
    }

    @Deprecated
    public void setInitialization(Initialization initialization) {
        this.initialization = initialization;
    }

    @Override
    public String getName() {
        return this.getNameStrategy().getName();
    }

    @Override
    public void setName(String name) {
        this.setNameStrategy(new ExplicitCamelContextNameStrategy(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CamelContextNameStrategy getNameStrategy() {
        if (this.nameStrategy == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.nameStrategy == null) {
                    this.setNameStrategy(this.createCamelContextNameStrategy());
                }
            }
        }
        return this.nameStrategy;
    }

    @Override
    public void setNameStrategy(CamelContextNameStrategy nameStrategy) {
        this.nameStrategy = this.doAddService(nameStrategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ManagementNameStrategy getManagementNameStrategy() {
        if (this.managementNameStrategy == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.managementNameStrategy == null) {
                    this.setManagementNameStrategy(this.createManagementNameStrategy());
                }
            }
        }
        return this.managementNameStrategy;
    }

    @Override
    public void setManagementNameStrategy(ManagementNameStrategy managementNameStrategy) {
        this.managementNameStrategy = this.doAddService(managementNameStrategy);
    }

    @Override
    public String getManagementName() {
        return this.managementName;
    }

    @Override
    public void setManagementName(String managementName) {
        this.managementName = managementName;
    }

    @Override
    public Component hasComponent(String componentName) {
        if (this.components.isEmpty()) {
            return null;
        }
        return this.components.get(componentName);
    }

    @Override
    public void addComponent(String componentName, Component component) {
        ObjectHelper.notNull(component, "component");
        component.setCamelContext(this.getCamelContextReference());
        if (this.isStarted()) {
            ServiceHelper.startService((Object)component);
        } else {
            ServiceHelper.initService((Object)component);
        }
        Component oldValue = this.components.putIfAbsent(componentName, component);
        if (oldValue != null) {
            throw new IllegalArgumentException("Cannot add component as its already previously added: " + componentName);
        }
        this.postInitComponent(componentName, component);
    }

    private void postInitComponent(String componentName, Component component) {
        for (LifecycleStrategy strategy : this.lifecycleStrategies) {
            strategy.onComponentAdd(componentName, component);
        }
    }

    @Override
    public Component getComponent(String name) {
        return this.getComponent(name, this.autoCreateComponents, true);
    }

    @Override
    public Component getComponent(String name, boolean autoCreateComponents) {
        return this.getComponent(name, autoCreateComponents, true);
    }

    @Override
    public Component getComponent(final String name, final boolean autoCreateComponents, boolean autoStart) {
        this.build();
        if (this.componentsInCreation.get().contains(name)) {
            throw new IllegalStateException("Circular dependency detected, the component " + name + " is already being created");
        }
        try {
            final AtomicBoolean created = new AtomicBoolean();
            Component component = this.components.computeIfAbsent(name, new Function<String, Component>(){

                @Override
                public Component apply(String comp) {
                    created.set(true);
                    return AbstractCamelContext.this.initComponent(name, autoCreateComponents);
                }
            });
            if (component != null && created.get() && autoStart && (this.isStarted() || this.isStarting())) {
                StartupStep step = this.startupStepRecorder.beginStep(Component.class, name, "Start Component");
                this.startService(component);
                this.startupStepRecorder.endStep(step);
            }
            Component component2 = component;
            return component2;
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Cannot auto create component: " + name, e);
        }
        finally {
            this.componentsInCreation.get().remove(name);
        }
    }

    private Component initComponent(String name, boolean autoCreateComponents) {
        Component component = null;
        if (autoCreateComponents) {
            StartupStep step = this.startupStepRecorder.beginStep(Component.class, name, "Resolve Component");
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Using ComponentResolver: {} to resolve component with name: {}", (Object)this.getComponentResolver(), (Object)name);
                }
                this.componentsInCreation.get().add(name);
                component = ResolverHelper.lookupComponentInRegistryWithFallback(this.getCamelContextReference(), name);
                if (component == null) {
                    component = this.getComponentResolver().resolveComponent(name, this.getCamelContextReference());
                }
                if (component != null) {
                    component.setCamelContext(this.getCamelContextReference());
                    ServiceHelper.buildService((Object)component);
                    this.postInitComponent(name, component);
                }
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Cannot auto create component: " + name, e);
            }
            this.startupStepRecorder.endStep(step);
        }
        return component;
    }

    @Override
    public <T extends Component> T getComponent(String name, Class<T> componentType) {
        Component component = this.getComponent(name);
        if (componentType.isInstance(component)) {
            return (T)((Component)componentType.cast(component));
        }
        String message = component == null ? "Did not find component given by the name: " + name : "Found component of type: " + component.getClass() + " instead of expected: " + componentType;
        throw new IllegalArgumentException(message);
    }

    @Override
    public Component removeComponent(String componentName) {
        Component oldComponent = this.components.remove(componentName);
        if (oldComponent != null) {
            try {
                this.stopServices(oldComponent);
            }
            catch (Exception e) {
                LOG.warn("Error stopping component " + oldComponent + ". This exception will be ignored.", (Throwable)e);
            }
            for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                strategy.onComponentRemove(componentName, oldComponent);
            }
        }
        return oldComponent;
    }

    public EndpointRegistry<NormalizedUri> getEndpointRegistry() {
        return this.endpoints;
    }

    @Override
    public Collection<Endpoint> getEndpoints() {
        return this.endpoints.getReadOnlyValues();
    }

    @Override
    public Map<String, Endpoint> getEndpointMap() {
        TreeMap<String, Endpoint> answer = new TreeMap<String, Endpoint>();
        for (Map.Entry entry : this.endpoints.entrySet()) {
            answer.put((String)((NormalizedUri)entry.getKey()).get(), (Endpoint)entry.getValue());
        }
        return answer;
    }

    @Override
    public Endpoint hasEndpoint(String uri) {
        if (this.endpoints.isEmpty()) {
            return null;
        }
        return (Endpoint)this.endpoints.get(this.getEndpointKey(uri));
    }

    @Override
    public Endpoint hasEndpoint(NormalizedEndpointUri uri) {
        if (this.endpoints.isEmpty()) {
            return null;
        }
        return (Endpoint)this.endpoints.get(uri);
    }

    @Override
    public Endpoint addEndpoint(String uri, Endpoint endpoint) throws Exception {
        this.startService(endpoint);
        Endpoint oldEndpoint = (Endpoint)this.endpoints.remove(this.getEndpointKey(uri));
        for (LifecycleStrategy strategy : this.lifecycleStrategies) {
            strategy.onEndpointAdd(endpoint);
        }
        this.addEndpointToRegistry(uri, endpoint);
        if (oldEndpoint != null && oldEndpoint != endpoint) {
            this.stopServices(oldEndpoint);
        }
        return oldEndpoint;
    }

    @Override
    public void removeEndpoint(Endpoint endpoint) throws Exception {
        this.removeEndpoints(endpoint.getEndpointUri());
    }

    @Override
    public Collection<Endpoint> removeEndpoints(String uri) throws Exception {
        ArrayList<Endpoint> answer = new ArrayList<Endpoint>();
        Endpoint oldEndpoint = (Endpoint)this.endpoints.remove(this.getEndpointKey(uri));
        if (oldEndpoint != null) {
            answer.add(oldEndpoint);
            this.stopServices(oldEndpoint);
        } else {
            ArrayList toRemove = new ArrayList();
            for (Map.Entry entry : this.endpoints.entrySet()) {
                oldEndpoint = (Endpoint)entry.getValue();
                if (!EndpointHelper.matchEndpoint(this, oldEndpoint.getEndpointUri(), uri)) continue;
                try {
                    this.stopServices(oldEndpoint);
                }
                catch (Exception e) {
                    LOG.warn("Error stopping endpoint " + oldEndpoint + ". This exception will be ignored.", (Throwable)e);
                }
                answer.add(oldEndpoint);
                toRemove.add(entry.getKey());
            }
            for (NormalizedUri key : toRemove) {
                this.endpoints.remove(key);
            }
        }
        for (Endpoint endpoint : answer) {
            for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                strategy.onEndpointRemove(endpoint);
            }
        }
        return answer;
    }

    @Override
    public NormalizedEndpointUri normalizeUri(String uri) {
        try {
            uri = EndpointHelper.resolveEndpointUriPropertyPlaceholders(this, uri);
            return NormalizedUri.newNormalizedUri(uri, false);
        }
        catch (Exception e) {
            if (e instanceof ResolveEndpointFailedException) {
                throw e;
            }
            throw new ResolveEndpointFailedException(uri, e);
        }
    }

    @Override
    public Endpoint getEndpoint(String uri) {
        StartupStep step = null;
        if (!this.isStarted() && this.startupStepRecorder.isEnabled()) {
            String u = URISupport.sanitizeUri(uri);
            step = this.startupStepRecorder.beginStep(Endpoint.class, u, "Get Endpoint");
        }
        Endpoint answer = this.doGetEndpoint(uri, null, false, false);
        if (step != null) {
            this.startupStepRecorder.endStep(step);
        }
        return answer;
    }

    @Override
    public Endpoint getEndpoint(NormalizedEndpointUri uri) {
        return this.doGetEndpoint(uri.getUri(), null, true, false);
    }

    @Override
    public Endpoint getPrototypeEndpoint(String uri) {
        return this.doGetEndpoint(uri, null, false, true);
    }

    @Override
    public Endpoint getPrototypeEndpoint(NormalizedEndpointUri uri) {
        return this.doGetEndpoint(uri.getUri(), null, true, true);
    }

    @Override
    public Endpoint getEndpoint(String uri, Map<String, Object> parameters) {
        return this.doGetEndpoint(uri, parameters, false, false);
    }

    @Override
    public Endpoint getEndpoint(NormalizedEndpointUri uri, Map<String, Object> parameters) {
        return this.doGetEndpoint(uri.getUri(), parameters, true, false);
    }

    protected Endpoint doGetEndpoint(String uri, Map<String, Object> parameters, boolean normalized, boolean prototype) {
        this.build();
        StringHelper.notEmpty(uri, "uri");
        LOG.trace("Getting endpoint with uri: {} and parameters: {}", (Object)uri, parameters);
        if (!normalized) {
            uri = EndpointHelper.resolveEndpointUriPropertyPlaceholders(this, uri);
        }
        String rawUri = uri;
        if (!normalized) {
            uri = EndpointHelper.normalizeEndpointUri(uri);
        }
        LOG.trace("Getting endpoint with raw uri: {}, normalized uri: {}", (Object)rawUri, (Object)uri);
        Endpoint answer = null;
        if (!prototype) {
            NormalizedUri key = NormalizedUri.newNormalizedUri(uri, true);
            answer = (Endpoint)this.endpoints.get(key);
        }
        if (answer == null) {
            try {
                String scheme = StringHelper.before(uri, ":");
                if (scheme == null) {
                    answer = this.getRegistry().lookupByNameAndType(uri, Endpoint.class);
                    if (answer != null) {
                        return answer;
                    }
                    throw new NoSuchEndpointException(uri);
                }
                LOG.trace("Endpoint uri: {} is from component with name: {}", (Object)uri, (Object)scheme);
                Component component = this.getComponent(scheme);
                ServiceHelper.initService((Object)component);
                if (component != null) {
                    LOG.trace("Creating endpoint from uri: {} using component: {}", (Object)uri, (Object)component);
                    answer = component.createEndpoint(component.useRawUri() ? rawUri : uri, parameters);
                    if (answer != null && LOG.isDebugEnabled()) {
                        LOG.debug("{} converted to endpoint: {} by component: {}", new Object[]{URISupport.sanitizeUri(uri), answer, component});
                    }
                }
                if (answer == null) {
                    answer = this.createEndpoint(uri);
                    LOG.trace("No component to create endpoint from uri: {} fallback lookup in registry -> {}", (Object)uri, (Object)answer);
                }
                if (answer != null) {
                    if (!prototype) {
                        this.addService(answer);
                        answer = this.addEndpointToRegistry(uri, answer);
                    } else {
                        this.addPrototypeService(answer);
                        for (EndpointStrategy strategy : this.endpointStrategies) {
                            answer = strategy.registerEndpoint(uri, answer);
                        }
                    }
                }
            }
            catch (NoSuchEndpointException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ResolveEndpointFailedException(uri, e);
            }
        }
        if (answer == null) {
            throw new NoSuchEndpointException(uri);
        }
        return answer;
    }

    @Override
    public <T extends Endpoint> T getEndpoint(String name, Class<T> endpointType) {
        Endpoint endpoint = this.getEndpoint(name);
        if (endpoint == null) {
            throw new NoSuchEndpointException(name);
        }
        if (endpoint instanceof InterceptSendToEndpoint) {
            endpoint = ((InterceptSendToEndpoint)endpoint).getOriginalEndpoint();
        }
        if (endpointType.isInstance(endpoint)) {
            return (T)((Endpoint)endpointType.cast(endpoint));
        }
        throw new IllegalArgumentException("The endpoint is not of type: " + endpointType + " but is: " + endpoint.getClass().getCanonicalName());
    }

    @Override
    public void registerEndpointCallback(EndpointStrategy strategy) {
        if (!this.endpointStrategies.contains(strategy)) {
            this.endpointStrategies.add(strategy);
            for (Endpoint endpoint : this.getEndpoints()) {
                Endpoint newEndpoint = strategy.registerEndpoint(endpoint.getEndpointUri(), endpoint);
                if (newEndpoint == null) continue;
                this.endpoints.put(this.getEndpointKey(endpoint.getEndpointUri()), newEndpoint);
            }
        }
    }

    protected Endpoint addEndpointToRegistry(String uri, Endpoint endpoint) {
        StringHelper.notEmpty(uri, "uri");
        ObjectHelper.notNull(endpoint, "endpoint");
        for (EndpointStrategy strategy : this.endpointStrategies) {
            endpoint = strategy.registerEndpoint(uri, endpoint);
        }
        this.endpoints.put(this.getEndpointKey(uri, endpoint), endpoint);
        return endpoint;
    }

    protected NormalizedUri getEndpointKey(String uri) {
        return NormalizedUri.newNormalizedUri(uri, false);
    }

    protected NormalizedUri getEndpointKey(String uri, Endpoint endpoint) {
        if (endpoint != null && !endpoint.isSingleton()) {
            int counter = this.endpointKeyCounter.incrementAndGet();
            return NormalizedUri.newNormalizedUri(uri + ":" + counter, false);
        }
        return NormalizedUri.newNormalizedUri(uri, false);
    }

    @Override
    public GlobalEndpointConfiguration getGlobalEndpointConfiguration() {
        return this.globalEndpointConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RouteController getRouteController() {
        if (this.routeController == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.routeController == null) {
                    this.setRouteController(this.createRouteController());
                }
            }
        }
        return this.routeController;
    }

    @Override
    public void setRouteController(RouteController routeController) {
        this.routeController = this.doAddService(routeController);
    }

    @Override
    public List<RouteStartupOrder> getRouteStartupOrder() {
        return this.routeStartupOrder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Route> getRoutes() {
        if (this.routes.isEmpty()) {
            return Collections.emptyList();
        }
        Set<Route> set = this.routes;
        synchronized (set) {
            return new ArrayList<Route>(this.routes);
        }
    }

    @Override
    public int getRoutesSize() {
        return this.routes.size();
    }

    @Override
    public Route getRoute(String id) {
        if (id != null) {
            for (Route route : this.getRoutes()) {
                if (!route.getId().equals(id)) continue;
                return route;
            }
        }
        return null;
    }

    @Override
    public Processor getProcessor(String id) {
        for (Route route : this.getRoutes()) {
            List<Processor> list = route.filter(id);
            if (list.size() != 1) continue;
            return list.get(0);
        }
        return null;
    }

    @Override
    public <T extends Processor> T getProcessor(String id, Class<T> type) {
        Processor answer = this.getProcessor(id);
        if (answer != null) {
            return (T)((Processor)type.cast(answer));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRoute(Route route) {
        Set<Route> set = this.routes;
        synchronized (set) {
            this.routes.remove(route);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRoute(Route route) {
        Set<Route> set = this.routes;
        synchronized (set) {
            this.routes.add(route);
        }
    }

    @Override
    public void addRoutes(RoutesBuilder builder) throws Exception {
        if (builder instanceof RouteConfigurationsBuilder) {
            this.addRoutesConfigurations((RouteConfigurationsBuilder)((Object)builder));
        }
        try (LifecycleHelper helper = new LifecycleHelper();){
            this.build();
            LOG.debug("Adding routes from builder: {}", (Object)builder);
            builder.addRoutesToCamelContext(this);
        }
    }

    @Override
    public void addRoutesConfigurations(RouteConfigurationsBuilder builder) throws Exception {
        try (LifecycleHelper helper = new LifecycleHelper();){
            this.build();
            LOG.debug("Adding route configurations from builder: {}", (Object)builder);
            builder.addRouteConfigurationsToCamelContext(this);
        }
    }

    public ServiceStatus getRouteStatus(String key) {
        RouteService routeService = this.routeServices.get(key);
        if (routeService != null) {
            return routeService.getStatus();
        }
        return null;
    }

    public boolean isStartingRoutes() {
        Boolean answer = this.isStartingRoutes.get();
        return answer != null && answer != false;
    }

    public void setStartingRoutes(boolean starting) {
        if (starting) {
            this.isStartingRoutes.set(true);
        } else {
            this.isStartingRoutes.remove();
        }
    }

    @Override
    public boolean isSetupRoutes() {
        Boolean answer = this.isSetupRoutes.get();
        return answer != null && answer != false;
    }

    public void startAllRoutes() throws Exception {
        this.internalRouteStartupManager.doStartOrResumeRoutes(this.routeServices, true, true, false, false);
    }

    public void stopAllRoutes() throws Exception {
        Comparator<RouteStartupOrder> comparator = Comparator.comparingInt(RouteStartupOrder::getStartupOrder);
        if (this.shutdownStrategy == null || this.shutdownStrategy.isShutdownRoutesInReverseOrder()) {
            comparator = comparator.reversed();
        }
        ArrayList<RouteStartupOrder> routesOrdered = new ArrayList<RouteStartupOrder>(this.getRouteStartupOrder());
        routesOrdered.sort(comparator);
        for (RouteStartupOrder order : routesOrdered) {
            Route route = order.getRoute();
            boolean stopped = this.getRouteController().getRouteStatus(route.getRouteId()).isStopped();
            if (stopped) continue;
            this.stopRoute(route.getRouteId(), LoggingLevel.DEBUG);
        }
        for (Route route : this.getRoutes()) {
            boolean stopped = this.getRouteController().getRouteStatus(route.getRouteId()).isStopped();
            if (stopped) continue;
            this.stopRoute(route.getRouteId(), LoggingLevel.DEBUG);
        }
        if (this.startupSummaryLevel != StartupSummaryLevel.Classic && this.startupSummaryLevel != StartupSummaryLevel.Oneline && this.startupSummaryLevel != StartupSummaryLevel.Off) {
            this.logRouteStopSummary(LoggingLevel.INFO);
        }
    }

    public void removeAllRoutes() throws Exception {
        Comparator<RouteStartupOrder> comparator = Comparator.comparingInt(RouteStartupOrder::getStartupOrder);
        if (this.shutdownStrategy == null || this.shutdownStrategy.isShutdownRoutesInReverseOrder()) {
            comparator = comparator.reversed();
        }
        ArrayList<RouteStartupOrder> routesOrdered = new ArrayList<RouteStartupOrder>(this.getRouteStartupOrder());
        routesOrdered.sort(comparator);
        for (RouteStartupOrder order : routesOrdered) {
            Route route = order.getRoute();
            boolean stopped = this.getRouteController().getRouteStatus(route.getRouteId()).isStopped();
            if (stopped) continue;
            this.stopRoute(route.getRouteId(), LoggingLevel.DEBUG);
        }
        for (Route route : this.getRoutes()) {
            boolean stopped = this.getRouteController().getRouteStatus(route.getRouteId()).isStopped();
            if (stopped) continue;
            this.stopRoute(route.getRouteId(), LoggingLevel.DEBUG);
        }
        this.logRouteStopSummary(LoggingLevel.DEBUG);
        for (Route route : this.getRoutes()) {
            this.removeRoute(route.getRouteId(), LoggingLevel.DEBUG);
        }
    }

    public synchronized void startRoute(String routeId) throws Exception {
        DefaultRouteError.reset(this, routeId);
        RouteService routeService = this.routeServices.get(routeId);
        if (routeService != null) {
            try {
                this.startRouteService(routeService, false);
            }
            catch (Exception e) {
                DefaultRouteError.set(this, routeId, RouteError.Phase.START, e);
                throw e;
            }
        }
    }

    public synchronized void resumeRoute(String routeId) throws Exception {
        DefaultRouteError.reset(this, routeId);
        try {
            if (!this.routeSupportsSuspension(routeId)) {
                this.startRoute(routeId);
                return;
            }
            RouteService routeService = this.routeServices.get(routeId);
            if (routeService != null) {
                this.resumeRouteService(routeService);
                Route route = this.getRoute(routeId);
                ServiceHelper.resumeService(route);
            }
        }
        catch (Exception e) {
            DefaultRouteError.set(this, routeId, RouteError.Phase.RESUME, e);
            throw e;
        }
    }

    public synchronized boolean stopRoute(String routeId, long timeout, TimeUnit timeUnit, boolean abortAfterTimeout, LoggingLevel loggingLevel) throws Exception {
        DefaultRouteError.reset(this, routeId);
        RouteService routeService = this.routeServices.get(routeId);
        if (routeService != null) {
            try {
                DefaultRouteStartupOrder route = new DefaultRouteStartupOrder(1, routeService.getRoute(), routeService);
                boolean completed = this.getShutdownStrategy().shutdown(this, route, timeout, timeUnit, abortAfterTimeout);
                if (completed) {
                    this.stopRouteService(routeService, false, loggingLevel);
                } else {
                    this.startRouteService(routeService, false);
                }
                return completed;
            }
            catch (Exception e) {
                DefaultRouteError.set(this, routeId, RouteError.Phase.STOP, e);
                throw e;
            }
        }
        return false;
    }

    public void stopRoute(String routeId) throws Exception {
        this.stopRoute(routeId, LoggingLevel.INFO);
    }

    public void stopRoute(String routeId, LoggingLevel loggingLevel) throws Exception {
        this.doShutdownRoute(routeId, this.getShutdownStrategy().getTimeout(), this.getShutdownStrategy().getTimeUnit(), false, loggingLevel);
    }

    public void stopRoute(String routeId, long timeout, TimeUnit timeUnit) throws Exception {
        this.doShutdownRoute(routeId, timeout, timeUnit, false, LoggingLevel.INFO);
    }

    protected synchronized void doShutdownRoute(String routeId, long timeout, TimeUnit timeUnit, boolean removingRoutes, LoggingLevel loggingLevel) throws Exception {
        DefaultRouteError.reset(this, routeId);
        RouteService routeService = this.routeServices.get(routeId);
        if (routeService != null) {
            try {
                ArrayList<RouteStartupOrder> routes = new ArrayList<RouteStartupOrder>(1);
                DefaultRouteStartupOrder order = new DefaultRouteStartupOrder(1, routeService.getRoute(), routeService);
                routes.add(order);
                this.getShutdownStrategy().shutdown(this, routes, timeout, timeUnit);
                this.stopRouteService(routeService, removingRoutes, loggingLevel);
            }
            catch (Exception e) {
                DefaultRouteError.set(this, routeId, removingRoutes ? RouteError.Phase.SHUTDOWN : RouteError.Phase.STOP, e);
                throw e;
            }
        }
    }

    @Override
    public synchronized boolean removeRoute(String routeId) throws Exception {
        return this.removeRoute(routeId, LoggingLevel.INFO);
    }

    protected synchronized boolean removeRoute(String routeId, LoggingLevel loggingLevel) throws Exception {
        DefaultRouteError.reset(this, routeId);
        HashMap<String, Set<Endpoint>> endpointsInUse = new HashMap<String, Set<Endpoint>>();
        for (Map.Entry<String, RouteService> entry : this.routeServices.entrySet()) {
            endpointsInUse.put(entry.getKey(), entry.getValue().gatherEndpoints());
        }
        RouteService routeService = this.routeServices.get(routeId);
        if (routeService != null) {
            if (this.getRouteStatus(routeId).isStopped()) {
                try {
                    routeService.setRemovingRoutes(true);
                    this.shutdownRouteService(routeService, loggingLevel);
                    this.routeServices.remove(routeId);
                    this.routeStartupOrder.removeIf(order -> order.getRoute().getId().equals(routeId));
                    LinkedHashSet<Endpoint> toRemove = new LinkedHashSet<Endpoint>();
                    for (Endpoint endpoint : (Set)endpointsInUse.get(routeId)) {
                        int count = 0;
                        for (Set endpoints : endpointsInUse.values()) {
                            if (!endpoints.contains(endpoint)) continue;
                            ++count;
                        }
                        if (count > true) continue;
                        toRemove.add(endpoint);
                    }
                    for (Endpoint endpoint : toRemove) {
                        LOG.debug("Removing: {} which was only in use by route: {}", (Object)endpoint, (Object)routeId);
                        this.removeEndpoint(endpoint);
                    }
                }
                catch (Exception e) {
                    DefaultRouteError.set(this, routeId, RouteError.Phase.REMOVE, e);
                    throw e;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public void suspendRoute(String routeId) throws Exception {
        this.suspendRoute(routeId, this.getShutdownStrategy().getTimeout(), this.getShutdownStrategy().getTimeUnit());
    }

    public synchronized void suspendRoute(String routeId, long timeout, TimeUnit timeUnit) throws Exception {
        DefaultRouteError.reset(this, routeId);
        try {
            if (!this.routeSupportsSuspension(routeId)) {
                this.stopRoute(routeId, timeout, timeUnit);
                return;
            }
            RouteService routeService = this.routeServices.get(routeId);
            if (routeService != null) {
                ArrayList<RouteStartupOrder> routes = new ArrayList<RouteStartupOrder>(1);
                Route route = routeService.getRoute();
                DefaultRouteStartupOrder order = new DefaultRouteStartupOrder(1, route, routeService);
                routes.add(order);
                this.getShutdownStrategy().suspend(this, routes, timeout, timeUnit);
                this.suspendRouteService(routeService);
                if (route instanceof SuspendableService) {
                    ((SuspendableService)((Object)route)).suspend();
                }
            }
        }
        catch (Exception e) {
            DefaultRouteError.set(this, routeId, RouteError.Phase.SUSPEND, e);
            throw e;
        }
    }

    @Override
    public void addService(Object object) throws Exception {
        this.addService(object, true);
    }

    @Override
    public void addService(Object object, boolean stopOnShutdown) throws Exception {
        this.addService(object, stopOnShutdown, false);
    }

    @Override
    public void addService(Object object, boolean stopOnShutdown, boolean forceStart) throws Exception {
        this.internalAddService(object, stopOnShutdown, forceStart, true);
    }

    @Override
    public void addPrototypeService(Object object) throws Exception {
        this.doAddService(object, false, true, false);
    }

    protected <T> T doAddService(T object) {
        return this.doAddService(object, true);
    }

    protected <T> T doAddService(T object, boolean stopOnShutdown) {
        return this.doAddService(object, stopOnShutdown, true, true);
    }

    protected <T> T doAddService(T object, boolean stopOnShutdown, boolean forceStart, boolean useLifecycleStrategies) {
        try {
            this.internalAddService(object, stopOnShutdown, forceStart, useLifecycleStrategies);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
        return object;
    }

    private void internalAddService(Object object, boolean stopOnShutdown, boolean forceStart, boolean useLifecycleStrategies) throws Exception {
        CamelContextAware.trySetCamelContext(object, this.getCamelContextReference());
        if (object instanceof Service) {
            Service service = (Service)object;
            if (useLifecycleStrategies) {
                for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                    if (service instanceof Endpoint) {
                        strategy.onEndpointAdd((Endpoint)service);
                        continue;
                    }
                    Route route = service instanceof RouteAware ? ((RouteAware)((Object)service)).getRoute() : this.internalRouteStartupManager.getSetupRoute();
                    strategy.onServiceAdd(this.getCamelContextReference(), service, route);
                }
            }
            if (!forceStart) {
                ServiceHelper.initService((Object)service);
                this.deferStartService(object, stopOnShutdown);
            } else {
                boolean singleton = true;
                if (object instanceof IsSingleton) {
                    singleton = ((IsSingleton)((Object)service)).isSingleton();
                }
                if (singleton && !(service instanceof Endpoint) && stopOnShutdown && !this.hasService(service)) {
                    boolean tc;
                    boolean bl = tc = service instanceof TypeConverter || service instanceof TypeConverterRegistry;
                    if (!tc) {
                        this.servicesToStop.add(service);
                    }
                }
                if (this.isStartingOrStarted()) {
                    ServiceHelper.startService((Object)service);
                } else {
                    ServiceHelper.initService((Object)service);
                    this.deferStartService(object, stopOnShutdown, true);
                }
            }
        }
    }

    @Override
    public boolean removeService(Object object) throws Exception {
        if (object instanceof Endpoint) {
            this.removeEndpoint((Endpoint)object);
            return true;
        }
        if (object instanceof Service) {
            Service service = (Service)object;
            for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                strategy.onServiceRemove(this, service, null);
            }
            return this.servicesToStop.remove(service);
        }
        return false;
    }

    @Override
    public void addBootstrap(BootstrapCloseable bootstrap) {
        this.bootstraps.add(bootstrap);
    }

    @Override
    public List<Service> getServices() {
        return Collections.unmodifiableList(this.servicesToStop);
    }

    @Override
    public boolean hasService(Object object) {
        if (this.servicesToStop.isEmpty()) {
            return false;
        }
        if (object instanceof Service) {
            Service service = (Service)object;
            return this.servicesToStop.contains(service);
        }
        return false;
    }

    @Override
    public <T> T hasService(Class<T> type) {
        if (this.servicesToStop.isEmpty()) {
            return null;
        }
        for (Service service : this.servicesToStop) {
            if (!type.isInstance(service)) continue;
            return type.cast(service);
        }
        return null;
    }

    @Override
    public <T> Set<T> hasServices(Class<T> type) {
        if (this.servicesToStop.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<Service> set = new HashSet<Service>();
        for (Service service : this.servicesToStop) {
            if (!type.isInstance(service)) continue;
            set.add(service);
        }
        return set;
    }

    @Override
    public void deferStartService(Object object, boolean stopOnShutdown) throws Exception {
        this.deferStartService(object, stopOnShutdown, false);
    }

    public void deferStartService(Object object, boolean stopOnShutdown, boolean startEarly) throws Exception {
        if (object instanceof Service) {
            Service service = (Service)object;
            boolean singleton = true;
            if (object instanceof IsSingleton) {
                singleton = ((IsSingleton)((Object)service)).isSingleton();
            }
            if (singleton && !(service instanceof Endpoint) && stopOnShutdown && !this.hasService(service)) {
                this.servicesToStop.add(service);
            }
            if (this.isStarted()) {
                ServiceHelper.startService((Object)service);
            } else {
                this.deferStartupListener.addService(service, startEarly);
            }
        }
    }

    protected List<StartupListener> getStartupListeners() {
        return this.startupListeners;
    }

    @Override
    public void addStartupListener(StartupListener listener) throws Exception {
        if (this.isStarted()) {
            listener.onCamelContextStarted(this, true);
        } else {
            this.startupListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getComponentParameterJsonSchema(String componentName) throws IOException {
        FactoryFinder finder = this.getFactoryFinder("META-INF/services/org/apache/camel/component/");
        Class<?> clazz = finder.findClass(componentName).orElse(null);
        if (clazz == null) {
            Component existing = this.hasComponent(componentName);
            if (existing != null) {
                clazz = existing.getClass();
            } else {
                return null;
            }
        }
        String packageName = clazz.getPackage().getName();
        packageName = packageName.replace('.', '/');
        String path = packageName + "/" + componentName + ".json";
        ClassResolver resolver2 = this.getClassResolver();
        InputStream inputStream = resolver2.loadResourceAsStream(path);
        LOG.debug("Loading component JSON Schema for: {} using class resolver: {} -> {}", new Object[]{componentName, resolver2, inputStream});
        if (inputStream != null) {
            try {
                String string = IOHelper.loadText(inputStream);
                return string;
            }
            finally {
                IOHelper.close((Closeable)inputStream);
            }
        }
        if ("ActiveMQComponent".equals(clazz.getSimpleName())) {
            return this.getComponentParameterJsonSchema("jms");
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDataFormatParameterJsonSchema(String dataFormatName) throws IOException {
        FactoryFinder finder = this.getFactoryFinder("META-INF/services/org/apache/camel/dataformat/");
        Class clazz = finder.findClass(dataFormatName).orElse(null);
        if (clazz == null) {
            return null;
        }
        String packageName = clazz.getPackage().getName();
        packageName = packageName.replace('.', '/');
        String path = packageName + "/" + dataFormatName + ".json";
        ClassResolver resolver2 = this.getClassResolver();
        InputStream inputStream = resolver2.loadResourceAsStream(path);
        LOG.debug("Loading dataformat JSON Schema for: {} using class resolver: {} -> {}", new Object[]{dataFormatName, resolver2, inputStream});
        if (inputStream != null) {
            try {
                String string = IOHelper.loadText(inputStream);
                return string;
            }
            finally {
                IOHelper.close((Closeable)inputStream);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLanguageParameterJsonSchema(String languageName) throws IOException {
        FactoryFinder finder = this.getFactoryFinder("META-INF/services/org/apache/camel/language/");
        Class clazz = finder.findClass(languageName).orElse(null);
        if (clazz == null) {
            return null;
        }
        String packageName = clazz.getPackage().getName();
        packageName = packageName.replace('.', '/');
        String path = packageName + "/" + languageName + ".json";
        ClassResolver resolver2 = this.getClassResolver();
        InputStream inputStream = resolver2.loadResourceAsStream(path);
        LOG.debug("Loading language JSON Schema for: {} using class resolver: {} -> {}", new Object[]{languageName, resolver2, inputStream});
        if (inputStream != null) {
            try {
                String string = IOHelper.loadText(inputStream);
                return string;
            }
            finally {
                IOHelper.close((Closeable)inputStream);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getEipParameterJsonSchema(String eipName) throws IOException {
        String[] subPackages;
        for (String sub : subPackages = new String[]{"", "/config", "/dataformat", "/language", "/loadbalancer", "/rest"}) {
            String path = "org/apache/camel/model/" + sub + "/" + eipName + ".json";
            ClassResolver resolver2 = this.getClassResolver();
            InputStream inputStream = resolver2.loadResourceAsStream(path);
            if (inputStream == null) continue;
            LOG.debug("Loading eip JSON Schema for: {} using class resolver: {} -> {}", new Object[]{eipName, resolver2, inputStream});
            try {
                String string = IOHelper.loadText(inputStream);
                return string;
            }
            finally {
                IOHelper.close((Closeable)inputStream);
            }
        }
        return null;
    }

    @Override
    public Language resolveLanguage(final String name) {
        LOG.debug("Resolving language: {}", (Object)name);
        return this.languages.computeIfAbsent(name, new Function<String, Language>(){

            @Override
            public Language apply(String s) {
                CamelContext camelContext;
                Language language;
                StartupStep step = null;
                if (!AbstractCamelContext.this.isStarted() && AbstractCamelContext.this.startupStepRecorder.isEnabled()) {
                    step = AbstractCamelContext.this.startupStepRecorder.beginStep(Language.class, name, "Resolve Language");
                }
                if ((language = ResolverHelper.lookupLanguageInRegistryWithFallback(camelContext = AbstractCamelContext.this.getCamelContextReference(), name)) == null) {
                    language = AbstractCamelContext.this.getLanguageResolver().resolveLanguage(name, camelContext);
                }
                if (language != null) {
                    if (language instanceof Service) {
                        try {
                            Service service = (Service)((Object)language);
                            CamelContextAware.trySetCamelContext(service, camelContext);
                            ServiceHelper.initService((Object)service);
                            AbstractCamelContext.this.startService(service);
                        }
                        catch (Exception e) {
                            throw RuntimeCamelException.wrapRuntimeCamelException(e);
                        }
                    }
                    CamelContextAware.trySetCamelContext(language, camelContext);
                    for (LifecycleStrategy strategy : AbstractCamelContext.this.lifecycleStrategies) {
                        strategy.onLanguageCreated(name, language);
                    }
                }
                if (step != null) {
                    AbstractCamelContext.this.startupStepRecorder.endStep(step);
                }
                return language;
            }
        });
    }

    @Override
    public String resolvePropertyPlaceholders(String text) {
        return this.resolvePropertyPlaceholders(text, false);
    }

    @Override
    public String resolvePropertyPlaceholders(String text, boolean keepUnresolvedOptional) {
        if (text != null && text.contains("{{")) {
            String answer = this.getPropertiesComponent().parseUri(text, keepUnresolvedOptional);
            LOG.debug("Resolved text: {} -> {}", (Object)text, (Object)answer);
            return answer;
        }
        if (text != null && text.startsWith("Exchange.")) {
            String field = StringHelper.after(text, "Exchange.");
            String constant = ExchangeConstantProvider.lookup(field);
            if (constant != null) {
                LOG.debug("Resolved constant: {} -> {}", (Object)text, (Object)constant);
                return constant;
            }
            throw new IllegalArgumentException("Constant field with name: " + field + " not found on Exchange.class");
        }
        return text;
    }

    @Override
    public TypeConverter getTypeConverter() {
        return this.typeConverter;
    }

    public void setTypeConverter(TypeConverter typeConverter) {
        this.typeConverter = this.doAddService(typeConverter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TypeConverter getOrCreateTypeConverter() {
        if (this.typeConverter == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.typeConverter == null) {
                    this.setTypeConverter(this.createTypeConverter());
                }
            }
        }
        return this.typeConverter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TypeConverterRegistry getTypeConverterRegistry() {
        if (this.typeConverterRegistry == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.typeConverterRegistry == null) {
                    this.setTypeConverterRegistry(this.createTypeConverterRegistry());
                }
            }
        }
        return this.typeConverterRegistry;
    }

    @Override
    public void setTypeConverterRegistry(TypeConverterRegistry typeConverterRegistry) {
        this.typeConverterRegistry = this.doAddService(typeConverterRegistry);
        if (typeConverterRegistry instanceof TypeConverter) {
            this.typeConverter = (TypeConverter)((Object)typeConverterRegistry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Injector getInjector() {
        if (this.injector == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.injector == null) {
                    this.setInjector(this.createInjector());
                }
            }
        }
        return this.injector;
    }

    @Override
    public void setInjector(Injector injector) {
        this.injector = this.doAddService(injector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PropertiesComponent getPropertiesComponent() {
        if (this.propertiesComponent == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.propertiesComponent == null) {
                    this.setPropertiesComponent(this.createPropertiesComponent());
                }
            }
        }
        return this.propertiesComponent;
    }

    @Override
    public void setPropertiesComponent(PropertiesComponent propertiesComponent) {
        this.propertiesComponent = this.doAddService(propertiesComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CamelBeanPostProcessor getBeanPostProcessor() {
        if (this.beanPostProcessor == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.beanPostProcessor == null) {
                    this.setBeanPostProcessor(this.createBeanPostProcessor());
                }
            }
        }
        return this.beanPostProcessor;
    }

    @Override
    public void setBeanPostProcessor(CamelBeanPostProcessor beanPostProcessor) {
        this.beanPostProcessor = this.doAddService(beanPostProcessor);
    }

    @Override
    public ManagementMBeanAssembler getManagementMBeanAssembler() {
        return this.managementMBeanAssembler;
    }

    public void setManagementMBeanAssembler(ManagementMBeanAssembler managementMBeanAssembler) {
        this.managementMBeanAssembler = this.doAddService(managementMBeanAssembler, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentResolver getComponentResolver() {
        if (this.componentResolver == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.componentResolver == null) {
                    this.setComponentResolver(this.createComponentResolver());
                }
            }
        }
        return this.componentResolver;
    }

    @Override
    public void setComponentResolver(ComponentResolver componentResolver) {
        this.componentResolver = this.doAddService(componentResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ComponentNameResolver getComponentNameResolver() {
        if (this.componentNameResolver == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.componentNameResolver == null) {
                    this.setComponentNameResolver(this.createComponentNameResolver());
                }
            }
        }
        return this.componentNameResolver;
    }

    @Override
    public void setComponentNameResolver(ComponentNameResolver componentNameResolver) {
        this.componentNameResolver = this.doAddService(componentNameResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LanguageResolver getLanguageResolver() {
        if (this.languageResolver == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.languageResolver == null) {
                    this.setLanguageResolver(this.createLanguageResolver());
                }
            }
        }
        return this.languageResolver;
    }

    @Override
    public void setLanguageResolver(LanguageResolver languageResolver) {
        this.languageResolver = this.doAddService(languageResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigurerResolver getConfigurerResolver() {
        if (this.configurerResolver == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.configurerResolver == null) {
                    this.setConfigurerResolver(this.createConfigurerResolver());
                }
            }
        }
        return this.configurerResolver;
    }

    @Override
    public void setConfigurerResolver(ConfigurerResolver configurerResolver) {
        this.configurerResolver = this.doAddService(configurerResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UriFactoryResolver getUriFactoryResolver() {
        if (this.uriFactoryResolver == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.uriFactoryResolver == null) {
                    this.setUriFactoryResolver(this.createUriFactoryResolver());
                }
            }
        }
        return this.uriFactoryResolver;
    }

    @Override
    public void setUriFactoryResolver(UriFactoryResolver uriFactoryResolver) {
        this.uriFactoryResolver = this.doAddService(uriFactoryResolver);
    }

    public boolean isAutoCreateComponents() {
        return this.autoCreateComponents;
    }

    public void setAutoCreateComponents(boolean autoCreateComponents) {
        this.autoCreateComponents = autoCreateComponents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Registry getRegistry() {
        if (this.registry == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.registry == null) {
                    this.setRegistry(this.createRegistry());
                }
            }
        }
        return this.registry;
    }

    @Override
    public void setRegistry(Registry registry) {
        CamelContextAware.trySetCamelContext(registry, this.getCamelContextReference());
        this.registry = registry;
    }

    @Override
    public <T> T getRegistry(Class<T> type) {
        Registry reg = this.getRegistry();
        if (type.isAssignableFrom(reg.getClass())) {
            return type.cast(reg);
        }
        return null;
    }

    @Override
    public List<LifecycleStrategy> getLifecycleStrategies() {
        return this.lifecycleStrategies;
    }

    @Override
    public void addLifecycleStrategy(LifecycleStrategy lifecycleStrategy) {
        if (!this.getLifecycleStrategies().contains(lifecycleStrategy)) {
            this.getLifecycleStrategies().add(lifecycleStrategy);
        }
    }

    @Override
    public void setupRoutes(boolean done) {
        if (done) {
            this.isSetupRoutes.remove();
        } else {
            this.isSetupRoutes.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestConfiguration getRestConfiguration() {
        if (this.restConfiguration == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.restConfiguration == null) {
                    this.setRestConfiguration(this.createRestConfiguration());
                }
            }
        }
        return this.restConfiguration;
    }

    @Override
    public void setRestConfiguration(RestConfiguration restConfiguration) {
        this.restConfiguration = restConfiguration;
    }

    @Override
    public List<InterceptStrategy> getInterceptStrategies() {
        return this.interceptStrategies;
    }

    public void setInterceptStrategies(List<InterceptStrategy> interceptStrategies) {
        this.interceptStrategies = interceptStrategies;
    }

    @Override
    public void addInterceptStrategy(InterceptStrategy interceptStrategy) {
        if (!this.getInterceptStrategies().contains(interceptStrategy)) {
            this.getInterceptStrategies().add(interceptStrategy);
        }
    }

    @Override
    public List<RoutePolicyFactory> getRoutePolicyFactories() {
        return this.routePolicyFactories;
    }

    public void setRoutePolicyFactories(List<RoutePolicyFactory> routePolicyFactories) {
        this.routePolicyFactories = routePolicyFactories;
    }

    @Override
    public void addRoutePolicyFactory(RoutePolicyFactory routePolicyFactory) {
        if (!this.getRoutePolicyFactories().contains(routePolicyFactory)) {
            this.getRoutePolicyFactories().add(routePolicyFactory);
        }
    }

    @Override
    public Set<LogListener> getLogListeners() {
        return this.logListeners;
    }

    @Override
    public void addLogListener(LogListener listener) {
        if (this.logListeners == null) {
            this.logListeners = new LinkedHashSet<LogListener>();
        }
        this.logListeners.add(listener);
    }

    @Override
    public void setStreamCaching(Boolean cache) {
        this.streamCache = cache;
    }

    @Override
    public Boolean isStreamCaching() {
        return this.streamCache;
    }

    @Override
    public void setTracing(Boolean tracing) {
        this.trace = tracing;
    }

    @Override
    public Boolean isTracing() {
        return this.trace;
    }

    @Override
    public String getTracingPattern() {
        return this.tracePattern;
    }

    @Override
    public void setTracingPattern(String tracePattern) {
        this.tracePattern = tracePattern;
    }

    @Override
    public Boolean isBacklogTracing() {
        return this.backlogTrace;
    }

    @Override
    public void setBacklogTracing(Boolean backlogTrace) {
        this.backlogTrace = backlogTrace;
    }

    @Override
    public void setDebugging(Boolean debug) {
        this.debug = debug;
    }

    @Override
    public Boolean isDebugging() {
        return this.debug;
    }

    @Override
    public void setMessageHistory(Boolean messageHistory) {
        this.messageHistory = messageHistory;
    }

    @Override
    public Boolean isMessageHistory() {
        return this.messageHistory;
    }

    @Override
    public void setLogMask(Boolean logMask) {
        this.logMask = logMask;
    }

    @Override
    public Boolean isLogMask() {
        return this.logMask != null && this.logMask != false;
    }

    @Override
    public Boolean isLogExhaustedMessageBody() {
        return this.logExhaustedMessageBody;
    }

    @Override
    public void setLogExhaustedMessageBody(Boolean logExhaustedMessageBody) {
        this.logExhaustedMessageBody = logExhaustedMessageBody;
    }

    @Override
    public Long getDelayer() {
        return this.delay;
    }

    @Override
    public void setDelayer(Long delay) {
        this.delay = delay;
    }

    @Override
    public ProducerTemplate createProducerTemplate() {
        return this.createProducerTemplate(0);
    }

    @Override
    public ProducerTemplate createProducerTemplate(int maximumCacheSize) {
        DefaultProducerTemplate answer = new DefaultProducerTemplate(this.getCamelContextReference());
        answer.setMaximumCacheSize(maximumCacheSize);
        try {
            this.startService(answer);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
        return answer;
    }

    @Override
    public FluentProducerTemplate createFluentProducerTemplate() {
        return this.createFluentProducerTemplate(0);
    }

    @Override
    public FluentProducerTemplate createFluentProducerTemplate(int maximumCacheSize) {
        DefaultFluentProducerTemplate answer = new DefaultFluentProducerTemplate(this.getCamelContextReference());
        answer.setMaximumCacheSize(maximumCacheSize);
        try {
            this.startService(answer);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
        return answer;
    }

    @Override
    public ConsumerTemplate createConsumerTemplate() {
        return this.createConsumerTemplate(0);
    }

    @Override
    public ConsumerTemplate createConsumerTemplate(int maximumCacheSize) {
        DefaultConsumerTemplate answer = new DefaultConsumerTemplate(this.getCamelContextReference());
        answer.setMaximumCacheSize(maximumCacheSize);
        try {
            this.startService(answer);
        }
        catch (Exception e) {
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
        return answer;
    }

    @Override
    public ErrorHandlerFactory getErrorHandlerFactory() {
        return this.errorHandlerFactory;
    }

    @Override
    public void setErrorHandlerFactory(ErrorHandlerFactory errorHandlerFactory) {
        this.errorHandlerFactory = errorHandlerFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScheduledExecutorService getErrorHandlerExecutorService() {
        if (this.errorHandlerExecutorService == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.errorHandlerExecutorService == null) {
                    this.errorHandlerExecutorService = this.createErrorHandlerExecutorService();
                }
            }
        }
        return this.errorHandlerExecutorService;
    }

    public void setErrorHandlerExecutorService(ScheduledExecutorService errorHandlerExecutorService) {
        this.errorHandlerExecutorService = errorHandlerExecutorService;
    }

    protected ScheduledExecutorService createErrorHandlerExecutorService() {
        return this.getExecutorServiceManager().newDefaultScheduledThreadPool("ErrorHandlerRedeliveryThreadPool", "ErrorHandlerRedeliveryTask");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UnitOfWorkFactory getUnitOfWorkFactory() {
        if (this.unitOfWorkFactory == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.unitOfWorkFactory == null) {
                    this.setUnitOfWorkFactory(this.createUnitOfWorkFactory());
                }
            }
        }
        return this.unitOfWorkFactory;
    }

    @Override
    public void setUnitOfWorkFactory(UnitOfWorkFactory unitOfWorkFactory) {
        this.unitOfWorkFactory = this.doAddService(unitOfWorkFactory);
    }

    @Override
    public RuntimeEndpointRegistry getRuntimeEndpointRegistry() {
        return this.runtimeEndpointRegistry;
    }

    @Override
    public void setRuntimeEndpointRegistry(RuntimeEndpointRegistry runtimeEndpointRegistry) {
        this.runtimeEndpointRegistry = this.doAddService(runtimeEndpointRegistry);
    }

    @Override
    public String getUptime() {
        long delta = this.getUptimeMillis();
        if (delta == 0L) {
            return "";
        }
        return TimeUtils.printDuration(delta);
    }

    @Override
    public long getUptimeMillis() {
        if (this.startDate == 0L) {
            return 0L;
        }
        return System.currentTimeMillis() - this.startDate;
    }

    @Override
    public Date getStartDate() {
        if (this.startDate == 0L) {
            return null;
        }
        return new Date(this.startDate);
    }

    @Override
    public boolean isEventNotificationApplicable() {
        return this.eventNotificationApplicable;
    }

    @Override
    public void setEventNotificationApplicable(boolean eventNotificationApplicable) {
        this.eventNotificationApplicable = eventNotificationApplicable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getVersion() {
        if (this.version == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.version == null) {
                    this.version = this.doGetVersion();
                }
            }
        }
        return this.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String doGetVersion() {
        Package aPackage;
        String version;
        block6: {
            version = null;
            InputStream is = null;
            try {
                Properties p = new Properties();
                is = AbstractCamelContext.class.getResourceAsStream("/META-INF/maven/org.apache.camel/camel-base-engine/pom.properties");
                if (is != null) {
                    p.load(is);
                    version = p.getProperty("version", "");
                }
                if (is == null) break block6;
            }
            catch (Exception p) {
                if (is != null) {
                    IOHelper.close(is);
                }
                break block6;
            }
            catch (Throwable throwable) {
                if (is == null) throw throwable;
                IOHelper.close(is);
                throw throwable;
            }
            IOHelper.close((Closeable)is);
        }
        if (version == null && (aPackage = this.getClass().getPackage()) != null && (version = aPackage.getImplementationVersion()) == null) {
            version = aPackage.getSpecificationVersion();
        }
        if (version != null) return version;
        return "";
    }

    @Override
    protected void doSuspend() throws Exception {
        EventHelper.notifyCamelContextSuspending(this);
        LOG.info("Apache Camel {} ({}) is suspending", (Object)this.getVersion(), (Object)this.getName());
        StopWatch watch = new StopWatch();
        for (Map.Entry<String, RouteService> entry : this.getRouteServices().entrySet()) {
            if (!entry.getValue().getStatus().isStarted()) continue;
            this.suspendedRouteServices.put(entry.getKey(), entry.getValue());
        }
        ArrayList<RouteStartupOrder> orders = new ArrayList<RouteStartupOrder>();
        for (Map.Entry<String, RouteService> entry : this.suspendedRouteServices.entrySet()) {
            Route route = entry.getValue().getRoute();
            Integer order = route.getStartupOrder();
            if (order == null) {
                order = this.defaultRouteStartupOrder++;
            }
            orders.add(new DefaultRouteStartupOrder(order, route, entry.getValue()));
        }
        this.getShutdownStrategy().suspend(this, orders);
        for (RouteService service : this.suspendedRouteServices.values()) {
            if (this.routeSupportsSuspension(service.getId())) {
                service.suspend();
                continue;
            }
            service.stop();
        }
        watch.taken();
        if (LOG.isInfoEnabled()) {
            LOG.info("Apache Camel {} ({}) is suspended in {}", new Object[]{this.getVersion(), this.getName(), TimeUtils.printDuration(watch.taken())});
        }
        EventHelper.notifyCamelContextSuspended(this);
    }

    @Override
    protected void doResume() throws Exception {
        try {
            EventHelper.notifyCamelContextResuming(this);
            LOG.info("Apache Camel {} ({}) is resuming", (Object)this.getVersion(), (Object)this.getName());
            StopWatch watch = new StopWatch();
            this.internalRouteStartupManager.doStartOrResumeRoutes(this.suspendedRouteServices, false, true, true, false);
            for (RouteService service : this.suspendedRouteServices.values()) {
                if (this.routeSupportsSuspension(service.getId())) {
                    service.resume();
                    continue;
                }
                service.start();
            }
            if (LOG.isInfoEnabled()) {
                LOG.info("Resumed {} routes", (Object)this.suspendedRouteServices.size());
                LOG.info("Apache Camel {} ({}) resumed in {}", new Object[]{this.getVersion(), this.getName(), TimeUtils.printDuration(watch.taken())});
            }
            this.suspendedRouteServices.clear();
            EventHelper.notifyCamelContextResumed(this);
        }
        catch (Exception e) {
            EventHelper.notifyCamelContextResumeFailed(this, e);
            throw e;
        }
    }

    @Override
    protected AutoCloseable doLifecycleChange() {
        return new LifecycleHelper();
    }

    @Override
    public void init() {
        try {
            super.init();
        }
        catch (RuntimeCamelException e) {
            if (e.getCause() != null && e.getCause() instanceof VetoCamelContextStartException) {
                this.vetoed = (VetoCamelContextStartException)e.getCause();
            }
            throw e;
        }
        if (this.vetoed != null) {
            LOG.info("CamelContext ({}) vetoed to not initialize due to {}", (Object)this.getName(), (Object)this.vetoed.getMessage());
            this.failOnStartup(this.vetoed);
            return;
        }
    }

    @Override
    public void start() {
        super.start();
        if (this.vetoed != null) {
            LOG.info("CamelContext ({}) vetoed to not start due to {}", (Object)this.getName(), (Object)this.vetoed.getMessage());
            this.failOnStartup(this.vetoed);
            this.stop();
            return;
        }
        for (LifecycleStrategy strategy : this.lifecycleStrategies) {
            try {
                strategy.onContextStarted(this);
            }
            catch (Throwable e) {
                LOG.warn("Lifecycle strategy {} failed on CamelContext ({}) due to: {}. This exception will be ignored", new Object[]{strategy, this.getName(), e.getMessage()});
            }
        }
        EventHelper.notifyCamelContextStarted(this);
        for (StartupListener startup : this.startupListeners) {
            try {
                startup.onCamelContextFullyStarted(this, this.isStarted());
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeException(e);
            }
        }
    }

    @Override
    public void stop() {
        for (LifecycleStrategy strategy : this.lifecycleStrategies) {
            try {
                strategy.onContextStopping(this);
                strategy.onContextStop(this);
            }
            catch (Throwable e) {
                LOG.warn("Lifecycle strategy {} failed on CamelContext ({}) due to: {}. This exception will be ignored", new Object[]{strategy, this.getName(), e.getMessage()});
            }
        }
        super.stop();
    }

    @Override
    public void doBuild() throws Exception {
        StartupStepRecorder fr;
        StopWatch watch = new StopWatch();
        if (this.startupStepRecorder.getClass().getSimpleName().equals("DefaultStartupStepRecorder") && (fr = (StartupStepRecorder)this.getBootstrapFactoryFinder().newInstance("startup-step-recorder", StartupStepRecorder.class).orElse(null)) != null) {
            LOG.debug("Discovered startup recorder: {} from classpath", (Object)fr);
            this.startupStepRecorder = fr;
        }
        this.startupStepRecorder.start();
        StartupStep step = this.startupStepRecorder.beginStep(CamelContext.class, null, "Build CamelContext");
        if (this.initialization != Initialization.Lazy) {
            StartupStep subStep = this.startupStepRecorder.beginStep(CamelContext.class, null, "Setup LRUCacheFactory");
            LRUCacheFactory.init();
            this.startupStepRecorder.endStep(subStep);
        }
        StartupStep step3 = this.startupStepRecorder.beginStep(CamelContext.class, null, "Setup Management");
        this.setupManagement(null);
        this.startupStepRecorder.endStep(step3);
        HealthCheckRegistry hcr = this.getExtension(HealthCheckRegistry.class);
        if (hcr == null) {
            StartupStep step4 = this.startupStepRecorder.beginStep(CamelContext.class, null, "Setup HealthCheckRegistry");
            hcr = this.createHealthCheckRegistry();
            if (hcr != null) {
                hcr.setCamelContext(this);
                this.setExtension(HealthCheckRegistry.class, hcr);
            }
            this.startupStepRecorder.endStep(step4);
        }
        CamelContextTracker.notifyContextCreated(this);
        if (this.eagerCreateTypeConverter()) {
            StartupStep step5 = this.startupStepRecorder.beginStep(CamelContext.class, null, "Setting up TypeConverter");
            this.getOrCreateTypeConverter();
            this.startupStepRecorder.endStep(step5);
        }
        this.startupStepRecorder.endStep(step);
        this.buildTaken = watch.taken();
        LOG.debug("Apache Camel {} ({}) built in {}", new Object[]{this.getVersion(), this.getName(), TimeUtils.printDuration(this.buildTaken)});
    }

    protected void resetBuildTime() {
        this.buildTaken = 0L;
    }

    @Override
    public void doInit() throws Exception {
        StopWatch watch = new StopWatch();
        this.vetoed = null;
        StartupStep step = this.startupStepRecorder.beginStep(CamelContext.class, null, "Init CamelContext");
        this.routeController = this.getRouteController();
        if ((this.startupSummaryLevel == StartupSummaryLevel.Classic || this.startupSummaryLevel == StartupSummaryLevel.Verbose) && this.routeController.getLoggingLevel().ordinal() < LoggingLevel.INFO.ordinal()) {
            this.routeController.setLoggingLevel(LoggingLevel.INFO);
        }
        this.shutdownStrategy = this.getShutdownStrategy();
        if ((this.startupSummaryLevel == StartupSummaryLevel.Classic || this.startupSummaryLevel == StartupSummaryLevel.Verbose) && this.shutdownStrategy != null && this.shutdownStrategy.getLoggingLevel().ordinal() < LoggingLevel.INFO.ordinal()) {
            this.shutdownStrategy.setLoggingLevel(LoggingLevel.INFO);
        }
        this.eventNotificationApplicable = EventHelper.eventsApplicable(this);
        if (this.loadTypeConverters.booleanValue() && this.typeConverter instanceof AnnotationScanTypeConverters) {
            StartupStep step2 = this.startupStepRecorder.beginStep(CamelContext.class, null, "Scan TypeConverters");
            ((AnnotationScanTypeConverters)((Object)this.typeConverter)).scanTypeConverters();
            this.startupStepRecorder.endStep(step2);
        }
        if (this.loadHealthChecks.booleanValue()) {
            Iterator<Object> step3 = this.startupStepRecorder.beginStep(CamelContext.class, null, "Scan HealthChecks");
            HealthCheckRegistry healthCheckRegistry = this.getExtension(HealthCheckRegistry.class);
            if (healthCheckRegistry != null) {
                healthCheckRegistry.loadHealthChecks();
            }
            this.startupStepRecorder.endStep((StartupStep)((Object)step3));
        }
        if (this.globalOptions != null && !this.globalOptions.isEmpty()) {
            for (Map.Entry entry : this.globalOptions.entrySet()) {
                String replaced;
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (value == null || value.equals(replaced = this.resolvePropertyPlaceholders(value))) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Camel property with key {} replaced value from {} -> {}", new Object[]{key, value, replaced});
                }
                entry.setValue(replaced);
            }
        }
        this.forceLazyInitialization();
        this.addService(this.getManagementStrategy(), false);
        this.lifecycleStrategies.sort(OrderedComparator.get());
        ServiceHelper.initService(this.lifecycleStrategies);
        for (LifecycleStrategy lifecycleStrategy : this.lifecycleStrategies) {
            try {
                lifecycleStrategy.onContextInitializing(this);
            }
            catch (VetoCamelContextStartException e) {
                LOG.warn("Lifecycle strategy {} vetoed initializing CamelContext ({}) due to: {}", new Object[]{lifecycleStrategy, this.getName(), e.getMessage()});
                throw e;
            }
            catch (Exception e) {
                LOG.warn("Lifecycle strategy {} failed initializing CamelContext ({}) due to: {}", new Object[]{lifecycleStrategy, this.getName(), e.getMessage()});
                throw e;
            }
        }
        this.eventNotificationApplicable = EventHelper.eventsApplicable(this);
        for (EventNotifier eventNotifier : this.getManagementStrategy().getEventNotifiers()) {
            if (eventNotifier instanceof Service) {
                Service service = (Service)((Object)eventNotifier);
                for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                    strategy.onServiceAdd(this.getCamelContextReference(), service, null);
                }
            }
            ServiceHelper.initService((Object)eventNotifier);
        }
        EventHelper.notifyCamelContextInitializing(this);
        this.endpoints = this.doAddService(this.createEndpointRegistry(this.endpoints));
        if (this.runtimeEndpointRegistry == null && this.getManagementStrategy() != null && this.getManagementStrategy().getManagementAgent() != null) {
            boolean extended;
            Boolean isEnabled = this.getManagementStrategy().getManagementAgent().getEndpointRuntimeStatisticsEnabled();
            boolean bl = this.getManagementStrategy().getManagementAgent().getStatisticsLevel().isExtended();
            boolean bl2 = extended = bl || isEnabled != null && isEnabled != false;
            if (extended) {
                this.runtimeEndpointRegistry = new DefaultRuntimeEndpointRegistry();
            }
        }
        if (this.runtimeEndpointRegistry != null) {
            if (this.runtimeEndpointRegistry instanceof EventNotifier && this.getManagementStrategy() != null) {
                this.getManagementStrategy().addEventNotifier((EventNotifier)((Object)this.runtimeEndpointRegistry));
            }
            this.addService(this.runtimeEndpointRegistry, true, true);
        }
        this.bindDataFormats();
        ServiceHelper.initService(this.components.values());
        for (RouteTemplateParameterSource routeTemplateParameterSource : this.getRegistry().findByType(RouteTemplateParameterSource.class)) {
            for (String routeId : routeTemplateParameterSource.routeIds()) {
                String id;
                HashMap<String, Object> map = new HashMap<String, Object>(routeTemplateParameterSource.parameters(routeId));
                Object templateId = map.remove("templateId");
                if (templateId == null) {
                    templateId = map.remove("template-id");
                }
                String string = id = templateId != null ? templateId.toString() : null;
                if (id == null) {
                    throw new IllegalArgumentException("RouteTemplateParameterSource with routeId: " + routeId + " has no templateId defined");
                }
                this.addRouteFromTemplate(routeId, id, map);
            }
        }
        StartupStep subStep = this.startupStepRecorder.beginStep(CamelContext.class, this.getName(), "Init Routes");
        this.startRouteDefinitions();
        this.internalRouteStartupManager.doInitRoutes(this.routeServices);
        this.startupStepRecorder.endStep(subStep);
        if (!this.lifecycleStrategies.isEmpty()) {
            subStep = this.startupStepRecorder.beginStep(CamelContext.class, this.getName(), "LifecycleStrategy onContextInitialized");
            for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                try {
                    strategy.onContextInitialized(this);
                }
                catch (VetoCamelContextStartException e) {
                    LOG.warn("Lifecycle strategy {} vetoed initializing CamelContext ({}) due to: {}", new Object[]{strategy, this.getName(), e.getMessage()});
                    throw e;
                }
                catch (Exception e) {
                    LOG.warn("Lifecycle strategy {} failed initializing CamelContext ({}) due to: {}", new Object[]{strategy, this.getName(), e.getMessage()});
                    throw e;
                }
            }
            this.startupStepRecorder.endStep(subStep);
        }
        EventHelper.notifyCamelContextInitialized(this);
        this.startupStepRecorder.endStep(step);
        this.initTaken = watch.taken();
        LOG.debug("Apache Camel {} ({}) initialized in {}", new Object[]{this.getVersion(), this.getName(), TimeUtils.printDuration(this.initTaken)});
    }

    @Override
    protected void doStart() throws Exception {
        if (this.firstStartDone) {
            LOG.warn("Starting CamelContext: {} after the context has been stopped is not recommended", (Object)this.getName());
        }
        StartupStep step = this.startupStepRecorder.beginStep(CamelContext.class, this.getName(), "Start CamelContext");
        try {
            this.doStartContext();
        }
        catch (Exception e) {
            EventHelper.notifyCamelContextStartupFailed(this, e);
            throw e;
        }
        this.startupStepRecorder.endStep(step);
        if (this.startupStepRecorder.getStartupRecorderDuration() < 0L) {
            this.startupStepRecorder.stop();
        }
    }

    protected void doStartContext() throws Exception {
        if (this.startupSummaryLevel == StartupSummaryLevel.Classic) {
            LOG.info("Apache Camel {} ({}) is starting", (Object)this.getVersion(), (Object)this.getName());
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Apache Camel {} ({}) is starting", (Object)this.getVersion(), (Object)this.getName());
        }
        this.vetoed = null;
        this.startDate = System.currentTimeMillis();
        this.stopWatch.restart();
        this.startService(this.routeController);
        boolean bl = this.doNotStartRoutesOnFirstStart = !this.firstStartDone && this.isAutoStartup() == false;
        if (this.firstStartDone && !this.isAutoStartup().booleanValue() && this.isStarted()) {
            try {
                this.internalRouteStartupManager.doStartOrResumeRoutes(this.routeServices, true, true, false, true);
            }
            catch (Exception e) {
                throw RuntimeCamelException.wrapRuntimeException(e);
            }
        }
        try {
            this.firstStartDone = true;
            this.doStartCamel();
        }
        catch (Exception e) {
            VetoCamelContextStartException veto = ObjectHelper.getException(VetoCamelContextStartException.class, e);
            if (veto != null) {
                this.vetoed = veto;
                return;
            }
            LOG.error("Error starting CamelContext (" + this.getName() + ") due to exception thrown: " + e.getMessage(), (Throwable)e);
            throw RuntimeCamelException.wrapRuntimeException(e);
        }
        this.logDuplicateComponents();
        if (this.startupSummaryLevel == StartupSummaryLevel.Classic) {
            this.logClassicStartSummary();
        } else {
            this.logStartSummary();
        }
        for (BootstrapCloseable bootstrap : this.bootstraps) {
            try {
                bootstrap.close();
            }
            catch (Exception e) {
                LOG.warn("Error during closing bootstrap. This exception is ignored.", (Throwable)e);
            }
        }
        this.bootstraps.clear();
        if (this.adapt(ExtendedCamelContext.class).getExchangeFactory().isPooled()) {
            LOG.info("Pooled mode enabled. Camel pools and reuses objects to reduce JVM object allocations. The pool capacity is: " + this.adapt(ExtendedCamelContext.class).getExchangeFactory().getCapacity() + " elements.");
        }
        if (this.isLightweight()) {
            LOG.info("Lightweight mode enabled. Performing optimizations and memory reduction.");
            ReifierStrategy.clearReifiers();
            this.adapt(ExtendedCamelContext.class).disposeModel();
        }
    }

    protected void logDuplicateComponents() {
        if (LOG.isInfoEnabled()) {
            LinkedHashMap<Class, Set> counters = new LinkedHashMap<Class, Set>();
            TreeSet<String> cnames = new TreeSet<String>(this.getComponentNames());
            for (String string : cnames) {
                Class<?> source = this.getComponent(string).getClass();
                if (counters.containsKey(source)) continue;
                for (String targetName : cnames) {
                    Class<?> target = this.getComponent(targetName).getClass();
                    if (source != target) continue;
                    Set names = counters.computeIfAbsent(source, k -> new TreeSet());
                    names.add(targetName);
                }
            }
            for (Map.Entry entry : counters.entrySet()) {
                int count = ((Set)entry.getValue()).size();
                if (count <= 1) continue;
                String fqn = ((Class)entry.getKey()).getName();
                String names = String.join((CharSequence)", ", (Iterable)entry.getValue());
                LOG.info("Using {} instances of same component class: {} with names: {}", new Object[]{count, fqn, names});
            }
        }
    }

    protected void logClassicStartSummary() {
        if (LOG.isInfoEnabled()) {
            int started = 0;
            for (Route route : this.getRoutes()) {
                ServiceStatus status = this.getRouteStatus(route.getId());
                if (status == null || !status.isStarted()) continue;
                ++started;
            }
            Collection<Route> controlledRoutes = this.getRouteController().getControlledRoutes();
            if (controlledRoutes.isEmpty()) {
                LOG.info("Total {} routes, of which {} are started", (Object)this.getRoutes().size(), (Object)started);
            } else {
                LOG.info("Total {} routes, of which {} are started, and {} are managed by RouteController: {}", new Object[]{this.getRoutes().size(), started, controlledRoutes.size(), this.getRouteController().getClass().getName()});
            }
            LOG.info("Apache Camel {} ({}) started in {}", new Object[]{this.getVersion(), this.getName(), TimeUtils.printDuration(this.stopWatch.taken())});
        }
    }

    protected void logStartSummary() {
        boolean supervised = this.getRouteController().isSupervising();
        if (!supervised && this.startupSummaryLevel != StartupSummaryLevel.Oneline && this.startupSummaryLevel != StartupSummaryLevel.Off && LOG.isInfoEnabled()) {
            String cid;
            String loc;
            String uri;
            String status;
            String id;
            int started = 0;
            int total = 0;
            int disabled = 0;
            ArrayList<String> lines = new ArrayList<String>();
            ArrayList<String> configs = new ArrayList<String>();
            this.routeStartupOrder.sort(Comparator.comparingInt(RouteStartupOrder::getStartupOrder));
            for (RouteStartupOrder order : this.routeStartupOrder) {
                ++total;
                id = order.getRoute().getRouteId();
                status = this.getRouteStatus(id).name();
                if (ServiceStatus.Started.name().equals(status)) {
                    ++started;
                }
                uri = order.getRoute().getEndpoint().getEndpointBaseUri();
                uri = URISupport.sanitizeUri(uri);
                String string = loc = order.getRoute().getSourceResource() != null ? order.getRoute().getSourceResource().getLocation() : null;
                if (this.startupSummaryLevel == StartupSummaryLevel.Verbose && loc != null) {
                    lines.add(String.format("    %s %s (%s) (source: %s)", status, id, uri, loc));
                } else {
                    lines.add(String.format("    %s %s (%s)", status, id, uri));
                }
                if ((cid = order.getRoute().getConfigurationId()) == null) continue;
                configs.add(String.format("    %s (%s)", id, cid));
            }
            for (Route route : this.routes) {
                if (route.isAutoStartup().booleanValue()) continue;
                ++total;
                ++disabled;
                id = route.getRouteId();
                status = this.getRouteStatus(id).name();
                if (ServiceStatus.Stopped.name().equals(status)) {
                    status = "Disabled";
                }
                uri = route.getEndpoint().getEndpointBaseUri();
                uri = URISupport.sanitizeUri(uri);
                String string = loc = route.getSourceResource() != null ? route.getSourceResource().getLocation() : null;
                if (this.startupSummaryLevel == StartupSummaryLevel.Verbose && loc != null) {
                    lines.add(String.format("    %s %s (%s) (source: %s)", status, id, uri, loc));
                } else {
                    lines.add(String.format("    %s %s (%s)", status, id, uri));
                }
                if ((cid = route.getConfigurationId()) == null) continue;
                configs.add(String.format("    %s (%s)", id, cid));
            }
            if (disabled > 0) {
                LOG.info("Routes startup (total:{} started:{} disabled:{})", new Object[]{total, started, disabled});
            } else {
                LOG.info("Routes startup (total:{} started:{})", (Object)total, (Object)started);
            }
            if (this.startupSummaryLevel == StartupSummaryLevel.Default || this.startupSummaryLevel == StartupSummaryLevel.Verbose) {
                for (String line : lines) {
                    LOG.info(line);
                }
                if (this.startupSummaryLevel == StartupSummaryLevel.Verbose) {
                    LOG.info("Routes configuration:");
                    for (String line : configs) {
                        LOG.info(line);
                    }
                }
            }
        }
        if (this.startupSummaryLevel != StartupSummaryLevel.Off && LOG.isInfoEnabled()) {
            long taken = this.stopWatch.taken();
            long max = this.buildTaken + this.initTaken + taken;
            String total = TimeUtils.printDuration(max);
            String start = TimeUtils.printDuration(taken);
            String init = TimeUtils.printDuration(this.initTaken);
            String built = TimeUtils.printDuration(this.buildTaken);
            LOG.info("Apache Camel {} ({}) started in {} (build:{} init:{} start:{})", new Object[]{this.getVersion(), this.getName(), total, built, init, start});
        }
    }

    protected void doStartCamel() throws Exception {
        long invokedCounter;
        long cacheCounter;
        Object subStep;
        if (!this.adapt(ExtendedCamelContext.class).getBeanPostProcessor().isEnabled()) {
            LOG.info("BeanPostProcessor is disabled. Dependency injection of Camel annotations in beans is not supported.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using ClassResolver={}, PackageScanClassResolver={}, ApplicationContextClassLoader={}, RouteController={}", new Object[]{this.getClassResolver(), this.getPackageScanClassResolver(), this.getApplicationContextClassLoader(), this.getRouteController()});
        }
        if (this.isStreamCaching().booleanValue()) {
            LOG.info("StreamCaching is enabled on CamelContext: {}", (Object)this.getName());
        }
        if (this.isBacklogTracing().booleanValue()) {
            LOG.info("Backlog Tracing is enabled on CamelContext: {}", (Object)this.getName());
        }
        if (this.isTracing().booleanValue()) {
            LOG.info("Tracing is enabled on CamelContext: {}", (Object)this.getName());
        }
        if (this.isUseMDCLogging().booleanValue()) {
            String pattern = this.getMDCLoggingKeysPattern();
            if (pattern != null) {
                LOG.info("MDC logging (keys-pattern: {}) is enabled on CamelContext: {}", (Object)pattern, (Object)this.getName());
            } else {
                LOG.info("MDC logging is enabled on CamelContext: {}", (Object)this.getName());
            }
        }
        if (this.getDelayer() != null && this.getDelayer() > 0L) {
            LOG.info("Delayer is enabled with: {} ms. on CamelContext: {}", (Object)this.getDelayer(), (Object)this.getName());
        }
        ManagementStrategy managementStrategy = this.getManagementStrategy();
        this.startService(managementStrategy);
        if (!this.lifecycleStrategies.isEmpty()) {
            subStep = this.startupStepRecorder.beginStep(CamelContext.class, this.getName(), "LifecycleStrategy onContextStarting");
            this.startServices(this.lifecycleStrategies);
            for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                try {
                    strategy.onContextStarting(this);
                    strategy.onContextStart(this);
                }
                catch (VetoCamelContextStartException e) {
                    LOG.warn("Lifecycle strategy {} vetoed starting CamelContext ({}) due to: {}", new Object[]{strategy, this.getName(), e.getMessage()});
                    throw e;
                }
                catch (Exception e) {
                    LOG.warn("Lifecycle strategy {} failed starting CamelContext ({}) due to: {}", new Object[]{strategy, this.getName(), e.getMessage()});
                    throw e;
                }
            }
            this.startupStepRecorder.endStep((StartupStep)subStep);
        }
        for (Map.Entry entry : this.components.entrySet()) {
            StartupStep step = this.startupStepRecorder.beginStep(Component.class, (String)entry.getKey(), "Start Component");
            try {
                this.startService((Service)entry.getValue());
            }
            catch (Exception e) {
                throw new FailedToStartComponentException((String)entry.getKey(), e.getMessage(), e);
            }
            finally {
                this.startupStepRecorder.endStep(step);
            }
        }
        if (!this.startupListeners.isEmpty()) {
            subStep = this.startupStepRecorder.beginStep(CamelContext.class, this.getName(), "StartupListener onCamelContextStarting");
            this.startupListeners.sort(OrderedComparator.get());
            for (StartupListener startup : this.startupListeners) {
                startup.onCamelContextStarting(this.getCamelContextReference(), this.isStarted());
            }
            this.startupStepRecorder.endStep((StartupStep)subStep);
        }
        for (EventNotifier eventNotifier : this.getManagementStrategy().getEventNotifiers()) {
            if (!(eventNotifier instanceof Service)) continue;
            this.startService((Service)((Object)eventNotifier));
        }
        EventHelper.notifyCamelContextStarting(this);
        if (this.isUseDataType().booleanValue()) {
            LOG.info("Message DataType is enabled on CamelContext: {}", (Object)this.getName());
        }
        if (this.isStreamCachingInUse()) {
            this.getStreamCachingStrategy().setEnabled(true);
        } else {
            LOG.debug("StreamCaching is not in use. If using streams then it's recommended to enable stream caching. See more details at http://camel.apache.org/stream-caching.html");
        }
        if (this.isAllowUseOriginalMessage().booleanValue()) {
            LOG.debug("AllowUseOriginalMessage enabled because UseOriginalMessage is in use");
        }
        LOG.debug("Using HeadersMapFactory: {}", (Object)this.getHeadersMapFactory());
        if (this.isCaseInsensitiveHeaders().booleanValue() && !this.getHeadersMapFactory().isCaseInsensitive()) {
            LOG.info("HeadersMapFactory: {} is case-sensitive which can cause problems for protocols such as HTTP based, which rely on case-insensitive headers.", (Object)this.getHeadersMapFactory());
        } else if (!this.isCaseInsensitiveHeaders().booleanValue()) {
            LOG.info("Case-insensitive headers is not in use. This can cause problems for protocols such as HTTP based, which rely on case-insensitive headers.");
        }
        if (!this.getReactiveExecutor().getClass().getSimpleName().equals("DefaultReactiveExecutor")) {
            LOG.info("Using ReactiveExecutor: {}", (Object)this.getReactiveExecutor());
        } else {
            LOG.debug("Using ReactiveExecutor: {}", (Object)this.getReactiveExecutor());
        }
        if (!this.getExecutorServiceManager().getThreadPoolFactory().getClass().getSimpleName().equals("DefaultThreadPoolFactory")) {
            LOG.info("Using ThreadPoolFactory: {}", (Object)this.getExecutorServiceManager().getThreadPoolFactory());
        } else {
            LOG.debug("Using ThreadPoolFactory: {}", (Object)this.getExecutorServiceManager().getThreadPoolFactory());
        }
        HealthCheckRegistry hcr = this.getExtension(HealthCheckRegistry.class);
        if (hcr != null && hcr.isEnabled()) {
            LOG.debug("Using HealthCheck: {}", (Object)hcr.getId());
        }
        if (this.doNotStartRoutesOnFirstStart) {
            LOG.debug("Skip starting routes as CamelContext has been configured with autoStartup=false");
        }
        if (this.isDumpRoutes() != null && this.isDumpRoutes().booleanValue()) {
            this.doDumpRoutes();
        }
        StartupStep startupStep = this.startupStepRecorder.beginStep(CamelContext.class, this.getName(), "Start Routes");
        EventHelper.notifyCamelContextRoutesStarting(this);
        this.internalRouteStartupManager.doStartOrResumeRoutes(this.routeServices, true, !this.doNotStartRoutesOnFirstStart, false, true);
        EventHelper.notifyCamelContextRoutesStarted(this);
        this.startupStepRecorder.endStep(startupStep);
        long l = cacheCounter = this.beanIntrospection != null ? this.beanIntrospection.getCachedClassesCounter() : 0L;
        if (cacheCounter > 0L) {
            LOG.debug("Clearing BeanIntrospection cache with {} objects using during starting Camel", (Object)cacheCounter);
            this.beanIntrospection.clearCache();
        }
        long l2 = invokedCounter = this.beanIntrospection != null ? this.beanIntrospection.getInvokedCounter() : 0L;
        if (invokedCounter > 0L) {
            LOG.debug("BeanIntrospection invoked {} times during starting Camel", (Object)invokedCounter);
        }
    }

    @Override
    protected void doStop() throws Exception {
        this.stopWatch.restart();
        if (this.startupSummaryLevel != StartupSummaryLevel.Oneline && this.startupSummaryLevel != StartupSummaryLevel.Off) {
            if (this.shutdownStrategy != null && this.shutdownStrategy.getTimeUnit() != null) {
                long timeout = this.shutdownStrategy.getTimeUnit().toMillis(this.shutdownStrategy.getTimeout());
                String to = TimeUtils.printDuration(timeout);
                LOG.info("Apache Camel {} ({}) shutting down (timeout:{})", new Object[]{this.getVersion(), this.getName(), to});
            } else {
                LOG.info("Apache Camel {} ({}) shutting down", (Object)this.getVersion(), (Object)this.getName());
            }
        }
        EventHelper.notifyCamelContextStopping(this);
        EventHelper.notifyCamelContextRoutesStopping(this);
        ServiceHelper.stopAndShutdownService(this.routeController);
        try {
            if (this.shutdownStrategy != null) {
                this.shutdownStrategy.shutdownForced(this, this.getRouteStartupOrder());
            }
        }
        catch (Throwable e) {
            LOG.warn("Error occurred while shutting down routes. This exception will be ignored.", e);
        }
        this.shutdownServices(this.asyncProcessorAwaitManager);
        for (RouteService routeService : this.routeServices.values()) {
            boolean found = this.routeStartupOrder.stream().anyMatch(o -> o.getRoute().getId().equals(routeService.getId()));
            if (found) continue;
            LOG.debug("Route: {} which failed to startup will be stopped", (Object)routeService.getId());
            this.routeStartupOrder.add(this.internalRouteStartupManager.doPrepareRouteToBeStarted(routeService));
        }
        this.routeStartupOrder.sort(Comparator.comparingInt(RouteStartupOrder::getStartupOrder).reversed());
        ArrayList<RouteService> list = new ArrayList<RouteService>();
        for (RouteStartupOrder startupOrder : this.routeStartupOrder) {
            DefaultRouteStartupOrder order = (DefaultRouteStartupOrder)startupOrder;
            RouteService routeService = order.getRouteService();
            list.add(routeService);
        }
        this.shutdownServices(list, false);
        if (this.startupSummaryLevel != StartupSummaryLevel.Classic && this.startupSummaryLevel != StartupSummaryLevel.Oneline && this.startupSummaryLevel != StartupSummaryLevel.Off) {
            this.logRouteStopSummary(LoggingLevel.INFO);
        }
        this.routeStartupOrder.clear();
        EventHelper.notifyCamelContextRoutesStopped(this);
        this.suspendedRouteServices.clear();
        for (Service service : this.servicesToStop) {
            if (!(service instanceof Consumer)) continue;
            this.shutdownServices(service);
        }
        if (this.errorHandlerExecutorService != null) {
            this.getExecutorServiceManager().shutdownNow(this.errorHandlerExecutorService);
            this.errorHandlerExecutorService = null;
        }
        ServiceHelper.stopAndShutdownService(this.getDebugger());
        this.shutdownServices(this.endpoints.values());
        this.endpoints.clear();
        this.shutdownServices(this.components.values());
        this.components.clear();
        this.shutdownServices(this.languages.values());
        this.languages.clear();
        this.shutdownServices(this.servicesToStop);
        this.servicesToStop.clear();
        try {
            for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                strategy.onContextStopped(this);
            }
        }
        catch (Throwable throwable) {
            LOG.warn("Error occurred while stopping lifecycle strategies. This exception will be ignored.", throwable);
        }
        EventHelper.notifyCamelContextStopped(this);
        if (this.getManagementStrategy() != null) {
            for (EventNotifier notifier : this.getManagementStrategy().getEventNotifiers()) {
                this.shutdownServices(notifier);
            }
        }
        this.shutdownServices(this.managementStrategy);
        this.shutdownServices(this.managementMBeanAssembler);
        this.shutdownServices(this.lifecycleStrategies);
        this.shutdownServices(this.executorServiceManager);
        this.shutdownServices(this.reactiveExecutor);
        ServiceHelper.stopService((Object)this.typeConverter);
        ServiceHelper.stopService((Object)this.typeConverterRegistry);
        ServiceHelper.stopService((Object)this.registry);
        this.forceStopLazyInitialization();
        if (this.startupSummaryLevel == StartupSummaryLevel.Classic) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Apache Camel {} ({}) uptime {}", new Object[]{this.getVersion(), this.getName(), this.getUptime()});
                LOG.info("Apache Camel {} ({}) is shutdown in {}", new Object[]{this.getVersion(), this.getName(), TimeUtils.printDuration(this.stopWatch.taken())});
            }
        } else if (this.startupSummaryLevel != StartupSummaryLevel.Off && LOG.isInfoEnabled()) {
            String string = TimeUtils.printDuration(this.stopWatch.taken());
            LOG.info("Apache Camel {} ({}) shutdown in {} (uptime:{})", new Object[]{this.getVersion(), this.getName(), string, this.getUptime()});
        }
        this.startupStepRecorder.stop();
        this.startDate = 0L;
        CamelContextTracker.notifyContextDestroyed(this);
        this.firstStartDone = true;
    }

    @Override
    protected void doFail(Exception e) {
        super.doFail(e);
        this.firstStartDone = false;
    }

    protected void doDumpRoutes() {
    }

    protected void logRouteStopSummary(LoggingLevel loggingLevel) {
        CamelLogger logger = new CamelLogger(LOG, loggingLevel);
        if (logger.shouldLog()) {
            int total = 0;
            int stopped = 0;
            int forced = 0;
            ArrayList<String> lines = new ArrayList<String>();
            if (this.shutdownStrategy != null && this.shutdownStrategy.isShutdownRoutesInReverseOrder()) {
                this.routeStartupOrder.sort(Comparator.comparingInt(RouteStartupOrder::getStartupOrder).reversed());
            } else {
                this.routeStartupOrder.sort(Comparator.comparingInt(RouteStartupOrder::getStartupOrder));
            }
            for (RouteStartupOrder order : this.routeStartupOrder) {
                ++total;
                String id = order.getRoute().getRouteId();
                String status = this.getRouteStatus(id).name();
                if (ServiceStatus.Stopped.name().equals(status)) {
                    ++stopped;
                }
                if (order.getRoute().getProperties().containsKey("forcedShutdown")) {
                    ++forced;
                    status = "Forced stopped";
                }
                String uri = order.getRoute().getEndpoint().getEndpointBaseUri();
                uri = URISupport.sanitizeUri(uri);
                lines.add(String.format("    %s %s (%s)", status, id, uri));
            }
            if (forced > 0) {
                logger.log(String.format("Routes stopped (total:%s stopped:%s forced:%s)", total, stopped, forced));
            } else {
                logger.log(String.format("Routes stopped (total:%s stopped:%s)", total, stopped));
            }
            if (this.startupSummaryLevel == StartupSummaryLevel.Default || this.startupSummaryLevel == StartupSummaryLevel.Verbose) {
                for (String line : lines) {
                    logger.log(line);
                }
            }
        }
    }

    public void startRouteDefinitions() throws Exception {
    }

    protected boolean isStreamCachingInUse() throws Exception {
        return this.isStreamCaching();
    }

    protected void bindDataFormats() throws Exception {
    }

    protected boolean routeSupportsSuspension(String routeId) {
        RouteService routeService = this.routeServices.get(routeId);
        if (routeService != null) {
            return routeService.getRoute().supportsSuspension();
        }
        return false;
    }

    private void shutdownServices(Object service) {
        try {
            if (service instanceof Service) {
                ServiceHelper.stopAndShutdownService(service);
            } else if (service instanceof Collection) {
                ServiceHelper.stopAndShutdownServices((Collection)service);
            }
        }
        catch (Throwable e) {
            LOG.warn("Error occurred while shutting down service: " + service + ". This exception will be ignored.", e);
            EventHelper.notifyServiceStopFailure(this, service, e);
        }
    }

    private void shutdownServices(Collection<?> services) {
        this.shutdownServices(services, true);
    }

    private void shutdownServices(Collection<?> services, boolean reverse) {
        Collection<?> list = services;
        if (reverse) {
            ArrayList reverseList = new ArrayList(services);
            Collections.reverse(reverseList);
            list = reverseList;
        }
        for (Object service : list) {
            this.shutdownServices(service);
        }
    }

    void startService(Service service) throws Exception {
        if (service instanceof StartupListener) {
            StartupListener listener = (StartupListener)((Object)service);
            this.addStartupListener(listener);
        }
        CamelContextAware.trySetCamelContext(service, this.getCamelContextReference());
        ServiceHelper.startService((Object)service);
    }

    private void startServices(Collection<?> services) throws Exception {
        for (Object element : services) {
            if (!(element instanceof Service)) continue;
            this.startService((Service)element);
        }
    }

    private void stopServices(Object service) throws Exception {
        try {
            ServiceHelper.stopService(service);
        }
        catch (Exception e) {
            EventHelper.notifyServiceStopFailure(this.getCamelContextReference(), service, e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startRouteService(RouteService routeService, boolean addingRoutes) throws Exception {
        boolean alreadyStartingRoutes = this.isStartingRoutes();
        if (!alreadyStartingRoutes) {
            this.setStartingRoutes(true);
        }
        try {
            if (routeService.getStatus().isSuspended()) {
                this.resumeRouteService(routeService);
            } else {
                this.routeServices.put(routeService.getId(), routeService);
                if (this.shouldStartRoutes()) {
                    StartupStep step = this.startupStepRecorder.beginStep(Route.class, routeService.getId(), "Start Route Services");
                    this.internalRouteStartupManager.safelyStartRouteServices(true, true, true, false, addingRoutes, routeService);
                    boolean autoStartup = routeService.isAutoStartup();
                    if (!addingRoutes || autoStartup) {
                        routeService.start();
                    }
                    this.startupStepRecorder.endStep(step);
                }
            }
        }
        finally {
            if (!alreadyStartingRoutes) {
                this.setStartingRoutes(false);
            }
        }
    }

    protected synchronized void resumeRouteService(RouteService routeService) throws Exception {
        if (!routeService.getStatus().isSuspended()) {
            this.startRouteService(routeService, false);
        } else if (this.shouldStartRoutes()) {
            this.internalRouteStartupManager.safelyStartRouteServices(true, false, true, true, false, routeService);
            routeService.resume();
        }
    }

    protected synchronized void stopRouteService(RouteService routeService, boolean removingRoutes, LoggingLevel loggingLevel) throws Exception {
        routeService.setRemovingRoutes(removingRoutes);
        this.stopRouteService(routeService, loggingLevel);
    }

    protected void logRouteState(Route route, String state, LoggingLevel loggingLevel) {
        CamelLogger logger = new CamelLogger(LOG, loggingLevel);
        if (logger.shouldLog()) {
            if (route.getConsumer() != null) {
                String id = route.getId();
                String uri = route.getEndpoint().getEndpointBaseUri();
                uri = URISupport.sanitizeUri(uri);
                String line = String.format("%s %s (%s)", state, id, uri);
                logger.log(line);
            } else {
                String id = route.getId();
                String line = String.format("%s %s", state, id);
                logger.log(line);
            }
        }
    }

    protected synchronized void stopRouteService(RouteService routeService, LoggingLevel loggingLevel) throws Exception {
        routeService.stop();
        this.logRouteState(routeService.getRoute(), "Stopped", loggingLevel);
    }

    protected synchronized void shutdownRouteService(RouteService routeService) throws Exception {
        this.shutdownRouteService(routeService, LoggingLevel.INFO);
    }

    protected synchronized void shutdownRouteService(RouteService routeService, LoggingLevel loggingLevel) throws Exception {
        routeService.shutdown();
        this.logRouteState(routeService.getRoute(), "Shutdown", loggingLevel);
    }

    protected synchronized void suspendRouteService(RouteService routeService) throws Exception {
        routeService.setRemovingRoutes(false);
        routeService.suspend();
        this.logRouteState(routeService.getRoute(), "Suspended", LoggingLevel.INFO);
    }

    protected void forceLazyInitialization() {
        StartupStep step = this.startupStepRecorder.beginStep(CamelContext.class, this.getName(), "Start Mandatory Services");
        this.initEagerMandatoryServices();
        this.startupStepRecorder.endStep(step);
        if (this.initialization != Initialization.Lazy) {
            step = this.startupStepRecorder.beginStep(CamelContext.class, this.getName(), "Start Standard Services");
            this.doStartStandardServices();
            this.startupStepRecorder.endStep(step);
            if (this.initialization == Initialization.Eager) {
                step = this.startupStepRecorder.beginStep(CamelContext.class, this.getName(), "Start Eager Services");
                this.doStartEagerServices();
                this.startupStepRecorder.endStep(step);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initEagerMandatoryServices() {
        if (this.headersMapFactory == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.headersMapFactory == null) {
                    if (this.isCaseInsensitiveHeaders().booleanValue()) {
                        this.setHeadersMapFactory(this.createHeadersMapFactory());
                    } else {
                        this.setHeadersMapFactory(new HashMapHeadersMapFactory());
                    }
                }
            }
        }
    }

    protected void doStartStandardServices() {
        this.getVersion();
        this.getClassResolver();
        this.getRegistry();
        this.getBootstrapFactoryFinder();
        this.getFactoryFinderResolver();
        this.getTypeConverterRegistry();
        this.getInjector();
        this.getDefaultFactoryFinder();
        this.getBootstrapConfigurerResolver();
        this.getConfigurerResolver();
        this.getPropertiesComponent();
        this.getLanguageResolver();
        this.getComponentResolver();
        this.getComponentNameResolver();
        this.getDataFormatResolver();
        this.getHealthCheckResolver();
        this.getExecutorServiceManager();
        this.getExchangeFactoryManager();
        this.getExchangeFactory();
        this.getShutdownStrategy();
        this.getUuidGenerator();
        if (this.isTypeConverterStatisticsEnabled().booleanValue()) {
            this.getTypeConverterRegistry().getStatistics().setStatisticsEnabled(this.isTypeConverterStatisticsEnabled());
        }
        this.resolveLanguage("simple");
    }

    protected void doStartEagerServices() {
        this.getPackageScanClassResolver();
        this.getInflightRepository();
        this.getAsyncProcessorAwaitManager();
        this.getReactiveExecutor();
        this.getBeanIntrospection();
        this.getUriFactoryResolver();
        this.getXMLRoutesDefinitionLoader();
        this.getModelToXMLDumper();
        this.getNodeIdFactory();
        this.getModelJAXBContextFactory();
        this.getUnitOfWorkFactory();
        this.getRouteController();
        this.getRoutesLoader();
        this.getResourceLoader();
        try {
            this.getRestRegistryFactory();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.getProcessorFactory();
            this.getInternalProcessorFactory();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.getBeanProxyFactory();
            this.getBeanProcessorFactory();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.getBeanPostProcessor();
    }

    protected void forceStopLazyInitialization() {
        this.injector = null;
        this.languageResolver = null;
        this.dataFormatResolver = null;
        this.componentResolver = null;
        this.typeConverterRegistry = null;
        this.typeConverter = null;
        this.reactiveExecutor = null;
        this.asyncProcessorAwaitManager = null;
        this.exchangeFactory = null;
        this.exchangeFactoryManager = null;
        this.processorExchangeFactory = null;
        this.registry = null;
    }

    protected Endpoint createEndpoint(String uri) {
        Object value = this.getRegistry().lookupByName(uri);
        if (value instanceof Endpoint) {
            return (Endpoint)value;
        }
        if (value instanceof Processor) {
            return new ProcessorEndpoint(uri, this.getCamelContextReference(), (Processor)value);
        }
        if (value != null) {
            return this.convertBeanToEndpoint(uri, value);
        }
        return null;
    }

    protected Endpoint convertBeanToEndpoint(String uri, Object bean) {
        throw new IllegalArgumentException("uri: " + uri + " bean: " + bean + " could not be converted to an Endpoint");
    }

    protected boolean shouldStartRoutes() {
        return this.isStarted() && !this.isStarting();
    }

    @Override
    public Map<String, String> getGlobalOptions() {
        return this.globalOptions;
    }

    @Override
    public void setGlobalOptions(Map<String, String> globalOptions) {
        this.globalOptions = globalOptions;
    }

    @Override
    public FactoryFinder getDefaultFactoryFinder() {
        return this.getFactoryFinder("META-INF/services/org/apache/camel/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConfigurerResolver getBootstrapConfigurerResolver() {
        if (this.bootstrapConfigurerResolver == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.bootstrapConfigurerResolver == null) {
                    this.bootstrapConfigurerResolver = new BootstrapConfigurerResolver(this.getFactoryFinderResolver().resolveBootstrapFactoryFinder(this.getClassResolver(), "META-INF/services/org/apache/camel/configurer/"));
                }
            }
        }
        return this.bootstrapConfigurerResolver;
    }

    @Override
    public void setBootstrapConfigurerResolver(ConfigurerResolver configurerResolver) {
        this.bootstrapConfigurerResolver = configurerResolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FactoryFinder getBootstrapFactoryFinder() {
        if (this.bootstrapFactoryFinder == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.bootstrapFactoryFinder == null) {
                    this.bootstrapFactoryFinder = this.getFactoryFinderResolver().resolveBootstrapFactoryFinder(this.getClassResolver());
                }
            }
        }
        return this.bootstrapFactoryFinder;
    }

    @Override
    public void setBootstrapFactoryFinder(FactoryFinder factoryFinder) {
        this.bootstrapFactoryFinder = factoryFinder;
    }

    @Override
    public FactoryFinder getBootstrapFactoryFinder(String path) {
        return this.bootstrapFactories.computeIfAbsent(path, this::createBootstrapFactoryFinder);
    }

    protected FactoryFinder createBootstrapFactoryFinder(String path) {
        return this.getFactoryFinderResolver().resolveBootstrapFactoryFinder(this.getClassResolver(), path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FactoryFinderResolver getFactoryFinderResolver() {
        if (this.factoryFinderResolver == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.factoryFinderResolver == null) {
                    this.factoryFinderResolver = this.createFactoryFinderResolver();
                }
            }
        }
        return this.factoryFinderResolver;
    }

    @Override
    public void setFactoryFinderResolver(FactoryFinderResolver factoryFinderResolver) {
        this.factoryFinderResolver = this.doAddService(factoryFinderResolver);
    }

    @Override
    public FactoryFinder getFactoryFinder(String path) {
        return this.factories.computeIfAbsent(path, this::createFactoryFinder);
    }

    protected FactoryFinder createFactoryFinder(String path) {
        return this.getFactoryFinderResolver().resolveFactoryFinder(this.getClassResolver(), path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClassResolver getClassResolver() {
        if (this.classResolver == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.classResolver == null) {
                    this.setClassResolver(this.createClassResolver());
                }
            }
        }
        return this.classResolver;
    }

    @Override
    public void setClassResolver(ClassResolver classResolver) {
        this.classResolver = this.doAddService(classResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PackageScanClassResolver getPackageScanClassResolver() {
        if (this.packageScanClassResolver == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.packageScanClassResolver == null) {
                    this.setPackageScanClassResolver(this.createPackageScanClassResolver());
                }
            }
        }
        return this.packageScanClassResolver;
    }

    @Override
    public void setPackageScanClassResolver(PackageScanClassResolver packageScanClassResolver) {
        this.packageScanClassResolver = this.doAddService(packageScanClassResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PackageScanResourceResolver getPackageScanResourceResolver() {
        if (this.packageScanResourceResolver == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.packageScanResourceResolver == null) {
                    this.setPackageScanResourceResolver(this.createPackageScanResourceResolver());
                }
            }
        }
        return this.packageScanResourceResolver;
    }

    @Override
    public void setPackageScanResourceResolver(PackageScanResourceResolver packageScanResourceResolver) {
        this.packageScanResourceResolver = this.doAddService(packageScanResourceResolver);
    }

    @Override
    public Set<String> getComponentNames() {
        return Collections.unmodifiableSet(this.components.keySet());
    }

    @Override
    public Set<String> getLanguageNames() {
        return Collections.unmodifiableSet(this.languages.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelJAXBContextFactory getModelJAXBContextFactory() {
        if (this.modelJAXBContextFactory == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.modelJAXBContextFactory == null) {
                    this.setModelJAXBContextFactory(this.createModelJAXBContextFactory());
                }
            }
        }
        return this.modelJAXBContextFactory;
    }

    @Override
    public void setModelJAXBContextFactory(ModelJAXBContextFactory modelJAXBContextFactory) {
        this.modelJAXBContextFactory = this.doAddService(modelJAXBContextFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NodeIdFactory getNodeIdFactory() {
        if (this.nodeIdFactory == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.nodeIdFactory == null) {
                    this.setNodeIdFactory(this.createNodeIdFactory());
                }
            }
        }
        return this.nodeIdFactory;
    }

    @Override
    public void setNodeIdFactory(NodeIdFactory idFactory) {
        this.nodeIdFactory = this.doAddService(idFactory);
    }

    @Override
    public ManagementStrategy getManagementStrategy() {
        return this.managementStrategy;
    }

    @Override
    public void setManagementStrategy(ManagementStrategy managementStrategy) {
        this.managementStrategy = managementStrategy;
    }

    @Override
    public void disableJMX() {
        if (this.isNew()) {
            this.disableJMX = true;
        } else if (this.isInit() || this.isBuild()) {
            this.disableJMX = true;
            this.setupManagement(null);
        } else {
            throw new IllegalStateException("Disabling JMX can only be done when CamelContext has not been started");
        }
    }

    public boolean isJMXDisabled() {
        String override = System.getProperty("org.apache.camel.jmx.disabled");
        if (override != null) {
            return "true".equals(override);
        }
        return this.disableJMX;
    }

    @Override
    public void setupManagement(Map<String, Object> options) {
        LOG.trace("Setting up management");
        ManagementStrategyFactory factory = null;
        if (!this.isJMXDisabled()) {
            try {
                Object object;
                FactoryFinder finder = this.createFactoryFinder("META-INF/services/org/apache/camel/management/");
                if (finder != null && (object = finder.newInstance("ManagementStrategyFactory").orElse(null)) instanceof ManagementStrategyFactory) {
                    factory = object;
                }
            }
            catch (Exception e) {
                LOG.warn("Cannot create JmxManagementStrategyFactory. Will fallback and disable JMX.", (Throwable)e);
            }
        }
        if (factory == null) {
            factory = new DefaultManagementStrategyFactory();
        }
        LOG.debug("Setting up management with factory: {}", (Object)factory);
        List<EventNotifier> notifiers = null;
        if (this.managementStrategy != null) {
            notifiers = this.managementStrategy.getEventNotifiers();
        }
        try {
            ManagementStrategy strategy = factory.create(this.getCamelContextReference(), options);
            if (notifiers != null) {
                notifiers.forEach(strategy::addEventNotifier);
            }
            LifecycleStrategy lifecycle = factory.createLifecycle(this);
            factory.setupManagement(this, strategy, lifecycle);
        }
        catch (Exception e) {
            LOG.warn("Error setting up management due {}", (Object)e.getMessage());
            throw RuntimeCamelException.wrapRuntimeCamelException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InflightRepository getInflightRepository() {
        if (this.inflightRepository == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.inflightRepository == null) {
                    this.setInflightRepository(this.createInflightRepository());
                }
            }
        }
        return this.inflightRepository;
    }

    @Override
    public void setInflightRepository(InflightRepository repository) {
        this.inflightRepository = this.doAddService(repository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AsyncProcessorAwaitManager getAsyncProcessorAwaitManager() {
        if (this.asyncProcessorAwaitManager == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.asyncProcessorAwaitManager == null) {
                    this.setAsyncProcessorAwaitManager(this.createAsyncProcessorAwaitManager());
                }
            }
        }
        return this.asyncProcessorAwaitManager;
    }

    @Override
    public void setAsyncProcessorAwaitManager(AsyncProcessorAwaitManager asyncProcessorAwaitManager) {
        this.asyncProcessorAwaitManager = this.doAddService(asyncProcessorAwaitManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BeanIntrospection getBeanIntrospection() {
        if (this.beanIntrospection == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.beanIntrospection == null) {
                    this.setBeanIntrospection(this.createBeanIntrospection());
                }
            }
        }
        return this.beanIntrospection;
    }

    @Override
    public void setBeanIntrospection(BeanIntrospection beanIntrospection) {
        this.beanIntrospection = this.doAddService(beanIntrospection);
    }

    @Override
    public void setAutoStartup(Boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    @Override
    public Boolean isAutoStartup() {
        return this.autoStartup != null && this.autoStartup != false;
    }

    @Override
    public Boolean isLoadTypeConverters() {
        return this.loadTypeConverters != null && this.loadTypeConverters != false;
    }

    @Override
    public void setLoadTypeConverters(Boolean loadTypeConverters) {
        this.loadTypeConverters = loadTypeConverters;
    }

    @Override
    public Boolean isLoadHealthChecks() {
        return this.loadHealthChecks != null && this.loadHealthChecks != false;
    }

    @Override
    public void setLoadHealthChecks(Boolean loadHealthChecks) {
        this.loadHealthChecks = loadHealthChecks;
    }

    @Override
    public Boolean isTypeConverterStatisticsEnabled() {
        return this.typeConverterStatisticsEnabled != null && this.typeConverterStatisticsEnabled != false;
    }

    @Override
    public void setTypeConverterStatisticsEnabled(Boolean typeConverterStatisticsEnabled) {
        this.typeConverterStatisticsEnabled = typeConverterStatisticsEnabled;
    }

    @Override
    public Boolean isDumpRoutes() {
        return this.dumpRoutes;
    }

    @Override
    public void setDumpRoutes(Boolean dumpRoutes) {
        this.dumpRoutes = dumpRoutes;
    }

    @Override
    public Boolean isUseMDCLogging() {
        return this.useMDCLogging != null && this.useMDCLogging != false;
    }

    @Override
    public void setUseMDCLogging(Boolean useMDCLogging) {
        this.useMDCLogging = useMDCLogging;
    }

    @Override
    public String getMDCLoggingKeysPattern() {
        return this.mdcLoggingKeysPattern;
    }

    @Override
    public void setMDCLoggingKeysPattern(String pattern) {
        this.mdcLoggingKeysPattern = pattern;
    }

    @Override
    public Boolean isUseDataType() {
        return this.useDataType;
    }

    @Override
    public void setUseDataType(Boolean useDataType) {
        this.useDataType = useDataType;
    }

    @Override
    public Boolean isUseBreadcrumb() {
        return this.useBreadcrumb != null && this.useBreadcrumb != false;
    }

    @Override
    public void setUseBreadcrumb(Boolean useBreadcrumb) {
        this.useBreadcrumb = useBreadcrumb;
    }

    @Override
    public ClassLoader getApplicationContextClassLoader() {
        return this.applicationContextClassLoader;
    }

    @Override
    public void setApplicationContextClassLoader(ClassLoader classLoader) {
        this.applicationContextClassLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DataFormatResolver getDataFormatResolver() {
        if (this.dataFormatResolver == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.dataFormatResolver == null) {
                    this.setDataFormatResolver(this.createDataFormatResolver());
                }
            }
        }
        return this.dataFormatResolver;
    }

    @Override
    public void setDataFormatResolver(DataFormatResolver dataFormatResolver) {
        this.dataFormatResolver = this.doAddService(dataFormatResolver);
    }

    @Override
    public DataFormat resolveDataFormat(String name) {
        DataFormat answer = this.dataformats.computeIfAbsent(name, s -> {
            DataFormat df;
            StartupStep step = null;
            if (!this.isStarted() && this.startupStepRecorder.isEnabled()) {
                step = this.startupStepRecorder.beginStep(DataFormat.class, name, "Resolve DataFormat");
            }
            if ((df = Optional.ofNullable(ResolverHelper.lookupDataFormatInRegistryWithFallback(this.getCamelContextReference(), name)).orElseGet(() -> this.getDataFormatResolver().createDataFormat(name, this.getCamelContextReference()))) != null) {
                CamelContextAware.trySetCamelContext(df, this.getCamelContextReference());
                for (LifecycleStrategy strategy : this.lifecycleStrategies) {
                    strategy.onDataFormatCreated(name, df);
                }
            }
            if (step != null) {
                this.startupStepRecorder.endStep(step);
            }
            return df;
        });
        return answer;
    }

    @Override
    public DataFormat createDataFormat(String name) {
        StartupStep step = null;
        if (!this.isStarted() && this.startupStepRecorder.isEnabled()) {
            step = this.startupStepRecorder.beginStep(DataFormat.class, name, "Create DataFormat");
        }
        DataFormat answer = this.getDataFormatResolver().createDataFormat(name, this.getCamelContextReference());
        CamelContextAware.trySetCamelContext(answer, this.getCamelContextReference());
        for (LifecycleStrategy strategy : this.lifecycleStrategies) {
            strategy.onDataFormatCreated(name, answer);
        }
        if (step != null) {
            this.startupStepRecorder.endStep(step);
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HealthCheckResolver getHealthCheckResolver() {
        if (this.healthCheckResolver == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.healthCheckResolver == null) {
                    this.setHealthCheckResolver(this.createHealthCheckResolver());
                }
            }
        }
        return this.healthCheckResolver;
    }

    @Override
    public void setHealthCheckResolver(HealthCheckResolver healthCheckResolver) {
        this.healthCheckResolver = this.doAddService(healthCheckResolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ShutdownStrategy getShutdownStrategy() {
        if (this.shutdownStrategy == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.shutdownStrategy == null) {
                    this.setShutdownStrategy(this.createShutdownStrategy());
                }
            }
        }
        return this.shutdownStrategy;
    }

    @Override
    public void setShutdownStrategy(ShutdownStrategy shutdownStrategy) {
        this.shutdownStrategy = this.doAddService(shutdownStrategy);
    }

    @Override
    public ShutdownRoute getShutdownRoute() {
        return this.shutdownRoute;
    }

    @Override
    public void setShutdownRoute(ShutdownRoute shutdownRoute) {
        this.shutdownRoute = shutdownRoute;
    }

    @Override
    public ShutdownRunningTask getShutdownRunningTask() {
        return this.shutdownRunningTask;
    }

    @Override
    public void setShutdownRunningTask(ShutdownRunningTask shutdownRunningTask) {
        this.shutdownRunningTask = shutdownRunningTask;
    }

    @Override
    public void setAllowUseOriginalMessage(Boolean allowUseOriginalMessage) {
        this.allowUseOriginalMessage = allowUseOriginalMessage;
    }

    @Override
    public Boolean isAllowUseOriginalMessage() {
        return this.allowUseOriginalMessage != null && this.allowUseOriginalMessage != false;
    }

    @Override
    public Boolean isCaseInsensitiveHeaders() {
        return this.caseInsensitiveHeaders != null && this.caseInsensitiveHeaders != false;
    }

    @Override
    public void setCaseInsensitiveHeaders(Boolean caseInsensitiveHeaders) {
        this.caseInsensitiveHeaders = caseInsensitiveHeaders;
    }

    @Override
    public Boolean isAutowiredEnabled() {
        return this.autowiredEnabled != null && this.autowiredEnabled != false;
    }

    @Override
    public void setAutowiredEnabled(Boolean autowiredEnabled) {
        this.autowiredEnabled = autowiredEnabled;
    }

    @Override
    public boolean isLightweight() {
        return this.lightweight;
    }

    @Override
    public void setLightweight(boolean lightweight) {
        this.lightweight = lightweight;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExecutorServiceManager getExecutorServiceManager() {
        if (this.executorServiceManager == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.executorServiceManager == null) {
                    this.setExecutorServiceManager(this.createExecutorServiceManager());
                }
            }
        }
        return this.executorServiceManager;
    }

    @Override
    public void setExecutorServiceManager(ExecutorServiceManager executorServiceManager) {
        this.executorServiceManager = this.doAddService(executorServiceManager, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessorFactory getProcessorFactory() {
        if (this.processorFactory == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.processorFactory == null) {
                    this.setProcessorFactory(this.createProcessorFactory());
                }
            }
        }
        return this.processorFactory;
    }

    @Override
    public void setProcessorFactory(ProcessorFactory processorFactory) {
        this.processorFactory = this.doAddService(processorFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalProcessorFactory getInternalProcessorFactory() {
        if (this.internalProcessorFactory == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.internalProcessorFactory == null) {
                    this.setInternalProcessorFactory(this.createInternalProcessorFactory());
                }
            }
        }
        return this.internalProcessorFactory;
    }

    @Override
    public void setInternalProcessorFactory(InternalProcessorFactory internalProcessorFactory) {
        this.internalProcessorFactory = this.doAddService(internalProcessorFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InterceptEndpointFactory getInterceptEndpointFactory() {
        if (this.interceptEndpointFactory == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.interceptEndpointFactory == null) {
                    this.setInterceptEndpointFactory(this.createInterceptEndpointFactory());
                }
            }
        }
        return this.interceptEndpointFactory;
    }

    @Override
    public void setInterceptEndpointFactory(InterceptEndpointFactory interceptEndpointFactory) {
        this.interceptEndpointFactory = this.doAddService(interceptEndpointFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RouteFactory getRouteFactory() {
        if (this.routeFactory == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.routeFactory == null) {
                    this.setRouteFactory(this.createRouteFactory());
                }
            }
        }
        return this.routeFactory;
    }

    @Override
    public void setRouteFactory(RouteFactory routeFactory) {
        this.routeFactory = routeFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageHistoryFactory getMessageHistoryFactory() {
        if (this.messageHistoryFactory == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.messageHistoryFactory == null) {
                    this.setMessageHistoryFactory(this.createMessageHistoryFactory());
                }
            }
        }
        return this.messageHistoryFactory;
    }

    @Override
    public void setMessageHistoryFactory(MessageHistoryFactory messageHistoryFactory) {
        this.messageHistoryFactory = this.doAddService(messageHistoryFactory);
        this.setMessageHistory(true);
    }

    @Override
    public Debugger getDebugger() {
        return this.debugger;
    }

    @Override
    public void setDebugger(Debugger debugger) {
        if (this.isStartingOrStarted()) {
            throw new IllegalStateException("Cannot set debugger on a started CamelContext");
        }
        this.debugger = this.doAddService(debugger, true, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Tracer getTracer() {
        if (this.tracer == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.tracer == null) {
                    this.setTracer(this.createTracer());
                }
            }
        }
        return this.tracer;
    }

    @Override
    public void setTracer(Tracer tracer) {
        if (!this.isTracingStandby() && this.isStartingOrStarted()) {
            throw new IllegalStateException("Cannot set tracer on a started CamelContext");
        }
        this.tracer = this.doAddService(tracer, true, false, true);
    }

    @Override
    public void setTracingStandby(boolean tracingStandby) {
        this.traceStandby = tracingStandby;
    }

    @Override
    public boolean isTracingStandby() {
        return this.traceStandby != null && this.traceStandby != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UuidGenerator getUuidGenerator() {
        if (this.uuidGenerator == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.uuidGenerator == null) {
                    this.setUuidGenerator(this.createUuidGenerator());
                }
            }
        }
        return this.uuidGenerator;
    }

    @Override
    public void setUuidGenerator(UuidGenerator uuidGenerator) {
        this.uuidGenerator = this.doAddService(uuidGenerator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StreamCachingStrategy getStreamCachingStrategy() {
        if (this.streamCachingStrategy == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.streamCachingStrategy == null) {
                    this.setStreamCachingStrategy(this.createStreamCachingStrategy());
                }
            }
        }
        return this.streamCachingStrategy;
    }

    @Override
    public void setStreamCachingStrategy(StreamCachingStrategy streamCachingStrategy) {
        this.streamCachingStrategy = this.doAddService(streamCachingStrategy, true, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestRegistry getRestRegistry() {
        if (this.restRegistry == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.restRegistry == null) {
                    this.setRestRegistry(this.createRestRegistry());
                }
            }
        }
        return this.restRegistry;
    }

    @Override
    public void setRestRegistry(RestRegistry restRegistry) {
        this.restRegistry = this.doAddService(restRegistry);
    }

    protected RestRegistry createRestRegistry() {
        RestRegistryFactory factory = this.getRestRegistryFactory();
        return factory.createRegistry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestRegistryFactory getRestRegistryFactory() {
        if (this.restRegistryFactory == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.restRegistryFactory == null) {
                    this.setRestRegistryFactory(this.createRestRegistryFactory());
                }
            }
        }
        return this.restRegistryFactory;
    }

    public void setRestRegistryFactory(RestRegistryFactory restRegistryFactory) {
        this.restRegistryFactory = this.doAddService(restRegistryFactory);
    }

    @Override
    public String getGlobalOption(String key) {
        String value = this.getGlobalOptions().get(key);
        if (ObjectHelper.isNotEmpty(value)) {
            try {
                value = this.resolvePropertyPlaceholders(value);
            }
            catch (Exception e) {
                throw new RuntimeCamelException("Error getting global option: " + key, e);
            }
        }
        return value;
    }

    @Override
    public Transformer resolveTransformer(String scheme) {
        return this.getTransformerRegistry().resolveTransformer(new TransformerKey(scheme));
    }

    @Override
    public Transformer resolveTransformer(DataType from, DataType to) {
        return this.getTransformerRegistry().resolveTransformer(new TransformerKey(from, to));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransformerRegistry getTransformerRegistry() {
        if (this.transformerRegistry == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.transformerRegistry == null) {
                    this.setTransformerRegistry(this.createTransformerRegistry());
                }
            }
        }
        return this.transformerRegistry;
    }

    public void setTransformerRegistry(TransformerRegistry transformerRegistry) {
        this.transformerRegistry = this.doAddService(transformerRegistry);
    }

    @Override
    public Validator resolveValidator(DataType type) {
        return this.getValidatorRegistry().resolveValidator(new ValidatorKey(type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ValidatorRegistry getValidatorRegistry() {
        if (this.validatorRegistry == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.validatorRegistry == null) {
                    this.setValidatorRegistry(this.createValidatorRegistry());
                }
            }
        }
        return this.validatorRegistry;
    }

    public void setValidatorRegistry(ValidatorRegistry validatorRegistry) {
        this.validatorRegistry = this.doAddService(validatorRegistry);
    }

    @Override
    public SSLContextParameters getSSLContextParameters() {
        return this.sslContextParameters;
    }

    @Override
    public void setSSLContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    @Override
    public StartupSummaryLevel getStartupSummaryLevel() {
        return this.startupSummaryLevel;
    }

    @Override
    public void setStartupSummaryLevel(StartupSummaryLevel startupSummaryLevel) {
        this.startupSummaryLevel = startupSummaryLevel;
    }

    @Override
    public HeadersMapFactory getHeadersMapFactory() {
        return this.headersMapFactory;
    }

    @Override
    public void setHeadersMapFactory(HeadersMapFactory headersMapFactory) {
        this.headersMapFactory = this.doAddService(headersMapFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XMLRoutesDefinitionLoader getXMLRoutesDefinitionLoader() {
        if (this.xmlRoutesDefinitionLoader == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.xmlRoutesDefinitionLoader == null) {
                    this.setXMLRoutesDefinitionLoader(this.createXMLRoutesDefinitionLoader());
                }
            }
        }
        return this.xmlRoutesDefinitionLoader;
    }

    @Override
    public void setXMLRoutesDefinitionLoader(XMLRoutesDefinitionLoader xmlRoutesDefinitionLoader) {
        this.xmlRoutesDefinitionLoader = this.doAddService(xmlRoutesDefinitionLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RoutesLoader getRoutesLoader() {
        if (this.routesLoader == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.routesLoader == null) {
                    this.setRoutesLoader(this.createRoutesLoader());
                }
            }
        }
        return this.routesLoader;
    }

    @Override
    public void setRoutesLoader(RoutesLoader routesLoader) {
        this.routesLoader = this.doAddService(routesLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResourceLoader getResourceLoader() {
        if (this.resourceLoader == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.resourceLoader == null) {
                    this.setResourceLoader(this.createResourceLoader());
                }
            }
        }
        return this.resourceLoader;
    }

    @Override
    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = this.doAddService(resourceLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModelToXMLDumper getModelToXMLDumper() {
        if (this.modelToXMLDumper == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.modelToXMLDumper == null) {
                    this.setModelToXMLDumper(this.createModelToXMLDumper());
                }
            }
        }
        return this.modelToXMLDumper;
    }

    @Override
    public void setModelToXMLDumper(ModelToXMLDumper modelToXMLDumper) {
        this.modelToXMLDumper = this.doAddService(modelToXMLDumper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestBindingJaxbDataFormatFactory getRestBindingJaxbDataFormatFactory() {
        if (this.restBindingJaxbDataFormatFactory == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.restBindingJaxbDataFormatFactory == null) {
                    this.setRestBindingJaxbDataFormatFactory(this.createRestBindingJaxbDataFormatFactory());
                }
            }
        }
        return this.restBindingJaxbDataFormatFactory;
    }

    @Override
    public void setRestBindingJaxbDataFormatFactory(RestBindingJaxbDataFormatFactory restBindingJaxbDataFormatFactory) {
        this.restBindingJaxbDataFormatFactory = restBindingJaxbDataFormatFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RuntimeCamelCatalog getRuntimeCamelCatalog() {
        if (this.runtimeCamelCatalog == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.runtimeCamelCatalog == null) {
                    this.setRuntimeCamelCatalog(this.createRuntimeCamelCatalog());
                }
            }
        }
        return this.runtimeCamelCatalog;
    }

    @Override
    public void setRuntimeCamelCatalog(RuntimeCamelCatalog runtimeCamelCatalog) {
        this.runtimeCamelCatalog = this.doAddService(runtimeCamelCatalog);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExchangeFactory getExchangeFactory() {
        if (this.exchangeFactory == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.exchangeFactory == null) {
                    this.setExchangeFactory(this.createExchangeFactory());
                }
            }
        }
        return this.exchangeFactory;
    }

    @Override
    public void setExchangeFactory(ExchangeFactory exchangeFactory) {
        exchangeFactory.setCamelContext(this);
        this.exchangeFactory = exchangeFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ExchangeFactoryManager getExchangeFactoryManager() {
        if (this.exchangeFactoryManager == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.exchangeFactoryManager == null) {
                    this.setExchangeFactoryManager(this.createExchangeFactoryManager());
                }
            }
        }
        return this.exchangeFactoryManager;
    }

    @Override
    public void setExchangeFactoryManager(ExchangeFactoryManager exchangeFactoryManager) {
        this.exchangeFactoryManager = this.doAddService(exchangeFactoryManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProcessorExchangeFactory getProcessorExchangeFactory() {
        if (this.processorExchangeFactory == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.processorExchangeFactory == null) {
                    this.setProcessorExchangeFactory(this.createProcessorExchangeFactory());
                }
            }
        }
        return this.processorExchangeFactory;
    }

    @Override
    public void setProcessorExchangeFactory(ProcessorExchangeFactory processorExchangeFactory) {
        processorExchangeFactory.setCamelContext(this);
        this.processorExchangeFactory = processorExchangeFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReactiveExecutor getReactiveExecutor() {
        if (this.reactiveExecutor == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.reactiveExecutor == null) {
                    this.setReactiveExecutor(this.createReactiveExecutor());
                }
            }
        }
        return this.reactiveExecutor;
    }

    @Override
    public void setReactiveExecutor(ReactiveExecutor reactiveExecutor) {
        this.reactiveExecutor = this.doAddService(reactiveExecutor, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeferServiceFactory getDeferServiceFactory() {
        if (this.deferServiceFactory == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.deferServiceFactory == null) {
                    this.setDeferServiceFactory(this.createDeferServiceFactory());
                }
            }
        }
        return this.deferServiceFactory;
    }

    @Override
    public void setDeferServiceFactory(DeferServiceFactory deferServiceFactory) {
        this.deferServiceFactory = deferServiceFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AnnotationBasedProcessorFactory getAnnotationBasedProcessorFactory() {
        if (this.annotationBasedProcessorFactory == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.annotationBasedProcessorFactory == null) {
                    this.setAnnotationBasedProcessorFactory(this.createAnnotationBasedProcessorFactory());
                }
            }
        }
        return this.annotationBasedProcessorFactory;
    }

    @Override
    public void setAnnotationBasedProcessorFactory(AnnotationBasedProcessorFactory annotationBasedProcessorFactory) {
        this.annotationBasedProcessorFactory = annotationBasedProcessorFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BeanProxyFactory getBeanProxyFactory() {
        if (this.beanProxyFactory == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.beanProxyFactory == null) {
                    this.setBeanProxyFactory(this.createBeanProxyFactory());
                }
            }
        }
        return this.beanProxyFactory;
    }

    public void setBeanProxyFactory(BeanProxyFactory beanProxyFactory) {
        this.beanProxyFactory = this.doAddService(beanProxyFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BeanProcessorFactory getBeanProcessorFactory() {
        if (this.beanProcessorFactory == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.beanProcessorFactory == null) {
                    this.setBeanProcessorFactory(this.createBeanProcessorFactory());
                }
            }
        }
        return this.beanProcessorFactory;
    }

    public void setBeanProcessorFactory(BeanProcessorFactory beanProcessorFactory) {
        this.beanProcessorFactory = this.doAddService(beanProcessorFactory);
    }

    protected Map<String, RouteService> getRouteServices() {
        return this.routeServices;
    }

    public String toString() {
        return "CamelContext(" + this.getName() + ")";
    }

    protected void failOnStartup(Exception e) {
        if (e instanceof VetoCamelContextStartException) {
            VetoCamelContextStartException vetoException = (VetoCamelContextStartException)e;
            if (vetoException.isRethrowException()) {
                this.fail(e);
            } else {
                this.status = (byte)12;
            }
        } else {
            this.fail(e);
        }
    }

    protected abstract ExchangeFactory createExchangeFactory();

    protected abstract ExchangeFactoryManager createExchangeFactoryManager();

    protected abstract ProcessorExchangeFactory createProcessorExchangeFactory();

    protected abstract HealthCheckRegistry createHealthCheckRegistry();

    protected abstract ReactiveExecutor createReactiveExecutor();

    protected abstract StreamCachingStrategy createStreamCachingStrategy();

    protected abstract TypeConverter createTypeConverter();

    protected abstract TypeConverterRegistry createTypeConverterRegistry();

    protected abstract Injector createInjector();

    protected abstract PropertiesComponent createPropertiesComponent();

    protected abstract CamelBeanPostProcessor createBeanPostProcessor();

    protected abstract ComponentResolver createComponentResolver();

    protected abstract ComponentNameResolver createComponentNameResolver();

    protected abstract Registry createRegistry();

    protected abstract UuidGenerator createUuidGenerator();

    protected abstract ModelJAXBContextFactory createModelJAXBContextFactory();

    protected abstract NodeIdFactory createNodeIdFactory();

    protected abstract FactoryFinderResolver createFactoryFinderResolver();

    protected abstract ClassResolver createClassResolver();

    protected abstract ProcessorFactory createProcessorFactory();

    protected abstract InternalProcessorFactory createInternalProcessorFactory();

    protected abstract InterceptEndpointFactory createInterceptEndpointFactory();

    protected abstract RouteFactory createRouteFactory();

    protected abstract DataFormatResolver createDataFormatResolver();

    protected abstract HealthCheckResolver createHealthCheckResolver();

    protected abstract MessageHistoryFactory createMessageHistoryFactory();

    protected abstract InflightRepository createInflightRepository();

    protected abstract AsyncProcessorAwaitManager createAsyncProcessorAwaitManager();

    protected abstract RouteController createRouteController();

    protected abstract ShutdownStrategy createShutdownStrategy();

    protected abstract PackageScanClassResolver createPackageScanClassResolver();

    protected abstract PackageScanResourceResolver createPackageScanResourceResolver();

    protected abstract ExecutorServiceManager createExecutorServiceManager();

    protected abstract UnitOfWorkFactory createUnitOfWorkFactory();

    protected abstract CamelContextNameStrategy createCamelContextNameStrategy();

    protected abstract ManagementNameStrategy createManagementNameStrategy();

    protected abstract HeadersMapFactory createHeadersMapFactory();

    protected abstract BeanProxyFactory createBeanProxyFactory();

    protected abstract AnnotationBasedProcessorFactory createAnnotationBasedProcessorFactory();

    protected abstract DeferServiceFactory createDeferServiceFactory();

    protected abstract BeanProcessorFactory createBeanProcessorFactory();

    protected abstract BeanIntrospection createBeanIntrospection();

    protected abstract XMLRoutesDefinitionLoader createXMLRoutesDefinitionLoader();

    protected abstract RoutesLoader createRoutesLoader();

    protected abstract ResourceLoader createResourceLoader();

    protected abstract ModelToXMLDumper createModelToXMLDumper();

    protected abstract RestBindingJaxbDataFormatFactory createRestBindingJaxbDataFormatFactory();

    protected abstract RuntimeCamelCatalog createRuntimeCamelCatalog();

    protected abstract Tracer createTracer();

    protected abstract LanguageResolver createLanguageResolver();

    protected abstract ConfigurerResolver createConfigurerResolver();

    protected abstract UriFactoryResolver createUriFactoryResolver();

    protected abstract RestRegistryFactory createRestRegistryFactory();

    protected abstract EndpointRegistry<NormalizedUri> createEndpointRegistry(Map<NormalizedUri, Endpoint> var1);

    protected abstract TransformerRegistry<TransformerKey> createTransformerRegistry();

    protected abstract ValidatorRegistry<ValidatorKey> createValidatorRegistry();

    protected RestConfiguration createRestConfiguration() {
        RestConfiguration conf = CamelContextHelper.lookup(this, "rest-configuration", RestConfiguration.class);
        if (conf == null) {
            conf = CamelContextHelper.findByType(this, RestConfiguration.class);
        }
        if (conf == null) {
            conf = new RestConfiguration();
        }
        return conf;
    }

    @Override
    public RouteController getInternalRouteController() {
        return this.internalRouteController;
    }

    @Override
    public EndpointUriFactory getEndpointUriFactory(String scheme) {
        return this.getUriFactoryResolver().resolveFactory(scheme, this);
    }

    @Override
    public StartupStepRecorder getStartupStepRecorder() {
        return this.startupStepRecorder;
    }

    @Override
    public void setStartupStepRecorder(StartupStepRecorder startupStepRecorder) {
        this.startupStepRecorder = startupStepRecorder;
    }

    class LifecycleHelper
    implements AutoCloseable {
        final Map<String, String> originalContextMap;
        final ClassLoader tccl = Thread.currentThread().getContextClassLoader();

        LifecycleHelper() {
            if (AbstractCamelContext.this.applicationContextClassLoader != null) {
                Thread.currentThread().setContextClassLoader(AbstractCamelContext.this.applicationContextClassLoader);
            }
            if (AbstractCamelContext.this.isUseMDCLogging().booleanValue()) {
                this.originalContextMap = MDC.getCopyOfContextMap();
                MDC.put((String)"camel.contextId", (String)AbstractCamelContext.this.getName());
            } else {
                this.originalContextMap = null;
            }
        }

        @Override
        public void close() {
            if (AbstractCamelContext.this.isUseMDCLogging().booleanValue()) {
                if (this.originalContextMap != null) {
                    MDC.setContextMap(this.originalContextMap);
                } else {
                    MDC.clear();
                }
            }
            Thread.currentThread().setContextClassLoader(this.tccl);
        }
    }

    @Deprecated
    public static enum Initialization {
        Eager,
        Default,
        Lazy;

    }
}

