/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Endpoint;
import org.apache.camel.EndpointProducerResolver;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.FluentProducerTemplate;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.processor.ConvertBodyProcessor;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;
import org.apache.camel.util.ObjectHelper;

public class DefaultFluentProducerTemplate
extends ServiceSupport
implements FluentProducerTemplate {
    private Map<String, Object> headers;
    private Object body;
    private Supplier<Exchange> exchangeSupplier;
    private Supplier<Processor> processorSupplier;
    private Consumer<ProducerTemplate> templateCustomizer;
    private final CamelContext context;
    private final ClassValue<Processor> resultProcessors;
    private Endpoint defaultEndpoint;
    private int maximumCacheSize;
    private boolean eventNotifierEnabled;
    private volatile Endpoint endpoint;
    private volatile String endpointUri;
    private volatile ProducerTemplate template;
    private volatile boolean cloned;
    private volatile boolean useDefaultEndpoint = true;

    public DefaultFluentProducerTemplate(CamelContext context) {
        this.context = context;
        this.eventNotifierEnabled = true;
        this.resultProcessors = new ClassValue<Processor>(){

            @Override
            protected Processor computeValue(Class<?> type) {
                return new ConvertBodyProcessor(type);
            }
        };
    }

    private DefaultFluentProducerTemplate(CamelContext context, ClassValue<Processor> resultProcessors, Endpoint defaultEndpoint, int maximumCacheSize, boolean eventNotifierEnabled, ProducerTemplate template, Endpoint endpoint, String endpointUri) {
        this.context = context;
        this.resultProcessors = resultProcessors;
        this.defaultEndpoint = defaultEndpoint;
        this.maximumCacheSize = maximumCacheSize;
        this.eventNotifierEnabled = eventNotifierEnabled;
        this.template = template;
        this.endpoint = endpoint;
        this.endpointUri = endpointUri;
        this.cloned = true;
    }

    private DefaultFluentProducerTemplate newClone() {
        return new DefaultFluentProducerTemplate(this.context, this.resultProcessors, this.defaultEndpoint, this.maximumCacheSize, this.eventNotifierEnabled, this.template, this.endpoint, this.endpointUri);
    }

    private DefaultFluentProducerTemplate checkCloned() {
        if (!this.cloned) {
            return this.newClone();
        }
        return this;
    }

    @Override
    public CamelContext getCamelContext() {
        return this.context;
    }

    @Override
    public int getCurrentCacheSize() {
        if (this.template == null) {
            return 0;
        }
        return this.template.getCurrentCacheSize();
    }

    @Override
    public void cleanUp() {
        if (this.template != null) {
            this.template.cleanUp();
        }
    }

    @Override
    public void setDefaultEndpointUri(String endpointUri) {
        this.setDefaultEndpoint(this.getCamelContext().getEndpoint(endpointUri));
    }

    @Override
    public Endpoint getDefaultEndpoint() {
        return this.defaultEndpoint;
    }

    @Override
    public void setDefaultEndpoint(Endpoint defaultEndpoint) {
        if (this.defaultEndpoint != null && this.isStarted()) {
            throw new IllegalArgumentException("Not allowed after template has been started");
        }
        this.defaultEndpoint = defaultEndpoint;
    }

    @Override
    public int getMaximumCacheSize() {
        return this.maximumCacheSize;
    }

    @Override
    public void setMaximumCacheSize(int maximumCacheSize) {
        if (this.maximumCacheSize != 0 && this.isStarted()) {
            throw new IllegalArgumentException("Not allowed after template has been started");
        }
        this.maximumCacheSize = maximumCacheSize;
    }

    @Override
    public boolean isEventNotifierEnabled() {
        return this.eventNotifierEnabled;
    }

    @Override
    public void setEventNotifierEnabled(boolean eventNotifierEnabled) {
        if (this.isStarted()) {
            throw new IllegalArgumentException("Not allowed after template has been started");
        }
        this.eventNotifierEnabled = eventNotifierEnabled;
    }

    @Override
    public FluentProducerTemplate clearAll() {
        this.clearBody();
        this.clearHeaders();
        return this;
    }

    @Override
    public FluentProducerTemplate withHeaders(Map<String, Object> headers) {
        DefaultFluentProducerTemplate clone = this.checkCloned();
        if (clone.processorSupplier != null) {
            throw new IllegalArgumentException("Cannot use both withBody and withProcessor with FluentProducerTemplate");
        }
        Map<String, Object> map = clone.headers;
        if (map == null) {
            clone.headers = map = new LinkedHashMap<String, Object>();
        }
        map.putAll(headers);
        return clone;
    }

    @Override
    public FluentProducerTemplate withHeader(String key, Object value) {
        DefaultFluentProducerTemplate clone = this.checkCloned();
        if (clone.processorSupplier != null) {
            throw new IllegalArgumentException("Cannot use both withBody and withProcessor with FluentProducerTemplate");
        }
        Map<String, Object> map = clone.headers;
        if (map == null) {
            clone.headers = map = new LinkedHashMap<String, Object>();
        }
        map.put(key, value);
        return clone;
    }

    @Override
    public FluentProducerTemplate clearHeaders() {
        DefaultFluentProducerTemplate clone = this.checkCloned();
        if (clone.headers != null) {
            clone.headers.clear();
        }
        return clone;
    }

    @Override
    public FluentProducerTemplate withBody(Object body) {
        DefaultFluentProducerTemplate clone = this.checkCloned();
        if (clone.processorSupplier != null) {
            throw new IllegalArgumentException("Cannot use both withBody and withProcessor with FluentProducerTemplate");
        }
        clone.body = body;
        return clone;
    }

    @Override
    public FluentProducerTemplate withBodyAs(Object body, Class<?> type) {
        Object b;
        DefaultFluentProducerTemplate clone = this.checkCloned();
        if (clone.processorSupplier != null) {
            throw new IllegalArgumentException("Cannot use both withBody and withProcessor with FluentProducerTemplate");
        }
        clone.body = b = type != null ? clone.context.getTypeConverter().convertTo(type, body) : body;
        return clone;
    }

    @Override
    public FluentProducerTemplate clearBody() {
        DefaultFluentProducerTemplate clone = this.checkCloned();
        clone.body = null;
        return clone;
    }

    @Override
    public FluentProducerTemplate withDefaultEndpoint(String endpointUri) {
        if (this.cloned) {
            throw new IllegalArgumentException("Default endpoint must be set before template has been used");
        }
        this.defaultEndpoint = this.getCamelContext().getEndpoint(endpointUri);
        return this;
    }

    @Override
    public FluentProducerTemplate withDefaultEndpoint(EndpointProducerResolver resolver2) {
        if (this.cloned) {
            throw new IllegalArgumentException("Default endpoint must be set before template has been used");
        }
        this.defaultEndpoint = resolver2.resolve(this.getCamelContext());
        return this;
    }

    @Override
    public FluentProducerTemplate withDefaultEndpoint(Endpoint endpoint) {
        if (this.cloned) {
            throw new IllegalArgumentException("Default endpoint must be set before template has been used");
        }
        this.defaultEndpoint = endpoint;
        return this;
    }

    @Override
    public FluentProducerTemplate withTemplateCustomizer(Consumer<ProducerTemplate> templateCustomizer) {
        if (this.templateCustomizer != null && this.isStarted()) {
            throw new IllegalArgumentException("Not allowed after template has been started");
        }
        this.templateCustomizer = templateCustomizer;
        if (this.template != null) {
            ServiceHelper.stopService((Object)this.template);
            templateCustomizer.accept(this.template);
            ServiceHelper.startService((Object)this.template);
        }
        return this;
    }

    @Override
    public FluentProducerTemplate withExchange(Exchange exchange) {
        return this.withExchange(() -> exchange);
    }

    @Override
    public FluentProducerTemplate withExchange(Supplier<Exchange> exchangeSupplier) {
        DefaultFluentProducerTemplate clone = this.checkCloned();
        clone.exchangeSupplier = exchangeSupplier;
        return clone;
    }

    @Override
    public FluentProducerTemplate withProcessor(Processor processor) {
        return this.withProcessor(() -> processor);
    }

    @Override
    public FluentProducerTemplate withProcessor(Supplier<Processor> processorSupplier) {
        DefaultFluentProducerTemplate clone = this.checkCloned();
        if (clone.body != null) {
            throw new IllegalArgumentException("Cannot use both withBody and withProcessor with FluentProducerTemplate");
        }
        clone.processorSupplier = processorSupplier;
        return clone;
    }

    @Override
    public FluentProducerTemplate to(String endpointUri) {
        DefaultFluentProducerTemplate clone = this.checkCloned();
        clone.useDefaultEndpoint = false;
        clone.endpointUri = endpointUri;
        clone.endpoint = this.context.getEndpoint(endpointUri);
        return clone;
    }

    @Override
    public FluentProducerTemplate to(Endpoint endpoint) {
        DefaultFluentProducerTemplate clone = this.checkCloned();
        clone.useDefaultEndpoint = false;
        clone.endpoint = endpoint;
        return clone;
    }

    @Override
    public Object request() throws CamelExecutionException {
        return this.request(Object.class);
    }

    @Override
    public <T> T request(Class<T> type) throws CamelExecutionException {
        Object result;
        Processor processorSupplier;
        if (this.exchangeSupplier != null && this.exchangeSupplier.get() != null) {
            throw new IllegalArgumentException("withExchange not supported on FluentProducerTemplate.request method. Use send method instead.");
        }
        DefaultFluentProducerTemplate clone = this.checkCloned();
        Endpoint target = clone.target();
        Processor processor = clone.processorSupplier != null ? clone.processorSupplier.get() : null;
        Processor processor2 = processorSupplier = processor != null ? processor : clone.defaultProcessor();
        if (type == Exchange.class) {
            result = clone.template().request(target, processorSupplier);
        } else if (type == Message.class) {
            Exchange exchange = clone.template().request(target, processorSupplier);
            result = exchange.getMessage();
        } else {
            Exchange exchange = clone.template().send(target, ExchangePattern.InOut, processorSupplier, clone.resultProcessors.get(type));
            result = clone.context.getTypeConverter().convertTo(type, ExchangeHelper.extractResultBody(exchange, exchange.getPattern()));
        }
        this.cloned = false;
        this.useDefaultEndpoint = true;
        return (T)result;
    }

    @Override
    public Future<Object> asyncRequest() {
        return this.asyncRequest(Object.class);
    }

    @Override
    public <T> Future<T> asyncRequest(Class<T> type) {
        CompletableFuture<T> result;
        DefaultFluentProducerTemplate clone = this.checkCloned();
        Endpoint target = clone.target();
        if (ObjectHelper.isNotEmpty(clone.headers)) {
            HashMap<String, Object> headersCopy = new HashMap<String, Object>(clone.headers);
            Object bodyCopy = clone.body;
            result = clone.template().asyncRequestBodyAndHeaders(target, bodyCopy, headersCopy, type);
        } else {
            Object bodyCopy = clone.body;
            result = clone.template().asyncRequestBody(target, bodyCopy, type);
        }
        this.cloned = false;
        this.useDefaultEndpoint = true;
        return result;
    }

    @Override
    public Exchange send() throws CamelExecutionException {
        Exchange result;
        Exchange exchange;
        DefaultFluentProducerTemplate clone = this.checkCloned();
        Endpoint target = clone.target();
        Exchange exchange2 = exchange = clone.exchangeSupplier != null ? clone.exchangeSupplier.get() : null;
        if (exchange != null) {
            result = clone.template().send(target, exchange);
        } else {
            Processor proc = clone.processorSupplier != null ? clone.processorSupplier.get() : null;
            Processor processor = proc != null ? proc : clone.defaultProcessor();
            result = clone.template().send(target, processor);
        }
        this.cloned = false;
        this.useDefaultEndpoint = true;
        return result;
    }

    @Override
    public Future<Exchange> asyncSend() {
        CompletableFuture<Exchange> result;
        Exchange exchange;
        DefaultFluentProducerTemplate clone = this.checkCloned();
        Endpoint target = clone.target();
        Exchange exchange2 = exchange = clone.exchangeSupplier != null ? clone.exchangeSupplier.get() : null;
        if (exchange != null) {
            result = clone.template().asyncSend(target, exchange);
        } else {
            Processor proc = clone.processorSupplier != null ? clone.processorSupplier.get() : null;
            Processor processor = proc != null ? proc : clone.defaultAsyncProcessor();
            result = clone.template().asyncSend(target, processor);
        }
        this.cloned = false;
        this.useDefaultEndpoint = true;
        return result;
    }

    public static FluentProducerTemplate on(CamelContext context) {
        DefaultFluentProducerTemplate fluent = new DefaultFluentProducerTemplate(context);
        fluent.cloned = true;
        fluent.start();
        return fluent;
    }

    public static FluentProducerTemplate on(CamelContext context, Endpoint endpoint) {
        DefaultFluentProducerTemplate fluent = new DefaultFluentProducerTemplate(context);
        fluent.withDefaultEndpoint(endpoint);
        fluent.cloned = true;
        fluent.start();
        return fluent;
    }

    public static FluentProducerTemplate on(CamelContext context, EndpointProducerResolver resolver2) {
        DefaultFluentProducerTemplate fluent = new DefaultFluentProducerTemplate(context);
        fluent.withDefaultEndpoint(resolver2);
        fluent.cloned = true;
        fluent.start();
        return fluent;
    }

    public static FluentProducerTemplate on(CamelContext context, String endpoint) {
        DefaultFluentProducerTemplate fluent = new DefaultFluentProducerTemplate(context);
        fluent.withDefaultEndpoint(endpoint);
        fluent.cloned = true;
        fluent.start();
        return fluent;
    }

    private ProducerTemplate template() {
        return this.template;
    }

    private Processor defaultProcessor() {
        return exchange -> {
            if (this.headers != null) {
                exchange.getIn().getHeaders().putAll(this.headers);
            }
            if (this.body != null) {
                exchange.getIn().setBody(this.body);
            }
        };
    }

    private Processor defaultAsyncProcessor() {
        HashMap<String, Object> headersCopy = ObjectHelper.isNotEmpty(this.headers) ? new HashMap<String, Object>(this.headers) : null;
        Object bodyCopy = this.body;
        return exchange -> {
            if (headersCopy != null) {
                exchange.getIn().getHeaders().putAll(headersCopy);
            }
            if (bodyCopy != null) {
                exchange.getIn().setBody(bodyCopy);
            }
        };
    }

    private Endpoint target() {
        if (!this.useDefaultEndpoint && this.endpoint != null) {
            return this.endpoint;
        }
        if (this.defaultEndpoint != null) {
            return this.defaultEndpoint;
        }
        if (this.template != null && this.template.getDefaultEndpoint() != null) {
            return this.template.getDefaultEndpoint();
        }
        throw new IllegalArgumentException("No endpoint configured on FluentProducerTemplate. You can configure an endpoint with to(uri)");
    }

    @Override
    protected void doInit() throws Exception {
        ObjectHelper.notNull(this.context, "CamelContext");
        this.template = this.context.createProducerTemplate(this.maximumCacheSize);
        if (this.defaultEndpoint != null) {
            this.template.setDefaultEndpoint(this.defaultEndpoint);
        }
        this.template.setEventNotifierEnabled(this.eventNotifierEnabled);
        if (this.templateCustomizer != null) {
            this.templateCustomizer.accept(this.template);
        }
        ServiceHelper.initService((Object)this.template);
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startService((Object)this.template);
    }

    @Override
    protected void doStop() throws Exception {
        this.clearAll();
        this.endpoint = null;
        this.endpointUri = null;
        this.exchangeSupplier = null;
        this.processorSupplier = null;
        this.templateCustomizer = null;
        ServiceHelper.stopService((Object)this.template);
    }

    @Override
    protected void doShutdown() throws Exception {
        ServiceHelper.stopAndShutdownService(this.template);
        this.template = null;
    }
}

