/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.xtokenizer;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.language.xtokenizer.XMLTokenExpressionIterator;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.annotations.Language;
import org.apache.camel.support.ExpressionToPredicateAdapter;
import org.apache.camel.support.LanguageSupport;
import org.apache.camel.support.builder.Namespaces;
import org.apache.camel.support.component.PropertyConfigurerSupport;
import org.apache.camel.util.ObjectHelper;

@Language(value="xtokenize")
public class XMLTokenizeLanguage
extends LanguageSupport
implements PropertyConfigurer {
    private String headerName;
    private String path;
    private char mode;
    private int group;
    private Namespaces namespaces;

    @Deprecated
    public static Expression tokenize(String path) {
        return XMLTokenizeLanguage.tokenize(null, path, 'i');
    }

    @Deprecated
    public static Expression tokenize(String path, char mode) {
        return XMLTokenizeLanguage.tokenize(null, path, mode);
    }

    @Deprecated
    public static Expression tokenize(String headerName, String path) {
        return XMLTokenizeLanguage.tokenize(headerName, path, 'i');
    }

    @Deprecated
    public static Expression tokenize(String headerName, String path, char mode) {
        return XMLTokenizeLanguage.tokenize(headerName, path, mode, 1, null);
    }

    @Deprecated
    public static Expression tokenize(String headerName, String path, char mode, int group, Namespaces namespaces) {
        XMLTokenizeLanguage language = new XMLTokenizeLanguage();
        language.setHeaderName(headerName);
        language.setMode(mode);
        language.setGroup(group);
        language.setNamespaces(namespaces);
        return language.createExpression(path);
    }

    @Override
    public Predicate createPredicate(String expression) {
        return ExpressionToPredicateAdapter.toPredicate(this.createExpression(expression));
    }

    @Override
    public Expression createExpression(String expression) {
        String path = expression != null ? expression : this.path;
        ObjectHelper.notNull(path, "path");
        XMLTokenExpressionIterator expr = new XMLTokenExpressionIterator(path, this.mode, this.group, this.headerName);
        if (this.namespaces != null) {
            expr.setNamespaces(this.namespaces.getNamespaces());
        }
        return expr;
    }

    @Override
    public Predicate createPredicate(String expression, Object[] properties) {
        return ExpressionToPredicateAdapter.toPredicate(this.createExpression(expression, properties));
    }

    @Override
    public Expression createExpression(String expression, Object[] properties) {
        XMLTokenizeLanguage answer = new XMLTokenizeLanguage();
        answer.setHeaderName(this.property(String.class, properties, 0, this.headerName));
        answer.setMode(this.property(Character.class, properties, 1, "i").charValue());
        answer.setGroup(this.property(Integer.class, properties, 2, this.group));
        Object obj = properties[3];
        if (obj instanceof Namespaces) {
            answer.setNamespaces((Namespaces)obj);
        } else if (obj instanceof Map) {
            Namespaces ns = new Namespaces();
            ((Map)obj).forEach(ns::add);
            answer.setNamespaces(ns);
        } else {
            throw new IllegalArgumentException("Namespaces is not instance of java.util.Map or " + Namespaces.class.getName());
        }
        String path = expression != null ? expression : this.path;
        return answer.createExpression(path);
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public char getMode() {
        return this.mode;
    }

    public void setMode(char mode) {
        this.mode = mode;
    }

    public int getGroup() {
        return this.group;
    }

    public void setGroup(int group) {
        this.group = group;
    }

    public Namespaces getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(Namespaces namespaces) {
        this.namespaces = namespaces;
    }

    @Override
    public boolean configure(CamelContext camelContext, Object target, String name, Object value, boolean ignoreCase) {
        if (target != this) {
            throw new IllegalStateException("Can only configure our own instance !");
        }
        switch (ignoreCase ? name.toLowerCase() : name) {
            case "headername": 
            case "headerName": {
                this.setHeaderName(PropertyConfigurerSupport.property(camelContext, String.class, value));
                return true;
            }
            case "mode": {
                this.setMode(PropertyConfigurerSupport.property(camelContext, Character.TYPE, value).charValue());
                return true;
            }
            case "group": {
                this.setGroup(PropertyConfigurerSupport.property(camelContext, Integer.TYPE, value));
                return true;
            }
            case "namespaces": {
                this.setNamespaces(PropertyConfigurerSupport.property(camelContext, Namespaces.class, value));
                return true;
            }
        }
        return false;
    }
}

