/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.xml.jaxb;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.transform.TransformerException;
import org.apache.camel.CamelContext;
import org.apache.camel.DelegateEndpoint;
import org.apache.camel.Endpoint;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NamedNode;
import org.apache.camel.TypeConversionException;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.model.RouteTemplatesDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.spi.ModelToXMLDumper;
import org.apache.camel.spi.PropertiesComponent;
import org.apache.camel.spi.annotations.JdkService;
import org.apache.camel.util.xml.XmlLineNumberParser;
import org.apache.camel.xml.jaxb.JaxbHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@JdkService(value="modelxml-dumper")
public class JaxbModelToXMLDumper
implements ModelToXMLDumper {
    @Override
    public String dumpModelAsXml(CamelContext context, NamedNode definition) throws Exception {
        Document dom;
        JAXBContext jaxbContext = JaxbHelper.getJAXBContext(context);
        LinkedHashMap<String, String> namespaces = new LinkedHashMap<String, String>();
        if (definition instanceof RouteTemplatesDefinition) {
            List<RouteTemplateDefinition> templates = ((RouteTemplatesDefinition)definition).getRouteTemplates();
            for (RouteTemplateDefinition routeTemplateDefinition : templates) {
                JaxbHelper.extractNamespaces(routeTemplateDefinition.getRoute(), namespaces);
                JaxbHelper.resolveEndpointDslUris(routeTemplateDefinition.getRoute());
            }
        } else if (definition instanceof RouteTemplateDefinition) {
            RouteTemplateDefinition template = (RouteTemplateDefinition)definition;
            JaxbHelper.extractNamespaces(template.getRoute(), namespaces);
            JaxbHelper.resolveEndpointDslUris(template.getRoute());
        } else if (definition instanceof RoutesDefinition) {
            List<RouteDefinition> routes = ((RoutesDefinition)definition).getRoutes();
            for (RouteDefinition routeDefinition : routes) {
                JaxbHelper.extractNamespaces(routeDefinition, namespaces);
                JaxbHelper.resolveEndpointDslUris(routeDefinition);
            }
        } else if (definition instanceof RouteDefinition) {
            RouteDefinition route = (RouteDefinition)definition;
            JaxbHelper.extractNamespaces(route, namespaces);
            JaxbHelper.resolveEndpointDslUris(route);
        }
        Marshaller marshaller = jaxbContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", Boolean.TRUE);
        marshaller.setProperty("jaxb.encoding", "UTF-8");
        StringWriter buffer = new StringWriter();
        marshaller.marshal((Object)definition, buffer);
        XmlConverter xmlConverter = JaxbHelper.newXmlConverter(context);
        String xml = buffer.toString();
        try {
            dom = xmlConverter.toDOMDocument(xml, null);
        }
        catch (Exception e) {
            throw new TypeConversionException(xml, Document.class, e);
        }
        JaxbModelToXMLDumper.sanitizeXml(dom);
        Element documentElement = dom.getDocumentElement();
        for (Map.Entry entry : namespaces.entrySet()) {
            String nsPrefix = (String)entry.getKey();
            String prefix = nsPrefix.equals("xmlns") ? nsPrefix : "xmlns:" + nsPrefix;
            documentElement.setAttribute(prefix, (String)entry.getValue());
        }
        Properties outputProperties = new Properties();
        outputProperties.put("omit-xml-declaration", "yes");
        outputProperties.put("encoding", "UTF-8");
        try {
            return xmlConverter.toStringFromDocument(dom, outputProperties);
        }
        catch (TransformerException e) {
            throw new IllegalStateException("Failed converting document object to string", e);
        }
    }

    @Override
    public String dumpModelAsXml(final CamelContext context, final NamedNode definition, final boolean resolvePlaceholders, final boolean resolveDelegateEndpoints) throws Exception {
        String xml = this.dumpModelAsXml(context, definition);
        if (resolvePlaceholders || resolveDelegateEndpoints) {
            final AtomicBoolean changed = new AtomicBoolean();
            ByteArrayInputStream is = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));
            Document dom = XmlLineNumberParser.parseXml(is, new XmlLineNumberParser.XmlTextTransformer(){
                private String prev;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public String transform(String text) {
                    String after = text;
                    if (resolveDelegateEndpoints && "uri".equals(this.prev)) {
                        try {
                            String uri = context.resolvePropertyPlaceholders(text);
                            Endpoint endpoint = context.hasEndpoint(uri);
                            if (endpoint instanceof DelegateEndpoint) {
                                endpoint = ((DelegateEndpoint)endpoint).getEndpoint();
                                after = endpoint.getEndpointUri();
                            }
                        }
                        catch (Exception uri) {
                            // empty catch block
                        }
                    }
                    if (resolvePlaceholders) {
                        RouteDefinition routeDefinition;
                        PropertiesComponent pc = context.getPropertiesComponent();
                        if (definition instanceof RouteDefinition && (routeDefinition = (RouteDefinition)definition).isTemplate() != null && routeDefinition.isTemplate().booleanValue() && routeDefinition.getTemplateParameters() != null) {
                            Properties prop = new Properties();
                            prop.putAll(routeDefinition.getTemplateParameters());
                            pc.setLocalProperties(prop);
                        }
                        try {
                            after = context.resolvePropertyPlaceholders(after);
                        }
                        catch (Exception exception) {
                        }
                        finally {
                            pc.setLocalProperties(null);
                        }
                    }
                    if (!changed.get()) {
                        changed.set(!text.equals(after));
                    }
                    this.prev = text;
                    return after;
                }
            });
            if (changed.get()) {
                xml = context.getTypeConverter().mandatoryConvertTo(String.class, dom);
                ExtendedCamelContext ecc = context.adapt(ExtendedCamelContext.class);
                NamedNode copy = JaxbHelper.modelToXml(context, xml, NamedNode.class);
                xml = ecc.getModelToXMLDumper().dumpModelAsXml(context, copy);
            }
        }
        return xml;
    }

    private static void sanitizeXml(Node node) {
        Node att;
        if (node.hasAttributes() && (att = node.getAttributes().getNamedItem("customId")) != null && "false".equals(att.getNodeValue())) {
            node.getAttributes().removeNamedItem("customId");
        }
        if (node.hasChildNodes()) {
            for (int i = 0; i < node.getChildNodes().getLength(); ++i) {
                Node child = node.getChildNodes().item(i);
                JaxbModelToXMLDumper.sanitizeXml(child);
            }
        }
    }
}

