/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ext.logging.event;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.ext.logging.event.LogEvent;
import org.apache.cxf.ext.logging.event.LogEventSender;
import org.apache.cxf.staxutils.PrettyPrintXMLStreamWriter;
import org.apache.cxf.staxutils.StaxUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrettyLoggingFilter
implements LogEventSender {
    private static final Logger LOG = LoggerFactory.getLogger(PrettyLoggingFilter.class);
    private LogEventSender next;
    private boolean prettyLogging;

    public PrettyLoggingFilter(LogEventSender next) {
        this.next = next;
        this.prettyLogging = false;
    }

    @Override
    public void send(LogEvent event) {
        if (this.shouldPrettyPrint(event)) {
            event.setPayload(this.getPrettyMessage(event));
        }
        this.next.send(event);
    }

    private boolean shouldPrettyPrint(LogEvent event) {
        String contentType = event.getContentType();
        return this.prettyLogging && contentType != null && contentType.indexOf("xml") >= 0 && contentType.toLowerCase().indexOf("multipart/related") < 0 && event.getPayload() != null && event.getPayload().length() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPrettyMessage(LogEvent event) {
        String payload = event.getPayload();
        StringWriter swriter = new StringWriter(this.estimatePrettySize(payload));
        PrettyPrintXMLStreamWriter xwriter = new PrettyPrintXMLStreamWriter(StaxUtils.createXMLStreamWriter(swriter), 2);
        XMLStreamReader xreader = StaxUtils.createXMLStreamReader(new StringReader(payload));
        try {
            StaxUtils.copy(xreader, (XMLStreamWriter)xwriter);
            xwriter.flush();
        }
        catch (XMLStreamException xse) {
            String string = this.getPrettyMessageAfterExceptionHandling(xse, event, payload, swriter, xwriter);
            return string;
        }
        catch (RuntimeException ex) {
            if (!(ex.getCause() instanceof XMLStreamException)) {
                throw ex;
            }
            XMLStreamException xse = (XMLStreamException)ex.getCause();
            String string = this.getPrettyMessageAfterExceptionHandling(xse, event, payload, swriter, xwriter);
            return string;
        }
        finally {
            this.close(xwriter);
            this.close(xreader);
        }
        return swriter.toString();
    }

    private String getPrettyMessageAfterExceptionHandling(XMLStreamException xse, LogEvent event, String payload, StringWriter swriter, XMLStreamWriter xwriter) {
        if (!event.isTruncated()) {
            LOG.debug("Error while pretty printing cxf message, returning raw message.", (Throwable)xse);
            return payload;
        }
        this.flush(xwriter);
        return swriter.toString();
    }

    private void flush(XMLStreamWriter xwriter) {
        try {
            xwriter.flush();
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    private void close(XMLStreamWriter xwriter) {
        try {
            xwriter.close();
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    private void close(XMLStreamReader xreader) {
        try {
            xreader.close();
        }
        catch (XMLStreamException xMLStreamException) {
            // empty catch block
        }
    }

    private int estimatePrettySize(String payload) {
        return payload.length() * 2;
    }

    public void setNext(LogEventSender next) {
        this.next = next;
    }

    public void setPrettyLogging(boolean prettyLogging) {
        this.prettyLogging = prettyLogging;
    }
}

