/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.ws.rs.BeanParam;
import javax.ws.rs.CookieParam;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.PathParam;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.InvocationCallback;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PrimitiveUtils;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.jaxrs.client.AbstractClient;
import org.apache.cxf.jaxrs.client.Client;
import org.apache.cxf.jaxrs.client.ClientProviderFactory;
import org.apache.cxf.jaxrs.client.ClientState;
import org.apache.cxf.jaxrs.client.InvocationHandlerAware;
import org.apache.cxf.jaxrs.client.JAXRSClientFactory;
import org.apache.cxf.jaxrs.client.JaxrsClientCallback;
import org.apache.cxf.jaxrs.client.LocalClientState;
import org.apache.cxf.jaxrs.client.ResponseExceptionMapper;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.Multipart;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.ResponseImpl;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.model.Parameter;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.FormUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;

public class ClientProxyImpl
extends AbstractClient
implements InvocationHandlerAware,
InvocationHandler,
Closeable {
    protected static final Logger LOG = LogUtils.getL7dLogger(ClientProxyImpl.class);
    protected static final ResourceBundle BUNDLE = BundleUtils.getBundle(ClientProxyImpl.class);
    protected static final String SLASH = "/";
    protected static final String BUFFER_PROXY_RESPONSE = "buffer.proxy.response";
    protected static final String PROXY_METHOD_PARAM_BODY_INDEX = "proxy.method.parameter.body.index";
    protected ClassResourceInfo cri;
    protected ClassLoader proxyLoader;
    protected boolean inheritHeaders;
    protected boolean isRoot;
    protected Map<String, Object> valuesMap = Collections.emptyMap();
    protected BodyWriter bodyWriter = new BodyWriter();
    protected Client proxy;

    public ClientProxyImpl(URI baseURI, ClassLoader loader, ClassResourceInfo cri, boolean isRoot, boolean inheritHeaders, Object ... varValues) {
        this(baseURI, loader, cri, isRoot, inheritHeaders, Collections.emptyMap(), varValues);
    }

    public ClientProxyImpl(URI baseURI, ClassLoader loader, ClassResourceInfo cri, boolean isRoot, boolean inheritHeaders, Map<String, Object> properties, Object ... varValues) {
        this(new LocalClientState(baseURI, properties), loader, cri, isRoot, inheritHeaders, varValues);
    }

    public ClientProxyImpl(ClientState initialState, ClassLoader loader, ClassResourceInfo cri, boolean isRoot, boolean inheritHeaders, Object ... varValues) {
        super(initialState);
        this.proxyLoader = loader;
        this.cri = cri;
        this.isRoot = isRoot;
        this.inheritHeaders = inheritHeaders;
        this.initValuesMap(varValues);
        this.cfg.getInInterceptors().add(new ClientAsyncResponseInterceptor());
    }

    void setProxyClient(Client client) {
        this.proxy = client;
    }

    private void initValuesMap(Object ... varValues) {
        if (this.isRoot) {
            List<String> vars = this.cri.getURITemplate().getVariables();
            this.valuesMap = new LinkedHashMap<String, Object>();
            for (int i = 0; i < vars.size(); ++i) {
                if (varValues.length > 0) {
                    if (i < varValues.length) {
                        this.valuesMap.put(vars.get(i), varValues[i]);
                        continue;
                    }
                    org.apache.cxf.common.i18n.Message msg = new org.apache.cxf.common.i18n.Message("ROOT_VARS_MISMATCH", BUNDLE, vars.size(), varValues.length);
                    LOG.info(msg.toString());
                    break;
                }
                this.valuesMap.put(vars.get(i), "");
            }
        }
    }

    private static Object invokeDefaultMethod(final Class<?> declaringClass, final Object o, final Method m, final Object[] params) throws Throwable {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    try {
                        Field f;
                        MethodHandles.Lookup lookup = MethodHandles.publicLookup().in(declaringClass);
                        try {
                            f = MethodHandles.Lookup.class.getDeclaredField("allowedModes");
                        }
                        catch (NoSuchFieldException nsfe) {
                            f = MethodHandles.Lookup.class.getDeclaredField("accessMode");
                            m.setAccessible(true);
                        }
                        int modifiers = f.getModifiers();
                        if (Modifier.isFinal(modifiers)) {
                            Field modifiersField = Field.class.getDeclaredField("modifiers");
                            modifiersField.setAccessible(true);
                            modifiersField.setInt(f, modifiers & 0xFFFFFFEF);
                            f.setAccessible(true);
                            f.set(lookup, 2);
                        }
                        MethodHandle mh = lookup.unreflectSpecial(m, declaringClass).bindTo(o);
                        return params != null && params.length > 0 ? mh.invokeWithArguments(params) : mh.invoke();
                    }
                    catch (Throwable t) {
                        try {
                            return ClientProxyImpl.invokeDefaultMethodUsingPrivateLookup(declaringClass, o, m, params);
                        }
                        catch (NoSuchMethodException ex) {
                            throw new WrappedException(t);
                        }
                    }
                }
            });
        }
        catch (PrivilegedActionException pae) {
            Throwable wrapped = pae.getCause();
            if (wrapped instanceof WrappedException) {
                throw ((WrappedException)wrapped).getWrapped();
            }
            throw wrapped;
        }
    }

    private static Object invokeDefaultMethodUsingPrivateLookup(Class<?> declaringClass, Object o, Method m, Object[] params) throws WrappedException, NoSuchMethodException {
        try {
            Method privateLookup = MethodHandles.class.getDeclaredMethod("privateLookupIn", Class.class, MethodHandles.Lookup.class);
            return ((MethodHandles.Lookup)privateLookup.invoke(null, declaringClass, MethodHandles.lookup())).unreflectSpecial(m, declaringClass).bindTo(o).invokeWithArguments(params);
        }
        catch (NoSuchMethodException t) {
            throw t;
        }
        catch (Throwable t) {
            throw new WrappedException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object o, Method m, Object[] params) throws Throwable {
        this.checkClosed();
        Class<?> declaringClass = m.getDeclaringClass();
        if (Client.class == declaringClass || InvocationHandlerAware.class == declaringClass || Object.class == declaringClass || Closeable.class == declaringClass || AutoCloseable.class == declaringClass) {
            return m.invoke((Object)this, params);
        }
        this.resetResponse();
        OperationResourceInfo ori = this.cri.getMethodDispatcher().getOperationResourceInfo(m);
        if (ori == null) {
            if (m.isDefault()) {
                return ClientProxyImpl.invokeDefaultMethod(declaringClass, o, m, params);
            }
            ClientProxyImpl.reportInvalidResourceMethod(m, "INVALID_RESOURCE_METHOD");
        }
        MultivaluedMap<ParameterType, Parameter> types = this.getParametersInfo(m, params, ori);
        List<Parameter> beanParamsList = ClientProxyImpl.getParameters(types, ParameterType.BEAN);
        int bodyIndex = ClientProxyImpl.getBodyIndex(types, ori);
        List<Object> pathParams = this.getPathParamValues(m, params, types, beanParamsList, ori, bodyIndex);
        UriBuilder builder = this.getCurrentBuilder().clone();
        if (this.isRoot) {
            this.addNonEmptyPath(builder, ori.getClassResourceInfo().getURITemplate().getValue());
        }
        this.addNonEmptyPath(builder, ori.getURITemplate().getValue());
        this.handleMatrixes(m, params, types, beanParamsList, builder);
        this.handleQueries(m, params, types, beanParamsList, builder);
        URI uri = builder.buildFromEncoded(pathParams.toArray()).normalize();
        MultivaluedMap<String, String> headers = this.getHeaders();
        MetadataMap<String, String> paramHeaders = new MetadataMap<String, String>();
        this.handleHeaders(m, params, paramHeaders, beanParamsList, types);
        this.handleCookies(m, params, paramHeaders, beanParamsList, types);
        if (ori.isSubResourceLocator()) {
            ClassResourceInfo subCri = this.cri.getSubResource(m.getReturnType(), m.getReturnType());
            if (subCri == null) {
                ClientProxyImpl.reportInvalidResourceMethod(m, "INVALID_SUBRESOURCE");
            }
            MetadataMap<String, String> subHeaders = paramHeaders;
            if (this.inheritHeaders) {
                subHeaders.putAll((Map<String, String>)headers);
            }
            ClientState newState = this.getState().newState(uri, subHeaders, this.getTemplateParametersMap(ori.getURITemplate(), pathParams));
            ClientProxyImpl proxyImpl = new ClientProxyImpl(newState, this.proxyLoader, subCri, false, this.inheritHeaders, new Object[0]);
            proxyImpl.setConfiguration(this.getConfiguration());
            return JAXRSClientFactory.createProxy(m.getReturnType(), this.proxyLoader, proxyImpl);
        }
        headers.putAll(paramHeaders);
        this.getState().setTemplates(this.getTemplateParametersMap(ori.getURITemplate(), pathParams));
        MultivaluedMap<String, String> body = null;
        if (bodyIndex != -1) {
            body = params[bodyIndex];
            if (body == null) {
                bodyIndex = -1;
            }
        } else if (types.containsKey((Object)ParameterType.FORM)) {
            body = this.handleForm(m, params, types, beanParamsList);
        } else if (types.containsKey((Object)ParameterType.REQUEST_BODY)) {
            body = this.handleMultipart(types, ori, params);
        } else if (this.hasFormParams(params, beanParamsList)) {
            body = this.handleForm(m, params, types, beanParamsList);
        }
        this.setRequestHeaders(headers, ori, types.containsKey((Object)ParameterType.FORM), body == null ? null : body.getClass(), m.getReturnType());
        try {
            Object object = this.doChainedInvocation(uri, headers, ori, params, body, bodyIndex, null, null);
            return object;
        }
        finally {
            this.resetResponseStateImmediatelyIfNeeded();
        }
    }

    protected void addNonEmptyPath(UriBuilder builder, String pathValue) {
        if (!SLASH.equals(pathValue)) {
            builder.path(pathValue);
        }
    }

    protected MultivaluedMap<ParameterType, Parameter> getParametersInfo(Method m, Object[] params, OperationResourceInfo ori) {
        MetadataMap<ParameterType, Parameter> map = new MetadataMap<ParameterType, Parameter>();
        List<Parameter> parameters = ori.getParameters();
        if (parameters.isEmpty()) {
            return map;
        }
        int requestBodyParam = 0;
        int multipartParam = 0;
        for (Parameter p : parameters) {
            if (this.isIgnorableParameter(m, p)) continue;
            if (p.getType() == ParameterType.REQUEST_BODY) {
                ++requestBodyParam;
                if (ClientProxyImpl.getMultipart(ori, p.getIndex()) != null) {
                    ++multipartParam;
                }
            }
            map.add(p.getType(), p);
        }
        if (map.containsKey((Object)ParameterType.REQUEST_BODY)) {
            if (requestBodyParam > 1 && requestBodyParam != multipartParam) {
                ClientProxyImpl.reportInvalidResourceMethod(ori.getMethodToInvoke(), "SINGLE_BODY_ONLY");
            }
            if (map.containsKey((Object)ParameterType.FORM)) {
                ClientProxyImpl.reportInvalidResourceMethod(ori.getMethodToInvoke(), "ONLY_FORM_ALLOWED");
            }
        }
        return map;
    }

    protected boolean isIgnorableParameter(Method m, Parameter p) {
        if (p.getType() == ParameterType.CONTEXT) {
            return true;
        }
        return p.getType() == ParameterType.REQUEST_BODY && m.getParameterTypes()[p.getIndex()] == AsyncResponse.class;
    }

    protected static int getBodyIndex(MultivaluedMap<ParameterType, Parameter> map, OperationResourceInfo ori) {
        int index;
        List list = (List)map.get((Object)ParameterType.REQUEST_BODY);
        int n = index = list == null || list.size() > 1 ? -1 : ((Parameter)list.get(0)).getIndex();
        if (ori.isSubResourceLocator() && index != -1) {
            ClientProxyImpl.reportInvalidResourceMethod(ori.getMethodToInvoke(), "NO_BODY_IN_SUBRESOURCE");
        }
        return index;
    }

    protected void checkResponse(Method m, Response r, Message inMessage) throws Throwable {
        WebApplicationException t = null;
        int status = r.getStatus();
        if (status >= 300) {
            Class<?>[] exTypes = m.getExceptionTypes();
            if (exTypes.length == 0) {
                exTypes = new Class[]{WebApplicationException.class};
            }
            for (Class<?> exType : exTypes) {
                ResponseExceptionMapper<?> mapper = ClientProxyImpl.findExceptionMapper(inMessage, exType);
                if (mapper == null || (t = mapper.fromResponse(r)) == null) continue;
                throw t;
            }
            if (t == null && m.getReturnType() == Response.class && m.getExceptionTypes().length == 0) {
                return;
            }
            t = this.convertToWebApplicationException(r);
            if (inMessage.getExchange().get(Message.RESPONSE_CODE) == null) {
                throw t;
            }
            Endpoint ep = inMessage.getExchange().getEndpoint();
            inMessage.getExchange().put(InterceptorProvider.class, this.getConfiguration());
            inMessage.setContent(Exception.class, new Fault(t));
            inMessage.getInterceptorChain().abort();
            if (ep.getInFaultObserver() != null) {
                ep.getInFaultObserver().onMessage(inMessage);
            }
            throw t;
        }
    }

    protected static ResponseExceptionMapper<?> findExceptionMapper(Message message, Class<?> exType) {
        ClientProviderFactory pf = ClientProviderFactory.getInstance(message);
        return pf.createResponseExceptionMapper(message, exType);
    }

    protected MultivaluedMap<String, String> setRequestHeaders(MultivaluedMap<String, String> headers, OperationResourceInfo ori, boolean formParams, Class<?> bodyClass, Class<?> responseClass) {
        List<MediaType> accepts;
        if (headers.getFirst("Content-Type") == null) {
            if (formParams || bodyClass != null && MultivaluedMap.class.isAssignableFrom(bodyClass)) {
                headers.putSingle("Content-Type", "application/x-www-form-urlencoded");
            } else {
                String ctType = null;
                List<MediaType> consumeTypes = ori.getConsumeTypes();
                if (!consumeTypes.isEmpty() && !consumeTypes.get(0).equals(MediaType.WILDCARD_TYPE)) {
                    ctType = JAXRSUtils.mediaTypeToString(ori.getConsumeTypes().get(0), new String[0]);
                }
                if (ctType != null) {
                    headers.putSingle("Content-Type", ctType);
                }
            }
        }
        if ((accepts = this.getAccept(headers)) == null) {
            if (responseClass == Void.class || responseClass == Void.TYPE) {
                accepts = Collections.singletonList(MediaType.WILDCARD_TYPE);
            } else {
                boolean produceWildcard;
                List<MediaType> produceTypes = ori.getProduceTypes();
                boolean bl = produceWildcard = produceTypes.isEmpty() || produceTypes.get(0).equals(MediaType.WILDCARD_TYPE);
                accepts = produceWildcard ? (InjectionUtils.isPrimitive(responseClass) ? Collections.singletonList(MediaType.TEXT_PLAIN_TYPE) : Collections.singletonList(MediaType.APPLICATION_XML_TYPE)) : produceTypes;
            }
            for (MediaType mt : accepts) {
                headers.add("Accept", JAXRSUtils.mediaTypeToString(mt, new String[0]));
            }
        }
        return headers;
    }

    protected List<MediaType> getAccept(MultivaluedMap<String, String> allHeaders) {
        List headers = (List)allHeaders.get("Accept");
        if (headers == null || headers.isEmpty()) {
            return null;
        }
        return headers.stream().flatMap(header -> JAXRSUtils.parseMediaTypes(header).stream()).collect(Collectors.toList());
    }

    protected List<Object> getPathParamValues(Method m, Object[] params, MultivaluedMap<ParameterType, Parameter> map, List<Parameter> beanParams, OperationResourceInfo ori, int bodyIndex) {
        ArrayList<Object> list = new ArrayList<Object>();
        List<String> methodVars = ori.getURITemplate().getVariables();
        List<Parameter> paramsList = ClientProxyImpl.getParameters(map, ParameterType.PATH);
        HashMap beanParamValues = new HashMap(beanParams.size());
        beanParams.forEach(p -> beanParamValues.putAll(this.getValuesFromBeanParam(params[p.getIndex()], PathParam.class)));
        if (!beanParamValues.isEmpty() && !methodVars.containsAll(beanParamValues.keySet())) {
            List<String> classVars = ori.getClassResourceInfo().getURITemplate().getVariables();
            classVars.forEach(classVar -> {
                BeanPair pair = (BeanPair)beanParamValues.get(classVar);
                if (pair != null) {
                    String paramValue = this.convertParamValue(pair.getValue(), pair.getAnns());
                    if (this.isRoot) {
                        this.valuesMap.put((String)classVar, paramValue);
                    } else {
                        list.add(paramValue);
                    }
                }
            });
        }
        if (this.isRoot) {
            list.addAll(this.valuesMap.values());
        }
        LinkedHashMap paramsMap = new LinkedHashMap();
        paramsList.forEach(p -> {
            if (p.getName().isEmpty()) {
                MultivaluedMap<String, Object> values = InjectionUtils.extractValuesFromBean(params[p.getIndex()], "");
                methodVars.forEach(var -> list.addAll((Collection)values.get(var)));
            } else {
                paramsMap.put(p.getName(), p);
            }
        });
        Object requestBody = bodyIndex == -1 ? null : params[bodyIndex];
        methodVars.forEach(varName -> {
            Parameter p = (Parameter)paramsMap.remove(varName);
            if (p != null) {
                list.add(this.convertParamValue(params[p.getIndex()], m.getParameterTypes()[p.getIndex()], ClientProxyImpl.getParamAnnotations(m, p)));
            } else if (beanParamValues.containsKey(varName)) {
                BeanPair pair = (BeanPair)beanParamValues.get(varName);
                list.add(this.convertParamValue(pair.getValue(), pair.getAnns()));
            } else if (requestBody != null) {
                try {
                    Method getter = requestBody.getClass().getMethod("get" + StringUtils.capitalize(varName), new Class[0]);
                    list.add(getter.invoke(requestBody, new Object[0]));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        block0: for (Parameter p2 : paramsMap.values()) {
            if (!this.valuesMap.containsKey(p2.getName())) continue;
            int index = 0;
            Iterator<String> it = this.valuesMap.keySet().iterator();
            while (it.hasNext()) {
                if (it.next().equals(p2.getName()) && index < list.size()) {
                    list.set(index, this.convertParamValue(params[p2.getIndex()], null));
                    continue block0;
                }
                ++index;
            }
        }
        return list;
    }

    protected static Annotation[] getParamAnnotations(Method m, Parameter p) {
        return m.getParameterAnnotations()[p.getIndex()];
    }

    protected static List<Parameter> getParameters(MultivaluedMap<ParameterType, Parameter> map, ParameterType key) {
        return map.get((Object)key) == null ? Collections.emptyList() : (List)map.get((Object)key);
    }

    protected void handleQueries(Method m, Object[] params, MultivaluedMap<ParameterType, Parameter> map, List<Parameter> beanParams, UriBuilder ub) {
        List<Parameter> qs = ClientProxyImpl.getParameters(map, ParameterType.QUERY);
        qs.stream().filter(p -> params[p.getIndex()] != null).forEachOrdered(p -> this.addMatrixQueryParamsToBuilder(ub, p.getName(), ParameterType.QUERY, ClientProxyImpl.getParamAnnotations(m, p), params[p.getIndex()]));
        beanParams.stream().map(p -> this.getValuesFromBeanParam(params[p.getIndex()], QueryParam.class)).forEachOrdered(values -> values.forEach((key, value) -> {
            if (value != null) {
                this.addMatrixQueryParamsToBuilder(ub, (String)key, ParameterType.QUERY, value.getAnns(), value.getValue());
            }
        }));
    }

    protected Map<String, BeanPair> getValuesFromBeanParam(Object bean, Class<? extends Annotation> annClass) {
        HashMap<String, BeanPair> values = new HashMap<String, BeanPair>();
        this.getValuesFromBeanParam(bean, annClass, values);
        return values;
    }

    protected Map<String, BeanPair> getValuesFromBeanParam(Object bean, Class<? extends Annotation> annClass, Map<String, BeanPair> values) {
        boolean completeFieldIntrospectionNeeded = false;
        for (Method m : bean.getClass().getMethods()) {
            if (m.getName().startsWith("set")) {
                try {
                    boolean beanParam;
                    String propertyName = m.getName().substring(3);
                    Annotation methodAnnotation = m.getAnnotation(annClass);
                    boolean bl = beanParam = m.getAnnotation(BeanParam.class) != null;
                    if (methodAnnotation != null || beanParam) {
                        Method getter = bean.getClass().getMethod("get" + propertyName, new Class[0]);
                        Object value = getter.invoke(bean, new Object[0]);
                        if (value != null) {
                            if (methodAnnotation != null) {
                                String annotationValue = AnnotationUtils.getAnnotationValue(methodAnnotation);
                                values.put(annotationValue, new BeanPair(value, m.getParameterAnnotations()[0]));
                            } else {
                                this.getValuesFromBeanParam(value, annClass, values);
                            }
                        }
                    } else {
                        Object value;
                        String fieldName = StringUtils.uncapitalize(propertyName);
                        Field f = InjectionUtils.getDeclaredField(bean.getClass(), fieldName);
                        if (f == null) {
                            completeFieldIntrospectionNeeded = true;
                            continue;
                        }
                        boolean jaxrsParamAnnAvailable = this.getValuesFromBeanParamField(bean, f, annClass, values);
                        if (!jaxrsParamAnnAvailable && f.getAnnotation(BeanParam.class) != null && (value = ReflectionUtil.accessDeclaredField(f, bean, Object.class)) != null) {
                            this.getValuesFromBeanParam(value, annClass, values);
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (!completeFieldIntrospectionNeeded) continue;
            for (Field f : bean.getClass().getDeclaredFields()) {
                Object value;
                boolean jaxrsParamAnnAvailable = this.getValuesFromBeanParamField(bean, f, annClass, values);
                if (jaxrsParamAnnAvailable || f.getAnnotation(BeanParam.class) == null || (value = ReflectionUtil.accessDeclaredField(f, bean, Object.class)) == null) continue;
                this.getValuesFromBeanParam(value, annClass, values);
            }
        }
        return values;
    }

    protected boolean getValuesFromBeanParamField(Object bean, Field f, Class<? extends Annotation> annClass, Map<String, BeanPair> values) {
        boolean jaxrsParamAnnAvailable = false;
        Annotation fieldAnnotation = f.getAnnotation(annClass);
        if (fieldAnnotation != null) {
            jaxrsParamAnnAvailable = true;
            Object value = ReflectionUtil.accessDeclaredField(f, bean, Object.class);
            if (value != null) {
                String annotationValue = AnnotationUtils.getAnnotationValue(fieldAnnotation);
                values.put(annotationValue, new BeanPair(value, f.getAnnotations()));
            }
        }
        return jaxrsParamAnnAvailable;
    }

    protected void handleMatrixes(Method m, Object[] params, MultivaluedMap<ParameterType, Parameter> map, List<Parameter> beanParams, UriBuilder ub) {
        List<Parameter> mx = ClientProxyImpl.getParameters(map, ParameterType.MATRIX);
        mx.stream().filter(p -> params[p.getIndex()] != null).forEachOrdered(p -> this.addMatrixQueryParamsToBuilder(ub, p.getName(), ParameterType.MATRIX, ClientProxyImpl.getParamAnnotations(m, p), params[p.getIndex()]));
        beanParams.stream().map(p -> this.getValuesFromBeanParam(params[p.getIndex()], MatrixParam.class)).forEachOrdered(values -> values.forEach((key, value) -> {
            if (value != null) {
                this.addMatrixQueryParamsToBuilder(ub, (String)key, ParameterType.MATRIX, value.getAnns(), value.getValue());
            }
        }));
    }

    protected MultivaluedMap<String, String> handleForm(Method m, Object[] params, MultivaluedMap<ParameterType, Parameter> map, List<Parameter> beanParams) {
        MetadataMap<String, String> form = new MetadataMap<String, String>();
        List<Parameter> fm = ClientProxyImpl.getParameters(map, ParameterType.FORM);
        fm.forEach(p -> this.addFormValue(form, p.getName(), params[p.getIndex()], ClientProxyImpl.getParamAnnotations(m, p)));
        beanParams.stream().map(p -> this.getValuesFromBeanParam(params[p.getIndex()], FormParam.class)).forEachOrdered(values -> values.forEach((key, value) -> this.addFormValue(form, (String)key, value.getValue(), value.getAnns())));
        return form;
    }

    protected void addFormValue(MultivaluedMap<String, String> form, String name, Object pValue, Annotation[] anns) {
        if (pValue != null) {
            if (InjectionUtils.isSupportedCollectionOrArray(pValue.getClass())) {
                List<Object> c = pValue.getClass().isArray() ? Arrays.asList((Object[])pValue) : (List<Object>)pValue;
                Iterator it = c.iterator();
                while (it.hasNext()) {
                    FormUtils.addPropertyToForm(form, name, this.convertParamValue(it.next(), anns));
                }
            } else {
                FormUtils.addPropertyToForm(form, name, name.isEmpty() ? pValue : this.convertParamValue(pValue, anns));
            }
        }
    }

    protected List<Attachment> handleMultipart(MultivaluedMap<ParameterType, Parameter> map, OperationResourceInfo ori, Object[] params) {
        List<Parameter> fm = ClientProxyImpl.getParameters(map, ParameterType.REQUEST_BODY);
        ArrayList<Attachment> atts = new ArrayList<Attachment>(fm.size());
        fm.forEach(p -> {
            Object partObject;
            Multipart part = ClientProxyImpl.getMultipart(ori, p.getIndex());
            if (part != null && (partObject = params[p.getIndex()]) != null) {
                atts.add(new Attachment(part.value(), part.type(), partObject));
            }
        });
        return atts;
    }

    protected void handleHeaders(Method m, Object[] params, MultivaluedMap<String, String> headers, List<Parameter> beanParams, MultivaluedMap<ParameterType, Parameter> map) {
        List<Parameter> hs = ClientProxyImpl.getParameters(map, ParameterType.HEADER);
        hs.stream().filter(p -> params[p.getIndex()] != null).forEachOrdered(p -> headers.add(p.getName(), this.convertParamValue(params[p.getIndex()], ClientProxyImpl.getParamAnnotations(m, p))));
        beanParams.stream().map(p -> this.getValuesFromBeanParam(params[p.getIndex()], HeaderParam.class)).forEachOrdered(values -> values.forEach((key, value) -> {
            if (value != null) {
                headers.add((String)key, this.convertParamValue(value.getValue(), value.getAnns()));
            }
        }));
    }

    protected static Multipart getMultipart(OperationResourceInfo ori, int index) {
        Method aMethod = ori.getAnnotatedMethod();
        return aMethod != null ? AnnotationUtils.getAnnotation(aMethod.getParameterAnnotations()[index], Multipart.class) : null;
    }

    protected void handleCookies(Method m, Object[] params, MultivaluedMap<String, String> headers, List<Parameter> beanParams, MultivaluedMap<ParameterType, Parameter> map) {
        List<Parameter> cs = ClientProxyImpl.getParameters(map, ParameterType.COOKIE);
        cs.stream().filter(p -> params[p.getIndex()] != null).forEachOrdered(p -> headers.add("Cookie", p.getName() + '=' + this.convertParamValue(params[p.getIndex()].toString(), ClientProxyImpl.getParamAnnotations(m, p))));
        beanParams.stream().map(p -> this.getValuesFromBeanParam(params[p.getIndex()], CookieParam.class)).forEachOrdered(values -> values.forEach((key, value) -> {
            if (value != null) {
                headers.add("Cookie", key + "=" + this.convertParamValue(value.getValue(), value.getAnns()));
            }
        }));
    }

    protected Message createMessage(Object body, OperationResourceInfo ori, MultivaluedMap<String, String> headers, URI currentURI, Exchange exchange, Map<String, Object> invocationContext, boolean isProxy) {
        return this.createMessage(body, ori.getHttpMethod(), headers, currentURI, exchange, invocationContext, isProxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object doChainedInvocation(URI uri, MultivaluedMap<String, String> headers, OperationResourceInfo ori, Object[] methodParams, Object body, int bodyIndex, Exchange exchange, Map<String, Object> invocationContext) throws Throwable {
        Bus configuredBus = this.getConfiguration().getBus();
        Bus origBus = BusFactory.getAndSetThreadDefaultBus(configuredBus);
        ClassLoaderUtils.ClassLoaderHolder origLoader = null;
        try {
            Object object;
            ClassLoader loader = configuredBus.getExtension(ClassLoader.class);
            if (loader != null) {
                origLoader = ClassLoaderUtils.setThreadContextClassloader(loader);
            }
            Message outMessage = this.createMessage(body, ori, headers, uri, exchange, invocationContext, true);
            if (bodyIndex != -1) {
                outMessage.put(Type.class, ori.getMethodToInvoke().getGenericParameterTypes()[bodyIndex]);
            }
            outMessage.getExchange().setOneWay(ori.isOneway());
            this.setSupportOnewayResponseProperty(outMessage);
            outMessage.setContent(OperationResourceInfo.class, ori);
            this.setPlainOperationNameProperty(outMessage, ori.getMethodToInvoke().getName());
            outMessage.getExchange().put(Method.class, ori.getMethodToInvoke());
            outMessage.put(Annotation.class.getName(), ClientProxyImpl.getMethodAnnotations(ori.getAnnotatedMethod(), bodyIndex));
            outMessage.getExchange().put("org.apache.cxf.service.object", this.proxy);
            if (methodParams != null) {
                outMessage.put(List.class, Arrays.asList(methodParams));
            }
            if (body != null) {
                outMessage.put(PROXY_METHOD_PARAM_BODY_INDEX, bodyIndex);
            }
            outMessage.getInterceptorChain().add(this.bodyWriter);
            Map<String, Object> reqContext = this.getRequestContext(outMessage);
            reqContext.put(OperationResourceInfo.class.getName(), ori);
            reqContext.put(PROXY_METHOD_PARAM_BODY_INDEX, bodyIndex);
            InvocationCallback<Object> asyncCallback = this.checkAsyncCallback(ori, reqContext, outMessage);
            if (asyncCallback != null) {
                Object object2 = this.doInvokeAsync(ori, outMessage, asyncCallback);
                return object2;
            }
            this.doRunInterceptorChain(outMessage);
            Object[] results = this.preProcessResult(outMessage);
            if (results != null && results.length == 1) {
                Object object3 = results[0];
                return object3;
            }
            try {
                object = this.handleResponse(outMessage, ori.getClassResourceInfo().getServiceClass());
            }
            catch (Throwable throwable) {
                this.completeExchange(outMessage.getExchange(), true);
                throw throwable;
            }
            this.completeExchange(outMessage.getExchange(), true);
            return object;
        }
        finally {
            if (origLoader != null) {
                origLoader.reset();
            }
            if (origBus != configuredBus) {
                BusFactory.setThreadDefaultBus(origBus);
            }
        }
    }

    protected InvocationCallback<Object> checkAsyncCallback(OperationResourceInfo ori, Map<String, Object> reqContext, Message outMessage) {
        Object callbackProp = reqContext.get(InvocationCallback.class.getName());
        if (callbackProp != null) {
            if (callbackProp instanceof Collection) {
                Collection callbacks = (Collection)callbackProp;
                for (InvocationCallback callback : callbacks) {
                    if (this.doCheckAsyncCallback(ori, callback) == null) continue;
                    return callback;
                }
            } else {
                InvocationCallback callback = (InvocationCallback)callbackProp;
                return this.doCheckAsyncCallback(ori, callback);
            }
        }
        return null;
    }

    protected InvocationCallback<Object> doCheckAsyncCallback(OperationResourceInfo ori, InvocationCallback<Object> callback) {
        Type callbackOutType = ClientProxyImpl.getCallbackType(callback);
        Class<?> callbackRespClass = ClientProxyImpl.getCallbackClass(callbackOutType);
        Class<?> methodReturnType = ori.getMethodToInvoke().getReturnType();
        if (Object.class == callbackRespClass || callbackRespClass.isAssignableFrom(methodReturnType) || PrimitiveUtils.canPrimitiveTypeBeAutoboxed(methodReturnType, callbackRespClass)) {
            return callback;
        }
        return null;
    }

    protected Object doInvokeAsync(OperationResourceInfo ori, Message outMessage, InvocationCallback<Object> asyncCallback) {
        outMessage.getExchange().setSynchronous(false);
        this.setAsyncMessageObserverIfNeeded(outMessage.getExchange());
        JaxrsClientCallback<?> cb = this.newJaxrsClientCallback(asyncCallback, outMessage, ori.getMethodToInvoke().getReturnType(), ori.getMethodToInvoke().getGenericReturnType());
        outMessage.getExchange().put(JaxrsClientCallback.class, cb);
        this.doRunInterceptorChain(outMessage);
        return null;
    }

    protected JaxrsClientCallback<?> newJaxrsClientCallback(InvocationCallback<Object> asyncCallback, Message outMessage, Class<?> responseClass, Type outGenericType) {
        return new JaxrsClientCallback<Object>(asyncCallback, responseClass, outGenericType);
    }

    @Override
    protected Object retryInvoke(URI newRequestURI, MultivaluedMap<String, String> headers, Object body, Exchange exchange, Map<String, Object> invContext) throws Throwable {
        Map reqContext = CastUtils.cast((Map)invContext.get("RequestContext"));
        int bodyIndex = body != null ? (Integer)reqContext.get(PROXY_METHOD_PARAM_BODY_INDEX) : -1;
        OperationResourceInfo ori = (OperationResourceInfo)reqContext.get(OperationResourceInfo.class.getName());
        return this.doChainedInvocation(newRequestURI, headers, ori, null, body, bodyIndex, exchange, invContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object handleResponse(Message outMessage, Class<?> serviceCls) throws Throwable {
        try {
            Response r = this.setResponseBuilder(outMessage, outMessage.getExchange()).build();
            ((ResponseImpl)r).setOutMessage(outMessage);
            this.getState().setResponse(r);
            Method method = outMessage.getExchange().get(Method.class);
            this.checkResponse(method, r, outMessage);
            if (method.getReturnType() == Void.class || method.getReturnType() == Void.TYPE) {
                Object var5_5 = null;
                return var5_5;
            }
            if (method.getReturnType() == Response.class && (r.getEntity() == null || InputStream.class.isAssignableFrom(r.getEntity().getClass()) && ((InputStream)r.getEntity()).available() == 0)) {
                Response response = r;
                return response;
            }
            if (PropertyUtils.isTrue(super.getConfiguration().getResponseContext().get(BUFFER_PROXY_RESPONSE))) {
                r.bufferEntity();
            }
            Class<?> returnType = this.getReturnType(method, outMessage);
            Type genericType = this.getGenericReturnType(serviceCls, method, returnType);
            returnType = InjectionUtils.updateParamClassToTypeIfNeeded(returnType, genericType);
            Object obj = this.readBody(r, outMessage, returnType, genericType, method.getDeclaredAnnotations());
            return obj;
        }
        finally {
            ClientProviderFactory.getInstance(outMessage).clearThreadLocalProxies();
        }
    }

    protected Type getGenericReturnType(Class<?> serviceCls, Method method, Class<?> returnType) {
        return InjectionUtils.processGenericTypeIfNeeded(serviceCls, returnType, method.getGenericReturnType());
    }

    protected Class<?> getReturnType(Method method, Message outMessage) {
        return method.getReturnType();
    }

    @Override
    public Object getInvocationHandler() {
        return this;
    }

    protected static void reportInvalidResourceMethod(Method m, String name) {
        org.apache.cxf.common.i18n.Message errorMsg = new org.apache.cxf.common.i18n.Message(name, BUNDLE, m.getDeclaringClass().getName(), m.getName());
        LOG.severe(errorMsg.toString());
        throw new ProcessingException(errorMsg.toString());
    }

    protected static Annotation[] getMethodAnnotations(Method aMethod, int bodyIndex) {
        return aMethod == null || bodyIndex == -1 ? new Annotation[]{} : aMethod.getParameterAnnotations()[bodyIndex];
    }

    private boolean hasFormParams(Object[] params, List<Parameter> beanParams) {
        return beanParams.stream().map(p -> this.getValuesFromBeanParam(params[p.getIndex()], FormParam.class)).anyMatch(((Predicate<Map>)Map::isEmpty).negate());
    }

    class ClientAsyncResponseInterceptor
    extends AbstractClient.AbstractClientAsyncResponseInterceptor {
        ClientAsyncResponseInterceptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doHandleAsyncResponse(Message message, Response r, JaxrsClientCallback<?> cb) {
            try {
                Object entity = ClientProxyImpl.this.handleResponse(message.getExchange().getOutMessage(), cb.getResponseClass());
                cb.handleResponse(message, new Object[]{entity});
            }
            catch (Throwable t) {
                cb.handleException(message, t);
            }
            finally {
                ClientProxyImpl.this.completeExchange(message.getExchange(), false);
                this.closeAsyncResponseIfPossible(r, message, cb);
            }
        }
    }

    protected static class BeanPair {
        protected Object value;
        protected Annotation[] anns;

        BeanPair(Object value, Annotation[] anns) {
            this.value = value;
            this.anns = anns;
        }

        public Object getValue() {
            return this.value;
        }

        public Annotation[] getAnns() {
            return this.anns;
        }
    }

    protected class BodyWriter
    extends AbstractClient.AbstractBodyWriter {
        protected BodyWriter() {
        }

        @Override
        protected void doWriteBody(Message outMessage, Object body, Type bodyType, Annotation[] customAnns, OutputStream os) throws Fault {
            OperationResourceInfo ori = outMessage.getContent(OperationResourceInfo.class);
            if (ori == null) {
                return;
            }
            Method method = ori.getMethodToInvoke();
            int bodyIndex = (Integer)outMessage.get(ClientProxyImpl.PROXY_METHOD_PARAM_BODY_INDEX);
            Annotation[] anns = customAnns != null ? customAnns : ClientProxyImpl.getMethodAnnotations(ori.getAnnotatedMethod(), bodyIndex);
            try {
                Class<?>[] parameterTypes = method.getParameterTypes();
                if (bodyIndex >= 0 && bodyIndex < parameterTypes.length) {
                    Type[] genericParameterTypes;
                    Class<?> paramClass = parameterTypes[bodyIndex];
                    Class<?> bodyClass = paramClass.isAssignableFrom(body.getClass()) ? paramClass : body.getClass();
                    Type genericType = bodyType;
                    if (genericType == null && bodyIndex < (genericParameterTypes = method.getGenericParameterTypes()).length) {
                        genericType = genericParameterTypes[bodyIndex];
                    }
                    genericType = InjectionUtils.processGenericTypeIfNeeded(ori.getClassResourceInfo().getServiceClass(), bodyClass, genericType);
                    bodyClass = InjectionUtils.updateParamClassToTypeIfNeeded(bodyClass, genericType);
                    ClientProxyImpl.this.writeBody(body, outMessage, bodyClass, genericType, anns, os);
                } else {
                    Type paramType = body.getClass();
                    if (bodyType != null) {
                        paramType = bodyType;
                    }
                    ClientProxyImpl.this.writeBody(body, outMessage, body.getClass(), paramType, anns, os);
                }
            }
            catch (Exception ex) {
                throw new Fault(ex);
            }
        }
    }

    private static class WrappedException
    extends Exception {
        private static final long serialVersionUID = 1183890106889852917L;
        final Throwable wrapped;

        WrappedException(Throwable wrapped) {
            this.wrapped = wrapped;
        }

        Throwable getWrapped() {
            return this.wrapped;
        }
    }
}

