/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.impl;

import javax.ws.rs.core.EntityTag;
import javax.ws.rs.ext.RuntimeDelegate;

public class EntityTagHeaderProvider
implements RuntimeDelegate.HeaderDelegate<EntityTag> {
    private static final String WEAK_PREFIX = "W/";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public EntityTag fromString(String header) {
        if (header == null) {
            throw new IllegalArgumentException("ETag value can not be null");
        }
        if ("*".equals(header)) {
            return new EntityTag("*");
        }
        String tag = null;
        boolean weak = false;
        String trimmed = header.trim();
        if (trimmed.startsWith(WEAK_PREFIX)) {
            weak = true;
            if (trimmed.length() <= 2) return new EntityTag("", weak);
            tag = trimmed.substring(2);
        } else {
            tag = trimmed;
        }
        if (tag.length() > 0 && !tag.startsWith("\"") && !tag.endsWith("\"")) {
            return new EntityTag(tag, weak);
        }
        if (tag.length() < 2 || !tag.startsWith("\"") || !tag.endsWith("\"")) {
            throw new IllegalArgumentException("Misformatted ETag : " + header);
        }
        tag = tag.length() == 2 ? "" : tag.substring(1, tag.length() - 1);
        return new EntityTag(tag, weak);
    }

    @Override
    public String toString(EntityTag tag) {
        String tagValue;
        StringBuilder sb = new StringBuilder();
        if (tag.isWeak()) {
            sb.append(WEAK_PREFIX);
        }
        if (!(tagValue = tag.getValue()).startsWith("\"")) {
            sb.append('\"').append(tagValue).append('\"');
        } else {
            sb.append(tagValue);
        }
        return sb.toString();
    }
}

